# Generated by Django 2.2.11 on 2020-04-06 16:05

from django.db import migrations, models, transaction


def translate_sum_type(apps, schema_editor):
    # use sum_type as int as createrepo_c uses
    with transaction.atomic():
        UpdateCollectionPackage = apps.get_model('rpm', 'UpdateCollectionPackage')
        update_collection_package_to_save = []
        for package in UpdateCollectionPackage.objects.all():
            package.sum_type_temp = int(package.sum_type) if package.sum_type else None
            update_collection_package_to_save.append(package)
        UpdateCollectionPackage.objects.bulk_update(
            update_collection_package_to_save,
            ['sum_type_temp']
        )


class Migration(migrations.Migration):

    dependencies = [
        ('rpm', '0007_checksum_types'),
    ]

    operations = [
        migrations.AddField(
            model_name='updatecollectionpackage',
            name='sum_type_temp',
            field=models.PositiveIntegerField(
                null=True, default=None,
                choices=[
                    (0, 0), (1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6), (7, 7)
                ]
            )
        ),
        migrations.RunPython(translate_sum_type),
        migrations.RemoveField(
            model_name='updatecollectionpackage',
            name='sum_type'
        ),
        migrations.RenameField(
            model_name='updatecollectionpackage',
            old_name='sum_type_temp',
            new_name='sum_type'
        )
    ]
