# Generated by Django 4.2.17 on 2024-12-05 18:54

from django.db import migrations, models, transaction
import django.db.models.deletion


def migrate_data_from_old_model_to_new_model_up(apps, schema_editor):
    """ Move objects from RpmDistribution to NewRpmDistribution."""
    RpmDistribution = apps.get_model('rpm', 'RpmDistribution')
    NewRpmDistribution = apps.get_model('rpm', 'NewRpmDistribution')
    for distribution in RpmDistribution.objects.all():
        with transaction.atomic():
            NewRpmDistribution(
                pulp_id=distribution.pulp_id,
                pulp_created=distribution.pulp_created,
                pulp_last_updated=distribution.pulp_last_updated,
                pulp_type=distribution.pulp_type,
                name=distribution.name,
                base_path=distribution.base_path,
                content_guard=distribution.content_guard,
                remote=distribution.remote,
                publication=distribution.publication
            ).save()
            distribution.delete()


def migrate_data_from_old_model_to_new_model_down(apps, schema_editor):
    """ Move objects from NewRpmDistribution to RpmDistribution."""
    RpmDistribution = apps.get_model('rpm', 'RpmDistribution')
    NewRpmDistribution = apps.get_model('rpm', 'NewRpmDistribution')
    for distribution in NewRpmDistribution.objects.all():
        with transaction.atomic():
            RpmDistribution(
                pulp_id=distribution.pulp_id,
                pulp_created=distribution.pulp_created,
                pulp_last_updated=distribution.pulp_last_updated,
                pulp_type=distribution.pulp_type,
                name=distribution.name,
                base_path=distribution.base_path,
                content_guard=distribution.content_guard,
                remote=distribution.remote,
                publication=distribution.publication
            ).save()
            distribution.delete()


class Migration(migrations.Migration):
    atomic = False

    dependencies = [
        ('rpm', '0032_ulnremote'),
    ]

    operations = [
        migrations.CreateModel(
            name='NewRpmDistribution',
            fields=[
                ('distribution_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='rpm_rpmdistribution', serialize=False, to='core.distribution')),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
            },
            bases=('core.distribution',),
        ),
        migrations.RunPython(
            code=migrate_data_from_old_model_to_new_model_up,
            reverse_code=migrate_data_from_old_model_to_new_model_down,
        ),
        migrations.DeleteModel(
            name='RpmDistribution',
        ),
        migrations.RenameModel(
            old_name='NewRpmDistribution',
            new_name='RpmDistribution',
        ),
    ]
