# Copyright (C) 2023 - 2025 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.


class PointData:
    """Point Data."""

    def __init__(self, pedb, edb_object=None):
        self._pedb = pedb
        self._edb_object = edb_object

    @classmethod
    def create_from_x(cls, pedb, x):
        """Create a new PointData object."""
        edb_object = pedb.core.Geometry.PointData(pedb.edb_value(x))
        return cls(pedb, edb_object)

    @classmethod
    def create_from_xy(cls, pedb, x, y):
        """Create a new PointData object."""
        edb_object = pedb.core.Geometry.PointData(pedb.edb_value(x), pedb.edb_value(y))
        return cls(pedb, edb_object)

    @property
    def x(self):
        """X value of point."""
        return self._edb_object.X.ToString()

    @x.setter
    def x(self, value):
        self._edb_object.X = self._pedb.edb_value(value)

    @property
    def x_evaluated(self):
        return self._edb_object.X.ToDouble()

    @property
    def y(self):
        """Y value of point."""
        return self._edb_object.Y.ToString()

    @y.setter
    def y(self, value):
        self._edb_object.Y = self._pedb.edb_value(value)

    @property
    def y_evaluated(self):
        return self._edb_object.Y.ToDouble()
