#  -*- coding: utf-8 -*-
__author__ = "kubik.augustyn@post.cz"

from enum import IntEnum, unique


# https://github.com/tlsfuzzer/tlslite-ng/blob/6db0826e5ba19ae35e898bd9e6d8410662b4528c/tlslite/constants.py#L584
# https://datatracker.ietf.org/doc/html/rfc8446#appendix-B.4
@unique
class CipherSuite(IntEnum):
    # TODO Add all of them
    TLS_AES_128_GCM_SHA256 = 0x1301
    TLS_AES_256_GCM_SHA384 = 0x1302
    TLS_CHACHA20_POLY1305_SHA256 = 0x1303
    TLS_AES_128_CCM_SHA256 = 0x1304
    TLS_AES_128_CCM_8_SHA256 = 0x1305

    # Stolen from the https://williamlieurance.com/tls-handshake-parser/ example handshake
    TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = 0xc02c
    TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = 0xc030
    TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256 = 0xcca9
    # Selected by the https://google.com/ server v
    TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = 0xcca8
    TLS_ECDHE_ECDSA_WITH_AES_256_CCM = 0xc0ad
    TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = 0xc02b
    TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = 0xc02f
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM = 0xc0ac
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256 = 0xc023
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256 = 0xc027
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = 0xc00a
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA = 0xc014
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = 0xc009
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA = 0xc013
    TLS_RSA_WITH_AES_256_GCM_SHA384 = 0x009d
    TLS_RSA_WITH_AES_256_CCM = 0xc09d
    TLS_RSA_WITH_AES_128_GCM_SHA256 = 0x009c
    TLS_RSA_WITH_AES_128_CCM = 0xc09c
    TLS_RSA_WITH_AES_256_CBC_SHA256 = 0x003d
    TLS_RSA_WITH_AES_128_CBC_SHA256 = 0x003c
    TLS_RSA_WITH_AES_256_CBC_SHA = 0x0035
    TLS_RSA_WITH_AES_128_CBC_SHA = 0x002f
    TLS_DHE_RSA_WITH_AES_256_GCM_SHA384 = 0x009f
    TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = 0xccaa
    TLS_DHE_RSA_WITH_AES_256_CCM = 0xc09f
    TLS_DHE_RSA_WITH_AES_128_GCM_SHA256 = 0x009e
    TLS_DHE_RSA_WITH_AES_128_CCM = 0xc09e
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA256 = 0x006b
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA256 = 0x0067
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA = 0x0039
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA = 0x0033
    # Some more
    TLS_RSA_WITH_AES_128_CCM_8 = 0xC0A0
    TLS_RSA_WITH_AES_256_CCM_8 = 0xC0A1
    TLS_DHE_RSA_WITH_AES_128_CCM_8 = 0xC0A2
    TLS_DHE_RSA_WITH_AES_256_CCM_8 = 0xC0A3
    TLS_RSA_WITH_NULL_MD5 = 0x0001
    TLS_RSA_WITH_NULL_SHA = 0x0002
    TLS_RSA_WITH_RC4_128_MD5 = 0x0004
    TLS_RSA_WITH_RC4_128_SHA = 0x0005
    TLS_RSA_WITH_3DES_EDE_CBC_SHA = 0x000A
    TLS_RSA_WITH_NULL_SHA256 = 0x003B
    TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_draft_00 = 0xCCA1
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384 = 0xc028
    TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA = 0xC012
    TLS_ECDHE_RSA_WITH_RC4_128_SHA = 0xC011
    TLS_ECDHE_RSA_WITH_NULL_SHA = 0xC010


CERTIFICATE_SUITES: set[CipherSuite] = {
    CipherSuite.TLS_RSA_WITH_AES_256_GCM_SHA384,
    CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256,
    CipherSuite.TLS_RSA_WITH_AES_256_CCM,
    CipherSuite.TLS_RSA_WITH_AES_128_CCM,
    CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA256,
    CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA256,
    CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA,
    CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA,
    CipherSuite.TLS_RSA_WITH_AES_256_CCM_8,
    CipherSuite.TLS_RSA_WITH_AES_128_CCM_8,
    CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA,
    CipherSuite.TLS_RSA_WITH_RC4_128_SHA,
    CipherSuite.TLS_RSA_WITH_RC4_128_MD5,
    CipherSuite.TLS_RSA_WITH_NULL_MD5,
    CipherSuite.TLS_RSA_WITH_NULL_SHA,
    CipherSuite.TLS_RSA_WITH_NULL_SHA256
}

# ECDHE
ECDHE_ECDSA_SUITES: set[CipherSuite] = set()
ECDHE_CERTIFICATE_SUITES: set[CipherSuite] = {
    CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256,
    CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_draft_00,
    CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,
    CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,
    CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,
    CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,
    CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA,
    CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,
    CipherSuite.TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA,
    CipherSuite.TLS_ECDHE_RSA_WITH_RC4_128_SHA,
    CipherSuite.TLS_ECDHE_RSA_WITH_NULL_SHA
}
ECDH_ANON_SUITES: set[CipherSuite] = set()
ECDH_ALL_SUITES: set[CipherSuite] = (ECDHE_ECDSA_SUITES
                                     .union(ECDHE_CERTIFICATE_SUITES)
                                     .union(ECDH_ANON_SUITES))
# DHE
DH_ALL_SUITES: set[CipherSuite] = set()

# SRP
SRP_ALL_SUITES: set[CipherSuite] = set()
