#  -*- coding: utf-8 -*-
__author__ = "Jakub Augustýn <kubik.augustyn@post.cz>, ChatGPT 3"

from kutil.typing_help import EnforceSuperCallMeta, enforcesupercall

"""import functools

class EnforceSuperMeta(type):
    def __new__(cls, name, bases, dct):
        for attr, value in dct.items():
            if callable(value):
                # Pokud metoda existuje v rodičovské třídě, zabalíme ji
                for base in bases:
                    parent_method = getattr(base, attr, None)
                    if parent_method:
                        dct[attr] = cls.wrap_method(parent_method, value)
        return super().__new__(cls, name, bases, dct)

    @staticmethod
    def wrap_method(parent_method, child_method):
        def wrapper(self, *args, **kwargs):
            if not hasattr(self, '_super_called'):
                self._super_called = False

            # Zavoláme metodu potomka
            result = child_method(self, *args, **kwargs)

            # Zkontrolujeme, zda bylo volání super() provedeno
            if not self._super_called:
                raise RuntimeError(
                    f"Musíš zavolat super().{parent_method.__name__}() v {self.__class__.__name__}")

            return result

        return wrapper
        
class Parent(metaclass=EnforceSuperMeta):
    def foo(self):
        print("Parent method")
        self._super_called = True  # Označí, že super bylo zavoláno"""


class Parent(metaclass=EnforceSuperCallMeta):
    def __init__(self):
        print("Parent __init__")

    @enforcesupercall
    def foo(self) -> None:
        print("Parent method")


class Child(Parent):
    def __init__(self):
        super().__init__()
        print("Child __init__")

    def foo(self):
        super().foo()
        print("Child method")


class BadChild(Parent):
    def __init__(self):
        super().__init__()
        print("BadChild __init__")

    def foo(self):
        print("BadChild method")


# Testování
print("Test 1 - Parent")
parent = Parent()
parent.foo()  # Projde

print("\nTest 2 - Child")
child = Child()
child.foo()  # Projde

print("\nTest 3 - BadChild")
bad_child = BadChild()
bad_child.foo()  # Vyhodí RuntimeError, protože nebylo zavoláno super().foo()
