#  -*- coding: utf-8 -*-
__author__ = "Jakub Augustýn <kubik.augustyn@post.cz>"

from kutil import *


# https://en.wikipedia.org/wiki/Intel_HEX#Record_structure

def main() -> None:
    path = r'C:\Users\Radek Augustyn\Downloads\approtect_flag.hex'
    txt = readFile(path, 'text', encoding='ascii')

    memory: bytearray = bytearray(0)
    for line in txt.splitlines(keepends=False):
        assert line.startswith(":")
        byteCount = int(line[1:3], 16)
        address = int(line[3:7], 16)
        recordType = int(line[7:9], 16)
        dataEnd: int = 9 + byteCount * 2
        data: bytes = bytes.fromhex(line[9:dataEnd])
        checksum = int(line[dataEnd:dataEnd + 2], 16)

        if recordType == 0x01:
            break
        elif recordType == 0x00:
            if address + byteCount > len(memory):
                # print(f"Extend {len(memory)} by {((address + byteCount) - len(memory) - 1)} to "
                #       f"fit in {address + byteCount}")
                memory.extend([0] * ((address + byteCount) - len(memory) - 1))
            memory[address:address + byteCount] = data
        elif recordType == 0x03:
            assert byteCount == 4
            assert address == 0
            print(f"Start segment: CS {int.from_bytes(data[0:2], 'big')}, "
                  f"IP {int.from_bytes(data[2:4], 'big')}")
        else:
            raise NotImplementedError(f"Unknown record type {hex(recordType)}")

    print(memory)
    pathOut = r'C:\Users\Radek Augustyn\Downloads\memory.bin'
    writeFile(pathOut, memory)

    strings: list[tuple[int, str]] = [(-1, "")]

    lastNul = False
    for i, byte in enumerate(memory):
        # if byte < 128:
        if 32 <= byte <= 127 or byte in b'\r\n':
            # print('<CRLF>' if byte in b'\r\n' else chr(byte), end='')
            lastNul = False

            string = strings[-1]
            start = i if string[0] == -1 else string[0]
            content = string[1] + chr(byte)
            strings[-1] = start, content
        elif byte == 0 and not lastNul:
            # print("")
            lastNul = True

            strings.append((-1, ""))

    for start, content in strings:
        if len(content) > 5:
            print("=" * 25, start, "=" * 25)
            print(content)


if __name__ == '__main__':
    main()
