#  -*- coding: utf-8 -*-
__author__ = "kubik.augustyn@post.cz"

import json

import requests
import re

"""Must wait until I implement HTTPS
from kutil.protocol.HTTP import HTTPRequest, HTTPResponse, HTTPHeaders, HTTPMethod
from kutil import HTTPConnection

VIDEO_ID = "vCMr76HuNzk"
headers: HTTPHeaders = HTTPHeaders()
headers["Content-Length"] = "0"
headers["Accept"] = "text/html"
conn: HTTPConnection


def onResponse(resp: HTTPResponse):
    conn.close()
    print(resp)
    print("Headers:")
    for name, value in resp.headers.items():
        print(f"    {name}: {value}")
    assert resp.statusCode == 200
    print(resp.body.decode("utf-8"))


if __name__ == '__main__':
    conn = HTTPConnection(("youtube.com", 80), onResponse)
    req: HTTPRequest = HTTPRequest(HTTPMethod.GET, f"http://www.youtube.com/embed/{VIDEO_ID}", headers, b'')
    print(req)
    print("Headers:")
    for name, value in req.headers.items():
        print(f"    {name}: {value}")
    conn.sendData(req)
"""

VIDEO_ID = "vCMr76HuNzk"
info_regex = r'"PLAYER_VARS":{"embedded_player_response":"([\s\S]+)","video_id":"([a-zA-Z0-9]{11})"}'
api_regex = r'"INNERTUBE_API_KEY":"([a-zA-Z0-9_]+)","INNERTUBE_API_VERSION":"([a-zA-Z0-9]+)"'
external_ip = requests.get('https://ident.me').text
if __name__ == '__main__':
    r = requests.get(f"https://www.youtube.com/embed/{VIDEO_ID}")
    assert r.status_code == 200
    # print(r.text)
    # Match player info
    match = re.search(info_regex, r.text)
    assert match is not None
    assert match.group(2) == VIDEO_ID
    info_str: str = eval('"' + match.group(1) + '"')  # Unescape it
    # print(info_str)
    info: dict = json.loads(info_str)
    print(info)
    json.dump(info, open("tmp.json", "w+"))

    # Match API info
    match = re.search(api_regex, r.text)
    assert match is not None
    api_key: str = match.group(1)
    api_version: str = match.group(2)
    print(api_key)
    print(api_version)

    data = {
        "context": {
            "client": json.loads("""{
                "hl": "en-GB",
                    "gl": "CZ",
                    "remoteHost": "IP",
                    "deviceMake": "",
                    "deviceModel": "",
                    "visitorData": "Cgs4WEdocUJTSkR0RSjRr9WrBjIICgJDWhICEgA%3D",
                    "userAgent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36,gzip(gfe)",
                    "clientName": "WEB",
                    "clientVersion": "2.20231208.01.00",
                    "osName": "Windows",
                    "osVersion": "10.0",
                    "originalUrl": "https://www.youtube.com/watch?v=VIDEO_ID",
                    "screenPixelDensity": 3,
                    "platform": "DESKTOP",
                    "clientFormFactor": "UNKNOWN_FORM_FACTOR",
                    "configInfo": {
                        "appInstallData": "CNGv1asGEKXC_hIQzN-uBRCu1P4SEKn3rwUQ3JmwBRDqw68FEL75rwUQ_IWwBRCIh7AFEKiasAUQiOOvBRCrgrAFEKKBsAUQ7qKvBRCst68FEM-NsAUQ5LP-EhDonbAFEKaasAUQpoGwBRDh8q8FEOLUrgUQt--vBRC9tq4FEInorgUQ65OuBRC9mbAFEPX5rwUQlPr-EhDnuq8FEL2KsAUQ0-GvBRC8-a8FEMyu_hIQ3ej-EhCVz68FENShrwUQ2piwBRDcgrAFENuvrwUQmvCvBRDNlbAFEK-esAUQ6YywBRDQ4q8FEMeDsAUQt-r-EhCWg7AFEMn3rwUQnouwBRC7jrAFENnJrwUQqaCwBRC4i64FEL-dsAUQ1-mvBRCZkbAFEJj8_hIQopKwBRDr6P4SELfgrgUQ1YiwBRCZlLAFEPiasAUQtIL_EhCYnbAFEKn1rwU%3D"
                    },
                    "screenDensityFloat": 2.5,
                    "userInterfaceTheme": "USER_INTERFACE_THEME_LIGHT",
                    "timeZone": "Europe/Prague",
                    "browserName": "Chrome",
                    "browserVersion": "120.0.0.0",
                    "acceptHeader": "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7",
                    "deviceExperimentId": "ChxOek14TURnME5qRXlOalV3T1RNM056UXhNUT09ENGv1asGGNGv1asG",
                    "screenWidthPoints": 1536,
                    "screenHeightPoints": 302,
                    "utcOffsetMinutes": 60,
                    "connectionType": "CONN_CELLULAR_4G",
                    "memoryTotalKbytes": "8000000",
                    "mainAppWebInfo": {
                        "graftUrl": "https://www.youtube.com/watch?v=VIDEO_ID",
                        "webDisplayMode": "WEB_DISPLAY_MODE_BROWSER",
                        "isWebNativeShareAvailable": true
                    },
                    "playerType": "UNIPLAYER",
                    "tvAppInfo": {
                        "livingRoomAppMode": "LIVING_ROOM_APP_MODE_UNSPECIFIED"
                    }
                }""".replace("VIDEO_ID", VIDEO_ID).replace("IP", external_ip))
        },
        "engagementType": "ENGAGEMENT_TYPE_PLAYBACK",
        "ids": [
            {
                "playbackId": {
                    "videoId": VIDEO_ID,
                    "cpn": "bQh0Uve24hkMBYi4"
                }
            }
        ]
    }
    r = requests.post(f"https://www.youtube.com/youtubei/{api_version}/player?key={api_key}&prettyPrint=false",
                      json=data)
    print(r.status_code) # 400 - Bad Request
    # assert r.status_code == 200
    # print(r.text)
    # Failed lol
