sim_idx_list = ["main", "sub1", "sub2", "sub3", "sub4", "sub5", "sub6"]
description_trans = {
    "ko":{
        "job_type": "훈련인지 테스트인지 여부",
        "model_name": "모델 이름",
        "pretrained": "사전 훈련된 모델을 사용할지 여부",
        "pretrained_model_name": "사전 훈련된 모델의 이름",
        "pretrained_checkpoint": "사전 훈련된 모델의 체크포인트",
        "system.enable_gui": "GUI 활성화",
        "system.version": "버전",
        "system.enable_main_camera": "메인 카메라 활성화",
        "system.enable_sub_camera": "서브 카메라 활성화",
        "system.enable_kvs_camera": "KVS 카메라 활성화",
        "system.train_multi_config": "다중 구성 훈련",
        "simulation.number_of_sub_simulations": "다중 훈련을 위한 서브 시뮬레이션 개수",
        **{f"simulation.{sim_idx}.car_color": f"{sim_idx}의 차량 색깔" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"{sim_idx}의 트랙" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"트랙 주행 방향" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"훈련 중 주행 방향을 번갈아 할지 여부" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"레이스 유형 (Time Trial: 빈 트랙에서 주행, Object Avoidance: 장애물 피하기)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"장애물 객체 유형" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"장애물 개수" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"장애물 위치를 랜덤으로 할지 여부" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"장애물 간 최소 거리" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"장애물 위치" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "카메라 개수",
        "vehicle.sensor.lidar": "라이다 사용 여부",
        "vehicle.action_space_type": "행동 공간 (모델 출력)",
        "vehicle.action_space.continuous": "연속 행동 공간",
        "vehicle.action_space.continuous.steering_angle.high": "좌측 최대 바퀴 각도 (양수)",
        "vehicle.action_space.continuous.steering_angle.low": "우측 최대 바퀴 각도 (음수)",
        "vehicle.action_space.continuous.speed.high": "최대 속도(m/s)",
        "vehicle.action_space.continuous.speed.low": "최저 하한(m/s)",
        "vehicle.action_space.discrete": "이산 행동 공간",
        "vehicle.neural_network": "CNN 모델 구조",
        "vehicle.sensor.preprocess_type": "입력 데이터 전처리 타입",
        "training.algorithm": "모델 훈련 알고리즘",
        "training.round_robin_advanced": "모델 훈련시 순환 비율",
        "training.min_evaluation_number_of_trials": "최소 평가 시도 횟수",
        "training.hyperparameters.batch_size": "배치 크기 (가중치 업데이트를 위한 데이터 묶음 개수)",
        "training.hyperparameters.discount_factor": "할인율 (미래 보상에 대한 가중치)",
        "training.hyperparameters.learning_rate": "학습률 (가중치 업데이트 강도)",
        "training.hyperparameters.loss_type": "손실 유형 (가중치 업데이트를 위한 손실 함수)",
        "training.hyperparameters.entropy": "엔트로피 (무작위성)",
        "training.hyperparameters.sac_alpha": "SAC 알파 (무작위성)",
        "training.hyperparameters.e_greedy_value": "E-Greedy 값",
        "training.hyperparameters.epsilon_steps": "입실론 단계",
        "training.hyperparameters.exploration_type": "탐색 유형",
        "training.hyperparameters.stack_size": "스택 크기",
        "training.hyperparameters.term_cond_avg_score": "평균 점수 종료 조건",
        "training.hyperparameters.term_cond_max_episodes": "최대 에피소드 종료 조건",
        "training.hyperparameters.num_episodes_between_training": "정책 업데이트 반복 사이의 에피소드 수",
        "training.hyperparameters.num_epochs": "에포크 수",
        "training.best_model_metric": "최고 모델 메트릭",
        "auto_test_after_training": "훈련 후 자동 테스트",
        "test.number_of_trials": "테스트 평가 랩(바퀴) 수",
        "test.checkpoint": "테스트할 모델의 체크포인트",
        "test.penalty.is_offtrack": "트랙 이탈시 패널티 (초)",
        "test.penalty.is_crashed": "충돌시 패널티 (초)",
        "test.max_resets": "최대 리셋(이탈 및 충돌)",
        "test.is_continuous": "결승점 통과시 멈추지 않고 다음 랩(바퀴)를 측정",
        "test.save_mp4": "테스트 영상 저장 여부",
        "test.crash_reset_behind_dist": "충돌시 리셋할 물체로부터의 거리",
        "test.car_name": "테스트 차량 이름",

    },
    "en": {
        "job_type": "Whether training or testing",
        "model_name": "Model name",
        "pretrained": "Whether to use a pre-trained model",
        "pretrained_model_name": "Name of the pre-trained model",
        "pretrained_checkpoint": "Checkpoint of the pre-trained model",
        "system.enable_gui": "Enable GUI",
        "system.version": "Version",
        "system.enable_main_camera": "Enable main camera",
        "system.enable_sub_camera": "Enable sub camera",
        "system.enable_kvs_camera": "Enable KVS camera",
        "system.train_multi_config": "Multi-configuration training",
        "simulation.number_of_sub_simulations": "Number of sub-simulations for multi-training",
        **{f"simulation.{sim_idx}.car_color": f"Car color of {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"Track of {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"Track driving direction" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"Whether to alternate driving direction during training" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"Race type (Time Trial: driving on empty track, Object Avoidance: avoiding obstacles)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"Obstacle object type" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"Number of obstacles" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"Whether to randomize obstacle locations" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"Minimum distance between obstacles" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"Obstacle locations" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "Number of cameras",
        "vehicle.sensor.lidar": "Whether to use LiDAR",
        "vehicle.action_space_type": "Action space (model output)",
        "vehicle.action_space.continuous": "Continuous action space",
        "vehicle.action_space.continuous.steering_angle.high": "Maximum left steering angle (positive)",
        "vehicle.action_space.continuous.steering_angle.low": "Maximum right steering angle (negative)",
        "vehicle.action_space.continuous.speed.high": "Maximum speed (m/s)",
        "vehicle.action_space.continuous.speed.low": "Minimum speed (m/s)",
        "vehicle.action_space.discrete": "Discrete action space",
        "vehicle.neural_network": "CNN model architecture",
        "vehicle.sensor.preprocess_type": "Input data preprocessing type",
        "training.algorithm": "Model training algorithm",
        "training.round_robin_advanced": "Round robin ratio during model training",
        "training.min_evaluation_number_of_trials": "Minimum number of evaluation trials",
        "training.hyperparameters.batch_size": "Batch size (number of data bundles for weight updates)",
        "training.hyperparameters.discount_factor": "Discount factor (weight for future rewards)",
        "training.hyperparameters.learning_rate": "Learning rate (weight update intensity)",
        "training.hyperparameters.loss_type": "Loss type (loss function for weight updates)",
        "training.hyperparameters.entropy": "Entropy (randomness)",
        "training.hyperparameters.sac_alpha": "SAC alpha (randomness)",
        "training.hyperparameters.e_greedy_value": "E-Greedy value",
        "training.hyperparameters.epsilon_steps": "Epsilon steps",
        "training.hyperparameters.exploration_type": "Exploration type",
        "training.hyperparameters.stack_size": "Stack size",
        "training.hyperparameters.term_cond_avg_score": "Average score termination condition",
        "training.hyperparameters.term_cond_max_episodes": "Maximum episodes termination condition",
        "training.hyperparameters.num_episodes_between_training": "Number of episodes between policy updates",
        "training.hyperparameters.num_epochs": "Number of epochs",
        "training.best_model_metric": "Best model metric",
        "auto_test_after_training": "Auto test after training",
        "test.number_of_trials": "Number of test evaluation laps",
        "test.checkpoint": "Checkpoint of the model to test",
        "test.penalty.is_offtrack": "Penalty for going off track (seconds)",
        "test.penalty.is_crashed": "Penalty for crashing (seconds)",
        "test.max_resets": "Maximum resets (off-track and crashes)",
        "test.is_continuous": "Measure next lap without stopping at finish line",
        "test.save_mp4": "Whether to save test video",
        "test.crash_reset_behind_dist": "Distance from object to reset after crash",
        "test.car_name": "Test vehicle name",
    },
    "it": {
        "job_type": "Se addestramento o test",
        "model_name": "Nome del modello",
        "pretrained": "Se utilizzare un modello pre-addestrato",
        "pretrained_model_name": "Nome del modello pre-addestrato",
        "pretrained_checkpoint": "Checkpoint del modello pre-addestrato",
        "system.enable_gui": "Abilita GUI",
        "system.version": "Versione",
        "system.enable_main_camera": "Abilita camera principale",
        "system.enable_sub_camera": "Abilita camera secondaria",
        "system.enable_kvs_camera": "Abilita camera KVS",
        "system.train_multi_config": "Addestramento multi-configurazione",
        "simulation.number_of_sub_simulations": "Numero di sotto-simulazioni per multi-addestramento",
        **{f"simulation.{sim_idx}.car_color": f"Colore dell'auto di {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"Pista di {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"Direzione di guida della pista" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"Se alternare la direzione di guida durante l'addestramento" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"Tipo di gara (Time Trial: guida su pista vuota, Object Avoidance: evitare ostacoli)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"Tipo di oggetto ostacolo" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"Numero di ostacoli" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"Se randomizzare le posizioni degli ostacoli" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"Distanza minima tra ostacoli" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"Posizioni degli ostacoli" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "Numero di camere",
        "vehicle.sensor.lidar": "Se utilizzare LiDAR",
        "vehicle.action_space_type": "Spazio d'azione (output del modello)",
        "vehicle.action_space.continuous": "Spazio d'azione continuo",
        "vehicle.action_space.continuous.steering_angle.high": "Angolo di sterzo massimo sinistro (positivo)",
        "vehicle.action_space.continuous.steering_angle.low": "Angolo di sterzo massimo destro (negativo)",
        "vehicle.action_space.continuous.speed.high": "Velocità massima (m/s)",
        "vehicle.action_space.continuous.speed.low": "Velocità minima (m/s)",
        "vehicle.action_space.discrete": "Spazio d'azione discreto",
        "vehicle.neural_network": "Architettura del modello CNN",
        "vehicle.sensor.preprocess_type": "Tipo di preprocessing dei dati di input",
        "training.algorithm": "Algoritmo di addestramento del modello",
        "training.round_robin_advanced": "Rapporto round robin durante l'addestramento del modello",
        "training.min_evaluation_number_of_trials": "Numero minimo di prove di valutazione",
        "training.hyperparameters.batch_size": "Dimensione del batch (numero di bundle di dati per aggiornamenti dei pesi)",
        "training.hyperparameters.discount_factor": "Fattore di sconto (peso per ricompense future)",
        "training.hyperparameters.learning_rate": "Tasso di apprendimento (intensità di aggiornamento dei pesi)",
        "training.hyperparameters.loss_type": "Tipo di perdita (funzione di perdita per aggiornamenti dei pesi)",
        "training.hyperparameters.entropy": "Entropia (casualità)",
        "training.hyperparameters.sac_alpha": "SAC alpha (casualità)",
        "training.hyperparameters.e_greedy_value": "Valore E-Greedy",
        "training.hyperparameters.epsilon_steps": "Passi epsilon",
        "training.hyperparameters.exploration_type": "Tipo di esplorazione",
        "training.hyperparameters.stack_size": "Dimensione dello stack",
        "training.hyperparameters.term_cond_avg_score": "Condizione di terminazione punteggio medio",
        "training.hyperparameters.term_cond_max_episodes": "Condizione di terminazione episodi massimi",
        "training.hyperparameters.num_episodes_between_training": "Numero di episodi tra aggiornamenti di policy",
        "training.hyperparameters.num_epochs": "Numero di epoche",
        "training.best_model_metric": "Metrica del miglior modello",
        "auto_test_after_training": "Test automatico dopo l'addestramento",
        "test.number_of_trials": "Numero di giri di valutazione del test",
        "test.checkpoint": "Checkpoint del modello da testare",
        "test.penalty.is_offtrack": "Penalità per uscire dalla pista (secondi)",
        "test.penalty.is_crashed": "Penalità per incidente (secondi)",
        "test.max_resets": "Reset massimi (fuori pista e incidenti)",
        "test.is_continuous": "Misura il giro successivo senza fermarsi al traguardo",
        "test.save_mp4": "Se salvare il video del test",
        "test.crash_reset_behind_dist": "Distanza dall'oggetto per reset dopo incidente",
        "test.car_name": "Nome del veicolo di test",
    },
    "nl": {
        "job_type": "Of training of testen",
        "model_name": "Modelnaam",
        "pretrained": "Of een voorgetraind model te gebruiken",
        "pretrained_model_name": "Naam van het voorgetrainde model",
        "pretrained_checkpoint": "Checkpoint van het voorgetrainde model",
        "system.enable_gui": "GUI inschakelen",
        "system.version": "Versie",
        "system.enable_main_camera": "Hoofdcamera inschakelen",
        "system.enable_sub_camera": "Subcamera inschakelen",
        "system.enable_kvs_camera": "KVS-camera inschakelen",
        "system.train_multi_config": "Multi-configuratie training",
        "simulation.number_of_sub_simulations": "Aantal sub-simulaties voor multi-training",
        **{f"simulation.{sim_idx}.car_color": f"Autokleur van {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"Circuit van {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"Rijrichting van circuit" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"Of rijrichting tijdens training af te wisselen" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"Racetype (Time Trial: rijden op leeg circuit, Object Avoidance: obstakels vermijden)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"Type obstakel object" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"Aantal obstakels" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"Of obstakellocaties te randomiseren" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"Minimale afstand tussen obstakels" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"Obstakellocaties" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "Aantal camera's",
        "vehicle.sensor.lidar": "Of LiDAR te gebruiken",
        "vehicle.action_space_type": "Actieruimte (modeloutput)",
        "vehicle.action_space.continuous": "Continue actieruimte",
        "vehicle.action_space.continuous.steering_angle.high": "Maximale linker stuurhoek (positief)",
        "vehicle.action_space.continuous.steering_angle.low": "Maximale rechter stuurhoek (negatief)",
        "vehicle.action_space.continuous.speed.high": "Maximale snelheid (m/s)",
        "vehicle.action_space.continuous.speed.low": "Minimale snelheid (m/s)",
        "vehicle.action_space.discrete": "Discrete actieruimte",
        "vehicle.neural_network": "CNN-modelarchitectuur",
        "vehicle.sensor.preprocess_type": "Voorbewerking type van inputdata",
        "training.algorithm": "Modeltraining algoritme",
        "training.round_robin_advanced": "Round robin ratio tijdens modeltraining",
        "training.min_evaluation_number_of_trials": "Minimum aantal evaluatiepogingen",
        "training.hyperparameters.batch_size": "Batchgrootte (aantal databundels voor gewichtupdates)",
        "training.hyperparameters.discount_factor": "Kortingsfactor (gewicht voor toekomstige beloningen)",
        "training.hyperparameters.learning_rate": "Leersnelheid (intensiteit van gewichtupdates)",
        "training.hyperparameters.loss_type": "Verliestype (verliesfunctie voor gewichtupdates)",
        "training.hyperparameters.entropy": "Entropie (willekeurigheid)",
        "training.hyperparameters.sac_alpha": "SAC alpha (willekeurigheid)",
        "training.hyperparameters.e_greedy_value": "E-Greedy waarde",
        "training.hyperparameters.epsilon_steps": "Epsilon stappen",
        "training.hyperparameters.exploration_type": "Exploratietype",
        "training.hyperparameters.stack_size": "Stapelgrootte",
        "training.hyperparameters.term_cond_avg_score": "Gemiddelde score beëindigingsvoorwaarde",
        "training.hyperparameters.term_cond_max_episodes": "Maximum afleveringen beëindigingsvoorwaarde",
        "training.hyperparameters.num_episodes_between_training": "Aantal afleveringen tussen beleidsupdates",
        "training.hyperparameters.num_epochs": "Aantal tijdperken",
        "training.best_model_metric": "Beste model metriek",
        "auto_test_after_training": "Automatische test na training",
        "test.number_of_trials": "Aantal test evaluatierondes",
        "test.checkpoint": "Checkpoint van het te testen model",
        "test.penalty.is_offtrack": "Straf voor van circuit afgaan (seconden)",
        "test.penalty.is_crashed": "Straf voor crash (seconden)",
        "test.max_resets": "Maximum resets (van circuit af en crashes)",
        "test.is_continuous": "Meet volgende ronde zonder stoppen bij finish",
        "test.save_mp4": "Of testvideo op te slaan",
        "test.crash_reset_behind_dist": "Afstand van object om te resetten na crash",
        "test.car_name": "Testvoertuignaam",
    },
    "de": {
        "job_type": "Ob Training oder Testen",
        "model_name": "Modellname",
        "pretrained": "Ob ein vortrainiertes Modell verwendet werden soll",
        "pretrained_model_name": "Name des vortrainierten Modells",
        "pretrained_checkpoint": "Checkpoint des vortrainierten Modells",
        "system.enable_gui": "GUI aktivieren",
        "system.version": "Version",
        "system.enable_main_camera": "Hauptkamera aktivieren",
        "system.enable_sub_camera": "Unterkamera aktivieren",
        "system.enable_kvs_camera": "KVS-Kamera aktivieren",
        "system.train_multi_config": "Multi-Konfigurations-Training",
        "simulation.number_of_sub_simulations": "Anzahl der Unter-Simulationen für Multi-Training",
        **{f"simulation.{sim_idx}.car_color": f"Autofarbe von {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"Strecke von {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"Fahrtrichtung der Strecke" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"Ob Fahrtrichtung während Training zu wechseln" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"Renntyp (Time Trial: Fahren auf leerer Strecke, Object Avoidance: Hindernisse vermeiden)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"Hindernisobjekt-Typ" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"Anzahl der Hindernisse" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"Ob Hindernispositionen zu randomisieren" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"Mindestabstand zwischen Hindernissen" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"Hindernispositionen" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "Anzahl der Kameras",
        "vehicle.sensor.lidar": "Ob LiDAR zu verwenden",
        "vehicle.action_space_type": "Aktionsraum (Modellausgabe)",
        "vehicle.action_space.continuous": "Kontinuierlicher Aktionsraum",
        "vehicle.action_space.continuous.steering_angle.high": "Maximaler linker Lenkwinkel (positiv)",
        "vehicle.action_space.continuous.steering_angle.low": "Maximaler rechter Lenkwinkel (negativ)",
        "vehicle.action_space.continuous.speed.high": "Höchstgeschwindigkeit (m/s)",
        "vehicle.action_space.continuous.speed.low": "Mindestgeschwindigkeit (m/s)",
        "vehicle.action_space.discrete": "Diskreter Aktionsraum",
        "vehicle.neural_network": "CNN-Modellarchitektur",
        "vehicle.sensor.preprocess_type": "Vorverarbeitungstyp der Eingabedaten",
        "training.algorithm": "Modelltraining-Algorithmus",
        "training.round_robin_advanced": "Round-Robin-Verhältnis beim Modelltraining",
        "training.min_evaluation_number_of_trials": "Mindestanzahl von Bewertungsversuchen",
        "training.hyperparameters.batch_size": "Batch-Größe (Anzahl der Datenbündel für Gewichtsaktualisierungen)",
        "training.hyperparameters.discount_factor": "Diskontfaktor (Gewicht für zukünftige Belohnungen)",
        "training.hyperparameters.learning_rate": "Lernrate (Intensität der Gewichtsaktualisierung)",
        "training.hyperparameters.loss_type": "Verlusttyp (Verlustfunktion für Gewichtsaktualisierungen)",
        "training.hyperparameters.entropy": "Entropie (Zufälligkeit)",
        "training.hyperparameters.sac_alpha": "SAC Alpha (Zufälligkeit)",
        "training.hyperparameters.e_greedy_value": "E-Greedy-Wert",
        "training.hyperparameters.epsilon_steps": "Epsilon-Schritte",
        "training.hyperparameters.exploration_type": "Explorationstyp",
        "training.hyperparameters.stack_size": "Stapelgröße",
        "training.hyperparameters.term_cond_avg_score": "Durchschnittlicher Score-Beendigungsbedingung",
        "training.hyperparameters.term_cond_max_episodes": "Maximale Episoden-Beendigungsbedingung",
        "training.hyperparameters.num_episodes_between_training": "Anzahl der Episoden zwischen Policy-Updates",
        "training.hyperparameters.num_epochs": "Anzahl der Epochen",
        "training.best_model_metric": "Beste Modell-Metrik",
        "auto_test_after_training": "Automatischer Test nach Training",
        "test.number_of_trials": "Anzahl der Test-Bewertungsrunden",
        "test.checkpoint": "Checkpoint des zu testenden Modells",
        "test.penalty.is_offtrack": "Strafe für Abweichen von der Strecke (Sekunden)",
        "test.penalty.is_crashed": "Strafe für Crash (Sekunden)",
        "test.max_resets": "Maximale Resets (Abweichen und Crashes)",
        "test.is_continuous": "Nächste Runde messen ohne Stopp am Ziel",
        "test.save_mp4": "Ob Testvideo zu speichern",
        "test.crash_reset_behind_dist": "Abstand vom Objekt zum Reset nach Crash",
        "test.car_name": "Testfahrzeugname",
    },
    "pt": {
        "job_type": "Se treino ou teste",
        "model_name": "Nome do modelo",
        "pretrained": "Se usar um modelo pré-treinado",
        "pretrained_model_name": "Nome do modelo pré-treinado",
        "pretrained_checkpoint": "Checkpoint do modelo pré-treinado",
        "system.enable_gui": "Habilitar GUI",
        "system.version": "Versão",
        "system.enable_main_camera": "Habilitar câmera principal",
        "system.enable_sub_camera": "Habilitar câmera secundária",
        "system.enable_kvs_camera": "Habilitar câmera KVS",
        "system.train_multi_config": "Treinamento multi-configuração",
        "simulation.number_of_sub_simulations": "Número de sub-simulações para multi-treinamento",
        **{f"simulation.{sim_idx}.car_color": f"Cor do carro de {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"Pista de {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"Direção de condução da pista" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"Se alternar direção de condução durante treinamento" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"Tipo de corrida (Time Trial: condução em pista vazia, Object Avoidance: evitar obstáculos)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"Tipo de objeto obstáculo" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"Número de obstáculos" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"Se randomizar localizações dos obstáculos" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"Distância mínima entre obstáculos" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"Localizações dos obstáculos" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "Número de câmeras",
        "vehicle.sensor.lidar": "Se usar LiDAR",
        "vehicle.action_space_type": "Espaço de ação (saída do modelo)",
        "vehicle.action_space.continuous": "Espaço de ação contínuo",
        "vehicle.action_space.continuous.steering_angle.high": "Ângulo máximo de direção esquerda (positivo)",
        "vehicle.action_space.continuous.steering_angle.low": "Ângulo máximo de direção direita (negativo)",
        "vehicle.action_space.continuous.speed.high": "Velocidade máxima (m/s)",
        "vehicle.action_space.continuous.speed.low": "Velocidade mínima (m/s)",
        "vehicle.action_space.discrete": "Espaço de ação discreto",
        "vehicle.neural_network": "Arquitetura do modelo CNN",
        "vehicle.sensor.preprocess_type": "Tipo de pré-processamento de dados de entrada",
        "training.algorithm": "Algoritmo de treinamento do modelo",
        "training.round_robin_advanced": "Proporção round robin durante treinamento do modelo",
        "training.min_evaluation_number_of_trials": "Número mínimo de tentativas de avaliação",
        "training.hyperparameters.batch_size": "Tamanho do lote (número de pacotes de dados para atualizações de peso)",
        "training.hyperparameters.discount_factor": "Fator de desconto (peso para recompensas futuras)",
        "training.hyperparameters.learning_rate": "Taxa de aprendizado (intensidade de atualização de peso)",
        "training.hyperparameters.loss_type": "Tipo de perda (função de perda para atualizações de peso)",
        "training.hyperparameters.entropy": "Entropia (aleatoriedade)",
        "training.hyperparameters.sac_alpha": "SAC alpha (aleatoriedade)",
        "training.hyperparameters.e_greedy_value": "Valor E-Greedy",
        "training.hyperparameters.epsilon_steps": "Passos epsilon",
        "training.hyperparameters.exploration_type": "Tipo de exploração",
        "training.hyperparameters.stack_size": "Tamanho da pilha",
        "training.hyperparameters.term_cond_avg_score": "Condição de término de pontuação média",
        "training.hyperparameters.term_cond_max_episodes": "Condição de término de episódios máximos",
        "training.hyperparameters.num_episodes_between_training": "Número de episódios entre atualizações de política",
        "training.hyperparameters.num_epochs": "Número de épocas",
        "training.best_model_metric": "Métrica do melhor modelo",
        "auto_test_after_training": "Teste automático após treinamento",
        "test.number_of_trials": "Número de voltas de avaliação do teste",
        "test.checkpoint": "Checkpoint do modelo a testar",
        "test.penalty.is_offtrack": "Penalidade por sair da pista (segundos)",
        "test.penalty.is_crashed": "Penalidade por acidente (segundos)",
        "test.max_resets": "Resets máximos (fora da pista e acidentes)",
        "test.is_continuous": "Medir próxima volta sem parar na linha de chegada",
        "test.save_mp4": "Se salvar vídeo do teste",
        "test.crash_reset_behind_dist": "Distância do objeto para reset após acidente",
        "test.car_name": "Nome do veículo de teste",
    },
    "es": {
        "job_type": "Si entrenamiento o prueba",
        "model_name": "Nombre del modelo",
        "pretrained": "Si usar un modelo preentrenado",
        "pretrained_model_name": "Nombre del modelo preentrenado",
        "pretrained_checkpoint": "Checkpoint del modelo preentrenado",
        "system.enable_gui": "Habilitar GUI",
        "system.version": "Versión",
        "system.enable_main_camera": "Habilitar cámara principal",
        "system.enable_sub_camera": "Habilitar cámara secundaria",
        "system.enable_kvs_camera": "Habilitar cámara KVS",
        "system.train_multi_config": "Entrenamiento multi-configuración",
        "simulation.number_of_sub_simulations": "Número de sub-simulaciones para multi-entrenamiento",
        **{f"simulation.{sim_idx}.car_color": f"Color del coche de {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"Pista de {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"Dirección de conducción de la pista" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"Si alternar dirección de conducción durante entrenamiento" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"Tipo de carrera (Time Trial: conducción en pista vacía, Object Avoidance: evitar obstáculos)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"Tipo de objeto obstáculo" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"Número de obstáculos" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"Si aleatorizar ubicaciones de obstáculos" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"Distancia mínima entre obstáculos" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"Ubicaciones de obstáculos" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "Número de cámaras",
        "vehicle.sensor.lidar": "Si usar LiDAR",
        "vehicle.action_space_type": "Espacio de acción (salida del modelo)",
        "vehicle.action_space.continuous": "Espacio de acción continuo",
        "vehicle.action_space.continuous.steering_angle.high": "Ángulo máximo de dirección izquierda (positivo)",
        "vehicle.action_space.continuous.steering_angle.low": "Ángulo máximo de dirección derecha (negativo)",
        "vehicle.action_space.continuous.speed.high": "Velocidad máxima (m/s)",
        "vehicle.action_space.continuous.speed.low": "Velocidad mínima (m/s)",
        "vehicle.action_space.discrete": "Espacio de acción discreto",
        "vehicle.neural_network": "Arquitectura del modelo CNN",
        "vehicle.sensor.preprocess_type": "Tipo de preprocesamiento de datos de entrada",
        "training.algorithm": "Algoritmo de entrenamiento del modelo",
        "training.round_robin_advanced": "Proporción round robin durante entrenamiento del modelo",
        "training.min_evaluation_number_of_trials": "Número mínimo de intentos de evaluación",
        "training.hyperparameters.batch_size": "Tamaño del lote (número de paquetes de datos para actualizaciones de peso)",
        "training.hyperparameters.discount_factor": "Factor de descuento (peso para recompensas futuras)",
        "training.hyperparameters.learning_rate": "Tasa de aprendizaje (intensidad de actualización de peso)",
        "training.hyperparameters.loss_type": "Tipo de pérdida (función de pérdida para actualizaciones de peso)",
        "training.hyperparameters.entropy": "Entropía (aleatoriedad)",
        "training.hyperparameters.sac_alpha": "SAC alpha (aleatoriedad)",
        "training.hyperparameters.e_greedy_value": "Valor E-Greedy",
        "training.hyperparameters.epsilon_steps": "Pasos epsilon",
        "training.hyperparameters.exploration_type": "Tipo de exploración",
        "training.hyperparameters.stack_size": "Tamaño de pila",
        "training.hyperparameters.term_cond_avg_score": "Condición de terminación de puntuación promedio",
        "training.hyperparameters.term_cond_max_episodes": "Condición de terminación de episodios máximos",
        "training.hyperparameters.num_episodes_between_training": "Número de episodios entre actualizaciones de política",
        "training.hyperparameters.num_epochs": "Número de épocas",
        "training.best_model_metric": "Métrica del mejor modelo",
        "auto_test_after_training": "Prueba automática después del entrenamiento",
        "test.number_of_trials": "Número de vueltas de evaluación de prueba",
        "test.checkpoint": "Checkpoint del modelo a probar",
        "test.penalty.is_offtrack": "Penalización por salirse de la pista (segundos)",
        "test.penalty.is_crashed": "Penalización por accidente (segundos)",
        "test.max_resets": "Reinicios máximos (fuera de pista y accidentes)",
        "test.is_continuous": "Medir siguiente vuelta sin parar en línea de meta",
        "test.save_mp4": "Si guardar video de prueba",
        "test.crash_reset_behind_dist": "Distancia del objeto para reinicio después de accidente",
        "test.car_name": "Nombre del vehículo de prueba",
    },
    "fr": {
        "job_type": "Si entraînement ou test",
        "model_name": "Nom du modèle",
        "pretrained": "S'il faut utiliser un modèle pré-entraîné",
        "pretrained_model_name": "Nom du modèle pré-entraîné",
        "pretrained_checkpoint": "Point de contrôle du modèle pré-entraîné",
        "system.enable_gui": "Activer l'interface graphique",
        "system.version": "Version",
        "system.enable_main_camera": "Activer la caméra principale",
        "system.enable_sub_camera": "Activer la caméra secondaire",
        "system.enable_kvs_camera": "Activer la caméra KVS",
        "system.train_multi_config": "Entraînement multi-configuration",
        "simulation.number_of_sub_simulations": "Nombre de sous-simulations pour multi-entraînement",
        **{f"simulation.{sim_idx}.car_color": f"Couleur de la voiture de {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"Piste de {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"Direction de conduite de la piste" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"S'il faut alterner la direction de conduite pendant l'entraînement" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"Type de course (Time Trial: conduite sur piste vide, Object Avoidance: éviter les obstacles)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"Type d'objet obstacle" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"Nombre d'obstacles" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"S'il faut randomiser les emplacements des obstacles" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"Distance minimale entre obstacles" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"Emplacements des obstacles" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "Nombre de caméras",
        "vehicle.sensor.lidar": "S'il faut utiliser LiDAR",
        "vehicle.action_space_type": "Espace d'action (sortie du modèle)",
        "vehicle.action_space.continuous": "Espace d'action continu",
        "vehicle.action_space.continuous.steering_angle.high": "Angle de direction maximum gauche (positif)",
        "vehicle.action_space.continuous.steering_angle.low": "Angle de direction maximum droit (négatif)",
        "vehicle.action_space.continuous.speed.high": "Vitesse maximale (m/s)",
        "vehicle.action_space.continuous.speed.low": "Vitesse minimale (m/s)",
        "vehicle.action_space.discrete": "Espace d'action discret",
        "vehicle.neural_network": "Architecture du modèle CNN",
        "vehicle.sensor.preprocess_type": "Type de prétraitement des données d'entrée",
        "training.algorithm": "Algorithme d'entraînement du modèle",
        "training.round_robin_advanced": "Ratio round robin pendant l'entraînement du modèle",
        "training.min_evaluation_number_of_trials": "Nombre minimum d'essais d'évaluation",
        "training.hyperparameters.batch_size": "Taille du lot (nombre de paquets de données pour les mises à jour de poids)",
        "training.hyperparameters.discount_factor": "Facteur de remise (poids pour les récompenses futures)",
        "training.hyperparameters.learning_rate": "Taux d'apprentissage (intensité de mise à jour des poids)",
        "training.hyperparameters.loss_type": "Type de perte (fonction de perte pour les mises à jour de poids)",
        "training.hyperparameters.entropy": "Entropie (aléatoire)",
        "training.hyperparameters.sac_alpha": "SAC alpha (aléatoire)",
        "training.hyperparameters.e_greedy_value": "Valeur E-Greedy",
        "training.hyperparameters.epsilon_steps": "Étapes epsilon",
        "training.hyperparameters.exploration_type": "Type d'exploration",
        "training.hyperparameters.stack_size": "Taille de pile",
        "training.hyperparameters.term_cond_avg_score": "Condition de terminaison score moyen",
        "training.hyperparameters.term_cond_max_episodes": "Condition de terminaison épisodes maximum",
        "training.hyperparameters.num_episodes_between_training": "Nombre d'épisodes entre les mises à jour de politique",
        "training.hyperparameters.num_epochs": "Nombre d'époques",
        "training.best_model_metric": "Métrique du meilleur modèle",
        "auto_test_after_training": "Test automatique après entraînement",
        "test.number_of_trials": "Nombre de tours d'évaluation de test",
        "test.checkpoint": "Point de contrôle du modèle à tester",
        "test.penalty.is_offtrack": "Pénalité pour sortir de la piste (secondes)",
        "test.penalty.is_crashed": "Pénalité pour accident (secondes)",
        "test.max_resets": "Resets maximum (hors piste et accidents)",
        "test.is_continuous": "Mesurer le tour suivant sans s'arrêter à la ligne d'arrivée",
        "test.save_mp4": "S'il faut sauvegarder la vidéo de test",
        "test.crash_reset_behind_dist": "Distance de l'objet pour reset après accident",
        "test.car_name": "Nom du véhicule de test",
    },
    "hi": {
        "job_type": "क्या प्रशिक्षण या परीक्षण",
        "model_name": "मॉडल नाम",
        "pretrained": "क्या पूर्व-प्रशिक्षित मॉडल का उपयोग करना है",
        "pretrained_model_name": "पूर्व-प्रशिक्षित मॉडल का नाम",
        "pretrained_checkpoint": "पूर्व-प्रशिक्षित मॉडल का चेकपॉइंट",
        "system.enable_gui": "GUI सक्षम करें",
        "system.version": "संस्करण",
        "system.enable_main_camera": "मुख्य कैमरा सक्षम करें",
        "system.enable_sub_camera": "उप कैमरा सक्षम करें",
        "system.enable_kvs_camera": "KVS कैमरा सक्षम करें",
        "system.train_multi_config": "बहु-कॉन्फ़िगरेशन प्रशिक्षण",
        "simulation.number_of_sub_simulations": "बहु-प्रशिक्षण के लिए उप-सिमुलेशन की संख्या",
        **{f"simulation.{sim_idx}.car_color": f"{sim_idx} का कार रंग" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"{sim_idx} का ट्रैक" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"ट्रैक ड्राइविंग दिशा" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"प्रशिक्षण के दौरान ड्राइविंग दिशा को बारी-बारी से करना है या नहीं" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"रेस प्रकार (Time Trial: खाली ट्रैक पर ड्राइविंग, Object Avoidance: बाधाओं से बचना)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"बाधा ऑब्जेक्ट प्रकार" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"बाधाओं की संख्या" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"बाधा स्थानों को यादृच्छिक करना है या नहीं" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"बाधाओं के बीच न्यूनतम दूरी" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"बाधा स्थान" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "कैमरों की संख्या",
        "vehicle.sensor.lidar": "LiDAR का उपयोग करना है या नहीं",
        "vehicle.action_space_type": "क्रिया स्थान (मॉडल आउटपुट)",
        "vehicle.action_space.continuous": "निरंतर क्रिया स्थान",
        "vehicle.action_space.continuous.steering_angle.high": "अधिकतम बाएं स्टीयरिंग कोण (सकारात्मक)",
        "vehicle.action_space.continuous.steering_angle.low": "अधिकतम दाएं स्टीयरिंग कोण (नकारात्मक)",
        "vehicle.action_space.continuous.speed.high": "अधिकतम गति (m/s)",
        "vehicle.action_space.continuous.speed.low": "न्यूनतम गति (m/s)",
        "vehicle.action_space.discrete": "असतत क्रिया स्थान",
        "vehicle.neural_network": "CNN मॉडल आर्किटेक्चर",
        "vehicle.sensor.preprocess_type": "इनपुट डेटा प्रीप्रोसेसिंग प्रकार",
        "training.algorithm": "मॉडल प्रशिक्षण एल्गोरिदम",
        "training.round_robin_advanced": "मॉडल प्रशिक्षण के दौरान राउंड रॉबिन अनुपात",
        "training.min_evaluation_number_of_trials": "न्यूनतम मूल्यांकन प्रयासों की संख्या",
        "training.hyperparameters.batch_size": "बैच आकार (वजन अपडेट के लिए डेटा बंडलों की संख्या)",
        "training.hyperparameters.discount_factor": "छूट कारक (भविष्य के पुरस्कारों के लिए वजन)",
        "training.hyperparameters.learning_rate": "शिक्षण दर (वजन अपडेट तीव्रता)",
        "training.hyperparameters.loss_type": "हानि प्रकार (वजन अपडेट के लिए हानि फ़ंक्शन)",
        "training.hyperparameters.entropy": "एन्ट्रॉपी (यादृच्छिकता)",
        "training.hyperparameters.sac_alpha": "SAC अल्फा (यादृच्छिकता)",
        "training.hyperparameters.e_greedy_value": "E-Greedy मान",
        "training.hyperparameters.epsilon_steps": "एप्सिलॉन स्टेप्स",
        "training.hyperparameters.exploration_type": "अन्वेषण प्रकार",
        "training.hyperparameters.stack_size": "स्टैक आकार",
        "training.hyperparameters.term_cond_avg_score": "औसत स्कोर समाप्ति शर्त",
        "training.hyperparameters.term_cond_max_episodes": "अधिकतम एपिसोड समाप्ति शर्त",
        "training.hyperparameters.num_episodes_between_training": "नीति अपडेट के बीच एपिसोड की संख्या",
        "training.hyperparameters.num_epochs": "युगों की संख्या",
        "training.best_model_metric": "सर्वोत्तम मॉडल मेट्रिक",
        "auto_test_after_training": "प्रशिक्षण के बाद स्वचालित परीक्षण",
        "test.number_of_trials": "परीक्षण मूल्यांकन लैप्स की संख्या",
        "test.checkpoint": "परीक्षण करने वाले मॉडल का चेकपॉइंट",
        "test.penalty.is_offtrack": "ट्रैक से बाहर जाने पर जुर्माना (सेकंड)",
        "test.penalty.is_crashed": "दुर्घटना पर जुर्माना (सेकंड)",
        "test.max_resets": "अधिकतम रीसेट (ऑफ-ट्रैक और दुर्घटनाएं)",
        "test.is_continuous": "फिनिश लाइन पर रुके बिना अगली लैप मापें",
        "test.save_mp4": "परीक्षण वीडियो सहेजना है या नहीं",
        "test.crash_reset_behind_dist": "दुर्घटना के बाद रीसेट के लिए ऑब्जेक्ट से दूरी",
        "test.car_name": "परीक्षण वाहन नाम",
    },
    "vi": {
        "job_type": "Có phải đào tạo hay kiểm tra",
        "model_name": "Tên mô hình",
        "pretrained": "Có sử dụng mô hình được đào tạo trước hay không",
        "pretrained_model_name": "Tên của mô hình được đào tạo trước",
        "pretrained_checkpoint": "Checkpoint của mô hình được đào tạo trước",
        "system.enable_gui": "Kích hoạt GUI",
        "system.version": "Phiên bản",
        "system.enable_main_camera": "Kích hoạt camera chính",
        "system.enable_sub_camera": "Kích hoạt camera phụ",
        "system.enable_kvs_camera": "Kích hoạt camera KVS",
        "system.train_multi_config": "Đào tạo đa cấu hình",
        "simulation.number_of_sub_simulations": "Số lượng mô phỏng con cho đào tạo đa phương thức",
        **{f"simulation.{sim_idx}.car_color": f"Màu xe của {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"Đường đua của {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"Hướng lái xe trên đường đua" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"Có luân phiên hướng lái trong quá trình đào tạo hay không" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"Loại đua (Time Trial: lái trên đường đua trống, Object Avoidance: tránh chướng ngại vật)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"Loại vật thể chướng ngại" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"Số lượng chướng ngại vật" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"Có ngẫu nhiên hóa vị trí chướng ngại vật hay không" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"Khoảng cách tối thiểu giữa các chướng ngại vật" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"Vị trí chướng ngại vật" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "Số lượng camera",
        "vehicle.sensor.lidar": "Có sử dụng LiDAR hay không",
        "vehicle.action_space_type": "Không gian hành động (đầu ra mô hình)",
        "vehicle.action_space.continuous": "Không gian hành động liên tục",
        "vehicle.action_space.continuous.steering_angle.high": "Góc lái tối đa bên trái (dương)",
        "vehicle.action_space.continuous.steering_angle.low": "Góc lái tối đa bên phải (âm)",
        "vehicle.action_space.continuous.speed.high": "Tốc độ tối đa (m/s)",
        "vehicle.action_space.continuous.speed.low": "Tốc độ tối thiểu (m/s)",
        "vehicle.action_space.discrete": "Không gian hành động rời rạc",
        "vehicle.neural_network": "Kiến trúc mô hình CNN",
        "vehicle.sensor.preprocess_type": "Loại tiền xử lý dữ liệu đầu vào",
        "training.algorithm": "Thuật toán đào tạo mô hình",
        "training.round_robin_advanced": "Tỷ lệ round robin trong quá trình đào tạo mô hình",
        "training.min_evaluation_number_of_trials": "Số lần thử đánh giá tối thiểu",
        "training.hyperparameters.batch_size": "Kích thước batch (số gói dữ liệu cho cập nhật trọng số)",
        "training.hyperparameters.discount_factor": "Hệ số chiết khấu (trọng số cho phần thưởng tương lai)",
        "training.hyperparameters.learning_rate": "Tốc độ học (cường độ cập nhật trọng số)",
        "training.hyperparameters.loss_type": "Loại mất mát (hàm mất mát cho cập nhật trọng số)",
        "training.hyperparameters.entropy": "Entropy (tính ngẫu nhiên)",
        "training.hyperparameters.sac_alpha": "SAC alpha (tính ngẫu nhiên)",
        "training.hyperparameters.e_greedy_value": "Giá trị E-Greedy",
        "training.hyperparameters.epsilon_steps": "Các bước epsilon",
        "training.hyperparameters.exploration_type": "Loại khám phá",
        "training.hyperparameters.stack_size": "Kích thước ngăn xếp",
        "training.hyperparameters.term_cond_avg_score": "Điều kiện kết thúc điểm trung bình",
        "training.hyperparameters.term_cond_max_episodes": "Điều kiện kết thúc số tập tối đa",
        "training.hyperparameters.num_episodes_between_training": "Số tập giữa các lần cập nhật chính sách",
        "training.hyperparameters.num_epochs": "Số epochs",
        "training.best_model_metric": "Chỉ số mô hình tốt nhất",
        "auto_test_after_training": "Tự động kiểm tra sau đào tạo",
        "test.number_of_trials": "Số vòng đánh giá kiểm tra",
        "test.checkpoint": "Checkpoint của mô hình để kiểm tra",
        "test.penalty.is_offtrack": "Phạt khi ra khỏi đường đua (giây)",
        "test.penalty.is_crashed": "Phạt khi va chạm (giây)",
        "test.max_resets": "Số lần reset tối đa (ra khỏi đường đua và va chạm)",
        "test.is_continuous": "Đo vòng tiếp theo mà không dừng ở vạch đích",
        "test.save_mp4": "Có lưu video kiểm tra hay không",
        "test.crash_reset_behind_dist": "Khoảng cách từ vật thể để reset sau va chạm",
        "test.car_name": "Tên phương tiện kiểm tra",
    },
    "ja": {
        "job_type": "トレーニングかテストか",
        "model_name": "モデル名",
        "pretrained": "事前トレーニング済みモデルを使用するかどうか",
        "pretrained_model_name": "事前トレーニング済みモデルの名前",
        "pretrained_checkpoint": "事前トレーニング済みモデルのチェックポイント",
        "system.enable_gui": "GUI有効化",
        "system.version": "バージョン",
        "system.enable_main_camera": "メインカメラ有効化",
        "system.enable_sub_camera": "サブカメラ有効化",
        "system.enable_kvs_camera": "KVSカメラ有効化",
        "system.train_multi_config": "マルチ構成トレーニング",
        "simulation.number_of_sub_simulations": "マルチトレーニング用のサブシミュレーション数",
        **{f"simulation.{sim_idx}.car_color": f"{sim_idx}の車の色" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"{sim_idx}のトラック" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"トラック走行方向" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"トレーニング中に走行方向を交互にするかどうか" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"レースタイプ (Time Trial: 空のトラックで走行, Object Avoidance: 障害物回避)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"障害物オブジェクトタイプ" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"障害物の数" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"障害物の位置をランダム化するかどうか" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"障害物間の最小距離" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"障害物の位置" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "カメラの数",
        "vehicle.sensor.lidar": "LiDARを使用するかどうか",
        "vehicle.action_space_type": "アクション空間（モデル出力）",
        "vehicle.action_space.continuous": "連続アクション空間",
        "vehicle.action_space.continuous.steering_angle.high": "最大左ステアリング角度（正数）",
        "vehicle.action_space.continuous.steering_angle.low": "最大右ステアリング角度（負数）",
        "vehicle.action_space.continuous.speed.high": "最大速度（m/s）",
        "vehicle.action_space.continuous.speed.low": "最小速度（m/s）",
        "vehicle.action_space.discrete": "離散アクション空間",
        "vehicle.neural_network": "CNNモデルアーキテクチャ",
        "vehicle.sensor.preprocess_type": "入力データの前処理タイプ",
        "training.algorithm": "モデルトレーニングアルゴリズム",
        "training.round_robin_advanced": "モデルトレーニング中のラウンドロビン比率",
        "training.min_evaluation_number_of_trials": "最小評価試行回数",
        "training.hyperparameters.batch_size": "バッチサイズ（重み更新用のデータバンドル数）",
        "training.hyperparameters.discount_factor": "割引係数（将来の報酬の重み）",
        "training.hyperparameters.learning_rate": "学習率（重み更新の強度）",
        "training.hyperparameters.loss_type": "損失タイプ（重み更新用の損失関数）",
        "training.hyperparameters.entropy": "エントロピー（ランダム性）",
        "training.hyperparameters.sac_alpha": "SACアルファ（ランダム性）",
        "training.hyperparameters.e_greedy_value": "E-Greedy値",
        "training.hyperparameters.epsilon_steps": "エプシロンステップ",
        "training.hyperparameters.exploration_type": "探索タイプ",
        "training.hyperparameters.stack_size": "スタックサイズ",
        "training.hyperparameters.term_cond_avg_score": "平均スコア終了条件",
        "training.hyperparameters.term_cond_max_episodes": "最大エピソード終了条件",
        "training.hyperparameters.num_episodes_between_training": "ポリシー更新間のエピソード数",
        "training.hyperparameters.num_epochs": "エポック数",
        "training.best_model_metric": "最良モデルメトリック",
        "auto_test_after_training": "トレーニング後の自動テスト",
        "test.number_of_trials": "テスト評価ラップ数",
        "test.checkpoint": "テストするモデルのチェックポイント",
        "test.penalty.is_offtrack": "トラック外れ時のペナルティ（秒）",
        "test.penalty.is_crashed": "クラッシュ時のペナルティ（秒）",
        "test.max_resets": "最大リセット数（トラック外れとクラッシュ）",
        "test.is_continuous": "フィニッシュラインで止まらずに次のラップを測定",
        "test.save_mp4": "テストビデオを保存するかどうか",
        "test.crash_reset_behind_dist": "クラッシュ後のリセット用オブジェクトからの距離",
        "test.car_name": "テスト車両名",
    },
    "pl": {
        "job_type": "Czy trening czy test",
        "model_name": "Nazwa modelu",
        "pretrained": "Czy używać wstępnie wytrenowanego modelu",
        "pretrained_model_name": "Nazwa wstępnie wytrenowanego modelu",
        "pretrained_checkpoint": "Punkt kontrolny wstępnie wytrenowanego modelu",
        "system.enable_gui": "Włącz GUI",
        "system.version": "Wersja",
        "system.enable_main_camera": "Włącz główną kamerę",
        "system.enable_sub_camera": "Włącz kamerę pomocniczą",
        "system.enable_kvs_camera": "Włącz kamerę KVS",
        "system.train_multi_config": "Trening wielokonfiguracyjny",
        "simulation.number_of_sub_simulations": "Liczba pod-symulacji dla wielotreningu",
        **{f"simulation.{sim_idx}.car_color": f"Kolor samochodu {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"Tor {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"Kierunek jazdy po torze" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"Czy zmieniać kierunek jazdy podczas treningu" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"Typ wyścigu (Time Trial: jazda po pustym torze, Object Avoidance: unikanie przeszkód)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"Typ obiektu przeszkody" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"Liczba przeszkód" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"Czy losować położenia przeszkód" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"Minimalna odległość między przeszkodami" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"Położenia przeszkód" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "Liczba kamer",
        "vehicle.sensor.lidar": "Czy używać LiDAR",
        "vehicle.action_space_type": "Przestrzeń akcji (wyjście modelu)",
        "vehicle.action_space.continuous": "Ciągła przestrzeń akcji",
        "vehicle.action_space.continuous.steering_angle.high": "Maksymalny lewy kąt skrętu (dodatni)",
        "vehicle.action_space.continuous.steering_angle.low": "Maksymalny prawy kąt skrętu (ujemny)",
        "vehicle.action_space.continuous.speed.high": "Maksymalna prędkość (m/s)",
        "vehicle.action_space.continuous.speed.low": "Minimalna prędkość (m/s)",
        "vehicle.action_space.discrete": "Dyskretna przestrzeń akcji",
        "vehicle.neural_network": "Architektura modelu CNN",
        "vehicle.sensor.preprocess_type": "Typ przetwarzania wstępnego danych wejściowych",
        "training.algorithm": "Algorytm treningu modelu",
        "training.round_robin_advanced": "Współczynnik round robin podczas treningu modelu",
        "training.min_evaluation_number_of_trials": "Minimalna liczba prób ewaluacji",
        "training.hyperparameters.batch_size": "Rozmiar batch (liczba pakietów danych do aktualizacji wag)",
        "training.hyperparameters.discount_factor": "Współczynnik dyskonta (waga dla przyszłych nagród)",
        "training.hyperparameters.learning_rate": "Współczynnik uczenia (intensywność aktualizacji wag)",
        "training.hyperparameters.loss_type": "Typ straty (funkcja straty dla aktualizacji wag)",
        "training.hyperparameters.entropy": "Entropia (losowość)",
        "training.hyperparameters.sac_alpha": "SAC alpha (losowość)",
        "training.hyperparameters.e_greedy_value": "Wartość E-Greedy",
        "training.hyperparameters.epsilon_steps": "Kroki epsilon",
        "training.hyperparameters.exploration_type": "Typ eksploracji",
        "training.hyperparameters.stack_size": "Rozmiar stosu",
        "training.hyperparameters.term_cond_avg_score": "Warunek zakończenia średniego wyniku",
        "training.hyperparameters.term_cond_max_episodes": "Warunek zakończenia maksymalnych epizodów",
        "training.hyperparameters.num_episodes_between_training": "Liczba epizodów między aktualizacjami polityki",
        "training.hyperparameters.num_epochs": "Liczba epok",
        "training.best_model_metric": "Metryka najlepszego modelu",
        "auto_test_after_training": "Automatyczny test po treningu",
        "test.number_of_trials": "Liczba okrążeń ewaluacji testu",
        "test.checkpoint": "Punkt kontrolny modelu do testowania",
        "test.penalty.is_offtrack": "Kara za zjechanie z toru (sekundy)",
        "test.penalty.is_crashed": "Kara za wypadek (sekundy)",
        "test.max_resets": "Maksymalne resety (zjazdy z toru i wypadki)",
        "test.is_continuous": "Mierz następne okrążenie bez zatrzymywania na linii mety",
        "test.save_mp4": "Czy zapisać wideo testu",
        "test.crash_reset_behind_dist": "Odległość od obiektu do resetu po wypadku",
        "test.car_name": "Nazwa pojazdu testowego",
    },
    "ru": {
        "job_type": "Обучение или тестирование",
        "model_name": "Название модели",
        "pretrained": "Использовать ли предобученную модель",
        "pretrained_model_name": "Название предобученной модели",
        "pretrained_checkpoint": "Контрольная точка предобученной модели",
        "system.enable_gui": "Включить GUI",
        "system.version": "Версия",
        "system.enable_main_camera": "Включить основную камеру",
        "system.enable_sub_camera": "Включить дополнительную камеру",
        "system.enable_kvs_camera": "Включить камеру KVS",
        "system.train_multi_config": "Многоконфигурационное обучение",
        "simulation.number_of_sub_simulations": "Количество под-симуляций для мульти-обучения",
        **{f"simulation.{sim_idx}.car_color": f"Цвет автомобиля {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"Трек {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"Направление движения по треку" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"Чередовать ли направление движения во время обучения" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"Тип гонки (Time Trial: движение по пустому треку, Object Avoidance: избегание препятствий)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"Тип объекта препятствия" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"Количество препятствий" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"Рандомизировать ли расположения препятствий" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"Минимальное расстояние между препятствиями" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"Расположения препятствий" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "Количество камер",
        "vehicle.sensor.lidar": "Использовать ли LiDAR",
        "vehicle.action_space_type": "Пространство действий (выход модели)",
        "vehicle.action_space.continuous": "Непрерывное пространство действий",
        "vehicle.action_space.continuous.steering_angle.high": "Максимальный левый угол поворота (положительный)",
        "vehicle.action_space.continuous.steering_angle.low": "Максимальный правый угол поворота (отрицательный)",
        "vehicle.action_space.continuous.speed.high": "Максимальная скорость (м/с)",
        "vehicle.action_space.continuous.speed.low": "Минимальная скорость (м/с)",
        "vehicle.action_space.discrete": "Дискретное пространство действий",
        "vehicle.neural_network": "Архитектура модели CNN",
        "vehicle.sensor.preprocess_type": "Тип предобработки входных данных",
        "training.algorithm": "Алгоритм обучения модели",
        "training.round_robin_advanced": "Коэффициент round robin во время обучения модели",
        "training.min_evaluation_number_of_trials": "Минимальное количество попыток оценки",
        "training.hyperparameters.batch_size": "Размер пакета (количество пакетов данных для обновления весов)",
        "training.hyperparameters.discount_factor": "Коэффициент дисконтирования (вес для будущих наград)",
        "training.hyperparameters.learning_rate": "Скорость обучения (интенсивность обновления весов)",
        "training.hyperparameters.loss_type": "Тип потерь (функция потерь для обновления весов)",
        "training.hyperparameters.entropy": "Энтропия (случайность)",
        "training.hyperparameters.sac_alpha": "SAC альфа (случайность)",
        "training.hyperparameters.e_greedy_value": "Значение E-Greedy",
        "training.hyperparameters.epsilon_steps": "Шаги эпсилон",
        "training.hyperparameters.exploration_type": "Тип исследования",
        "training.hyperparameters.stack_size": "Размер стека",
        "training.hyperparameters.term_cond_avg_score": "Условие завершения среднего счета",
        "training.hyperparameters.term_cond_max_episodes": "Условие завершения максимальных эпизодов",
        "training.hyperparameters.num_episodes_between_training": "Количество эпизодов между обновлениями политики",
        "training.hyperparameters.num_epochs": "Количество эпох",
        "training.best_model_metric": "Метрика лучшей модели",
        "auto_test_after_training": "Автоматическое тестирование после обучения",
        "test.number_of_trials": "Количество кругов оценки теста",
        "test.checkpoint": "Контрольная точка модели для тестирования",
        "test.penalty.is_offtrack": "Штраф за съезд с трека (секунды)",
        "test.penalty.is_crashed": "Штраф за аварию (секунды)",
        "test.max_resets": "Максимальные сбросы (съезды с трека и аварии)",
        "test.is_continuous": "Измерить следующий круг без остановки на финишной линии",
        "test.save_mp4": "Сохранять ли видео теста",
        "test.crash_reset_behind_dist": "Расстояние от объекта для сброса после аварии",
        "test.car_name": "Название тестового транспортного средства",
    },
    "th": {
        "job_type": "ว่าเป็นการฝึกอบรมหรือการทดสอบ",
        "model_name": "ชื่อโมเดล",
        "pretrained": "ว่าจะใช้โมเดลที่ฝึกอบรมล่วงหน้าหรือไม่",
        "pretrained_model_name": "ชื่อของโมเดลที่ฝึกอบรมล่วงหน้า",
        "pretrained_checkpoint": "จุดตรวจสอบของโมเดลที่ฝึกอบรมล่วงหน้า",
        "system.enable_gui": "เปิดใช้งาน GUI",
        "system.version": "รุ่น",
        "system.enable_main_camera": "เปิดใช้งานกล้องหลัก",
        "system.enable_sub_camera": "เปิดใช้งานกล้องย่อย",
        "system.enable_kvs_camera": "เปิดใช้งานกล้อง KVS",
        "system.train_multi_config": "การฝึกอบรมหลายการกำหนดค่า",
        "simulation.number_of_sub_simulations": "จำนวนการจำลองย่อยสำหรับการฝึกอบรมหลายรูปแบบ",
        **{f"simulation.{sim_idx}.car_color": f"สีรถของ {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"ลู่วิ่งของ {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"ทิศทางการขับขี่บนลู่วิ่ง" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"ว่าจะสลับทิศทางการขับขี่ระหว่างการฝึกอบรมหรือไม่" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"ประเภทการแข่งขัน (Time Trial: ขับขี่บนลู่ว่าง, Object Avoidance: หลีกเลี่ยงสิ่งกีดขวาง)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"ประเภทวัตถุสิ่งกีดขวาง" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"จำนวนสิ่งกีดขวาง" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"ว่าจะสุ่มตำแหน่งสิ่งกีดขวางหรือไม่" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"ระยะทางขั้นต่ำระหว่างสิ่งกีดขวาง" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"ตำแหน่งสิ่งกีดขวาง" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "จำนวนกล้อง",
        "vehicle.sensor.lidar": "ว่าจะใช้ LiDAR หรือไม่",
        "vehicle.action_space_type": "พื้นที่การกระทำ (เอาต์พุตโมเดล)",
        "vehicle.action_space.continuous": "พื้นที่การกระทำต่อเนื่อง",
        "vehicle.action_space.continuous.steering_angle.high": "มุมพวงมาลัยซ้ายสูงสุด (บวก)",
        "vehicle.action_space.continuous.steering_angle.low": "มุมพวงมาลัยขวาสูงสุด (ลบ)",
        "vehicle.action_space.continuous.speed.high": "ความเร็วสูงสุด (ม./วิ.)",
        "vehicle.action_space.continuous.speed.low": "ความเร็วขั้นต่ำ (ม./วิ.)",
        "vehicle.action_space.discrete": "พื้นที่การกระทำแยกจากกัน",
        "vehicle.neural_network": "สถาปัตยกรรมโมเดล CNN",
        "vehicle.sensor.preprocess_type": "ประเภทการประมวลผลล่วงหน้าของข้อมูลอินพุต",
        "training.algorithm": "อัลกอริทึมการฝึกอบรมโมเดล",
        "training.round_robin_advanced": "อัตราส่วน round robin ระหว่างการฝึกอบรมโมเดล",
        "training.min_evaluation_number_of_trials": "จำนวนขั้นต่ำของการทดลองประเมิน",
        "training.hyperparameters.batch_size": "ขนาดแบทช์ (จำนวนกลุ่มข้อมูลสำหรับการอัปเดตน้ำหนัก)",
        "training.hyperparameters.discount_factor": "ปัจจัยส่วนลด (น้ำหนักสำหรับรางวัลในอนาคต)",
        "training.hyperparameters.learning_rate": "อัตราการเรียนรู้ (ความเข้มของการอัปเดตน้ำหนัก)",
        "training.hyperparameters.loss_type": "ประเภทการสูญเสีย (ฟังก์ชันการสูญเสียสำหรับการอัปเดตน้ำหนัก)",
        "training.hyperparameters.entropy": "เอนโทรปี (ความสุ่ม)",
        "training.hyperparameters.sac_alpha": "SAC อัลฟา (ความสุ่ม)",
        "training.hyperparameters.e_greedy_value": "ค่า E-Greedy",
        "training.hyperparameters.epsilon_steps": "ขั้นตอนเอปไซลอน",
        "training.hyperparameters.exploration_type": "ประเภทการสำรวจ",
        "training.hyperparameters.stack_size": "ขนาดสแต็ก",
        "training.hyperparameters.term_cond_avg_score": "เงื่อนไขการสิ้นสุดคะแนนเฉลี่ย",
        "training.hyperparameters.term_cond_max_episodes": "เงื่อนไขการสิ้นสุดตอนสูงสุด",
        "training.hyperparameters.num_episodes_between_training": "จำนวนตอนระหว่างการอัปเดตนโยบาย",
        "training.hyperparameters.num_epochs": "จำนวนยุค",
        "training.best_model_metric": "เมตริกโมเดลที่ดีที่สุด",
        "auto_test_after_training": "ทดสอบอัตโนมัติหลังการฝึกอบรม",
        "test.number_of_trials": "จำนวนรอบการประเมินการทดสอบ",
        "test.checkpoint": "จุดตรวจสอบของโมเดลที่จะทดสอบ",
        "test.penalty.is_offtrack": "โทษสำหรับการออกนอกลู่ (วินาที)",
        "test.penalty.is_crashed": "โทษสำหรับการชน (วินาที)",
        "test.max_resets": "การรีเซ็ตสูงสุด (นอกลู่และการชน)",
        "test.is_continuous": "วัดรอบถัดไปโดยไม่หยุดที่เส้นชัย",
        "test.save_mp4": "ว่าจะบันทึกวิดีโอทดสอบหรือไม่",
        "test.crash_reset_behind_dist": "ระยะทางจากวัตถุเพื่อรีเซ็ตหลังการชน",
        "test.car_name": "ชื่อยานพาหนะทดสอบ",
    },
    "tr": {
        "job_type": "Eğitim mi test mi",
        "model_name": "Model adı",
        "pretrained": "Önceden eğitilmiş model kullanılıp kullanılmayacağı",
        "pretrained_model_name": "Önceden eğitilmiş modelin adı",
        "pretrained_checkpoint": "Önceden eğitilmiş modelin kontrol noktası",
        "system.enable_gui": "GUI'yi etkinleştir",
        "system.version": "Sürüm",
        "system.enable_main_camera": "Ana kamerayı etkinleştir",
        "system.enable_sub_camera": "Alt kamerayı etkinleştir",
        "system.enable_kvs_camera": "KVS kamerasını etkinleştir",
        "system.train_multi_config": "Çoklu yapılandırma eğitimi",
        "simulation.number_of_sub_simulations": "Çoklu eğitim için alt simülasyon sayısı",
        **{f"simulation.{sim_idx}.car_color": f"{sim_idx}'ın araba rengi" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"{sim_idx}'ın pisti" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"Pist sürüş yönü" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"Eğitim sırasında sürüş yönünü değiştirip değiştirmeyeceği" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"Yarış türü (Time Trial: boş pistte sürüş, Object Avoidance: engelleri kaçınma)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"Engel nesne türü" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"Engel sayısı" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"Engel konumlarını rastgele hale getirip getirmeyeceği" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"Engeller arası minimum mesafe" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"Engel konumları" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "Kamera sayısı",
        "vehicle.sensor.lidar": "LiDAR kullanılıp kullanılmayacağı",
        "vehicle.action_space_type": "Eylem alanı (model çıktısı)",
        "vehicle.action_space.continuous": "Sürekli eylem alanı",
        "vehicle.action_space.continuous.steering_angle.high": "Maksimum sol direksiyon açısı (pozitif)",
        "vehicle.action_space.continuous.steering_angle.low": "Maksimum sağ direksiyon açısı (negatif)",
        "vehicle.action_space.continuous.speed.high": "Maksimum hız (m/s)",
        "vehicle.action_space.continuous.speed.low": "Minimum hız (m/s)",
        "vehicle.action_space.discrete": "Ayrık eylem alanı",
        "vehicle.neural_network": "CNN model mimarisi",
        "vehicle.sensor.preprocess_type": "Giriş verisi ön işleme türü",
        "training.algorithm": "Model eğitim algoritması",
        "training.round_robin_advanced": "Model eğitimi sırasında round robin oranı",
        "training.min_evaluation_number_of_trials": "Minimum değerlendirme deneme sayısı",
        "training.hyperparameters.batch_size": "Batch boyutu (ağırlık güncellemeleri için veri paketi sayısı)",
        "training.hyperparameters.discount_factor": "İndirim faktörü (gelecek ödüller için ağırlık)",
        "training.hyperparameters.learning_rate": "Öğrenme oranı (ağırlık güncelleme yoğunluğu)",
        "training.hyperparameters.loss_type": "Kayıp türü (ağırlık güncellemeleri için kayıp fonksiyonu)",
        "training.hyperparameters.entropy": "Entropi (rastgelelik)",
        "training.hyperparameters.sac_alpha": "SAC alfa (rastgelelik)",
        "training.hyperparameters.e_greedy_value": "E-Greedy değeri",
        "training.hyperparameters.epsilon_steps": "Epsilon adımları",
        "training.hyperparameters.exploration_type": "Keşif türü",
        "training.hyperparameters.stack_size": "Yığın boyutu",
        "training.hyperparameters.term_cond_avg_score": "Ortalama skor sonlandırma koşulu",
        "training.hyperparameters.term_cond_max_episodes": "Maksimum bölüm sonlandırma koşulu",
        "training.hyperparameters.num_episodes_between_training": "Politika güncellemeleri arasındaki bölüm sayısı",
        "training.hyperparameters.num_epochs": "Epoch sayısı",
        "training.best_model_metric": "En iyi model metriği",
        "auto_test_after_training": "Eğitim sonrası otomatik test",
        "test.number_of_trials": "Test değerlendirme tur sayısı",
        "test.checkpoint": "Test edilecek modelin kontrol noktası",
        "test.penalty.is_offtrack": "Pistten çıkma cezası (saniye)",
        "test.penalty.is_crashed": "Çarpışma cezası (saniye)",
        "test.max_resets": "Maksimum sıfırlama (pistten çıkma ve çarpışmalar)",
        "test.is_continuous": "Bitiş çizgisinde durmadan bir sonraki turu ölç",
        "test.save_mp4": "Test videosunu kaydetme",
        "test.crash_reset_behind_dist": "Çarpışma sonrası sıfırlama için nesneden uzaklık",
        "test.car_name": "Test aracı adı",
    },
    "zh-hans": {
        "job_type": "是训练还是测试",
        "model_name": "模型名称",
        "pretrained": "是否使用预训练模型",
        "pretrained_model_name": "预训练模型的名称",
        "pretrained_checkpoint": "预训练模型的检查点",
        "system.enable_gui": "启用GUI",
        "system.version": "版本",
        "system.enable_main_camera": "启用主摄像头",
        "system.enable_sub_camera": "启用子摄像头",
        "system.enable_kvs_camera": "启用KVS摄像头",
        "system.train_multi_config": "多配置训练",
        "simulation.number_of_sub_simulations": "多训练的子模拟数量",
        **{f"simulation.{sim_idx}.car_color": f"{sim_idx}的汽车颜色" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"{sim_idx}的赛道" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"赛道驾驶方向" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"训练期间是否交替驾驶方向" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"比赛类型 (Time Trial: 在空赛道上驾驶, Object Avoidance: 避开障碍物)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"障碍物对象类型" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"障碍物数量" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"是否随机化障碍物位置" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"障碍物之间的最小距离" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"障碍物位置" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "摄像头数量",
        "vehicle.sensor.lidar": "是否使用激光雷达",
        "vehicle.action_space_type": "动作空间（模型输出）",
        "vehicle.action_space.continuous": "连续动作空间",
        "vehicle.action_space.continuous.steering_angle.high": "最大左转角度（正数）",
        "vehicle.action_space.continuous.steering_angle.low": "最大右转角度（负数）",
        "vehicle.action_space.continuous.speed.high": "最大速度（米/秒）",
        "vehicle.action_space.continuous.speed.low": "最小速度（米/秒）",
        "vehicle.action_space.discrete": "离散动作空间",
        "vehicle.neural_network": "CNN模型架构",
        "vehicle.sensor.preprocess_type": "输入数据预处理类型",
        "training.algorithm": "模型训练算法",
        "training.round_robin_advanced": "模型训练期间的轮询比率",
        "training.min_evaluation_number_of_trials": "最少评估试验次数",
        "training.hyperparameters.batch_size": "批次大小（权重更新的数据包数量）",
        "training.hyperparameters.discount_factor": "折扣因子（未来奖励的权重）",
        "training.hyperparameters.learning_rate": "学习率（权重更新强度）",
        "training.hyperparameters.loss_type": "损失类型（权重更新的损失函数）",
        "training.hyperparameters.entropy": "熵（随机性）",
        "training.hyperparameters.sac_alpha": "SAC α（随机性）",
        "training.hyperparameters.e_greedy_value": "E-Greedy值",
        "training.hyperparameters.epsilon_steps": "ε步骤",
        "training.hyperparameters.exploration_type": "探索类型",
        "training.hyperparameters.stack_size": "堆栈大小",
        "training.hyperparameters.term_cond_avg_score": "平均分数终止条件",
        "training.hyperparameters.term_cond_max_episodes": "最大剧集终止条件",
        "training.hyperparameters.num_episodes_between_training": "策略更新之间的剧集数量",
        "training.hyperparameters.num_epochs": "时期数",
        "training.best_model_metric": "最佳模型指标",
        "auto_test_after_training": "训练后自动测试",
        "test.number_of_trials": "测试评估圈数",
        "test.checkpoint": "要测试的模型检查点",
        "test.penalty.is_offtrack": "偏离赛道的惩罚（秒）",
        "test.penalty.is_crashed": "撞车的惩罚（秒）",
        "test.max_resets": "最大重置次数（偏离赛道和撞车）",
        "test.is_continuous": "不在终点线停车测量下一圈",
        "test.save_mp4": "是否保存测试视频",
        "test.crash_reset_behind_dist": "撞车后重置的物体距离",
        "test.car_name": "测试车辆名称",
    },
    "zh-hant": {
        "job_type": "是訓練還是測試",
        "model_name": "模型名稱",
        "pretrained": "是否使用預訓練模型",
        "pretrained_model_name": "預訓練模型的名稱",
        "pretrained_checkpoint": "預訓練模型的檢查點",
        "system.enable_gui": "啟用GUI",
        "system.version": "版本",
        "system.enable_main_camera": "啟用主攝影機",
        "system.enable_sub_camera": "啟用子攝影機",
        "system.enable_kvs_camera": "啟用KVS攝影機",
        "system.train_multi_config": "多配置訓練",
        "simulation.number_of_sub_simulations": "多訓練的子模擬數量",
        **{f"simulation.{sim_idx}.car_color": f"{sim_idx}的汽車顏色" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"{sim_idx}的賽道" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"賽道駕駛方向" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"訓練期間是否交替駕駛方向" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"比賽類型 (Time Trial: 在空賽道上駕駛, Object Avoidance: 避開障礙物)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"障礙物對象類型" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"障礙物數量" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"是否隨機化障礙物位置" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"障礙物之間的最小距離" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"障礙物位置" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "攝影機數量",
        "vehicle.sensor.lidar": "是否使用雷射雷達",
        "vehicle.action_space_type": "動作空間（模型輸出）",
        "vehicle.action_space.continuous": "連續動作空間",
        "vehicle.action_space.continuous.steering_angle.high": "最大左轉角度（正數）",
        "vehicle.action_space.continuous.steering_angle.low": "最大右轉角度（負數）",
        "vehicle.action_space.continuous.speed.high": "最大速度（公尺/秒）",
        "vehicle.action_space.continuous.speed.low": "最小速度（公尺/秒）",
        "vehicle.action_space.discrete": "離散動作空間",
        "vehicle.neural_network": "CNN模型架構",
        "vehicle.sensor.preprocess_type": "輸入資料預處理類型",
        "training.algorithm": "模型訓練演算法",
        "training.round_robin_advanced": "模型訓練期間的輪詢比率",
        "training.min_evaluation_number_of_trials": "最少評估試驗次數",
        "training.hyperparameters.batch_size": "批次大小（權重更新的資料包數量）",
        "training.hyperparameters.discount_factor": "折扣因子（未來獎勵的權重）",
        "training.hyperparameters.learning_rate": "學習率（權重更新強度）",
        "training.hyperparameters.loss_type": "損失類型（權重更新的損失函數）",
        "training.hyperparameters.entropy": "熵（隨機性）",
        "training.hyperparameters.sac_alpha": "SAC α（隨機性）",
        "training.hyperparameters.e_greedy_value": "E-Greedy值",
        "training.hyperparameters.epsilon_steps": "ε步驟",
        "training.hyperparameters.exploration_type": "探索類型",
        "training.hyperparameters.stack_size": "堆疊大小",
        "training.hyperparameters.term_cond_avg_score": "平均分數終止條件",
        "training.hyperparameters.term_cond_max_episodes": "最大劇集終止條件",
        "training.hyperparameters.num_episodes_between_training": "策略更新之間的劇集數量",
        "training.hyperparameters.num_epochs": "時期數",
        "training.best_model_metric": "最佳模型指標",
        "auto_test_after_training": "訓練後自動測試",
        "test.number_of_trials": "測試評估圈數",
        "test.checkpoint": "要測試的模型檢查點",
        "test.penalty.is_offtrack": "偏離賽道的懲罰（秒）",
        "test.penalty.is_crashed": "撞車的懲罰（秒）",
        "test.max_resets": "最大重置次數（偏離賽道和撞車）",
        "test.is_continuous": "不在終點線停車測量下一圈",
        "test.save_mp4": "是否保存測試影片",
        "test.crash_reset_behind_dist": "撞車後重置的物體距離",
        "test.car_name": "測試車輛名稱",
    },
    "id": {
        "job_type": "Apakah pelatihan atau pengujian",
        "model_name": "Nama model",
        "pretrained": "Apakah menggunakan model yang sudah dilatih sebelumnya",
        "pretrained_model_name": "Nama model yang sudah dilatih sebelumnya",
        "pretrained_checkpoint": "Checkpoint model yang sudah dilatih sebelumnya",
        "system.enable_gui": "Aktifkan GUI",
        "system.version": "Versi",
        "system.enable_main_camera": "Aktifkan kamera utama",
        "system.enable_sub_camera": "Aktifkan kamera sub",
        "system.enable_kvs_camera": "Aktifkan kamera KVS",
        "system.train_multi_config": "Pelatihan multi-konfigurasi",
        "simulation.number_of_sub_simulations": "Jumlah sub-simulasi untuk multi-pelatihan",
        **{f"simulation.{sim_idx}.car_color": f"Warna mobil {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_id": f"Trek {sim_idx}" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.track_direction": f"Arah mengemudi trek" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.alternate_training_direction": f"Apakah berganti arah mengemudi selama pelatihan" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.race_type": f"Jenis balapan (Time Trial: mengemudi di trek kosong, Object Avoidance: menghindari rintangan)" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_type": f"Jenis objek rintangan" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.number_of_objects": f"Jumlah rintangan" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.randomize_object_locations": f"Apakah mengacak lokasi rintangan" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.min_distance_between_objects": f"Jarak minimum antara rintangan" for sim_idx in sim_idx_list},
        **{f"simulation.{sim_idx}.object_avoidance.object_locations": f"Lokasi rintangan" for sim_idx in sim_idx_list},
        "vehicle.sensor.camera": "Jumlah kamera",
        "vehicle.sensor.lidar": "Apakah menggunakan LiDAR",
        "vehicle.action_space_type": "Ruang aksi (keluaran model)",
        "vehicle.action_space.continuous": "Ruang aksi kontinu",
        "vehicle.action_space.continuous.steering_angle.high": "Sudut kemudi kiri maksimum (positif)",
        "vehicle.action_space.continuous.steering_angle.low": "Sudut kemudi kanan maksimum (negatif)",
        "vehicle.action_space.continuous.speed.high": "Kecepatan maksimum (m/s)",
        "vehicle.action_space.continuous.speed.low": "Kecepatan minimum (m/s)",
        "vehicle.action_space.discrete": "Ruang aksi diskrit",
        "vehicle.neural_network": "Arsitektur model CNN",
        "vehicle.sensor.preprocess_type": "Jenis pra-pemrosesan data input",
        "training.algorithm": "Algoritma pelatihan model",
        "training.round_robin_advanced": "Rasio round robin selama pelatihan model",
        "training.min_evaluation_number_of_trials": "Jumlah minimum percobaan evaluasi",
        "training.hyperparameters.batch_size": "Ukuran batch (jumlah paket data untuk pembaruan bobot)",
        "training.hyperparameters.discount_factor": "Faktor diskon (bobot untuk hadiah masa depan)",
        "training.hyperparameters.learning_rate": "Tingkat pembelajaran (intensitas pembaruan bobot)",
        "training.hyperparameters.loss_type": "Jenis kerugian (fungsi kerugian untuk pembaruan bobot)",
        "training.hyperparameters.entropy": "Entropi (keacakan)",
        "training.hyperparameters.sac_alpha": "SAC alpha (keacakan)",
        "training.hyperparameters.e_greedy_value": "Nilai E-Greedy",
        "training.hyperparameters.epsilon_steps": "Langkah epsilon",
        "training.hyperparameters.exploration_type": "Jenis eksplorasi",
        "training.hyperparameters.stack_size": "Ukuran tumpukan",
        "training.hyperparameters.term_cond_avg_score": "Kondisi penghentian skor rata-rata",
        "training.hyperparameters.term_cond_max_episodes": "Kondisi penghentian episode maksimum",
        "training.hyperparameters.num_episodes_between_training": "Jumlah episode antara pembaruan kebijakan",
        "training.hyperparameters.num_epochs": "Jumlah epoch",
        "training.best_model_metric": "Metrik model terbaik",
        "auto_test_after_training": "Tes otomatis setelah pelatihan",
        "test.number_of_trials": "Jumlah putaran evaluasi tes",
        "test.checkpoint": "Checkpoint model yang akan diuji",
        "test.penalty.is_offtrack": "Penalti untuk keluar jalur (detik)",
        "test.penalty.is_crashed": "Penalti untuk tabrakan (detik)",
        "test.max_resets": "Reset maksimum (keluar jalur dan tabrakan)",
        "test.is_continuous": "Ukur putaran berikutnya tanpa berhenti di garis finish",
        "test.save_mp4": "Apakah menyimpan video tes",
        "test.crash_reset_behind_dist": "Jarak dari objek untuk reset setelah tabrakan",
        "test.car_name": "Nama kendaraan tes",
    }
}