<a id="boto3-stubs-lite"></a>

# boto3-stubs-lite

[![PyPI - boto3-stubs-lite](https://img.shields.io/pypi/v/boto3-stubs-lite.svg?color=blue)](https://pypi.org/project/boto3-stubs-lite)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/boto3-stubs-lite.svg?color=blue)](https://pypi.org/project/boto3-stubs-lite)
[![Docs](https://img.shields.io/readthedocs/boto3-stubs.svg?color=blue)](https://youtype.github.io/boto3_stubs_docs/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/boto3-stubs-lite?color=blue)](https://pypistats.org/packages/boto3-stubs-lite)

![boto3.typed](https://github.com/youtype/mypy_boto3_builder/raw/main/logo.png)

Type annotations for
[boto3 1.26.135](https://boto3.amazonaws.com/v1/documentation/api/1.26.135/index.html)
compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 7.14.5](https://github.com/youtype/mypy_boto3_builder).

More information can be found in
[boto3-stubs-lite docs](https://youtype.github.io/boto3_stubs_docs/).

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/youtype/mypy_boto3_builder/raw/main/demo.gif)

- [boto3-stubs-lite](#boto3-stubs-lite)
  - [How to install](#how-to-install)
    - [VSCode extension](#vscode-extension)
    - [From PyPI with pip](#from-pypi-with-pip)
    - [From conda-forge](#from-conda-forge)
  - [How to uninstall](#how-to-uninstall)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Emacs](#emacs)
    - [Sublime Text](#sublime-text)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
    - [Explicit type annotations](#explicit-type-annotations)
    - [Pylint compatibility](#pylint-compatibility)
  - [How it works](#how-it-works)
  - [What's new](#what's-new)
    - [Implemented features](#implemented-features)
    - [Latest changes](#latest-changes)
  - [Versioning](#versioning)
  - [Thank you](#thank-you)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)
  - [Submodules](#submodules)

<a id="how-to-install"></a>

## How to install

<a id="vscode-extension"></a>

### VSCode extension

Add
[AWS Boto3](https://marketplace.visualstudio.com/items?itemName=Boto3typed.boto3-ide)
extension to your VSCode and run `AWS boto3: Quick Start` command.

Click `Auto-discover services` and select services you use in the current
project.

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `boto3-stubs-lite` to add type annotations for `boto3` package.

```bash
# install type annotations only for boto3
python -m pip install boto3-stubs-lite

# install boto3 type annotations
# for ec2, s3, rds, lambda, sqs, dynamo and cloudformation
python -m pip install 'boto3-stubs-lite[essential]'

# or install annotations for services you use
python -m pip install 'boto3-stubs-lite[acm,apigateway]'

# or install annotations in sync with boto3 version
python -m pip install 'boto3-stubs-lite[boto3]'


```

<a id="from-conda-forge"></a>

### From conda-forge

Add `conda-forge` to your channels with:

```bash
conda config --add channels conda-forge
conda config --set channel_priority strict
```

Once the `conda-forge` channel has been enabled, `boto3-stubs-lite` and
`boto3-stubs-lite-essential` can be installed with:

```bash
conda install boto3-stubs-lite boto3-stubs-lite-essential
```

It is possible to list all of the versions of `boto3-stubs-lite` available on
your platform with:

```bash
conda search boto3-stubs-lite --channel conda-forge
```

<a id="how-to-uninstall"></a>

## How to uninstall

```bash
# uninstall boto3-stubs-lite
python -m pip uninstall -y boto3-stubs-lite
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto3-stubs-lite[essential]` in your environment:

```bash
python -m pip install 'boto3-stubs-lite[essential]'
```

Both type checking and code completion should now work. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

Install `boto3-stubs-lite[essential]` in your environment:

```bash
python -m pip install 'boto3-stubs-lite[essential]'`
```

Both type checking and code completion should now work. Explicit type
annotations **are required**.

<a id="emacs"></a>

### Emacs

- Install `boto3-stubs-lite` with services you use in your environment:

```bash
python -m pip install 'boto3-stubs-lite[essential]'
```

- Install [use-package](https://github.com/jwiegley/use-package),
  [lsp](https://github.com/emacs-lsp/lsp-mode/),
  [company](https://github.com/company-mode/company-mode) and
  [flycheck](https://github.com/flycheck/flycheck) packages
- Install [lsp-pyright](https://github.com/emacs-lsp/lsp-pyright) package

```elisp
(use-package lsp-pyright
  :ensure t
  :hook (python-mode . (lambda ()
                          (require 'lsp-pyright)
                          (lsp)))  ; or lsp-deferred
  :init (when (executable-find "python3")
          (setq lsp-pyright-python-executable-cmd "python3"))
  )
```

- Make sure emacs uses the environment where you have installed
  `boto3-stubs-lite`

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="sublime-text"></a>

### Sublime Text

- Install `boto3-stubs-lite[essential]` with services you use in your
  environment:

```bash
python -m pip install 'boto3-stubs-lite[essential]'
```

- Install [LSP-pyright](https://github.com/sublimelsp/LSP-pyright) package

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto3-stubs-lite[essential]` in your environment:

```bash
python -m pip install 'boto3-stubs-lite[essential]'`
```

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `npm i -g pyright`
- Install `boto3-stubs-lite[essential]` in your environment:

```bash
python -m pip install 'boto3-stubs-lite[essential]'
```

Optionally, you can install `boto3-stubs-lite` to `typings` folder.

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

### Explicit type annotations

To speed up type checking and code completion, you can set types explicitly.

```python
import boto3
from boto3.session import Session

from mypy_boto3_ec2.client import EC2Client
from mypy_boto3_ec2.service_resource import EC2ServiceResource
from mypy_boto3_ec2.waiter import BundleTaskCompleteWaiter
from mypy_boto3_ec2.paginator import DescribeVolumesPaginator

session = Session(region_name="us-west-1")

ec2_client: EC2Client = boto3.client("ec2", region_name="us-west-1")
ec2_resource: EC2ServiceResource = session.resource("ec2")

bundle_task_complete_waiter: BundleTaskCompleteWaiter = ec2_client.get_waiter(
    "bundle_task_complete"
)
describe_volumes_paginator: DescribeVolumesPaginator = ec2_client.get_paginator("describe_volumes")
```

<a id="pylint-compatibility"></a>

### Pylint compatibility

It is totally safe to use `TYPE_CHECKING` flag in order to avoid `boto3-stubs`
dependency in production. However, there is an issue in `pylint` that it
complains about undefined variables. To fix it, set all types to `object` in
non-`TYPE_CHECKING` mode.

```python
import boto3
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from mypy_boto3_ec2 import EC2Client, EC2ServiceResource
    from mypy_boto3_ec2.waiters import BundleTaskCompleteWaiter
    from mypy_boto3_ec2.paginators import DescribeVolumesPaginator
else:
    EC2Client = object
    EC2ServiceResource = object
    BundleTaskCompleteWaiter = object
    DescribeVolumesPaginator = object

...
```

<a id="how-it-works"></a>

## How it works

Fully automated
[mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder) carefully
generates type annotations for each service, patiently waiting for `boto3`
updates. It delivers drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type
  annotations extracted from `botocore` schemas.
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) and
  [isort](https://github.com/PyCQA/isort) for readability.

<a id="what's-new"></a>

## What's new

<a id="implemented-features"></a>

### Implemented features

- Fully type annotated `boto3`, `botocore`, `aiobotocore` and `aioboto3`
  libraries
- `mypy`, `pyright`, `VSCode`, `PyCharm`, `Sublime Text` and `Emacs`
  compatibility
- `Client`, `ServiceResource`, `Resource`, `Waiter` `Paginator` type
  annotations for each service
- Generated `TypeDefs` for each service
- Generated `Literals` for each service
- Auto discovery of types for `boto3.client` and `boto3.resource` calls
- Auto discovery of types for `session.client` and `session.resource` calls
- Auto discovery of types for `client.get_waiter` and `client.get_paginator`
  calls
- Auto discovery of types for `ServiceResource` and `Resource` collections
- Auto discovery of types for `aiobotocore.Session.create_client` calls

<a id="latest-changes"></a>

### Latest changes

Builder changelog can be found in
[Releases](https://github.com/youtype/mypy_boto3_builder/releases).

<a id="versioning"></a>

## Versioning

`boto3-stubs-lite` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="thank-you"></a>

## Thank you

- [Allie Fitter](https://github.com/alliefitter) for
  [boto3-type-annotations](https://pypi.org/project/boto3-type-annotations/),
  this package is based on top of his work
- [black](https://github.com/psf/black) developers for an awesome formatting
  tool
- [Timothy Edmund Crosley](https://github.com/timothycrosley) for
  [isort](https://github.com/PyCQA/isort) and how flexible it is
- [mypy](https://github.com/python/mypy) developers for doing all dirty work
  for us
- [pyright](https://github.com/microsoft/pyright) team for the new era of typed
  Python

<a id="documentation"></a>

## Documentation

All services type annotations can be found in
[boto3 docs](https://youtype.github.io/boto3_stubs_docs/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder/issues/)
repository.

<a id="submodules"></a>

## Submodules

- `boto3-stubs-lite[all]` - Type annotations for all 344 services.
- `boto3-stubs-lite[essential]` - Type annotations for
  [CloudFormation](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_cloudformation/),
  [DynamoDB](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_dynamodb/),
  [EC2](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ec2/),
  [Lambda](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_lambda/),
  [RDS](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_rds/),
  [S3](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_s3/) and
  [SQS](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sqs/) services.
- `boto3-stubs-lite[boto3]` - Install annotations in sync with `boto3` version.
- `boto3-stubs-lite[accessanalyzer]` - Type annotations for
  [AccessAnalyzer](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_accessanalyzer/)
  service.
- `boto3-stubs-lite[account]` - Type annotations for
  [Account](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_account/)
  service.
- `boto3-stubs-lite[acm]` - Type annotations for
  [ACM](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_acm/) service.
- `boto3-stubs-lite[acm-pca]` - Type annotations for
  [ACMPCA](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_acm_pca/)
  service.
- `boto3-stubs-lite[alexaforbusiness]` - Type annotations for
  [AlexaForBusiness](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_alexaforbusiness/)
  service.
- `boto3-stubs-lite[amp]` - Type annotations for
  [PrometheusService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_amp/)
  service.
- `boto3-stubs-lite[amplify]` - Type annotations for
  [Amplify](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_amplify/)
  service.
- `boto3-stubs-lite[amplifybackend]` - Type annotations for
  [AmplifyBackend](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_amplifybackend/)
  service.
- `boto3-stubs-lite[amplifyuibuilder]` - Type annotations for
  [AmplifyUIBuilder](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_amplifyuibuilder/)
  service.
- `boto3-stubs-lite[apigateway]` - Type annotations for
  [APIGateway](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_apigateway/)
  service.
- `boto3-stubs-lite[apigatewaymanagementapi]` - Type annotations for
  [ApiGatewayManagementApi](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_apigatewaymanagementapi/)
  service.
- `boto3-stubs-lite[apigatewayv2]` - Type annotations for
  [ApiGatewayV2](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_apigatewayv2/)
  service.
- `boto3-stubs-lite[appconfig]` - Type annotations for
  [AppConfig](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_appconfig/)
  service.
- `boto3-stubs-lite[appconfigdata]` - Type annotations for
  [AppConfigData](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_appconfigdata/)
  service.
- `boto3-stubs-lite[appflow]` - Type annotations for
  [Appflow](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_appflow/)
  service.
- `boto3-stubs-lite[appintegrations]` - Type annotations for
  [AppIntegrationsService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_appintegrations/)
  service.
- `boto3-stubs-lite[application-autoscaling]` - Type annotations for
  [ApplicationAutoScaling](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_application_autoscaling/)
  service.
- `boto3-stubs-lite[application-insights]` - Type annotations for
  [ApplicationInsights](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_application_insights/)
  service.
- `boto3-stubs-lite[applicationcostprofiler]` - Type annotations for
  [ApplicationCostProfiler](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_applicationcostprofiler/)
  service.
- `boto3-stubs-lite[appmesh]` - Type annotations for
  [AppMesh](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_appmesh/)
  service.
- `boto3-stubs-lite[apprunner]` - Type annotations for
  [AppRunner](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_apprunner/)
  service.
- `boto3-stubs-lite[appstream]` - Type annotations for
  [AppStream](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_appstream/)
  service.
- `boto3-stubs-lite[appsync]` - Type annotations for
  [AppSync](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_appsync/)
  service.
- `boto3-stubs-lite[arc-zonal-shift]` - Type annotations for
  [ARCZonalShift](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_arc_zonal_shift/)
  service.
- `boto3-stubs-lite[athena]` - Type annotations for
  [Athena](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_athena/)
  service.
- `boto3-stubs-lite[auditmanager]` - Type annotations for
  [AuditManager](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_auditmanager/)
  service.
- `boto3-stubs-lite[autoscaling]` - Type annotations for
  [AutoScaling](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_autoscaling/)
  service.
- `boto3-stubs-lite[autoscaling-plans]` - Type annotations for
  [AutoScalingPlans](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_autoscaling_plans/)
  service.
- `boto3-stubs-lite[backup]` - Type annotations for
  [Backup](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_backup/)
  service.
- `boto3-stubs-lite[backup-gateway]` - Type annotations for
  [BackupGateway](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_backup_gateway/)
  service.
- `boto3-stubs-lite[backupstorage]` - Type annotations for
  [BackupStorage](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_backupstorage/)
  service.
- `boto3-stubs-lite[batch]` - Type annotations for
  [Batch](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_batch/)
  service.
- `boto3-stubs-lite[billingconductor]` - Type annotations for
  [BillingConductor](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_billingconductor/)
  service.
- `boto3-stubs-lite[braket]` - Type annotations for
  [Braket](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_braket/)
  service.
- `boto3-stubs-lite[budgets]` - Type annotations for
  [Budgets](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_budgets/)
  service.
- `boto3-stubs-lite[ce]` - Type annotations for
  [CostExplorer](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ce/)
  service.
- `boto3-stubs-lite[chime]` - Type annotations for
  [Chime](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_chime/)
  service.
- `boto3-stubs-lite[chime-sdk-identity]` - Type annotations for
  [ChimeSDKIdentity](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_chime_sdk_identity/)
  service.
- `boto3-stubs-lite[chime-sdk-media-pipelines]` - Type annotations for
  [ChimeSDKMediaPipelines](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_chime_sdk_media_pipelines/)
  service.
- `boto3-stubs-lite[chime-sdk-meetings]` - Type annotations for
  [ChimeSDKMeetings](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_chime_sdk_meetings/)
  service.
- `boto3-stubs-lite[chime-sdk-messaging]` - Type annotations for
  [ChimeSDKMessaging](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_chime_sdk_messaging/)
  service.
- `boto3-stubs-lite[chime-sdk-voice]` - Type annotations for
  [ChimeSDKVoice](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_chime_sdk_voice/)
  service.
- `boto3-stubs-lite[cleanrooms]` - Type annotations for
  [CleanRoomsService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_cleanrooms/)
  service.
- `boto3-stubs-lite[cloud9]` - Type annotations for
  [Cloud9](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_cloud9/)
  service.
- `boto3-stubs-lite[cloudcontrol]` - Type annotations for
  [CloudControlApi](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_cloudcontrol/)
  service.
- `boto3-stubs-lite[clouddirectory]` - Type annotations for
  [CloudDirectory](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_clouddirectory/)
  service.
- `boto3-stubs-lite[cloudformation]` - Type annotations for
  [CloudFormation](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_cloudformation/)
  service.
- `boto3-stubs-lite[cloudfront]` - Type annotations for
  [CloudFront](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_cloudfront/)
  service.
- `boto3-stubs-lite[cloudhsm]` - Type annotations for
  [CloudHSM](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_cloudhsm/)
  service.
- `boto3-stubs-lite[cloudhsmv2]` - Type annotations for
  [CloudHSMV2](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_cloudhsmv2/)
  service.
- `boto3-stubs-lite[cloudsearch]` - Type annotations for
  [CloudSearch](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_cloudsearch/)
  service.
- `boto3-stubs-lite[cloudsearchdomain]` - Type annotations for
  [CloudSearchDomain](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_cloudsearchdomain/)
  service.
- `boto3-stubs-lite[cloudtrail]` - Type annotations for
  [CloudTrail](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_cloudtrail/)
  service.
- `boto3-stubs-lite[cloudtrail-data]` - Type annotations for
  [CloudTrailDataService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_cloudtrail_data/)
  service.
- `boto3-stubs-lite[cloudwatch]` - Type annotations for
  [CloudWatch](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_cloudwatch/)
  service.
- `boto3-stubs-lite[codeartifact]` - Type annotations for
  [CodeArtifact](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_codeartifact/)
  service.
- `boto3-stubs-lite[codebuild]` - Type annotations for
  [CodeBuild](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_codebuild/)
  service.
- `boto3-stubs-lite[codecatalyst]` - Type annotations for
  [CodeCatalyst](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_codecatalyst/)
  service.
- `boto3-stubs-lite[codecommit]` - Type annotations for
  [CodeCommit](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_codecommit/)
  service.
- `boto3-stubs-lite[codedeploy]` - Type annotations for
  [CodeDeploy](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_codedeploy/)
  service.
- `boto3-stubs-lite[codeguru-reviewer]` - Type annotations for
  [CodeGuruReviewer](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_codeguru_reviewer/)
  service.
- `boto3-stubs-lite[codeguruprofiler]` - Type annotations for
  [CodeGuruProfiler](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_codeguruprofiler/)
  service.
- `boto3-stubs-lite[codepipeline]` - Type annotations for
  [CodePipeline](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_codepipeline/)
  service.
- `boto3-stubs-lite[codestar]` - Type annotations for
  [CodeStar](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_codestar/)
  service.
- `boto3-stubs-lite[codestar-connections]` - Type annotations for
  [CodeStarconnections](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_codestar_connections/)
  service.
- `boto3-stubs-lite[codestar-notifications]` - Type annotations for
  [CodeStarNotifications](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_codestar_notifications/)
  service.
- `boto3-stubs-lite[cognito-identity]` - Type annotations for
  [CognitoIdentity](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_cognito_identity/)
  service.
- `boto3-stubs-lite[cognito-idp]` - Type annotations for
  [CognitoIdentityProvider](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_cognito_idp/)
  service.
- `boto3-stubs-lite[cognito-sync]` - Type annotations for
  [CognitoSync](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_cognito_sync/)
  service.
- `boto3-stubs-lite[comprehend]` - Type annotations for
  [Comprehend](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_comprehend/)
  service.
- `boto3-stubs-lite[comprehendmedical]` - Type annotations for
  [ComprehendMedical](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_comprehendmedical/)
  service.
- `boto3-stubs-lite[compute-optimizer]` - Type annotations for
  [ComputeOptimizer](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_compute_optimizer/)
  service.
- `boto3-stubs-lite[config]` - Type annotations for
  [ConfigService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_config/)
  service.
- `boto3-stubs-lite[connect]` - Type annotations for
  [Connect](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_connect/)
  service.
- `boto3-stubs-lite[connect-contact-lens]` - Type annotations for
  [ConnectContactLens](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_connect_contact_lens/)
  service.
- `boto3-stubs-lite[connectcampaigns]` - Type annotations for
  [ConnectCampaignService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_connectcampaigns/)
  service.
- `boto3-stubs-lite[connectcases]` - Type annotations for
  [ConnectCases](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_connectcases/)
  service.
- `boto3-stubs-lite[connectparticipant]` - Type annotations for
  [ConnectParticipant](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_connectparticipant/)
  service.
- `boto3-stubs-lite[controltower]` - Type annotations for
  [ControlTower](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_controltower/)
  service.
- `boto3-stubs-lite[cur]` - Type annotations for
  [CostandUsageReportService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_cur/)
  service.
- `boto3-stubs-lite[customer-profiles]` - Type annotations for
  [CustomerProfiles](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_customer_profiles/)
  service.
- `boto3-stubs-lite[databrew]` - Type annotations for
  [GlueDataBrew](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_databrew/)
  service.
- `boto3-stubs-lite[dataexchange]` - Type annotations for
  [DataExchange](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_dataexchange/)
  service.
- `boto3-stubs-lite[datapipeline]` - Type annotations for
  [DataPipeline](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_datapipeline/)
  service.
- `boto3-stubs-lite[datasync]` - Type annotations for
  [DataSync](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_datasync/)
  service.
- `boto3-stubs-lite[dax]` - Type annotations for
  [DAX](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_dax/) service.
- `boto3-stubs-lite[detective]` - Type annotations for
  [Detective](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_detective/)
  service.
- `boto3-stubs-lite[devicefarm]` - Type annotations for
  [DeviceFarm](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_devicefarm/)
  service.
- `boto3-stubs-lite[devops-guru]` - Type annotations for
  [DevOpsGuru](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_devops_guru/)
  service.
- `boto3-stubs-lite[directconnect]` - Type annotations for
  [DirectConnect](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_directconnect/)
  service.
- `boto3-stubs-lite[discovery]` - Type annotations for
  [ApplicationDiscoveryService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_discovery/)
  service.
- `boto3-stubs-lite[dlm]` - Type annotations for
  [DLM](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_dlm/) service.
- `boto3-stubs-lite[dms]` - Type annotations for
  [DatabaseMigrationService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_dms/)
  service.
- `boto3-stubs-lite[docdb]` - Type annotations for
  [DocDB](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_docdb/)
  service.
- `boto3-stubs-lite[docdb-elastic]` - Type annotations for
  [DocDBElastic](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_docdb_elastic/)
  service.
- `boto3-stubs-lite[drs]` - Type annotations for
  [drs](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_drs/) service.
- `boto3-stubs-lite[ds]` - Type annotations for
  [DirectoryService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ds/)
  service.
- `boto3-stubs-lite[dynamodb]` - Type annotations for
  [DynamoDB](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_dynamodb/)
  service.
- `boto3-stubs-lite[dynamodbstreams]` - Type annotations for
  [DynamoDBStreams](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_dynamodbstreams/)
  service.
- `boto3-stubs-lite[ebs]` - Type annotations for
  [EBS](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ebs/) service.
- `boto3-stubs-lite[ec2]` - Type annotations for
  [EC2](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ec2/) service.
- `boto3-stubs-lite[ec2-instance-connect]` - Type annotations for
  [EC2InstanceConnect](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ec2_instance_connect/)
  service.
- `boto3-stubs-lite[ecr]` - Type annotations for
  [ECR](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ecr/) service.
- `boto3-stubs-lite[ecr-public]` - Type annotations for
  [ECRPublic](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ecr_public/)
  service.
- `boto3-stubs-lite[ecs]` - Type annotations for
  [ECS](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ecs/) service.
- `boto3-stubs-lite[efs]` - Type annotations for
  [EFS](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_efs/) service.
- `boto3-stubs-lite[eks]` - Type annotations for
  [EKS](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_eks/) service.
- `boto3-stubs-lite[elastic-inference]` - Type annotations for
  [ElasticInference](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_elastic_inference/)
  service.
- `boto3-stubs-lite[elasticache]` - Type annotations for
  [ElastiCache](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_elasticache/)
  service.
- `boto3-stubs-lite[elasticbeanstalk]` - Type annotations for
  [ElasticBeanstalk](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_elasticbeanstalk/)
  service.
- `boto3-stubs-lite[elastictranscoder]` - Type annotations for
  [ElasticTranscoder](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_elastictranscoder/)
  service.
- `boto3-stubs-lite[elb]` - Type annotations for
  [ElasticLoadBalancing](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_elb/)
  service.
- `boto3-stubs-lite[elbv2]` - Type annotations for
  [ElasticLoadBalancingv2](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_elbv2/)
  service.
- `boto3-stubs-lite[emr]` - Type annotations for
  [EMR](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_emr/) service.
- `boto3-stubs-lite[emr-containers]` - Type annotations for
  [EMRContainers](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_emr_containers/)
  service.
- `boto3-stubs-lite[emr-serverless]` - Type annotations for
  [EMRServerless](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_emr_serverless/)
  service.
- `boto3-stubs-lite[es]` - Type annotations for
  [ElasticsearchService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_es/)
  service.
- `boto3-stubs-lite[events]` - Type annotations for
  [EventBridge](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_events/)
  service.
- `boto3-stubs-lite[evidently]` - Type annotations for
  [CloudWatchEvidently](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_evidently/)
  service.
- `boto3-stubs-lite[finspace]` - Type annotations for
  [finspace](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_finspace/)
  service.
- `boto3-stubs-lite[finspace-data]` - Type annotations for
  [FinSpaceData](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_finspace_data/)
  service.
- `boto3-stubs-lite[firehose]` - Type annotations for
  [Firehose](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_firehose/)
  service.
- `boto3-stubs-lite[fis]` - Type annotations for
  [FIS](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_fis/) service.
- `boto3-stubs-lite[fms]` - Type annotations for
  [FMS](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_fms/) service.
- `boto3-stubs-lite[forecast]` - Type annotations for
  [ForecastService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_forecast/)
  service.
- `boto3-stubs-lite[forecastquery]` - Type annotations for
  [ForecastQueryService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_forecastquery/)
  service.
- `boto3-stubs-lite[frauddetector]` - Type annotations for
  [FraudDetector](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_frauddetector/)
  service.
- `boto3-stubs-lite[fsx]` - Type annotations for
  [FSx](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_fsx/) service.
- `boto3-stubs-lite[gamelift]` - Type annotations for
  [GameLift](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_gamelift/)
  service.
- `boto3-stubs-lite[gamesparks]` - Type annotations for
  [GameSparks](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_gamesparks/)
  service.
- `boto3-stubs-lite[glacier]` - Type annotations for
  [Glacier](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_glacier/)
  service.
- `boto3-stubs-lite[globalaccelerator]` - Type annotations for
  [GlobalAccelerator](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_globalaccelerator/)
  service.
- `boto3-stubs-lite[glue]` - Type annotations for
  [Glue](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_glue/) service.
- `boto3-stubs-lite[grafana]` - Type annotations for
  [ManagedGrafana](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_grafana/)
  service.
- `boto3-stubs-lite[greengrass]` - Type annotations for
  [Greengrass](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_greengrass/)
  service.
- `boto3-stubs-lite[greengrassv2]` - Type annotations for
  [GreengrassV2](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_greengrassv2/)
  service.
- `boto3-stubs-lite[groundstation]` - Type annotations for
  [GroundStation](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_groundstation/)
  service.
- `boto3-stubs-lite[guardduty]` - Type annotations for
  [GuardDuty](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_guardduty/)
  service.
- `boto3-stubs-lite[health]` - Type annotations for
  [Health](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_health/)
  service.
- `boto3-stubs-lite[healthlake]` - Type annotations for
  [HealthLake](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_healthlake/)
  service.
- `boto3-stubs-lite[honeycode]` - Type annotations for
  [Honeycode](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_honeycode/)
  service.
- `boto3-stubs-lite[iam]` - Type annotations for
  [IAM](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iam/) service.
- `boto3-stubs-lite[identitystore]` - Type annotations for
  [IdentityStore](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_identitystore/)
  service.
- `boto3-stubs-lite[imagebuilder]` - Type annotations for
  [imagebuilder](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_imagebuilder/)
  service.
- `boto3-stubs-lite[importexport]` - Type annotations for
  [ImportExport](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_importexport/)
  service.
- `boto3-stubs-lite[inspector]` - Type annotations for
  [Inspector](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_inspector/)
  service.
- `boto3-stubs-lite[inspector2]` - Type annotations for
  [Inspector2](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_inspector2/)
  service.
- `boto3-stubs-lite[internetmonitor]` - Type annotations for
  [CloudWatchInternetMonitor](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_internetmonitor/)
  service.
- `boto3-stubs-lite[iot]` - Type annotations for
  [IoT](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iot/) service.
- `boto3-stubs-lite[iot-data]` - Type annotations for
  [IoTDataPlane](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iot_data/)
  service.
- `boto3-stubs-lite[iot-jobs-data]` - Type annotations for
  [IoTJobsDataPlane](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iot_jobs_data/)
  service.
- `boto3-stubs-lite[iot-roborunner]` - Type annotations for
  [IoTRoboRunner](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iot_roborunner/)
  service.
- `boto3-stubs-lite[iot1click-devices]` - Type annotations for
  [IoT1ClickDevicesService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iot1click_devices/)
  service.
- `boto3-stubs-lite[iot1click-projects]` - Type annotations for
  [IoT1ClickProjects](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iot1click_projects/)
  service.
- `boto3-stubs-lite[iotanalytics]` - Type annotations for
  [IoTAnalytics](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iotanalytics/)
  service.
- `boto3-stubs-lite[iotdeviceadvisor]` - Type annotations for
  [IoTDeviceAdvisor](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iotdeviceadvisor/)
  service.
- `boto3-stubs-lite[iotevents]` - Type annotations for
  [IoTEvents](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iotevents/)
  service.
- `boto3-stubs-lite[iotevents-data]` - Type annotations for
  [IoTEventsData](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iotevents_data/)
  service.
- `boto3-stubs-lite[iotfleethub]` - Type annotations for
  [IoTFleetHub](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iotfleethub/)
  service.
- `boto3-stubs-lite[iotfleetwise]` - Type annotations for
  [IoTFleetWise](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iotfleetwise/)
  service.
- `boto3-stubs-lite[iotsecuretunneling]` - Type annotations for
  [IoTSecureTunneling](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iotsecuretunneling/)
  service.
- `boto3-stubs-lite[iotsitewise]` - Type annotations for
  [IoTSiteWise](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iotsitewise/)
  service.
- `boto3-stubs-lite[iotthingsgraph]` - Type annotations for
  [IoTThingsGraph](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iotthingsgraph/)
  service.
- `boto3-stubs-lite[iottwinmaker]` - Type annotations for
  [IoTTwinMaker](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iottwinmaker/)
  service.
- `boto3-stubs-lite[iotwireless]` - Type annotations for
  [IoTWireless](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_iotwireless/)
  service.
- `boto3-stubs-lite[ivs]` - Type annotations for
  [IVS](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ivs/) service.
- `boto3-stubs-lite[ivs-realtime]` - Type annotations for
  [ivsrealtime](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ivs_realtime/)
  service.
- `boto3-stubs-lite[ivschat]` - Type annotations for
  [ivschat](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ivschat/)
  service.
- `boto3-stubs-lite[kafka]` - Type annotations for
  [Kafka](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_kafka/)
  service.
- `boto3-stubs-lite[kafkaconnect]` - Type annotations for
  [KafkaConnect](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_kafkaconnect/)
  service.
- `boto3-stubs-lite[kendra]` - Type annotations for
  [kendra](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_kendra/)
  service.
- `boto3-stubs-lite[kendra-ranking]` - Type annotations for
  [KendraRanking](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_kendra_ranking/)
  service.
- `boto3-stubs-lite[keyspaces]` - Type annotations for
  [Keyspaces](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_keyspaces/)
  service.
- `boto3-stubs-lite[kinesis]` - Type annotations for
  [Kinesis](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_kinesis/)
  service.
- `boto3-stubs-lite[kinesis-video-archived-media]` - Type annotations for
  [KinesisVideoArchivedMedia](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_kinesis_video_archived_media/)
  service.
- `boto3-stubs-lite[kinesis-video-media]` - Type annotations for
  [KinesisVideoMedia](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_kinesis_video_media/)
  service.
- `boto3-stubs-lite[kinesis-video-signaling]` - Type annotations for
  [KinesisVideoSignalingChannels](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_kinesis_video_signaling/)
  service.
- `boto3-stubs-lite[kinesis-video-webrtc-storage]` - Type annotations for
  [KinesisVideoWebRTCStorage](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_kinesis_video_webrtc_storage/)
  service.
- `boto3-stubs-lite[kinesisanalytics]` - Type annotations for
  [KinesisAnalytics](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_kinesisanalytics/)
  service.
- `boto3-stubs-lite[kinesisanalyticsv2]` - Type annotations for
  [KinesisAnalyticsV2](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_kinesisanalyticsv2/)
  service.
- `boto3-stubs-lite[kinesisvideo]` - Type annotations for
  [KinesisVideo](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_kinesisvideo/)
  service.
- `boto3-stubs-lite[kms]` - Type annotations for
  [KMS](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_kms/) service.
- `boto3-stubs-lite[lakeformation]` - Type annotations for
  [LakeFormation](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_lakeformation/)
  service.
- `boto3-stubs-lite[lambda]` - Type annotations for
  [Lambda](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_lambda/)
  service.
- `boto3-stubs-lite[lex-models]` - Type annotations for
  [LexModelBuildingService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_lex_models/)
  service.
- `boto3-stubs-lite[lex-runtime]` - Type annotations for
  [LexRuntimeService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_lex_runtime/)
  service.
- `boto3-stubs-lite[lexv2-models]` - Type annotations for
  [LexModelsV2](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_lexv2_models/)
  service.
- `boto3-stubs-lite[lexv2-runtime]` - Type annotations for
  [LexRuntimeV2](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_lexv2_runtime/)
  service.
- `boto3-stubs-lite[license-manager]` - Type annotations for
  [LicenseManager](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_license_manager/)
  service.
- `boto3-stubs-lite[license-manager-linux-subscriptions]` - Type annotations
  for
  [LicenseManagerLinuxSubscriptions](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_license_manager_linux_subscriptions/)
  service.
- `boto3-stubs-lite[license-manager-user-subscriptions]` - Type annotations for
  [LicenseManagerUserSubscriptions](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_license_manager_user_subscriptions/)
  service.
- `boto3-stubs-lite[lightsail]` - Type annotations for
  [Lightsail](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_lightsail/)
  service.
- `boto3-stubs-lite[location]` - Type annotations for
  [LocationService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_location/)
  service.
- `boto3-stubs-lite[logs]` - Type annotations for
  [CloudWatchLogs](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_logs/)
  service.
- `boto3-stubs-lite[lookoutequipment]` - Type annotations for
  [LookoutEquipment](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_lookoutequipment/)
  service.
- `boto3-stubs-lite[lookoutmetrics]` - Type annotations for
  [LookoutMetrics](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_lookoutmetrics/)
  service.
- `boto3-stubs-lite[lookoutvision]` - Type annotations for
  [LookoutforVision](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_lookoutvision/)
  service.
- `boto3-stubs-lite[m2]` - Type annotations for
  [MainframeModernization](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_m2/)
  service.
- `boto3-stubs-lite[machinelearning]` - Type annotations for
  [MachineLearning](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_machinelearning/)
  service.
- `boto3-stubs-lite[macie]` - Type annotations for
  [Macie](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_macie/)
  service.
- `boto3-stubs-lite[macie2]` - Type annotations for
  [Macie2](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_macie2/)
  service.
- `boto3-stubs-lite[managedblockchain]` - Type annotations for
  [ManagedBlockchain](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_managedblockchain/)
  service.
- `boto3-stubs-lite[marketplace-catalog]` - Type annotations for
  [MarketplaceCatalog](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_marketplace_catalog/)
  service.
- `boto3-stubs-lite[marketplace-entitlement]` - Type annotations for
  [MarketplaceEntitlementService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_marketplace_entitlement/)
  service.
- `boto3-stubs-lite[marketplacecommerceanalytics]` - Type annotations for
  [MarketplaceCommerceAnalytics](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_marketplacecommerceanalytics/)
  service.
- `boto3-stubs-lite[mediaconnect]` - Type annotations for
  [MediaConnect](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_mediaconnect/)
  service.
- `boto3-stubs-lite[mediaconvert]` - Type annotations for
  [MediaConvert](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_mediaconvert/)
  service.
- `boto3-stubs-lite[medialive]` - Type annotations for
  [MediaLive](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_medialive/)
  service.
- `boto3-stubs-lite[mediapackage]` - Type annotations for
  [MediaPackage](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_mediapackage/)
  service.
- `boto3-stubs-lite[mediapackage-vod]` - Type annotations for
  [MediaPackageVod](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_mediapackage_vod/)
  service.
- `boto3-stubs-lite[mediastore]` - Type annotations for
  [MediaStore](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_mediastore/)
  service.
- `boto3-stubs-lite[mediastore-data]` - Type annotations for
  [MediaStoreData](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_mediastore_data/)
  service.
- `boto3-stubs-lite[mediatailor]` - Type annotations for
  [MediaTailor](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_mediatailor/)
  service.
- `boto3-stubs-lite[memorydb]` - Type annotations for
  [MemoryDB](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_memorydb/)
  service.
- `boto3-stubs-lite[meteringmarketplace]` - Type annotations for
  [MarketplaceMetering](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_meteringmarketplace/)
  service.
- `boto3-stubs-lite[mgh]` - Type annotations for
  [MigrationHub](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_mgh/)
  service.
- `boto3-stubs-lite[mgn]` - Type annotations for
  [mgn](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_mgn/) service.
- `boto3-stubs-lite[migration-hub-refactor-spaces]` - Type annotations for
  [MigrationHubRefactorSpaces](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_migration_hub_refactor_spaces/)
  service.
- `boto3-stubs-lite[migrationhub-config]` - Type annotations for
  [MigrationHubConfig](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_migrationhub_config/)
  service.
- `boto3-stubs-lite[migrationhuborchestrator]` - Type annotations for
  [MigrationHubOrchestrator](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_migrationhuborchestrator/)
  service.
- `boto3-stubs-lite[migrationhubstrategy]` - Type annotations for
  [MigrationHubStrategyRecommendations](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_migrationhubstrategy/)
  service.
- `boto3-stubs-lite[mobile]` - Type annotations for
  [Mobile](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_mobile/)
  service.
- `boto3-stubs-lite[mq]` - Type annotations for
  [MQ](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_mq/) service.
- `boto3-stubs-lite[mturk]` - Type annotations for
  [MTurk](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_mturk/)
  service.
- `boto3-stubs-lite[mwaa]` - Type annotations for
  [MWAA](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_mwaa/) service.
- `boto3-stubs-lite[neptune]` - Type annotations for
  [Neptune](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_neptune/)
  service.
- `boto3-stubs-lite[network-firewall]` - Type annotations for
  [NetworkFirewall](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_network_firewall/)
  service.
- `boto3-stubs-lite[networkmanager]` - Type annotations for
  [NetworkManager](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_networkmanager/)
  service.
- `boto3-stubs-lite[nimble]` - Type annotations for
  [NimbleStudio](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_nimble/)
  service.
- `boto3-stubs-lite[oam]` - Type annotations for
  [CloudWatchObservabilityAccessManager](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_oam/)
  service.
- `boto3-stubs-lite[omics]` - Type annotations for
  [Omics](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_omics/)
  service.
- `boto3-stubs-lite[opensearch]` - Type annotations for
  [OpenSearchService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_opensearch/)
  service.
- `boto3-stubs-lite[opensearchserverless]` - Type annotations for
  [OpenSearchServiceServerless](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_opensearchserverless/)
  service.
- `boto3-stubs-lite[opsworks]` - Type annotations for
  [OpsWorks](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_opsworks/)
  service.
- `boto3-stubs-lite[opsworkscm]` - Type annotations for
  [OpsWorksCM](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_opsworkscm/)
  service.
- `boto3-stubs-lite[organizations]` - Type annotations for
  [Organizations](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_organizations/)
  service.
- `boto3-stubs-lite[osis]` - Type annotations for
  [OpenSearchIngestion](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_osis/)
  service.
- `boto3-stubs-lite[outposts]` - Type annotations for
  [Outposts](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_outposts/)
  service.
- `boto3-stubs-lite[panorama]` - Type annotations for
  [Panorama](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_panorama/)
  service.
- `boto3-stubs-lite[personalize]` - Type annotations for
  [Personalize](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_personalize/)
  service.
- `boto3-stubs-lite[personalize-events]` - Type annotations for
  [PersonalizeEvents](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_personalize_events/)
  service.
- `boto3-stubs-lite[personalize-runtime]` - Type annotations for
  [PersonalizeRuntime](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_personalize_runtime/)
  service.
- `boto3-stubs-lite[pi]` - Type annotations for
  [PI](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_pi/) service.
- `boto3-stubs-lite[pinpoint]` - Type annotations for
  [Pinpoint](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_pinpoint/)
  service.
- `boto3-stubs-lite[pinpoint-email]` - Type annotations for
  [PinpointEmail](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_pinpoint_email/)
  service.
- `boto3-stubs-lite[pinpoint-sms-voice]` - Type annotations for
  [PinpointSMSVoice](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_pinpoint_sms_voice/)
  service.
- `boto3-stubs-lite[pinpoint-sms-voice-v2]` - Type annotations for
  [PinpointSMSVoiceV2](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_pinpoint_sms_voice_v2/)
  service.
- `boto3-stubs-lite[pipes]` - Type annotations for
  [EventBridgePipes](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_pipes/)
  service.
- `boto3-stubs-lite[polly]` - Type annotations for
  [Polly](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_polly/)
  service.
- `boto3-stubs-lite[pricing]` - Type annotations for
  [Pricing](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_pricing/)
  service.
- `boto3-stubs-lite[privatenetworks]` - Type annotations for
  [Private5G](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_privatenetworks/)
  service.
- `boto3-stubs-lite[proton]` - Type annotations for
  [Proton](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_proton/)
  service.
- `boto3-stubs-lite[qldb]` - Type annotations for
  [QLDB](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_qldb/) service.
- `boto3-stubs-lite[qldb-session]` - Type annotations for
  [QLDBSession](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_qldb_session/)
  service.
- `boto3-stubs-lite[quicksight]` - Type annotations for
  [QuickSight](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_quicksight/)
  service.
- `boto3-stubs-lite[ram]` - Type annotations for
  [RAM](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ram/) service.
- `boto3-stubs-lite[rbin]` - Type annotations for
  [RecycleBin](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_rbin/)
  service.
- `boto3-stubs-lite[rds]` - Type annotations for
  [RDS](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_rds/) service.
- `boto3-stubs-lite[rds-data]` - Type annotations for
  [RDSDataService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_rds_data/)
  service.
- `boto3-stubs-lite[redshift]` - Type annotations for
  [Redshift](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_redshift/)
  service.
- `boto3-stubs-lite[redshift-data]` - Type annotations for
  [RedshiftDataAPIService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_redshift_data/)
  service.
- `boto3-stubs-lite[redshift-serverless]` - Type annotations for
  [RedshiftServerless](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_redshift_serverless/)
  service.
- `boto3-stubs-lite[rekognition]` - Type annotations for
  [Rekognition](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_rekognition/)
  service.
- `boto3-stubs-lite[resiliencehub]` - Type annotations for
  [ResilienceHub](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_resiliencehub/)
  service.
- `boto3-stubs-lite[resource-explorer-2]` - Type annotations for
  [ResourceExplorer](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_resource_explorer_2/)
  service.
- `boto3-stubs-lite[resource-groups]` - Type annotations for
  [ResourceGroups](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_resource_groups/)
  service.
- `boto3-stubs-lite[resourcegroupstaggingapi]` - Type annotations for
  [ResourceGroupsTaggingAPI](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_resourcegroupstaggingapi/)
  service.
- `boto3-stubs-lite[robomaker]` - Type annotations for
  [RoboMaker](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_robomaker/)
  service.
- `boto3-stubs-lite[rolesanywhere]` - Type annotations for
  [IAMRolesAnywhere](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_rolesanywhere/)
  service.
- `boto3-stubs-lite[route53]` - Type annotations for
  [Route53](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_route53/)
  service.
- `boto3-stubs-lite[route53-recovery-cluster]` - Type annotations for
  [Route53RecoveryCluster](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_route53_recovery_cluster/)
  service.
- `boto3-stubs-lite[route53-recovery-control-config]` - Type annotations for
  [Route53RecoveryControlConfig](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_route53_recovery_control_config/)
  service.
- `boto3-stubs-lite[route53-recovery-readiness]` - Type annotations for
  [Route53RecoveryReadiness](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_route53_recovery_readiness/)
  service.
- `boto3-stubs-lite[route53domains]` - Type annotations for
  [Route53Domains](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_route53domains/)
  service.
- `boto3-stubs-lite[route53resolver]` - Type annotations for
  [Route53Resolver](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_route53resolver/)
  service.
- `boto3-stubs-lite[rum]` - Type annotations for
  [CloudWatchRUM](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_rum/)
  service.
- `boto3-stubs-lite[s3]` - Type annotations for
  [S3](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_s3/) service.
- `boto3-stubs-lite[s3control]` - Type annotations for
  [S3Control](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_s3control/)
  service.
- `boto3-stubs-lite[s3outposts]` - Type annotations for
  [S3Outposts](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_s3outposts/)
  service.
- `boto3-stubs-lite[sagemaker]` - Type annotations for
  [SageMaker](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sagemaker/)
  service.
- `boto3-stubs-lite[sagemaker-a2i-runtime]` - Type annotations for
  [AugmentedAIRuntime](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sagemaker_a2i_runtime/)
  service.
- `boto3-stubs-lite[sagemaker-edge]` - Type annotations for
  [SagemakerEdgeManager](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sagemaker_edge/)
  service.
- `boto3-stubs-lite[sagemaker-featurestore-runtime]` - Type annotations for
  [SageMakerFeatureStoreRuntime](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sagemaker_featurestore_runtime/)
  service.
- `boto3-stubs-lite[sagemaker-geospatial]` - Type annotations for
  [SageMakergeospatialcapabilities](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sagemaker_geospatial/)
  service.
- `boto3-stubs-lite[sagemaker-metrics]` - Type annotations for
  [SageMakerMetrics](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sagemaker_metrics/)
  service.
- `boto3-stubs-lite[sagemaker-runtime]` - Type annotations for
  [SageMakerRuntime](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sagemaker_runtime/)
  service.
- `boto3-stubs-lite[savingsplans]` - Type annotations for
  [SavingsPlans](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_savingsplans/)
  service.
- `boto3-stubs-lite[scheduler]` - Type annotations for
  [EventBridgeScheduler](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_scheduler/)
  service.
- `boto3-stubs-lite[schemas]` - Type annotations for
  [Schemas](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_schemas/)
  service.
- `boto3-stubs-lite[sdb]` - Type annotations for
  [SimpleDB](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sdb/)
  service.
- `boto3-stubs-lite[secretsmanager]` - Type annotations for
  [SecretsManager](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_secretsmanager/)
  service.
- `boto3-stubs-lite[securityhub]` - Type annotations for
  [SecurityHub](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_securityhub/)
  service.
- `boto3-stubs-lite[securitylake]` - Type annotations for
  [SecurityLake](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_securitylake/)
  service.
- `boto3-stubs-lite[serverlessrepo]` - Type annotations for
  [ServerlessApplicationRepository](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_serverlessrepo/)
  service.
- `boto3-stubs-lite[service-quotas]` - Type annotations for
  [ServiceQuotas](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_service_quotas/)
  service.
- `boto3-stubs-lite[servicecatalog]` - Type annotations for
  [ServiceCatalog](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_servicecatalog/)
  service.
- `boto3-stubs-lite[servicecatalog-appregistry]` - Type annotations for
  [AppRegistry](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_servicecatalog_appregistry/)
  service.
- `boto3-stubs-lite[servicediscovery]` - Type annotations for
  [ServiceDiscovery](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_servicediscovery/)
  service.
- `boto3-stubs-lite[ses]` - Type annotations for
  [SES](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ses/) service.
- `boto3-stubs-lite[sesv2]` - Type annotations for
  [SESV2](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sesv2/)
  service.
- `boto3-stubs-lite[shield]` - Type annotations for
  [Shield](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_shield/)
  service.
- `boto3-stubs-lite[signer]` - Type annotations for
  [signer](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_signer/)
  service.
- `boto3-stubs-lite[simspaceweaver]` - Type annotations for
  [SimSpaceWeaver](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_simspaceweaver/)
  service.
- `boto3-stubs-lite[sms]` - Type annotations for
  [SMS](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sms/) service.
- `boto3-stubs-lite[sms-voice]` - Type annotations for
  [PinpointSMSVoice](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sms_voice/)
  service.
- `boto3-stubs-lite[snow-device-management]` - Type annotations for
  [SnowDeviceManagement](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_snow_device_management/)
  service.
- `boto3-stubs-lite[snowball]` - Type annotations for
  [Snowball](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_snowball/)
  service.
- `boto3-stubs-lite[sns]` - Type annotations for
  [SNS](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sns/) service.
- `boto3-stubs-lite[sqs]` - Type annotations for
  [SQS](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sqs/) service.
- `boto3-stubs-lite[ssm]` - Type annotations for
  [SSM](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ssm/) service.
- `boto3-stubs-lite[ssm-contacts]` - Type annotations for
  [SSMContacts](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ssm_contacts/)
  service.
- `boto3-stubs-lite[ssm-incidents]` - Type annotations for
  [SSMIncidents](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ssm_incidents/)
  service.
- `boto3-stubs-lite[ssm-sap]` - Type annotations for
  [SsmSap](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ssm_sap/)
  service.
- `boto3-stubs-lite[sso]` - Type annotations for
  [SSO](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sso/) service.
- `boto3-stubs-lite[sso-admin]` - Type annotations for
  [SSOAdmin](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sso_admin/)
  service.
- `boto3-stubs-lite[sso-oidc]` - Type annotations for
  [SSOOIDC](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sso_oidc/)
  service.
- `boto3-stubs-lite[stepfunctions]` - Type annotations for
  [SFN](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_stepfunctions/)
  service.
- `boto3-stubs-lite[storagegateway]` - Type annotations for
  [StorageGateway](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_storagegateway/)
  service.
- `boto3-stubs-lite[sts]` - Type annotations for
  [STS](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_sts/) service.
- `boto3-stubs-lite[support]` - Type annotations for
  [Support](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_support/)
  service.
- `boto3-stubs-lite[support-app]` - Type annotations for
  [SupportApp](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_support_app/)
  service.
- `boto3-stubs-lite[swf]` - Type annotations for
  [SWF](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_swf/) service.
- `boto3-stubs-lite[synthetics]` - Type annotations for
  [Synthetics](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_synthetics/)
  service.
- `boto3-stubs-lite[textract]` - Type annotations for
  [Textract](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_textract/)
  service.
- `boto3-stubs-lite[timestream-query]` - Type annotations for
  [TimestreamQuery](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_timestream_query/)
  service.
- `boto3-stubs-lite[timestream-write]` - Type annotations for
  [TimestreamWrite](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_timestream_write/)
  service.
- `boto3-stubs-lite[tnb]` - Type annotations for
  [TelcoNetworkBuilder](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_tnb/)
  service.
- `boto3-stubs-lite[transcribe]` - Type annotations for
  [TranscribeService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_transcribe/)
  service.
- `boto3-stubs-lite[transfer]` - Type annotations for
  [Transfer](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_transfer/)
  service.
- `boto3-stubs-lite[translate]` - Type annotations for
  [Translate](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_translate/)
  service.
- `boto3-stubs-lite[voice-id]` - Type annotations for
  [VoiceID](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_voice_id/)
  service.
- `boto3-stubs-lite[vpc-lattice]` - Type annotations for
  [VPCLattice](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_vpc_lattice/)
  service.
- `boto3-stubs-lite[waf]` - Type annotations for
  [WAF](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_waf/) service.
- `boto3-stubs-lite[waf-regional]` - Type annotations for
  [WAFRegional](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_waf_regional/)
  service.
- `boto3-stubs-lite[wafv2]` - Type annotations for
  [WAFV2](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_wafv2/)
  service.
- `boto3-stubs-lite[wellarchitected]` - Type annotations for
  [WellArchitected](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_wellarchitected/)
  service.
- `boto3-stubs-lite[wisdom]` - Type annotations for
  [ConnectWisdomService](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_wisdom/)
  service.
- `boto3-stubs-lite[workdocs]` - Type annotations for
  [WorkDocs](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_workdocs/)
  service.
- `boto3-stubs-lite[worklink]` - Type annotations for
  [WorkLink](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_worklink/)
  service.
- `boto3-stubs-lite[workmail]` - Type annotations for
  [WorkMail](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_workmail/)
  service.
- `boto3-stubs-lite[workmailmessageflow]` - Type annotations for
  [WorkMailMessageFlow](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_workmailmessageflow/)
  service.
- `boto3-stubs-lite[workspaces]` - Type annotations for
  [WorkSpaces](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_workspaces/)
  service.
- `boto3-stubs-lite[workspaces-web]` - Type annotations for
  [WorkSpacesWeb](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_workspaces_web/)
  service.
- `boto3-stubs-lite[xray]` - Type annotations for
  [XRay](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_xray/) service.
