from __future__ import annotations

SINGLE_TARGET_SUPPORTED_COUNT = 1
# Audio Processing Constants
SAMPLE_RATE_DEFAULT = 48000
SAMPLE_RATE_HALF = 24000
CHANNELS_MONO = 1
OUTPUT_DEVICE_BLOCK_SIZE = 1024
AUDIO_CHUNK_SECONDS = 0.5
BYTES_PER_SAMPLE = 2

# Audio Streaming Constants
DECODE_TIMEOUT = 10.0
MAX_FRAMES_PER_READ = 10

# Timing Constants
BOOT_TIMEOUT = 30.0
SHUTDOWN_TIMEOUT = 5.0
LOGGER_SHUTDOWN_TIMEOUT = 20.0
SAFE_PUBLICATION_END_DELAY = 3.0
MONITOR_TIMEOUT = 0.1
DEFAULT_PROCESS_TIMEOUT = 300.0
TRACK_WAIT_TIMEOUT = 30.0
TRACK_CLOSE_TIMEOUT = 5.0
FINALIZE_WAIT_TIME = 5.0
SLEEP_INTERVAL_SHORT = 0.01
SLEEP_INTERVAL_DEFAULT = 0.1
SLEEP_INTERVAL_MEDIUM = 0.3
SLEEP_INTERVAL_LONG = 1.0
SLEEP_INTERVAL_BUFFER_CHECK = 5.0
QUEUE_READ_TIMEOUT = 1.0
QUEUE_WAIT_TIMEOUT = 0.5
WS_TIMEOUT = 5.0
DEBUG_TASK_CHECK_INTERVAL = 30.0


# Buffer and Queue Constants
THREADPOOL_MAX_WORKERS = 32
DEVICE_ID_HASH_LENGTH = 8
MONITOR_MESSAGE_PREVIEW_LENGTH = 100
AUDIO_PROGRESS_LOG_INTERVAL = 100000

# EOF and Completion Constants
EMPTY_MESSAGE_THRESHOLD = 10
EOF_DRAIN_TIMEOUT = 5.0
COMPLETION_WAIT_TIMEOUT = 2.0
STATS_LOG_INTERVAL = 5.0

# Preprocessing Constants
MIN_SENTENCE_CHARACTERS_DEFAULT = 80
MIN_SENTENCE_SECONDS_DEFAULT = 4
MIN_SPLIT_INTERVAL_DEFAULT = 0.6
CONTEXT_SIZE_DEFAULT = 30
SEGMENTS_AFTER_RESTART_DEFAULT = 15
STEP_SIZE_DEFAULT = 5
MAX_STEPS_WITHOUT_EOS_DEFAULT = 3
FORCE_END_OF_SEGMENT_DEFAULT = 0.5

# Filler Phrases Constants
MIN_TRANSCRIPTION_LEN_DEFAULT = 40
MIN_TRANSCRIPTION_TIME_DEFAULT = 3
PHRASE_CHANCE_DEFAULT = 0.5

# TTS Constants
F0_VARIANCE_FACTOR_DEFAULT = 1.2
ENERGY_VARIANCE_FACTOR_DEFAULT = 1.5
SPEECH_TEMPO_ADJUSTMENT_FACTOR_DEFAULT = 0.75

# Queue Config Constants
DESIRED_QUEUE_LEVEL_MS_DEFAULT = 10000
MAX_QUEUE_LEVEL_MS_DEFAULT = 24000
QUEUE_MIN_TEMPO = 1.0
QUEUE_MAX_TEMPO = 1.2

# TranscriptionMessage Constants
MIN_ALIGNMENT_SCORE_DEFAULT = 0.2
MAX_ALIGNMENT_CER_DEFAULT = 0.8
SEGMENT_CONFIRMATION_SILENCE_THRESHOLD_DEFAULT = 0.7

# VAD Constants
VAD_THRESHOLD_DEFAULT = 0.5
VAD_LEFT_PADDING_DEFAULT = 1
VAD_RIGHT_PADDING_DEFAULT = 1


WS_MODE_SAMPLE_RATE = 24000
WS_MODE_CHANNELS = 1
WS_MODE_CHUNK_DURATION_MS = 320

WEBRTC_MODE_SAMPLE_RATE = 48000
WEBRTC_MODE_CHANNELS = 1
WEBRTC_MODE_CHUNK_DURATION_MS = 320
