#! /usr/bin/env python3
# -*- coding: utf-8 -*-
import base64
import sys
import time

import requests

from ikabot.config import *
from ikabot.helpers.botComm import *
from ikabot.helpers.gui import *
from ikabot.helpers.pedirInfo import enter, read
from ikabot.helpers.process import run, updateProcessList

decaptcha_test_pictures = [
    {
        "ground_truth": "WURY5G",
        "picture": "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",
    },
    {
        "ground_truth": "XEPAMVW",
        "picture": "iVBORw0KGgoAAAANSUhEUgAAAQsAAAA8CAIAAAD+PwikAAAACXBIWXMAAA7EAAAOxAGVKw4bAAAgAElEQVR4nO2dd2DTdf7/X9l7N03TpHvRlu4yWkoLlKkgKnrK4Tj1TnHc1wHqiQtO5b4Cnuihh3j6PUXEhcxjCUWwltJS2gLdu02aNHvv8fvjU9KQtGnapgXvx/OffsY777yTfh6f13i/3p+gmupVMMkqP/EUslG05OMgX/JO8UWfI8dW3bVs334AePVcfgjHNqz2FbatLqNMUudlZ98GgAUlrwVutneBcVVF0nj63/H4zKe3j2dkwanqo+cWPLMrmJY7Hz0BAGs/XwIAafqZjhk1kzeqkYStzmukVU2oh1ANJYA8YHhQ8TnukQeM9674YnBs4+DBdRmDbSYJlUnFA66xMSonq8soewvbxgfJDZc3G791oabAhowkH2DOvvOoPxjeStsY1bixz7OLoBJaTiYbDx+NyslYLclkGxBEAczISGz8dm3IjSQEEWI33ruSf+ibIWDuuH8Yf8yHEEQh5GSK8fAoMCfBQzI1eCDyhySw3fjtEjIVXtZI8rCB7HpT4U2L51Tjxj5/SLxdr4lwcqPwgNH8rpC7Wy63G41Chao3+O/yqfx1w2zIO8UXA/tU3hoWGH+ty7g4PkhuIB4+QjgBP1SCsSTB2JBOnebdSxc+Ll6EQaMnMk7EhoyJjak3IxM3IHCjbMiY8AAvJBAbMhIw713JHzckN4k8YASZ8vIoMB5ig/7b9maD3X5VpQCArXXVLrdbbNC/NWsum0gcxzhbL61qffTEf6vd8NYNIGSseHhrWEfLG5iSV+Gd4qnICE+2gkx5BVanTmN3urQ261etjVKTMYJMuS0m/mhP5yX5ANLgwkD/spj4MfX51WO/AMADn82t+ug5gFuEhFoTwWMk+TldT5Wf+NyzM+okzM3jYvnLwwnvTdhX+PxYo5EmlfKLlgYAmBnOvz0mPpfL45LIBbzIN6rK3QAAcLa/L3hCPGyMaQy/dY0zDlE2KAlMAlVAHdOrQoXHsEktH3ncrVEnYW5mQrzlCVH8P8JILlaFRLz9ck0Sg/XO7Osu6//55bTUZAQAOh7/cfEiPAYT+K1HYiP42UNEUxmKhCQIgXHbEFmNTHlZSY+j8+fwwzLCUJhQ5kZCK5/ryRuY4Of4bwYNbBq0IchHCGbwAioVAORmk93lwqHRjSpFGjsMAJ5Iz9pUXQEAOpttc03lxplzRurh/0+74a1xEmLX2wFA16XTdem66F0RBRERsyPwNHyAl4TQvxo2GvHRSFG794WFXGq8N6HsLMAE3P0pFvIRfDjxXP3eiqEx+GSKxGRs1ajS2WGfNV3568wiCg4XTiJ72jSqlZ06TTyd6fPayWCjkVaFrc6bAjMSKgMC4ybEprcNbetsvSd6+071hWWGRRZH0qJoIRnZFAi5vDxelseNQXSTA1O05GOzw45w8lFckaW6YkthSadOmxvGYxAInmb3JKT848olm9PpcrvNDsdFmbREEMUmEJdFxx3r7ULaHOnu+J/MPM9LbtkNb42TkPg74ntO9BjFRs8Rt9Mtr5W7HK7Uh1P9209GgD6qgkz+rqpI2lvYtrqM4oPETQWM/3yIy+0+2NP6pbsYADZgzwHAyb6Y06LeRAbz7VlDF3cCg4lFoSg4HBqFWpue/a+myznccDqekMeNON7bhcTrldL+O+OSomn0KWBjCsxICA0IjJsQdhqbncaW18pb9rR4HyeGXZdct2qsBCYBxiuNzS42WVPoFCzaN87xdrTMDicJO0qsOQ7dzMDUKQc+argoNunzwiJ4JGp75aUzCXP+JNo9AwC08PZF7Gv5BUjLSAo1ls5wuFzIrtRk3NfR+khqRmYYN4HBbNdqAMDhdr9z6Je5ZfTQsmFxGomY30AKJLAmlO3l5nA7fuxwmB2kcBKgwDxgJnFI3g06D3aaBkz8OXw02j2O/o/2KzZe6cCjUekMahaTlsmiZTKp0ZTr3kJusRX9VAUAVCzmcElOJHk881/e0lq0lwcuJ7ATImmR3sdvHmA+uFp1QtSJApgfGfNiZgEAlJ3ZtSFv9geXcd16HQBsUO2rO7kve/E2pH00lb6ntemNGQWZYdwoKq1Nq0aOL42O+6zxitnpAABDuDt36zDGfyL6tPXFbuOVfM6yGZylifRcz3GPGdFYVHgMgYwLJUWhNSAw8fkQWixN3aR22VwzXpuhadP4WAyb1maWmTv3d86bg76ypyOuNJIaQRqpK3+dk6kBwOZy16r1tWo9dAEAMHDYbBYtk0nb+VR92saoVx++gMCXyqD64xGko7WoLOytBw+Q1zbU9Ne0q9oFtEi5SRHLjCmJnTcvriSJM8wsRKiA0cisGrnNanZisSiN3CYXmXUKW+5CbmIOw9PGx8V6Ki1PbbUAAIIHIgGV9nRGztbaapnZtNldTMZinzu5HgCyF29LYDDLxL0nervviEvMD4841tMpNugFVFrv692s2ShzNACA3eUqE/f6x/rjltPtuKI5Z3Eajol3HRPvYuC4+WFL89hLUpmzMSgsAskGQ+EvPSeXJt59V+oDyZz0ib9pyPGAiRPCiGOom9RWjdUgNjCTfPMhNt1gQO+0urrKJF1lEm46M640kpfBQvk5Tv6SmK3+B7V2x1mZ+qxMjYx+c8NguDmXy/ywped/UmKCHLnOoq4TX7gkOl8rOt+haIIigKuDp7Ys2RJFj6roO3+u59yTh5+i4Cjz4+cvTVwyjTttpN4CABOAltN7REatgxmOxxHQGAwag0PFpdPrzyqOfto7dxU/pzQMhotAcGjMIkHcO3W/Nqjk6Wyu53gMjfFy7qx1v54BAJPDsRmKd5Ysrju5ngsAUNyt1wJAJJlqcTq3fFueXU1+5LOS1S7XY2eOmxwOAKgekNrTXbiJ1Wt51KqttjgNnl2tXX5asvu0ZDcZQ8/hLPxj0pYz2O/Wd8xDAexv/mp/81dp3Ow7p61ZnLCSiB3DPdRbk4EHTJwQejwd2VA1qPwnEOlxdHmt3PuIvEEjb9AIZ3Nz/5QyaucHS3J6jOb3mrqPS5QjtbG73QDAxuNcAJnMUdJovlQMpxhmDGI0FsTPXxA/3+FyXOi78OaZjb/2/vr9fd+NOmZE3lSMZF66G/QAcMdTsT6vNWjt0i5z60VNTmnYSAWLFBweAI70tiGEFD758Vvfvv/KfU8LKNS745MPdLW53G4A2FxTubn03XKJaEPjP0AKkJlX9UkrzAGJ0P7oylQAwKDRaSzORfkAAJidjl/6+xYIg73FBJ4ujKVOfyL571WKo7WqU97HTU6dyNiKQWEP9e3wvkc2yusa5XUfVG5amnj3ndPWJHHSghwGomDwMBtl/b0/C2IXEknsMfQ8pnH4iyqkojAot9OtbFBGL472OZuyJiU8P/zqrgafamsCHRdM54dEss86xE0640gNHHl7sTWrHXl774nmXVLpHksQjNTyTNuRf1d9OBIVGBQmNSI7V1h4vuu0u5ajv1NPIwzCViWq3nP5603zN75e9obKrGKP5ctFFMC8oIQA4GthYtJpv+6XyvrMX5fq76kY/j6SzeEtFMSdFncVSITF/GgiBttEi9jVUP94etb9SdMUFtO5fhEA9Bp0J/q6VsQmPn5ufnwbAWD9oiJYBLDZXSwy6LPCwgEgPzzi4rUyrR86WvO4Ed7J4nGLhKXRsOxc9iIfQgCASxQeE39KwFAwKJzTbfc+ZbQb9jV9ebTth0Orq2gEBowmk1Hb13V5y+Xte233XrS/icEQhXGLuPzhnWqV/LJcUi3t+4UnKIhKuI1A9HV5htVECUFj0VQhVd+jN4qNVq2VwLjuy9W0aVr3tvovRqDwgrKkdwjD89n0eaeH1qyjAB5NEOzvk6ls132zC3hshdWGD+gh+ODhoSJHWJDBzyfiSABwpOEbVVRj6f8tyuJnzo0p6lR3cclh7y/7OwFLyOXn1PTXLEpYFMzIAwgBpr/dWHVMduef4/wtTFgkkcLAGrWO/B2sAP2sjEk+Je6qVw4U86MBIFUvrZCSHkxJJ2GxJZFRCCEAsLu5sexkuy7WhUmlZ+dsA4DXLvyyQXsQWs/Zot7FYzALhDEXZVIEEoXF/ElD3Uu5syb4GREJKSm/yvd7H7k/9pVeY3MSPc/qNN4X+5doyrTP21/xf+GazLU4TKDZZ48eOfoQ04b7c8oHZCrfbByoKf9ry+XPzcaB6MTb/RtrlC2ZM18wGSQ97Udk5Zty57wejDEJQeUiPZ6u79EDgKpBxS/kIwfdLnfvT719p/rgWhJLOJubuipW3qiR1inpwmDTF3VqvfducThrhYDrcrvjqKT3m3vUNgdiRpozqpbyA0WZ2YLZ3rt4DOGF+W8vT7/f+2CvulNlkgMAoNz10vp6af2C+AVPz3oaOZsbmVfTf2nihCC6/IsytYAFALmpL+79W7vd5oqeRvUAE7cUAEAkOxgLI5aWRFPp2Rzeqf6uB5MymATim/e+8MThz75qbSjiCzM43AeS0w5cbDbQXYACcYwN3FAtkyIBuoBC26wpBoANp18GgOzF27heU+wioyGYJVbBVGSxCfxMVsl5+UFkF4cicAiCCFK80+1gU6eLTW3D4sEgsO5Je/i+7+f9KW/d8uTfjdQ5tjoPAH4J3yUVV5CpfAAgUXhMTopG2SzuKRuWELNxgEzlk6l8Di+7suxF5cAlQezCwB8BQkIII44hPiMGL0JselvLnhZtu9bTJuXO6JQV0QAQXcSLLuIF3/npgesKK9fE8vd2S+fxWEqr3ehweo5XyDV/zwsU2LDIYbHspG5VG7Iby0768NymH+u/eLJow4zouQAg0nR9X/eZz6sqG2rhGhF5kXkHmw8GP/IAMhscfU2GhQ8IAeDyOSU/ngwARo0dAAY2PQ8AWdupp3ZeprKJACOWXeLQmFVx05rUikO9rQ8lZeIxmDiT8qe+nl/6RYv30gFg565la8+eNNjt19qj2UQSAFicDuTITvzi9+bMrzu5PgfgGBQjB6Um4+Hu9pVxoVnSqLT2e7bjaBkV8gMOtx2PIjyT+vEP3ds8p/Bo4l+mf31ZffZ4/2dXOPa0sjl8i3FB3DBXOQIGACBRhw2vbW/82nOWE56tUTY7HWaLWeVjH0wGCYkagWw77Canw6xWNE0RIbTYQZdd065xWp36Xn3L1y1I4RYAoDCo5PuTdz3b894K3yhlVDlc7p+9COGTCLls+ne90tIIDgDcHcX7T7/8oEi29ZWOuX9LwM8YpkzLO9WbIyzwEDIzpuST2Qeres6daP5xz8WPu1VtGDQmSzD7qaJXD1ze3a/rRZqZSOqPVzaz9FGryyhJnES5UT6+UMRHDRXqxFwGFocGgL4Wo15pc9jdaAPeE5dbTXYUGmVQWaZnbWVGDNlbn7LLvDB+Hpd/tLf9oaRMAChSdXVak2R8R9eTmNfzCwHg+az8ty6eR9rbXS6pyRhHZ1Cwg0Ggymr5VSJevHgbAGw4uR4ANruLAaBTN3Rrm6CUVrFnO4GWW6c6/YeEt1OZBWJT6zHxp55TDyW8pbJJeKSY9/LPAcDLNaUrY16n1xX7d+gTjuMJDDQabzbJSWQuADDDBqd0LGaFDyFadTuDlYhsG3R9AKDXdgfzEUJACI6MI4WTzDKz2+lu3t2sblF7PCssBZv2SBo9lg7QM46eq5VavZehuD8m4qBItjxyML+JRaM0Nse72ck/D6iD6S1XWLD/8pfIdq3oPA6DnxO/cE78QqVRtvJfeR+u+jZXWAgAdqft0/NbkWYELPHSH3e43K7v3rJTLGxcMq62v7Y0oXQcn8VbV8tVy9cOpoyy53Mq3zOTLIR7j6djcYOVAQQyjhtLl3VqxU1Kb0L8yy7nAcwDKD9x6uq3KwFWRS2ul0H0FaWiTaNOYrLSWJz5gugz4kHgq2WSODpjbqTwlGjw3/F1W6OASk1nh4XP2fhcedkG1DkAgAE4188rjowaafzBF70rvGxIPDWzTPJVAj0HAP7d/poLBv+zs8NWJNJy3qhbzsTzzki/pmCZRAylNOKBRvSjwbwFnZWg13QhhJDIXByebrfpLCYFsJO9m+k1XTxhIbJt0HYDABodVLooNCuo6HF0s8wMAOrmoYuVFE5KeyzNZ5Z9TDo9MJTkxaDgnijeczXNSXSK1eVaKQxHo1APxvHrNXqF1RagE4+8Q5HmgXqL3YxE5xxKeDQr4dfOUxa7uVZ0/vDVvYPjx5G3rdydJZgJANa7LXsu/vPIMXHfkxl7HcaJrCfpadRTGNiwSOLeBUiOjvBgxXT/ZtEZYbJOraRFnT5/eNuL0OJyu+88/B3GCevuOwgA0wGWQDcAbK8nvTGjkEemPDk9u1un7dJrAaBFowIAKg6PgsGbmMnh+KShfnvRgkgKdX32jM11g51vuPpB3VXwzMp7a0xrQpSWIULoOE4MNQ2PJv4q+7FFN2gKuMSoBxM2/e+V3+PRpFczvmMReN2GKy63G4sOKlIHABojTq/tDo+ciexSaJEapc5ikvk0M+j6Ehmxg9t6EQCQrzldgRUiQmLpAxcGvI8wEhmpD6diSYP9v3ouf13GmIsXT0uHXKxkGmW/SNZlNFerdNrIsLuieACARqFyWPQcFv2J4erhfWbTWeSwaFZCr7oDAJxu5xXJRSQC0VnUAPBt7aff1g7ZfTKe+t7K3RmRgy8/311W3nny36/so29iAcDewjbvNwoSGAQJrUBG0FH3/mdoosPpcCl6dXgSlsUfmlCKygi7eLBD3BxofRvyIIWVL6Xs6262TH9xoSAOAP7xxevHeOkbrCck5SckyPAAvqTcJjIarigVfQZ9FJV2e0zCkZ4OpBOj3Y7E5Vlh3HASWWY2AcDf3MXPZOTWXZuVD+bTDSuPl8XCR1hcxlRGgdGh3dv1DnIQDZinUz76sff9PlPzC2mfswg8AIilZozpLWjMOFl/pWeXROFplM1mo6yj8RujXkxjxvGjS7BYEg5HRqMHr0ajXgQAdGZCMP2HhhC387qyK94sXuLdiRNcVtWqM4q95tSbdEZkYoSGxeSy6a06YzJ9zDfyXGEBQggA1IrOz4ieK9WJXziwxnPQo5nRJakR2ch2RdfpLy588P7de+nEwfSrzyyeDzAjaVVFklFt+fFt8eotWWgMGgCay8VtlRJpq9rpcNE4xDVbSzyNefFMAgVn1tnUEoM3OYi8HzJSJe/f1938bUdjcUQ0HoP588NvXTj02WZ8MQAkMpiv5hVQcDg4uR5QAADKinNKAGbSWk9XBrutQaVIZ4cRMNg5fMH+zjYAcAOcEvVsWrwNALw5GZMBMTq0VpcJ2U6k5UrNXdMYs7/v3qKzD7oG98X9RWWTnJbsXiZ4PJu9IMhufUSlCc1GmctpR2NwAECm8AFAp2nHE5gJafcrpLV15/8Wm3wnkzNYD+F02iwmBQDQr4UlgTVRQlwOV9eRLkm5xHNEWCqMXRbr33KsZuQn6fDz6E8kRb3X1P2vWb5lPD7LqoYtx8oRFh648hWyfUlU0S5vXH/wIYVxAABQgEripucIC3KFhWkR2f9p/G79gQdfXrilX9v7ScW72+/6mjlygB788vGmc6LUYiGCh6hR+fPnVz2n9EqLUW2hsIZKy6LSOe1VUnGTypsQ/wfwzORG/jWv5I2asydFnctjkgDg4dz571+tAoB2reZvlyrfnjU3e/G279qbf+hojaRQtxctgJPrN3jdvj5rpL5bOA+HRi+Jijst6tHZbABgdtiVFjOHSMr24gSfNIYLxjuRlUTPG7B0x1Ezz0gHU09ZrPkzOLe9Vrssjprxu9iXgu/WRyg0hkyLNBklVHo0AFBoAgCw2wxJ0x+iM+Np9BhZf2VH47dZswffwqTvB3Cj0FjGFBBiVpibdzd7rxIBACJrotW1iLxdrGwmLZZKOiCS5bHpdpdLQCbmc0afcPVXrnCo1K9JWvfUD6vcbteqrD/MjC7JFsyiEIaKVuYn3e5w2h/9+rZwGn/byi9Z5BCU9Lld7pZy8V2vD4ZD6n4DADAjKAkzI0xaa9NZkV5hvo6QjLD2Kml3rWz6gmgI+OC2fC5fQKad6u9CCEllDY22VaP+qqXxgZS0exJSCBjMntYmmdmUuWjro2XHkHIsANhgOtpw6iiy/QzAZigGgG697pOG+g15g6O1tTkQ6xH8GmDvRFYiLUdrk+/pfMsNbgBg4LiPJb37YdOTLnA9nfIRBjWh65BCExj1YoQQKj0ahcLQmfFs7nQAQKExXH6+WtFEpQ8mHowGxMWKR2zOqMKWry8HgKJtRWMdluySrP2HdpfN5XPcIDIM2x7GYkYGLNar2sF+8GjUrllpq36pRwG8lh7/6IWrz45WnjhSPa9PKCKgR4u03UcavulRtbcrGqfz8yS6PqRqy+125QgLnix6pThhaQDrMSa1VPTzEphk+mDZgUZiBICIROaMOxPFzaqmsyKbxeHdPmp6GAD0N6uCeXBbIp11VtqL1DIKKfRZ4YILssEL9Ke+bhIWsyohZVFU7MGudhwajUahyFgcQkgcjbHDujCGRjc7HDKzSWezDWa0AEAJALPheudq2DXAw8oTpmNQuFjq9F2t66SWLgBAAWptyvbTkt3t+pqnU3aEk8Y8DeAjMoVv0PXxBAUAgMbgohOXc/kzPGcFsQs9LhYAGLS9AMBkj14WiAiLsDEmTpw2Z+eBzoGqodCcm8PFM/HIvKG+Tz/yS4OF5IzXNMhyAbdOrU+lU1bHRNSpdVana6UwfNhXIY7Wsn37A5S7e4ciBXGlj8x6rrL75zPt/9lT80+H014UvyhHWPiHmc9Gs8b2FKlR5Xa5Lx3pLH18KAzVykwAgFBBZuABwG5xer+EzCAAgMvpXvDHjOTC6xar+Gu+IPastHdn86UtMxeQsLh7YqfVKaRWlxMAzE7Hd+0tSQx2Zhh3Z8liPAZjdTqI155v0mfQ3Zs4bW9bE4tAMDsccG1WBI/G/Dkzx+Nc+SARDCceLyuGkia3ihA8AOCOqGcA4FDfjhLe/bO4y4P7/gKJTOUrpEOLFqPiB28lSHBCJHGIJI7nrF7bAwAMTtCEIH+C58QoMTZ/1WweMCO7GCImcVUiN4drEBsQQkxSk8vhQmNHLJEKDEny4fLWFUXeLtbqGP6ZAdWOGanP1zTXqHR3RvEoAVcUBl4N4hOKPF740tyExXMTFiuNsjVfzt+47CM0KjTl3z5qq5QQKThe/FC1HIGMAwCn3eXZtluHCEHshiCNI25UdtYMjEpIDoc3jcFp1iq/6Wx8JDkrnc2dHS44Kx2cCXEDbL988Z1Zc/kUKgAQMNjZEZE/dLQCgMPt7jPoZobzZ/IiGlTKapnkzrikBAZzGpNd/c91NnB7h+bDPlppJE48XlYiLXd745+ubeeV8h98vfZ2Pinxgfg3g/vyRhGFJjDoRW63C3X9/66p7hN+VAk7fOiu5HTajAYxAIpKG3G2x0fX+X+j2hBppbTjQIfbMZi5YiQwklcnI6umqAIqjoqzG+xup9skNVGFgR6lNSwkyYfLAeDrwgyV1V4h13iO31te/+b0eAB4Kjn6rnO1bDxWZ3fQccN4rusyLpaf6yv6IKr82REfg5ItGCrLa5LWec+KsCncdkVTMjcES3n8dfV07/TS69wJEh0PAC4kDYgCAJC2qk0aS9WP7QBAoOCsRrtGYsCTsKIGhdPhwox80wEAHBqzdVbpmjMHquX9jyRnAQARe91XZLDbX/n5+N9Ll7OJxDaNukI6FEYPmEzIA7VmhPM5ROIdcYlVHz1XA7DQL20V4NFK/r+j5JkutLrMEnMHAJAx9KdSPvy07UWTQ/fS9K8ImPHPlXkLh6fi8TSTQUrxWhaqVbWpFY0A4E2IVtUGbheJwgsyCIHgI3WHxdH+fbuiXoHsojComCUxgnkC74VQrBSWrEYGAPo+fWBC4BokAPDelXyEjdYVRbVq3X3llz3zWQDwdmai1GLddLVz09VOAIilEHe09n3U2pfNon0+e7rHmAT/7HdkftB/VgQAcoUFtaKKySBEIzVqZaaEmYNTVCqxobVC3H5BAgBoLAoAkKu/uVwMAAwemRZG4sYy4nLDw+MYl/7TWbWvTdykjM7gjvwOAAAYNPq+hPRPm2v7DLooKv3Z6TNtLueZ/h4AQKNQy6OTDvW0vnv0axmBZsQOlWCjUSjita/xyifrYwGqTkCQKd1hgfGgomQN2pBK+SFk44/JW6uVR6+oz/4hYXMUJVg/Jxixw7MGxBXciHwCiYUnMACgt/0IAKiVzQ67CYsbLM1UyS8DAJk6ikH2VrCEGEQGQ99g6EwKJ6WsSfFfL8VMYSKE+GS3RhJyQScfLl+xgYjYkxadEbzwQCQyWVtXFAFAl8G85EwN0oCOwzrdbhjX7yJ4z34gsyLIdo6w8FTLwfty/hR8V0Gqv1mFI2Cu/NSjk5vFTUrtgIkZQWELqP0tasS/+r9nygCAE0Vb+ZeZ+GvTrA67s7Wiv6deDgCyTu2ohABAFIUOAEd6255MywOAbDYPIcTldutsVgae0AVhFCwOHINVc1yroVjZHtemqrrwHUCwYIwkn6KYe9W53mc7EjlsPH9H01Mzw25fwP/9RN7IX1HxS+sr3yWSwlxuh07TaTUrteo2ABQ3Ir+z+QcaIxaNwZmNAwPi8wBAYwS7SgzG9FRSl8MlqZBYVJa42+PQuGEsvt1gv7DxAgBQBJSc53NG7XB2eTkAVBYVwbXfEsk+FPm/DV3IssGhIQIsiuAs5nM6DeaP265zn1ZsIA7LRgBHq+iDqI1Ld2w8/gyyG81KeLl0C1JaojTKHthdemztlVFHPlaJm1WHt1QDAD2cHJnMSpwVIUwPs5rsu1/42WFzAcDaz5dI29SHtlTf9epsbixd1qVtKRd3VEtZkVRuLJ0tpMXn8TzkBJDL7b7n1D632/3lvDtoeMJtx78piYj2RCPJDPby6KRZ3Mh/Nl1yul3FEdHpLC6TEJrsvI8UFvELF+c8brwNAHZRjkaRp3AaXmoAAAZtSURBVC2TX5f8CPkDL83GgcbanQ67EQBcTofTaYlOXC6MW1xfuTUxbTUKjcHiKFJRuajzeMaM5xnsYKewxpCHRmPRguIRF/EBAI6KowqpBpFh1GDdmw1EyIX+TvHFUiJeku6kPEE9r9AgoLgBTkqVJ70mEJl9KKYI/ZfH09ZuvnK4vNy7n8BCyFEah4p2SpNXUPDU3dU7UCj0/KTbWWROu7wxkTu2JaCjSjCNnb0stu5Yd/GDqcL0MADorpMd/7AWAB7aPg/J/0YksbKWxB59v4bKIVI5xJis8Bl3JRKpwZYnIUKjUOsyZm2u+/WKWv52bfnTaXnHRZ2esxwCCalMeSmrYOQ+QiMkkbWLchQAHjfeBka4HIOpUhx9PWtfAi0bJuHxsCQKL3fO6zarDgAA3Gg0DoenAkB45Izm+n/h8FSn0+qwG3F4Kp05hkRliH9hp+d4T9+pPgDIejZrpIcvzh75mlbZbH+8fHlhWFjPSzKCHtU/3dmf5VTF+j5JaFNy8vcSyb+ysjwdIhve3fqbEe8jq78o7tN0RbMSvlhzElnOprdqjzZ+982lT3+f+8S9OY+N9YMHo8rvW1rPSzIWxlz4oRUASh5OTy0R+rRRiQ3MCDIy6T5u/bOx5nBvGxGD9SwFAQAukbxYGL8mcZgqyclQhezAztbnkO0/Jm11u12Y+rPIrj8Poz59fIKymFVWsxJQKCyWSCKPIUyHkP86AmsaCyHEIDL4E+JvOnzExuPfSUk5KZc3rAcSGrWQy18YFkbFYk8rFD9IJP0WCwAIiUQUCjWPM5Th9nQYoH8fYHKEhX2arpdLt+AweJGm65LofJ34Qq3oPBqFQk1OthcAZt+bUnes+8IPrcuezRWmc4bNTbHH+Dj9YXW4tw0FEEYkiY16NwAWhb4nftrKmBQGPgQL0IOUZzLEU9yeIpz1YvoXMFx2OECKzP/sOEQkscf09AZvhdiGuJ3uyjcqnVYnbxYv6d4hV29UNvxVq9WelMvLFAomDreIyz0qkyGEvJyQUKFWv5qUxMQNfyfwmBRszWqECn97cqrl4K6KLen83FrReQwakyMszBEW5AoL+PRg0+Q3rW47/s3ueXdYnc5ICu2cpJeCw6WzuETMVP9QzL/bXy2T7uESo97I3L/l6gM6u/LtnGMM/FA5TPDVK/555KlUiL84FAYVOTeyr6zPk/iCgG5VAOUwGDkMxrqEhIsazUm5HMGDhcPlM5mXtNqR8AAvDotqYHZ5uYeT6zoXFmQKZuYICx4vfOm/gAqPbjv+zdGlQ4vvkYc83BAprf1IcfuBvg9EppaXpn/ljQeMpXrlxv6IRehvLTFLY8JnhIvPiN1Od8H5X2GMpsNHWBTquYaGyqKiDBrtvFqdSqOdUihW8IJd6V5ZVIRw4jMMDiX8tcXvj3tUY9XOKfnJPx88JlUPlccG00xpFZ+W7F4hfDqdOfxPlHhzAjcahmE1Wb+FOw63aqR+kE5OKxS7RaJ8BqPFaPzH9GDDTW//KlRDGp8m+yeVpxKPYPRx85/vjX1p3cWxPSrbkx0e9uyXRd0TH9hYNSmEjM+tGrUfl9t9SqGwuVzLg7MhRR9EAYCPizVs4mvKNEmc3Gx4uNwuo0Ozs/X5Dl3t2znHwoiBJgn8NZLrFaThClJB8hZiQkJ7n54IaR7rMdLs4Q00KaF1um42PDx6sjLrsaQt+ZxxftLgQ/nxKUjeQkZIyC+4kOABAefX4caZlFAZk5sWD7ND/33PtocSNk2wn8nmZFSFhpBQuVUh6TAwEgHeEdmYSlQmwsltx78BgJsTDwAwOrQENCn4R5YE1g3kZKKETIavMvV4+Lw73PSc3LSm479P48/23tjU0LCaOB5w7RNNpUlB2Ag+OLmFx1RqnDYk5G7VxHsOCR7Djgem6kYQjDG5hccUa8yETOoVc7Ph4dFUmpQAnNzCY+o1BkIm+2560+LhrSkzKf5O1y08boiCjUMmz62aoKYSD5jCKGXt50u8jcktPG6URidkau6aNy2BwyqYevuJyxPBH/qd+hYeN0qBvKwp8yh+E/5VAE2qSUGsx2SXdd3SSBqRkCm7qf/W8fBWyO8pPs7V1NQI35K3hvGybsKJDn/dhHhAqKMU/9jDJzi5pSnQdTZk6tkYnwG5OfHw10S+z8Ch+S1OpkxDhEx9rPzfjYdH4+AkyMzVLadrCvT/AAEZLa4me5LyAAAAAElFTkSuQmCC",
    },
    {
        "ground_truth": "T2YE3LV",
        "picture": "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",
    },
    {
        "ground_truth": "GPJPYB",
        "picture": "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",
    },
]


def decaptchaConf(session, event, stdin_fd, predetermined_input):
    """
    Parameters
    ----------
    session : ikabot.web.session.Session
    event : multiprocessing.Event
    stdin_fd: int
    predetermined_input : multiprocessing.managers.SyncManager.list
    """
    sys.stdin = os.fdopen(stdin_fd)
    config.predetermined_input = predetermined_input
    banner()
    try:
        session_data = session.getSessionData()

        if "decaptcha" not in session_data:
            session_data["decaptcha"] = {
                "name": "default",
                "endpoint": "default",
                "relevant_data": {},
            }
            session.setSessionData(session_data)

        if session_data["decaptcha"]["name"] == "default":
            print("You are currently using the default decaptcha service")
        elif session_data["decaptcha"]["name"] == "custom":
            print("You are currently using your custom decaptcha service")
            print("Endpoint : {}".format(session_data["decaptcha"]["endpoint"]))
        elif session_data["decaptcha"]["name"] == "9kw.eu":
            print("You are currently using 9kw.eu as your decaptcha service")
            print(
                "API key : {}".format(
                    session_data["decaptcha"]["relevant_data"]["apiKey"]
                )
            )
        elif session_data["decaptcha"]["name"] == "telegram":
            print("You are currently using Telegram as your decaptcha service")
            print(
                "Telegram ID : {}".format(session_data["shared"]["telegram"]["chatId"])
            )
        print()
        print("(0) Exit")
        print("(1) Default")
        print("(2) Custom")
        print("(3) 9kw.eu")
        print("(4) Telegram")

        action = read(min=0, max=4, digit=True)

        if action == 0:
            event.set()
            return

        elif action == 1:
            banner()
            session_data["decaptcha"] = {
                "name": "default",
                "endpoint": "default",
                "relevant_data": {},
            }
            session.setSessionData(session_data)
            print("Default decaptcha service set as decaptcha service!")
            enter()
            event.set()
            return

        elif action == 2:
            while True:
                banner()
                endpoint = read(msg="Enter your custom endpoint : ")
                if "http" not in endpoint:
                    print("Invalid endpoint!")
                    enter()
                    event.set()
                    return
                session_data["decaptcha"]["name"] = "custom"
                session_data["decaptcha"]["endpoint"] = endpoint
                print(
                    "Endpoint {} set! Remember, the picture will be sent via a POST request under the `upload_file` parameter".format(
                        endpoint
                    )
                )
                print("Do you want to test this newly-set custom endpoint?(y|n)")
                test_bool = read(values=["y", "Y", "n", "N"])
                if test_bool.lower() == "n":
                    session.setSessionData(session_data)
                    event.set()
                    return
                for test in decaptcha_test_pictures:
                    if testCustomDecaptcha(
                        test["ground_truth"],
                        base64.b64decode(test["picture"]),
                        endpoint,
                    ):
                        session.setSessionData(session_data)
                        print("Custom decaptcha passed at least one test, good enough!")
                        enter()
                        event.set()
                        return
                print("All tests failed. Do you wish to set the endpoint again?")
                input = read(values=["y", "Y", "n", "N"])
                if input.lower() == "y":
                    continue
                else:
                    event.set()
                    return

        elif action == 3:
            banner()
            apiKey_9kw = read(msg="Enter your 9kw.eu API key : ")
            response = requests.get(
                "https://www.9kw.eu/index.cgi?action=usercaptchaguthaben&apikey={}".format(
                    apiKey_9kw
                )
            ).text
            if "API key not found" in response:
                print("{}Failure!{} Wrong API key!".format(bcolors.RED, bcolors.ENDC))
                enter()
                event.set()
                return
            else:
                session_data["decaptcha"]["name"] = "9kw.eu"
                session_data["decaptcha"]["endpoint"] = "https://www.9kw.eu/index.cgi"
                session_data["decaptcha"]["relevant_data"] = {"apiKey": apiKey_9kw}
                print(
                    "{}Success!{} You currently have {} credits".format(
                        bcolors.GREEN, bcolors.ENDC, response
                    )
                )
                enter()
                session.setSessionData(session_data)
                event.set()
                return

        elif action == 4:
            banner()
            if checkTelegramData(session) is False:
                print("Please first set the Telegram data")
                enter()
                event.set()
                return
            session_data["decaptcha"]["name"] = "telegram"
            print("Do you wish to do a test?(y|n)")
            test = read(values=["y", "Y", "n", "N"])
            if test.lower() == "y":
                print(
                    "A captcha has been sent to you over Telegram. Please open the picture fully and respond on Telegram"
                )
                sendToBot(
                    session,
                    "Please resolve the captcha",
                    Photo=base64.b64decode(decaptcha_test_pictures[0]["picture"]),
                )
                captcha_time = time.time()
                while True:
                    response = getUserResponse(session, fullResponse=True)
                    if response == []:
                        time.sleep(5)
                        continue
                    response = response[-1]
                    if response["date"] < captcha_time:
                        time.sleep(5)
                        continue
                    else:
                        captcha = response["text"]
                        break
                    time.sleep(5)
                if (
                    captcha.lower()
                    == decaptcha_test_pictures[0]["ground_truth"].lower()
                ):
                    print(
                        "{}Success!{} Captcha is correct!".format(
                            bcolors.GREEN, bcolors.ENDC
                        )
                    )
                    enter()
                    session.setSessionData(session_data)
                    event.set()
                    return
                else:
                    print(
                        "{}Failure!{} Captcha is incorrect, try again!".format(
                            bcolors.GREEN, bcolors.ENDC
                        )
                    )
                    enter()
                    event.set()
                    return
            else:
                print("You will now recieve the piracy captcha over Telegram!")
                session.setSessionData(session_data)
                enter()
                event.set()
                return
    except KeyboardInterrupt:
        event.set()
        return


def testCustomDecaptcha(ground_truth, picture, address):

    try:
        files = {"upload_file": picture}
        captcha = requests.post("{0}".format(address), files=files).text
        if (
            captcha.lower() != ground_truth.lower()
        ):  # Ikariam's captcha is not case-sensitive
            return False
        return True
    except Exception:
        return False
