# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Union, Optional
from typing_extensions import Literal, TypeAlias

from ..._models import BaseModel

__all__ = [
    "HierarchyConfiguration",
    "ParentHierarchyConfiguration",
    "ParentHierarchyConfigurationChild",
    "ParentHierarchyConfigurationParentBehavior",
    "ChildHierarchyConfiguration",
    "ChildHierarchyConfigurationParent",
]


class ParentHierarchyConfigurationChild(BaseModel):
    contract_id: str

    customer_id: str


class ParentHierarchyConfigurationParentBehavior(BaseModel):
    invoice_consolidation_type: Optional[Literal["CONCATENATE", "NONE"]] = None
    """
    Account hierarchy M3 - Indicates the desired behavior of consolidated invoices
    generated by the parent in a customer hierarchy

    **CONCATENATE**: Statements on the invoices of child customers will be appended
    to the consolidated invoice

    **NONE**: Do not generate consolidated invoices
    """


class ParentHierarchyConfiguration(BaseModel):
    children: List[ParentHierarchyConfigurationChild]
    """List of contracts that belong to this parent."""

    parent_behavior: Optional[ParentHierarchyConfigurationParentBehavior] = None


class ChildHierarchyConfigurationParent(BaseModel):
    contract_id: str

    customer_id: str


class ChildHierarchyConfiguration(BaseModel):
    parent: ChildHierarchyConfigurationParent
    """The single parent contract/customer for this child."""

    payer: Optional[Literal["SELF", "PARENT"]] = None
    """
    Account hierarchy M3 - Indicates which customer should pay for the child's
    invoice charges

    **SELF**: The child pays for its own invoice charges

    **PARENT**: The parent pays for the child's invoice charges
    """

    usage_statement_behavior: Optional[Literal["CONSOLIDATE", "SEPARATE"]] = None
    """
    Account hierarchy M3 - Indicates the behavior of the child's invoice statements
    on the parent's invoices.

    **CONSOLIDATE**: Child's invoice statements will be added to parent's
    consolidated invoices

    **SEPARATE**: Child's invoice statements will appear not appear on parent's
    consolidated invoices
    """


HierarchyConfiguration: TypeAlias = Union[ParentHierarchyConfiguration, ChildHierarchyConfiguration]
