"""
    Gretel Api

    Gretel api definitions  # noqa: E501

    The version of the OpenAPI document: dev
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from gretel_client.rest.api_client import ApiClient
from gretel_client.rest.api_client import Endpoint as _Endpoint
from gretel_client.rest.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)


class JobsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __receive_one(self, **kwargs):
            """Get Gretel job for scheduling  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.receive_one(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                project_id (str): Deprecated, use project_ids instead.. [optional]
                project_ids ([str]): [optional]
                runner_modes ([str]): [optional]
                org_only (bool): Query for jobs within the same organization only. [optional]
                cluster_guid (str): GUID of the cluster for which to retrieve jobs. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            return self.call_with_http_info(**kwargs)

        self.receive_one = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/jobs/receive_one",
                "operation_id": "receive_one",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "project_ids",
                    "runner_modes",
                    "org_only",
                    "cluster_guid",
                ],
                "required": [],
                "nullable": [],
                "enum": [
                    "runner_modes",
                ],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {
                    ("runner_modes",): {
                        "CLOUD": "cloud",
                        "MANUAL": "manual",
                        "HYBRID": "hybrid",
                    },
                },
                "openapi_types": {
                    "project_id": (str,),
                    "project_ids": ([str],),
                    "runner_modes": ([str],),
                    "org_only": (bool,),
                    "cluster_guid": (str,),
                },
                "attribute_map": {
                    "project_id": "project_id",
                    "project_ids": "project_ids",
                    "runner_modes": "runner_modes",
                    "org_only": "org_only",
                    "cluster_guid": "cluster_guid",
                },
                "location_map": {
                    "project_id": "query",
                    "project_ids": "query",
                    "runner_modes": "query",
                    "org_only": "query",
                    "cluster_guid": "query",
                },
                "collection_format_map": {
                    "project_ids": "csv",
                    "runner_modes": "csv",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__receive_one,
        )
