"""
    Gretel Api

    Gretel api definitions  # noqa: E501

    The version of the OpenAPI document: dev
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from gretel_client.rest.api_client import ApiClient
from gretel_client.rest.api_client import Endpoint as _Endpoint
from gretel_client.rest.model.artifact import Artifact
from gretel_client.rest.model.project import Project
from gretel_client.rest.model.project_invite import ProjectInvite
from gretel_client.rest.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)


class ProjectsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_artifact(self, project_id, artifact, **kwargs):
            """Create a new artifact  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_artifact(project_id, artifact, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id
                artifact (Artifact):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            kwargs["artifact"] = artifact
            return self.call_with_http_info(**kwargs)

        self.create_artifact = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/artifacts",
                "operation_id": "create_artifact",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "artifact",
                ],
                "required": [
                    "project_id",
                    "artifact",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "project_id": (str,),
                    "artifact": (Artifact,),
                },
                "attribute_map": {
                    "project_id": "project_id",
                },
                "location_map": {
                    "project_id": "path",
                    "artifact": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
            callable=__create_artifact,
        )

        def __create_invite(self, project_id, project_invite, **kwargs):
            """Create a project invite  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_invite(project_id, project_invite, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id
                project_invite (ProjectInvite):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            kwargs["project_invite"] = project_invite
            return self.call_with_http_info(**kwargs)

        self.create_invite = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/invites",
                "operation_id": "create_invite",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "project_invite",
                ],
                "required": [
                    "project_id",
                    "project_invite",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "project_id": (str,),
                    "project_invite": (ProjectInvite,),
                },
                "attribute_map": {
                    "project_id": "project_id",
                },
                "location_map": {
                    "project_id": "path",
                    "project_invite": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
            callable=__create_invite,
        )

        def __create_model(self, project_id, body, **kwargs):
            """Create and train a new model  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_model(project_id, body, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id
                body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}):

            Keyword Args:
                dry_run (str): yes or no. [optional]
                runner_mode (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            kwargs["body"] = body
            return self.call_with_http_info(**kwargs)

        self.create_model = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/models",
                "operation_id": "create_model",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "body",
                    "dry_run",
                    "runner_mode",
                ],
                "required": [
                    "project_id",
                    "body",
                ],
                "nullable": [],
                "enum": [
                    "runner_mode",
                ],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {
                    ("runner_mode",): {
                        "CLOUD": "cloud",
                        "MANUAL": "manual",
                        "HYBRID": "hybrid",
                    },
                },
                "openapi_types": {
                    "project_id": (str,),
                    "body": (
                        {
                            str: (
                                bool,
                                date,
                                datetime,
                                dict,
                                float,
                                int,
                                list,
                                str,
                                none_type,
                            )
                        },
                    ),
                    "dry_run": (str,),
                    "runner_mode": (str,),
                },
                "attribute_map": {
                    "project_id": "project_id",
                    "dry_run": "dry_run",
                    "runner_mode": "runner_mode",
                },
                "location_map": {
                    "project_id": "path",
                    "body": "body",
                    "dry_run": "query",
                    "runner_mode": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
            callable=__create_model,
        )

        def __create_project(self, **kwargs):
            """create_project  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_project(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                project (Project): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            return self.call_with_http_info(**kwargs)

        self.create_project = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects",
                "operation_id": "create_project",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "project",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "project": (Project,),
                },
                "attribute_map": {},
                "location_map": {
                    "project": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
            callable=__create_project,
        )

        def __create_record_handler(self, project_id, model_id, **kwargs):
            """Create a record handler for a model  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_record_handler(project_id, model_id, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id
                model_id (str): Model id

            Keyword Args:
                runner_mode (str): [optional]
                body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            kwargs["model_id"] = model_id
            return self.call_with_http_info(**kwargs)

        self.create_record_handler = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/models/{model_id}/record_handlers",
                "operation_id": "create_record_handler",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "model_id",
                    "runner_mode",
                    "body",
                ],
                "required": [
                    "project_id",
                    "model_id",
                ],
                "nullable": [],
                "enum": [
                    "runner_mode",
                ],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {
                    ("runner_mode",): {
                        "CLOUD": "cloud",
                        "MANUAL": "manual",
                        "HYBRID": "hybrid",
                        "INHERIT": "inherit",
                    },
                },
                "openapi_types": {
                    "project_id": (str,),
                    "model_id": (str,),
                    "runner_mode": (str,),
                    "body": (
                        {
                            str: (
                                bool,
                                date,
                                datetime,
                                dict,
                                float,
                                int,
                                list,
                                str,
                                none_type,
                            )
                        },
                    ),
                },
                "attribute_map": {
                    "project_id": "project_id",
                    "model_id": "model_id",
                    "runner_mode": "runner_mode",
                },
                "location_map": {
                    "project_id": "path",
                    "model_id": "path",
                    "runner_mode": "query",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
            callable=__create_record_handler,
        )

        def __delete_artifact(self, project_id, **kwargs):
            """Delete an artifact  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_artifact(project_id, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id

            Keyword Args:
                key (str): Artifact key to delete. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            return self.call_with_http_info(**kwargs)

        self.delete_artifact = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/artifacts",
                "operation_id": "delete_artifact",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "key",
                ],
                "required": [
                    "project_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "project_id": (str,),
                    "key": (str,),
                },
                "attribute_map": {
                    "project_id": "project_id",
                    "key": "key",
                },
                "location_map": {
                    "project_id": "path",
                    "key": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__delete_artifact,
        )

        def __delete_model(self, project_id, model_id, **kwargs):
            """Delete a model by it's ID  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_model(project_id, model_id, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id
                model_id (str): Model id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            kwargs["model_id"] = model_id
            return self.call_with_http_info(**kwargs)

        self.delete_model = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/models/{model_id}",
                "operation_id": "delete_model",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "model_id",
                ],
                "required": [
                    "project_id",
                    "model_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "project_id": (str,),
                    "model_id": (str,),
                },
                "attribute_map": {
                    "project_id": "project_id",
                    "model_id": "model_id",
                },
                "location_map": {
                    "project_id": "path",
                    "model_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__delete_model,
        )

        def __delete_project(self, project_id, **kwargs):
            """delete_project  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_project(project_id, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project Id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            return self.call_with_http_info(**kwargs)

        self.delete_project = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}",
                "operation_id": "delete_project",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                ],
                "required": [
                    "project_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "project_id": (str,),
                },
                "attribute_map": {
                    "project_id": "project_id",
                },
                "location_map": {
                    "project_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__delete_project,
        )

        def __delete_record_handler(
            self, project_id, model_id, record_handler_id, **kwargs
        ):
            """delete_record_handler  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_record_handler(project_id, model_id, record_handler_id, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id
                model_id (str): Model id
                record_handler_id (str): Record handler id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            kwargs["model_id"] = model_id
            kwargs["record_handler_id"] = record_handler_id
            return self.call_with_http_info(**kwargs)

        self.delete_record_handler = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/models/{model_id}/record_handlers/{record_handler_id}",
                "operation_id": "delete_record_handler",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "model_id",
                    "record_handler_id",
                ],
                "required": [
                    "project_id",
                    "model_id",
                    "record_handler_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "project_id": (str,),
                    "model_id": (str,),
                    "record_handler_id": (str,),
                },
                "attribute_map": {
                    "project_id": "project_id",
                    "model_id": "model_id",
                    "record_handler_id": "record_handler_id",
                },
                "location_map": {
                    "project_id": "path",
                    "model_id": "path",
                    "record_handler_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__delete_record_handler,
        )

        def __download_artifact(self, project_id, **kwargs):
            """download_artifact  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.download_artifact(project_id, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id

            Keyword Args:
                key (str): Download artifact by key. [optional]
                uncompressed (str): Return a URL pointing to the uncompressed version of a gzip compressed file. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            return self.call_with_http_info(**kwargs)

        self.download_artifact = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/artifacts/download",
                "operation_id": "download_artifact",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "key",
                    "uncompressed",
                ],
                "required": [
                    "project_id",
                ],
                "nullable": [],
                "enum": [
                    "uncompressed",
                ],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {
                    ("uncompressed",): {
                        "FALSE": "false",
                        "TRUE": "true",
                        "AUTO": "auto",
                    },
                },
                "openapi_types": {
                    "project_id": (str,),
                    "key": (str,),
                    "uncompressed": (str,),
                },
                "attribute_map": {
                    "project_id": "project_id",
                    "key": "key",
                    "uncompressed": "uncompressed",
                },
                "location_map": {
                    "project_id": "path",
                    "key": "query",
                    "uncompressed": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__download_artifact,
        )

        def __get_artifact_manifest(self, project_id, **kwargs):
            """get_artifact_manifest  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_artifact_manifest(project_id, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id

            Keyword Args:
                key (str): Get artifact manifest by key. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            return self.call_with_http_info(**kwargs)

        self.get_artifact_manifest = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/artifacts/manifest",
                "operation_id": "get_artifact_manifest",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "key",
                ],
                "required": [
                    "project_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "project_id": (str,),
                    "key": (str,),
                },
                "attribute_map": {
                    "project_id": "project_id",
                    "key": "key",
                },
                "location_map": {
                    "project_id": "path",
                    "key": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__get_artifact_manifest,
        )

        def __get_artifacts(self, project_id, **kwargs):
            """List all project artifacts  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_artifacts(project_id, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            return self.call_with_http_info(**kwargs)

        self.get_artifacts = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/artifacts",
                "operation_id": "get_artifacts",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                ],
                "required": [
                    "project_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "project_id": (str,),
                },
                "attribute_map": {
                    "project_id": "project_id",
                },
                "location_map": {
                    "project_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__get_artifacts,
        )

        def __get_model(self, project_id, model_id, **kwargs):
            """Get model details  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_model(project_id, model_id, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id
                model_id (str): Model id

            Keyword Args:
                logs (str): Deprecated, use `expand` parameter instead.. [optional]
                expand ([str]): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            kwargs["model_id"] = model_id
            return self.call_with_http_info(**kwargs)

        self.get_model = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/models/{model_id}",
                "operation_id": "get_model",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "model_id",
                    "logs",
                    "expand",
                ],
                "required": [
                    "project_id",
                    "model_id",
                ],
                "nullable": [],
                "enum": [
                    "logs",
                    "expand",
                ],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {
                    ("logs",): {"YES": "yes", "NO": "no"},
                    ("expand",): {
                        "ARTIFACTS": "artifacts",
                        "LOGS": "logs",
                        "REPORT": "report",
                    },
                },
                "openapi_types": {
                    "project_id": (str,),
                    "model_id": (str,),
                    "logs": (str,),
                    "expand": ([str],),
                },
                "attribute_map": {
                    "project_id": "project_id",
                    "model_id": "model_id",
                    "logs": "logs",
                    "expand": "expand",
                },
                "location_map": {
                    "project_id": "path",
                    "model_id": "path",
                    "logs": "query",
                    "expand": "query",
                },
                "collection_format_map": {
                    "expand": "csv",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__get_model,
        )

        def __get_model_artifact(self, project_id, model_id, type, **kwargs):
            """Get model details  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_model_artifact(project_id, model_id, type, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id
                model_id (str): Model id
                type (str):

            Keyword Args:
                uncompressed (str): Return a URL pointing to the uncompressed version of a gzip compressed file. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            kwargs["model_id"] = model_id
            kwargs["type"] = type
            return self.call_with_http_info(**kwargs)

        self.get_model_artifact = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/models/{model_id}/artifact",
                "operation_id": "get_model_artifact",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "model_id",
                    "type",
                    "uncompressed",
                ],
                "required": [
                    "project_id",
                    "model_id",
                    "type",
                ],
                "nullable": [],
                "enum": [
                    "type",
                    "uncompressed",
                ],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {
                    ("type",): {
                        "MODEL": "model",
                        "REPORT": "report",
                        "REPORT_JSON": "report_json",
                        "CLASSIFICATION_REPORT": "classification_report",
                        "CLASSIFICATION_REPORT_JSON": "classification_report_json",
                        "REGRESSION_REPORT": "regression_report",
                        "REGRESSION_REPORT_JSON": "regression_report_json",
                        "TEXT_METRICS_REPORT": "text_metrics_report",
                        "TEXT_METRICS_REPORT_JSON": "text_metrics_report_json",
                        "DATA_PREVIEW": "data_preview",
                        "DATA": "data",
                        "MODEL_LOGS": "model_logs",
                    },
                    ("uncompressed",): {
                        "FALSE": "false",
                        "TRUE": "true",
                        "AUTO": "auto",
                    },
                },
                "openapi_types": {
                    "project_id": (str,),
                    "model_id": (str,),
                    "type": (str,),
                    "uncompressed": (str,),
                },
                "attribute_map": {
                    "project_id": "project_id",
                    "model_id": "model_id",
                    "type": "type",
                    "uncompressed": "uncompressed",
                },
                "location_map": {
                    "project_id": "path",
                    "model_id": "path",
                    "type": "query",
                    "uncompressed": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__get_model_artifact,
        )

        def __get_models(self, project_id, **kwargs):
            """List all project models  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_models(project_id, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id

            Keyword Args:
                limit (int): Limit number of models to return. [optional]
                model_name (str): Model name to match on. [optional]
                sort_by (str): Direction to sort by. Defaults to \"asc\". [optional]
                sort_field (str): field to sort on. Defaults to \"last_modified\". [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            return self.call_with_http_info(**kwargs)

        self.get_models = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/models",
                "operation_id": "get_models",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "limit",
                    "model_name",
                    "sort_by",
                    "sort_field",
                ],
                "required": [
                    "project_id",
                ],
                "nullable": [],
                "enum": [
                    "sort_by",
                    "sort_field",
                ],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {
                    ("sort_by",): {"ASC": "asc", "DESC": "desc"},
                    ("sort_field",): {
                        "LAST_MODIFIED": "last_modified",
                        "STATUS_HISTORY.CREATED": "status_history.created",
                        "MODEL_NAME": "model_name",
                    },
                },
                "openapi_types": {
                    "project_id": (str,),
                    "limit": (int,),
                    "model_name": (str,),
                    "sort_by": (str,),
                    "sort_field": (str,),
                },
                "attribute_map": {
                    "project_id": "project_id",
                    "limit": "limit",
                    "model_name": "model_name",
                    "sort_by": "sort_by",
                    "sort_field": "sort_field",
                },
                "location_map": {
                    "project_id": "path",
                    "limit": "query",
                    "model_name": "query",
                    "sort_by": "query",
                    "sort_field": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__get_models,
        )

        def __get_project(self, project_id, **kwargs):
            """get_project  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_project(project_id, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project Id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            return self.call_with_http_info(**kwargs)

        self.get_project = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}",
                "operation_id": "get_project",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                ],
                "required": [
                    "project_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "project_id": (str,),
                },
                "attribute_map": {
                    "project_id": "project_id",
                },
                "location_map": {
                    "project_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__get_project,
        )

        def __get_record_handler(
            self, project_id, model_id, record_handler_id, **kwargs
        ):
            """Get record handler  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_record_handler(project_id, model_id, record_handler_id, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id
                model_id (str): Model id
                record_handler_id (str): Record handler id

            Keyword Args:
                logs (str): Deprecated, use `expand` parameter instead.. [optional]
                expand ([str]): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            kwargs["model_id"] = model_id
            kwargs["record_handler_id"] = record_handler_id
            return self.call_with_http_info(**kwargs)

        self.get_record_handler = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/models/{model_id}/record_handlers/{record_handler_id}",
                "operation_id": "get_record_handler",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "model_id",
                    "record_handler_id",
                    "logs",
                    "expand",
                ],
                "required": [
                    "project_id",
                    "model_id",
                    "record_handler_id",
                ],
                "nullable": [],
                "enum": [
                    "logs",
                    "expand",
                ],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {
                    ("logs",): {"YES": "yes", "NO": "no"},
                    ("expand",): {"ARTIFACTS": "artifacts", "LOGS": "logs"},
                },
                "openapi_types": {
                    "project_id": (str,),
                    "model_id": (str,),
                    "record_handler_id": (str,),
                    "logs": (str,),
                    "expand": ([str],),
                },
                "attribute_map": {
                    "project_id": "project_id",
                    "model_id": "model_id",
                    "record_handler_id": "record_handler_id",
                    "logs": "logs",
                    "expand": "expand",
                },
                "location_map": {
                    "project_id": "path",
                    "model_id": "path",
                    "record_handler_id": "path",
                    "logs": "query",
                    "expand": "query",
                },
                "collection_format_map": {
                    "expand": "csv",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__get_record_handler,
        )

        def __get_record_handler_artifact(
            self, project_id, model_id, record_handler_id, type, **kwargs
        ):
            """Get record handler artifact  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_record_handler_artifact(project_id, model_id, record_handler_id, type, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id
                model_id (str): Model id
                record_handler_id (str): Record handler id
                type (str):

            Keyword Args:
                uncompressed (str): Return a URL pointing to the uncompressed version of a gzip compressed file. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            kwargs["model_id"] = model_id
            kwargs["record_handler_id"] = record_handler_id
            kwargs["type"] = type
            return self.call_with_http_info(**kwargs)

        self.get_record_handler_artifact = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/models/{model_id}/record_handlers/{record_handler_id}/artifact",
                "operation_id": "get_record_handler_artifact",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "model_id",
                    "record_handler_id",
                    "type",
                    "uncompressed",
                ],
                "required": [
                    "project_id",
                    "model_id",
                    "record_handler_id",
                    "type",
                ],
                "nullable": [],
                "enum": [
                    "type",
                    "uncompressed",
                ],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {
                    ("type",): {
                        "RUN_REPORT_JSON": "run_report_json",
                        "DATA": "data",
                        "RUN_LOGS": "run_logs",
                        "OUTPUT_FILES": "output_files",
                    },
                    ("uncompressed",): {
                        "FALSE": "false",
                        "TRUE": "true",
                        "AUTO": "auto",
                    },
                },
                "openapi_types": {
                    "project_id": (str,),
                    "model_id": (str,),
                    "record_handler_id": (str,),
                    "type": (str,),
                    "uncompressed": (str,),
                },
                "attribute_map": {
                    "project_id": "project_id",
                    "model_id": "model_id",
                    "record_handler_id": "record_handler_id",
                    "type": "type",
                    "uncompressed": "uncompressed",
                },
                "location_map": {
                    "project_id": "path",
                    "model_id": "path",
                    "record_handler_id": "path",
                    "type": "query",
                    "uncompressed": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__get_record_handler_artifact,
        )

        def __query_record_handlers(self, project_id, model_id, status, **kwargs):
            """Queries record handlers  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.query_record_handlers(project_id, model_id, status, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id
                model_id (str): Model id
                status (str):

            Keyword Args:
                skip (int): The number of records being skipped before returning the next set.. [optional]
                limit (int): The number of records returned in each result set.. [optional]
                expand ([str]): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            kwargs["model_id"] = model_id
            kwargs["status"] = status
            return self.call_with_http_info(**kwargs)

        self.query_record_handlers = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/models/{model_id}/record_handlers",
                "operation_id": "query_record_handlers",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "model_id",
                    "status",
                    "skip",
                    "limit",
                    "expand",
                ],
                "required": [
                    "project_id",
                    "model_id",
                    "status",
                ],
                "nullable": [],
                "enum": [
                    "status",
                    "expand",
                ],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {
                    ("status",): {
                        "COMPLETED": "completed",
                        "ERROR": "error",
                        "PENDING": "pending",
                        "ACTIVE": "active",
                        "LOST": "lost",
                        "CREATED": "created",
                        "CANCELLED": "cancelled",
                    },
                    ("expand",): {"ARTIFACTS": "artifacts"},
                },
                "openapi_types": {
                    "project_id": (str,),
                    "model_id": (str,),
                    "status": (str,),
                    "skip": (int,),
                    "limit": (int,),
                    "expand": ([str],),
                },
                "attribute_map": {
                    "project_id": "project_id",
                    "model_id": "model_id",
                    "status": "status",
                    "skip": "skip",
                    "limit": "limit",
                    "expand": "expand",
                },
                "location_map": {
                    "project_id": "path",
                    "model_id": "path",
                    "status": "query",
                    "skip": "query",
                    "limit": "query",
                    "expand": "query",
                },
                "collection_format_map": {
                    "expand": "csv",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__query_record_handlers,
        )

        def __search_projects(self, **kwargs):
            """search_projects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_projects(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                query (str): Project search filters. [optional]
                limit (int): Max number of projects to return. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            return self.call_with_http_info(**kwargs)

        self.search_projects = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects",
                "operation_id": "search_projects",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "query",
                    "limit",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "query": (str,),
                    "limit": (int,),
                },
                "attribute_map": {
                    "query": "query",
                    "limit": "limit",
                },
                "location_map": {
                    "query": "query",
                    "limit": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__search_projects,
        )

        def __update_model(self, project_id, model_id, body, **kwargs):
            """update_model  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_model(project_id, model_id, body, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id
                model_id (str): Model id
                body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            kwargs["model_id"] = model_id
            kwargs["body"] = body
            return self.call_with_http_info(**kwargs)

        self.update_model = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/models/{model_id}",
                "operation_id": "update_model",
                "http_method": "PATCH",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "model_id",
                    "body",
                ],
                "required": [
                    "project_id",
                    "model_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "project_id": (str,),
                    "model_id": (str,),
                    "body": (
                        {
                            str: (
                                bool,
                                date,
                                datetime,
                                dict,
                                float,
                                int,
                                list,
                                str,
                                none_type,
                            )
                        },
                    ),
                },
                "attribute_map": {
                    "project_id": "project_id",
                    "model_id": "model_id",
                },
                "location_map": {
                    "project_id": "path",
                    "model_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
            callable=__update_model,
        )

        def __update_record_handler(
            self, project_id, model_id, record_handler_id, body, **kwargs
        ):
            """update_record_handler  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_record_handler(project_id, model_id, record_handler_id, body, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str): Project id
                model_id (str): Model id
                record_handler_id (str): Record handler id
                body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["project_id"] = project_id
            kwargs["model_id"] = model_id
            kwargs["record_handler_id"] = record_handler_id
            kwargs["body"] = body
            return self.call_with_http_info(**kwargs)

        self.update_record_handler = _Endpoint(
            settings={
                "response_type": (
                    {
                        str: (
                            bool,
                            date,
                            datetime,
                            dict,
                            float,
                            int,
                            list,
                            str,
                            none_type,
                        )
                    },
                ),
                "auth": ["ApiKey"],
                "endpoint_path": "/projects/{project_id}/models/{model_id}/record_handlers/{record_handler_id}",
                "operation_id": "update_record_handler",
                "http_method": "PATCH",
                "servers": None,
            },
            params_map={
                "all": [
                    "project_id",
                    "model_id",
                    "record_handler_id",
                    "body",
                ],
                "required": [
                    "project_id",
                    "model_id",
                    "record_handler_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "project_id": (str,),
                    "model_id": (str,),
                    "record_handler_id": (str,),
                    "body": (
                        {
                            str: (
                                bool,
                                date,
                                datetime,
                                dict,
                                float,
                                int,
                                list,
                                str,
                                none_type,
                            )
                        },
                    ),
                },
                "attribute_map": {
                    "project_id": "project_id",
                    "model_id": "model_id",
                    "record_handler_id": "record_handler_id",
                },
                "location_map": {
                    "project_id": "path",
                    "model_id": "path",
                    "record_handler_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
            callable=__update_record_handler,
        )
