# coding: utf-8

"""
    

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from datetime import datetime
from typing import Optional

from pydantic import BaseModel, StrictStr, validator

from gretel_client.rest_v1.models.cluster_cloud_provider_info import (
    ClusterCloudProviderInfo,
)
from gretel_client.rest_v1.models.cluster_status import ClusterStatus
from gretel_client.rest_v1.models.user_profile import UserProfile


class Cluster(BaseModel):
    """
    Cluster
    """

    guid: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    owner_guid: Optional[StrictStr] = None
    owner_profile: Optional[UserProfile] = None
    cloud_provider: Optional[ClusterCloudProviderInfo] = None
    cloud_provider_type: Optional[StrictStr] = None
    status: Optional[ClusterStatus] = None
    created_at: Optional[datetime] = None
    last_checkin_time: Optional[datetime] = None
    __properties = [
        "guid",
        "name",
        "owner_guid",
        "owner_profile",
        "cloud_provider",
        "cloud_provider_type",
        "status",
        "created_at",
        "last_checkin_time",
    ]

    @validator("cloud_provider_type")
    def cloud_provider_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("UNKNOWN", "AWS", "GCP", "AZURE"):
            raise ValueError(
                "must be one of enum values ('UNKNOWN', 'AWS', 'GCP', 'AZURE')"
            )
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Cluster:
        """Create an instance of Cluster from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of owner_profile
        if self.owner_profile:
            _dict["owner_profile"] = self.owner_profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cloud_provider
        if self.cloud_provider:
            _dict["cloud_provider"] = self.cloud_provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict["status"] = self.status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Cluster:
        """Create an instance of Cluster from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Cluster.parse_obj(obj)

        _obj = Cluster.parse_obj(
            {
                "guid": obj.get("guid"),
                "name": obj.get("name"),
                "owner_guid": obj.get("owner_guid"),
                "owner_profile": UserProfile.from_dict(obj.get("owner_profile"))
                if obj.get("owner_profile") is not None
                else None,
                "cloud_provider": ClusterCloudProviderInfo.from_dict(
                    obj.get("cloud_provider")
                )
                if obj.get("cloud_provider") is not None
                else None,
                "cloud_provider_type": obj.get("cloud_provider_type"),
                "status": ClusterStatus.from_dict(obj.get("status"))
                if obj.get("status") is not None
                else None,
                "created_at": obj.get("created_at"),
                "last_checkin_time": obj.get("last_checkin_time"),
            }
        )
        return _obj
