# coding: utf-8

"""
    

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from datetime import datetime
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictBool, StrictStr, validator


class Connection(BaseModel):
    """
    Next available tag: 13
    """

    id: StrictStr = Field(
        ...,
        description="The id of the connection. Connection id's are prefixed with `c_`.",
    )
    type: StrictStr = Field(
        ..., description="Type of the connection: aws, gcs, azure etc."
    )
    name: StrictStr = Field(..., description="Name of the connection.")
    validation_status: StrictStr = Field(
        ..., description="Validation status: COMPLETED, ERROR, NONE."
    )
    credentials: Optional[Dict[str, Any]] = Field(
        None,
        description="Connection credentials in plain text. This can only be set when creating a connection for letting the control plane encrypt credentials. It is never set in API responses.",
    )
    config: Optional[Dict[str, Any]] = Field(
        None, description="Connection config. These values are returned by the API."
    )
    encrypted_credentials: Optional[Dict[str, Any]] = Field(
        None, description="Connection credentials in encrypted form."
    )
    customer_managed_credentials_encryption: Optional[StrictBool] = Field(
        None,
        description="Indicates whether the encrypted credentials are encrypted using a customer-managed key, as opposed to a Gretel-managed one. TODO: This should be [(google.api.field_behavior) = REQUIRED] but we can only set this once the change has been rolled out to Pilot.",
    )
    created_at: datetime = Field(...)
    project_id: StrictStr = Field(
        ..., description="ID of the Project that owns this connection"
    )
    created_by: StrictStr = Field(
        ..., description="ID of the User who created this connection"
    )
    connection_target_type: Optional[StrictStr] = Field(
        None,
        description="Explicitly declare this as `source`, `destination` or `unspecified`.  If unspecified or empty, no target enforcement.",
    )
    __properties = [
        "id",
        "type",
        "name",
        "validation_status",
        "credentials",
        "config",
        "encrypted_credentials",
        "customer_managed_credentials_encryption",
        "created_at",
        "project_id",
        "created_by",
        "connection_target_type",
    ]

    @validator("validation_status")
    def validation_status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in (
            "VALIDATION_STATUS_UNKNOWN",
            "VALIDATION_STATUS_VALIDATING",
            "VALIDATION_STATUS_VALID",
            "VALIDATION_STATUS_INVALID",
        ):
            raise ValueError(
                "must be one of enum values ('VALIDATION_STATUS_UNKNOWN', 'VALIDATION_STATUS_VALIDATING', 'VALIDATION_STATUS_VALID', 'VALIDATION_STATUS_INVALID')"
            )
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Connection:
        """Create an instance of Connection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Connection:
        """Create an instance of Connection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Connection.parse_obj(obj)

        _obj = Connection.parse_obj(
            {
                "id": obj.get("id"),
                "type": obj.get("type"),
                "name": obj.get("name"),
                "validation_status": obj.get("validation_status"),
                "credentials": obj.get("credentials"),
                "config": obj.get("config"),
                "encrypted_credentials": obj.get("encrypted_credentials"),
                "customer_managed_credentials_encryption": obj.get(
                    "customer_managed_credentials_encryption"
                ),
                "created_at": obj.get("created_at"),
                "project_id": obj.get("project_id"),
                "created_by": obj.get("created_by"),
                "connection_target_type": obj.get("connection_target_type"),
            }
        )
        return _obj
