# coding: utf-8

"""
    

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from datetime import datetime
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictStr, validator

from gretel_client.rest_v1.models.project import Project
from gretel_client.rest_v1.models.user_profile import UserProfile
from gretel_client.rest_v1.models.workflow_run import WorkflowRun


class Workflow(BaseModel):
    """
    Workflow
    """

    id: StrictStr = Field(...)
    name: StrictStr = Field(...)
    project_id: StrictStr = Field(...)
    project: Optional[Project] = None
    config: Optional[Dict[str, Any]] = None
    config_text: Optional[StrictStr] = None
    runner_mode: Optional[StrictStr] = None
    next_scheduled_run: Optional[datetime] = None
    created_by: StrictStr = Field(...)
    created_by_profile: Optional[UserProfile] = None
    updated_by: Optional[StrictStr] = None
    updated_by_profile: Optional[UserProfile] = None
    created_at: datetime = Field(...)
    updated_at: Optional[datetime] = None
    latest_run: Optional[WorkflowRun] = None
    __properties = [
        "id",
        "name",
        "project_id",
        "project",
        "config",
        "config_text",
        "runner_mode",
        "next_scheduled_run",
        "created_by",
        "created_by_profile",
        "updated_by",
        "updated_by_profile",
        "created_at",
        "updated_at",
        "latest_run",
    ]

    @validator("runner_mode")
    def runner_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in (
            "RUNNER_MODE_UNSET",
            "RUNNER_MODE_CLOUD",
            "RUNNER_MODE_HYBRID",
            "RUNNER_MODE_INVALID",
        ):
            raise ValueError(
                "must be one of enum values ('RUNNER_MODE_UNSET', 'RUNNER_MODE_CLOUD', 'RUNNER_MODE_HYBRID', 'RUNNER_MODE_INVALID')"
            )
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Workflow:
        """Create an instance of Workflow from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict["project"] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by_profile
        if self.created_by_profile:
            _dict["created_by_profile"] = self.created_by_profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of updated_by_profile
        if self.updated_by_profile:
            _dict["updated_by_profile"] = self.updated_by_profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of latest_run
        if self.latest_run:
            _dict["latest_run"] = self.latest_run.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Workflow:
        """Create an instance of Workflow from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Workflow.parse_obj(obj)

        _obj = Workflow.parse_obj(
            {
                "id": obj.get("id"),
                "name": obj.get("name"),
                "project_id": obj.get("project_id"),
                "project": Project.from_dict(obj.get("project"))
                if obj.get("project") is not None
                else None,
                "config": obj.get("config"),
                "config_text": obj.get("config_text"),
                "runner_mode": obj.get("runner_mode"),
                "next_scheduled_run": obj.get("next_scheduled_run"),
                "created_by": obj.get("created_by"),
                "created_by_profile": UserProfile.from_dict(
                    obj.get("created_by_profile")
                )
                if obj.get("created_by_profile") is not None
                else None,
                "updated_by": obj.get("updated_by"),
                "updated_by_profile": UserProfile.from_dict(
                    obj.get("updated_by_profile")
                )
                if obj.get("updated_by_profile") is not None
                else None,
                "created_at": obj.get("created_at"),
                "updated_at": obj.get("updated_at"),
                "latest_run": WorkflowRun.from_dict(obj.get("latest_run"))
                if obj.get("latest_run") is not None
                else None,
            }
        )
        return _obj
