# coding: utf-8

"""
    

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from datetime import datetime
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, validator

from gretel_client.rest_v1.models.project import Project
from gretel_client.rest_v1.models.user_profile import UserProfile
from gretel_client.rest_v1.models.workflow_run_cancellation_request import (
    WorkflowRunCancellationRequest,
)


class WorkflowRun(BaseModel):
    """
    WorkflowRun
    """

    id: StrictStr = Field(...)
    workflow_id: StrictStr = Field(...)
    project_id: StrictStr = Field(...)
    project: Optional[Project] = None
    cluster_guid: Optional[StrictStr] = None
    config: Optional[Dict[str, Any]] = None
    config_text: Optional[StrictStr] = None
    runner_mode: StrictStr = Field(...)
    status: StrictStr = Field(...)
    created_by: StrictStr = Field(...)
    created_at: datetime = Field(...)
    updated_at: Optional[datetime] = None
    pending_at: Optional[datetime] = None
    active_at: Optional[datetime] = None
    error_at: Optional[datetime] = None
    lost_at: Optional[datetime] = None
    cancelled_at: Optional[datetime] = None
    cancellation_request: Optional[WorkflowRunCancellationRequest] = None
    created_by_profile: Optional[UserProfile] = None
    total_compute_time_sconds: Optional[StrictInt] = None
    __properties = [
        "id",
        "workflow_id",
        "project_id",
        "project",
        "cluster_guid",
        "config",
        "config_text",
        "runner_mode",
        "status",
        "created_by",
        "created_at",
        "updated_at",
        "pending_at",
        "active_at",
        "error_at",
        "lost_at",
        "cancelled_at",
        "cancellation_request",
        "created_by_profile",
        "total_compute_time_sconds",
    ]

    @validator("runner_mode")
    def runner_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value not in (
            "RUNNER_MODE_UNSET",
            "RUNNER_MODE_CLOUD",
            "RUNNER_MODE_HYBRID",
            "RUNNER_MODE_INVALID",
        ):
            raise ValueError(
                "must be one of enum values ('RUNNER_MODE_UNSET', 'RUNNER_MODE_CLOUD', 'RUNNER_MODE_HYBRID', 'RUNNER_MODE_INVALID')"
            )
        return value

    @validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in (
            "RUN_STATUS_UNKNOWN",
            "RUN_STATUS_CREATED",
            "RUN_STATUS_PENDING",
            "RUN_STATUS_ACTIVE",
            "RUN_STATUS_ERROR",
            "RUN_STATUS_LOST",
            "RUN_STATUS_COMPLETED",
            "RUN_STATUS_CANCELLING",
            "RUN_STATUS_CANCELLED",
        ):
            raise ValueError(
                "must be one of enum values ('RUN_STATUS_UNKNOWN', 'RUN_STATUS_CREATED', 'RUN_STATUS_PENDING', 'RUN_STATUS_ACTIVE', 'RUN_STATUS_ERROR', 'RUN_STATUS_LOST', 'RUN_STATUS_COMPLETED', 'RUN_STATUS_CANCELLING', 'RUN_STATUS_CANCELLED')"
            )
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WorkflowRun:
        """Create an instance of WorkflowRun from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict["project"] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cancellation_request
        if self.cancellation_request:
            _dict["cancellation_request"] = self.cancellation_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by_profile
        if self.created_by_profile:
            _dict["created_by_profile"] = self.created_by_profile.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WorkflowRun:
        """Create an instance of WorkflowRun from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WorkflowRun.parse_obj(obj)

        _obj = WorkflowRun.parse_obj(
            {
                "id": obj.get("id"),
                "workflow_id": obj.get("workflow_id"),
                "project_id": obj.get("project_id"),
                "project": Project.from_dict(obj.get("project"))
                if obj.get("project") is not None
                else None,
                "cluster_guid": obj.get("cluster_guid"),
                "config": obj.get("config"),
                "config_text": obj.get("config_text"),
                "runner_mode": obj.get("runner_mode"),
                "status": obj.get("status"),
                "created_by": obj.get("created_by"),
                "created_at": obj.get("created_at"),
                "updated_at": obj.get("updated_at"),
                "pending_at": obj.get("pending_at"),
                "active_at": obj.get("active_at"),
                "error_at": obj.get("error_at"),
                "lost_at": obj.get("lost_at"),
                "cancelled_at": obj.get("cancelled_at"),
                "cancellation_request": WorkflowRunCancellationRequest.from_dict(
                    obj.get("cancellation_request")
                )
                if obj.get("cancellation_request") is not None
                else None,
                "created_by_profile": UserProfile.from_dict(
                    obj.get("created_by_profile")
                )
                if obj.get("created_by_profile") is not None
                else None,
                "total_compute_time_sconds": obj.get("total_compute_time_sconds"),
            }
        )
        return _obj
