__all__ = [
    "EXTRACTORS",
]
base_import: str = "wisent.core.contrastive_pairs.lm_eval_pairs.lm_task_extractors."
EXTRACTORS: dict[str, str] = {
    # key → "module_path:ClassName" (supports dotted attr path after ':')
    "arc_challenge": f"{base_import}arc_challenge:ArcChallengeExtractor",
    "arc_easy": f"{base_import}arc_easy:ArcEasyExtractor",
    "arithmetic": f"{base_import}arithmetic:ArithmeticExtractor",
    "asdiv": f"{base_import}asdiv:ASDivExtractor",
    "boolq": f"{base_import}boolq:BoolQExtractor",
    "boolq-seq2seq": f"{base_import}boolq_seq2seq:BoolqSeq2seqExtractor",
    "cb": f"{base_import}cb:CBExtractor",
    "copa": f"{base_import}copa:COPAExtractor",
    "coqa": f"{base_import}coqa:CoQAExtractor",
    "drop": f"{base_import}drop:DropExtractor",
    "gsm8k": f"{base_import}gsm8k:GSM8KExtractor",
    "headqa": f"{base_import}headqa:HeadQAExtractor",
    "hellaswag": f"{base_import}hellaswag:HellaSwagExtractor",
    "logiqa": f"{base_import}logiqa:LogiQAExtractor",
    "logiqa2": f"{base_import}logiqa2:LogiQA2Extractor",
    "mc_taco": f"{base_import}mc-taco:MCTACOExtractor",
    "medqa": f"{base_import}medqa:MedQAExtractor",
    "mmlu": f"{base_import}mmlu:MMLUExtractor",
    "mmmlu": f"{base_import}mmlu:MMLUExtractor",
    "mrpc": f"{base_import}mrpc:MRPCExtractor",
    "multirc": f"{base_import}multirc:MultiRCExtractor",
    "mutual": f"{base_import}mutual:MutualExtractor",
    "openbookqa": f"{base_import}openbookqa:OpenBookQAExtractor",
    "pawsx": f"{base_import}pawsx:PawsXExtractor",
    "piqa": f"{base_import}piqa:PIQAExtractor",
    "prost": f"{base_import}prost:ProstExtractor",
    "pubmedqa": f"{base_import}pubmedqa:PubMedQAExtractor",
    "qa4mre": f"{base_import}qa4mre:QA4MREExtractor",
    "qasper": f"{base_import}qasper:QasperExtractor",
    "qnli": f"{base_import}qnli:QNLIExtractor",
    "qqp": f"{base_import}qqp:QQPExtractor",
    "race": f"{base_import}race:RACEExtractor",
    "record": f"{base_import}record:RecordExtractor",
    "rte": f"{base_import}rte:RTEExtractor",
    "sciq": f"{base_import}sciq:SciQExtractor",
    "social_iqa": f"{base_import}social_iqa:SocialIQAExtractor",
    "squadv2": f"{base_import}squad2:SQuAD2Extractor",
    "squad2": f"{base_import}squad2:SQuAD2Extractor",
    "sst2": f"{base_import}sst2:SST2Extractor",
    "swag": f"{base_import}swag:SwagExtractor",
    "triviaqa": f"{base_import}triviaqa:TriviaQAExtractor",
    "truthfulqa_gen": f"{base_import}truthfulqa_gen:TruthfulQAGenExtractor",
    "truthfulqa_mc1": f"{base_import}truthfulqa_mc1:TruthfulQAMC1Extractor",
    "truthfulqa_mc2": f"{base_import}truthfulqa_mc2:TruthfulQAMC2Extractor",
    "webqs": f"{base_import}webqs:WebQSExtractor",
    "nq_open": f"{base_import}nq_open:NQOpenExtractor",
    "wic": f"{base_import}wic:WiCExtractor",
    "winogrande": f"{base_import}winogrande:WinograndeExtractor",
    "wnli": f"{base_import}wnli:WNLIExtractor",
    "wsc": f"{base_import}wsc:WSCExtractor",
    "xnli": f"{base_import}xnli:XNLIExtractor",
    "xstorycloze": f"{base_import}xstorycloze:XStoryClozeExtractor",
    "xwinograd": f"{base_import}xwinograd:XWinogradExtractor",
    "livecodebench": f"{base_import}livecodebench:LivecodebenchExtractor",
    # Perplexity/Language Modeling tasks
    "wikitext": f"{base_import}wikitext:WikitextExtractor",
    "wikitext103": f"{base_import}wikitext:WikitextExtractor",
    "ptb": f"{base_import}wikitext:WikitextExtractor",
    "penn_treebank": f"{base_import}wikitext:WikitextExtractor",
    # Word prediction tasks
    "lambada_openai": f"{base_import}lambada:LambadaExtractor",
    "lambada_standard": f"{base_import}lambada:LambadaExtractor",
    # NEW: BC branch extractors
    "ai2_arc": f"{base_import}ai2_arc:AI2ARCExtractor",
    "anli": f"{base_import}anli:ANLIExtractor",
    "anli_r1": f"{base_import}anli:ANLIExtractor",
    "anli_r2": f"{base_import}anli:ANLIExtractor",
    "anli_r3": f"{base_import}anli:ANLIExtractor",
    "bigbench": f"{base_import}bigbench:BigBenchExtractor",
    "bbh": f"{base_import}bbh:BBHExtractor",
    "gpqa": f"{base_import}gpqa:GPQAExtractor",
    "hle": f"{base_import}hle:HLEExtractor",
    "mathqa": f"{base_import}mathqa:MathQAExtractor",
    # Hendrycks Math and all subtasks
    "hendrycks_math": f"{base_import}hendrycks_math:HendrycksMathExtractor",
    "hendrycks_math_algebra": f"{base_import}hendrycks_math:HendrycksMathExtractor",
    "hendrycks_math_counting_and_prob": f"{base_import}hendrycks_math:HendrycksMathExtractor",
    "hendrycks_math_geometry": f"{base_import}hendrycks_math:HendrycksMathExtractor",
    "hendrycks_math_intermediate_algebra": f"{base_import}hendrycks_math:HendrycksMathExtractor",
    "hendrycks_math_num_theory": f"{base_import}hendrycks_math:HendrycksMathExtractor",
    "hendrycks_math_prealgebra": f"{base_import}hendrycks_math:HendrycksMathExtractor",
    "hendrycks_math_precalc": f"{base_import}hendrycks_math:HendrycksMathExtractor",
    "quac": f"{base_import}quac:QuACExtractor",
    "superglue": f"{base_import}superglue:SuperGLUEExtractor",
    "supergpqa": f"{base_import}supergpqa:SuperGPQAExtractor",
    "multilingual": f"{base_import}multilingual:MultilingualExtractor",
    "glue": f"{base_import}glue:GLUEExtractor",
    # Task 1/142: AraDiCE - group task with 28 subtasks
    # AraDiCE subtasks are named like AraDiCE_boolq_egy, AraDiCE_winogrande_lev, etc.
    # The AradiceExtractor routes to appropriate base extractors
    "aradice": f"{base_import}aradice:AradiceExtractor",
    # Task 2/142: ArabCulture
    "arabculture": f"{base_import}arabculture:ArabcultureExtractor",
    # Task 3/142: aclue
    "aclue": f"{base_import}aclue:AclueExtractor",
    # Remaining tasks - auto-registered
    "acp_bench": f"{base_import}acp_bench:AcpBenchExtractor",
    "acp_bench_hard": f"{base_import}acp_bench_hard:AcpBenchHardExtractor",
    "aexams": f"{base_import}aexams:AexamsExtractor",
    "agieval": f"{base_import}agieval:AgievalExtractor",
    "aime": f"{base_import}aime:AimeExtractor",
    "arabic_leaderboard_complete": f"{base_import}arabic_leaderboard_complete:ArabicLeaderboardCompleteExtractor",
    "arabic_leaderboard_light": f"{base_import}arabic_leaderboard_light:ArabicLeaderboardLightExtractor",
    "arabicmmlu": f"{base_import}arabicmmlu:ArabicmmluExtractor",
    "babi": f"{base_import}babi:BabiExtractor",
    "babilong": f"{base_import}babilong:BabilongExtractor",
    "bangla_mmlu": f"{base_import}bangla_mmlu:BanglaMmluExtractor",
    "basque_bench": f"{base_import}basque_bench:BasqueBenchExtractor",
    "basqueglue": f"{base_import}basqueglue:BasqueglueExtractor",
    "bbq": f"{base_import}bbq:BbqExtractor",
    "belebele": f"{base_import}belebele:BelebeleExtractor",
    "benchmarks": f"{base_import}benchmarks:BenchmarksExtractor",
    "bertaqa": f"{base_import}bertaqa:BertaqaExtractor",
    "bhs": f"{base_import}bhs:BhsExtractor",
    "blimp": f"{base_import}blimp:BlimpExtractor",
    "blimp_nl": f"{base_import}blimp_nl:BlimpNlExtractor",
    "c4": f"{base_import}c4:C4Extractor",
    "cabbq": f"{base_import}cabbq:CabbqExtractor",
    "careqa": f"{base_import}careqa:CareqaExtractor",
    "catalan_bench": f"{base_import}catalan_bench:CatalanBenchExtractor",
    "ceval": f"{base_import}ceval:CevalExtractor",
    "chartqa": f"{base_import}chartqa:ChartqaExtractor",
    "click": f"{base_import}click:ClickExtractor",
    "cmmlu": f"{base_import}cmmlu:CmmluExtractor",
    "code_x_glue": f"{base_import}code_x_glue:CodeXGlueExtractor",
    "commonsense_qa": f"{base_import}commonsense_qa:CommonsenseQAExtractor",
    "copal_id": f"{base_import}copal_id:CopalIdExtractor",
    "crows_pairs": f"{base_import}crows_pairs:CrowsPairsExtractor",
    "csatqa": f"{base_import}csatqa:CsatqaExtractor",
    "darija_bench": f"{base_import}darija_bench:DarijaBenchExtractor",
    "darijahellaswag": f"{base_import}darijahellaswag:DarijahellaswagExtractor",
    "darijammlu": f"{base_import}darijammlu:DarijammluExtractor",
    "discrim_eval": f"{base_import}discrim_eval:DiscrimEvalExtractor",
    "egyhellaswag": f"{base_import}egyhellaswag:EgyhellaswagExtractor",
    "egymmlu": f"{base_import}egymmlu:EgymmluExtractor",
    "eq_bench": f"{base_import}eq_bench:EqBenchExtractor",
    "eq_bench_ca": f"{base_import}eq_bench_ca:EqBenchCaExtractor",
    "eq_bench_es": f"{base_import}eq_bench_es:EqBenchEsExtractor",
    "esbbq": f"{base_import}esbbq:EsbbqExtractor",
    "eus_exams": f"{base_import}eus_exams:EusExamsExtractor",
    "eus_proficiency": f"{base_import}eus_proficiency:EusProficiencyExtractor",
    "eus_reading": f"{base_import}eus_reading:EusReadingExtractor",
    "eus_trivia": f"{base_import}eus_trivia:EusTriviaExtractor",
    "evalita_llm": f"{base_import}evalita_llm:EvalitaLlmExtractor",
    "fda": f"{base_import}fda:FdaExtractor",
    "fld": f"{base_import}fld:FldExtractor",
    "french_bench": f"{base_import}french_bench:FrenchBenchExtractor",
    "galician_bench": f"{base_import}galician_bench:GalicianBenchExtractor",
    "global_mmlu": f"{base_import}global_mmlu:GlobalMmluExtractor",
    "global_piqa": f"{base_import}global_piqa:GlobalPiqaExtractor",
    "groundcocoa": f"{base_import}groundcocoa:GroundcocoaExtractor",
    "haerae": f"{base_import}haerae:HaeraeExtractor",
    "hendrycks_ethics": f"{base_import}hendrycks_ethics:HendrycksEthicsExtractor",
    "histoires_morales": f"{base_import}histoires_morales:HistoiresMoralesExtractor",
    "hrm8k": f"{base_import}hrm8k:Hrm8kExtractor",
    "humaneval": f"{base_import}humaneval:HumanEvalExtractor",
    "humaneval_infilling": f"{base_import}humaneval_infilling:HumanevalInfillingExtractor",
    "icelandic_winogrande": f"{base_import}icelandic_winogrande:IcelandicWinograndeExtractor",
    "ifeval": f"{base_import}ifeval:IFEvalExtractor",
    "inverse_scaling": f"{base_import}inverse_scaling:InverseScalingExtractor",
    "japanese_leaderboard": f"{base_import}japanese_leaderboard:JapaneseLeaderboardExtractor",
    "jsonschema_bench": f"{base_import}jsonschema_bench:JsonschemaBenchExtractor",
    "kbl": f"{base_import}kbl:KblExtractor",
    "kmmlu": f"{base_import}kmmlu:KmmluExtractor",
    "kobest": f"{base_import}kobest:KobestExtractor",
    "kormedmcqa": f"{base_import}kormedmcqa:KormedmcqaExtractor",
    "lambada": f"{base_import}lambada:LambadaExtractor",
    "lambada_cloze": f"{base_import}lambada_cloze:LambadaClozeExtractor",
    "lambada_multilingual": f"{base_import}lambada_multilingual:LambadaMultilingualExtractor",
    "lambada_multilingual_stablelm": f"{base_import}lambada_multilingual_stablelm:LambadaMultilingualStablelmExtractor",
    "leaderboard": f"{base_import}leaderboard:LeaderboardExtractor",
    "libra": f"{base_import}libra:LibraExtractor",
    "lingoly": f"{base_import}lingoly:LingolyExtractor",
    "llama3": f"{base_import}llama3:Llama3Extractor",
    "lm_syneval": f"{base_import}lm_syneval:LmSynevalExtractor",
    "longbench": f"{base_import}longbench:LongbenchExtractor",
    "longbenchv2": f"{base_import}longbenchv2:Longbenchv2Extractor",
    "mastermind": f"{base_import}mastermind:MastermindExtractor",
    "mbpp": f"{base_import}mbpp:MBPPExtractor",
    "mc-taco": f"{base_import}mc-taco:MCTACOExtractor",
    "med_concepts_qa": f"{base_import}med_concepts_qa:MedConceptsQaExtractor",
    "meddialog": f"{base_import}meddialog:MeddialogExtractor",
    "mediqa_qa2019": f"{base_import}mediqa_qa2019:MediqaQa2019Extractor",
    "medmcqa": f"{base_import}medmcqa:MedmcqaExtractor",
    "medtext": f"{base_import}medtext:MedtextExtractor",
    "meqsum": f"{base_import}meqsum:MeqsumExtractor",
    "metabench": f"{base_import}metabench:MetabenchExtractor",
    "mgsm": f"{base_import}mgsm:MgsmExtractor",
    "mimic_repsum": f"{base_import}mimic_repsum:MimicRepsumExtractor",
    "minerva_math": f"{base_import}minerva_math:MinervaMathExtractor",
    "mlqa": f"{base_import}mlqa:MlqaExtractor",
    "mmlusr": f"{base_import}mmlusr:MmlusrExtractor",
    "mmmu": f"{base_import}mmmu:MmmuExtractor",
    "model_written_evals": f"{base_import}model_written_evals:ModelWrittenEvalsExtractor",
    "moral_stories": f"{base_import}moral_stories:MoralStoriesExtractor",
    "mts_dialog": f"{base_import}mts_dialog:MtsDialogExtractor",
    "multiblimp": f"{base_import}multiblimp:MultiblimpExtractor",
    "noreval": f"{base_import}noreval:NorevalExtractor",
    "okapi_arc_multilingual": f"{base_import}okapi_arc_multilingual:OkapiArcMultilingualExtractor",
    "okapi_hellaswag_multilingual": f"{base_import}okapi_hellaswag_multilingual:OkapiHellaswagMultilingualExtractor",
    "okapi_mmlu_multilingual": f"{base_import}okapi_mmlu_multilingual:OkapiMmluMultilingualExtractor",
    "okapi_truthfulqa_multilingual": f"{base_import}okapi_truthfulqa_multilingual:OkapiTruthfulqaMultilingualExtractor",
    "olaph": f"{base_import}olaph:OlaphExtractor",
    "paloma": f"{base_import}paloma:PalomaExtractor",
    "paws_x": f"{base_import}paws_x:PawsXExtractor",
    "pile": f"{base_import}pile:PileExtractor",
    "pile_10k": f"{base_import}pile_10k:Pile10kExtractor",
    "polemo2": f"{base_import}polemo2:Polemo2Extractor",
    "portuguese_bench": f"{base_import}portuguese_bench:PortugueseBenchExtractor",
    "realtoxicityprompts": f"{base_import}realtoxicityprompts:RealtoxicitypromptsExtractor",
    "ruler": f"{base_import}ruler:RulerExtractor",
    "score": f"{base_import}score:ScoreExtractor",
    "scrolls": f"{base_import}scrolls:ScrollsExtractor",
    "simple_cooccurrence_bias": f"{base_import}simple_cooccurrence_bias:SimpleCooccurrenceBiasExtractor",
    "siqa": f"{base_import}siqa:SIQAExtractor",
    "spanish_bench": f"{base_import}spanish_bench:SpanishBenchExtractor",
    "squad_completion": f"{base_import}squad_completion:SquadCompletionExtractor",
    "storycloze": f"{base_import}storycloze:StoryclozeExtractor",
    "super_glue": f"{base_import}super_glue:SuperGlueExtractor",
    "swde": f"{base_import}swde:SwdeExtractor",
    "tinybenchmarks": f"{base_import}tinybenchmarks:TinybenchmarksExtractor",
    "tmmluplus": f"{base_import}tmmluplus:TmmluplusExtractor",
    "toxigen": f"{base_import}toxigen:ToxigenExtractor",
    "translation": f"{base_import}translation:TranslationExtractor",
    "truthfulqa_multi": f"{base_import}truthfulqa_multi:TruthfulqaMultiExtractor",
    "turblimp_core": f"{base_import}turblimp_core:TurblimpCoreExtractor",
    "turkishmmlu": f"{base_import}turkishmmlu:TurkishmmluExtractor",
    "unitxt": f"{base_import}unitxt:UnitxtExtractor",
    "unscramble": f"{base_import}unscramble:UnscrambleExtractor",
    "winogender": f"{base_import}winogender:WinogenderExtractor",
    "wmdp": f"{base_import}wmdp:WmdpExtractor",
    "wmt2016": f"{base_import}wmt2016:Wmt2016Extractor",
    "wsc273": f"{base_import}wsc273:Wsc273Extractor",
    "xcopa": f"{base_import}xcopa:XcopaExtractor",
    "xquad": f"{base_import}xquad:XquadExtractor",
    "zhoblimp": f"{base_import}zhoblimp:ZhoblimpExtractor",
    # NEW: Auto-generated extractors for missing task families
    "arabic": f"{base_import}arabic:ArabicExtractor",
    "persona": f"{base_import}persona:PersonaExtractor",
    "afrixnli": f"{base_import}afrixnli:AfrixnliExtractor",
    "evalita_mp": f"{base_import}evalita_mp:EvalitaMpExtractor",
    "truthfulqa": f"{base_import}truthfulqa:TruthfulqaExtractor",
    "flores": f"{base_import}flores:FloresExtractor",
    "afrimgsm": f"{base_import}afrimgsm:AfrimgsmExtractor",
    "ceval_valid": f"{base_import}ceval_valid:CevalValidExtractor",
    "advanced": f"{base_import}advanced:AdvancedExtractor",
    "tmlu": f"{base_import}tmlu:TmluExtractor",
    "arc": f"{base_import}arc:ArcExtractor",
    "afrimmlu": f"{base_import}afrimmlu:AfrimmluExtractor",
    "m_mmlu": f"{base_import}m_mmlu:MMmluExtractor",
    "non": f"{base_import}non:NonExtractor",
    "prompt": f"{base_import}prompt:PromptExtractor",
    "inverse": f"{base_import}inverse:InverseExtractor",
    "mela": f"{base_import}mela:MelaExtractor",
    "paws": f"{base_import}paws:PawsExtractor",
    "ja": f"{base_import}ja:JaExtractor",
    "super": f"{base_import}super:SuperExtractor",
    "multiple": f"{base_import}multiple:MultipleExtractor",
    "multiple_choice": f"{base_import}multiple:MultipleExtractor",
    "option": f"{base_import}option:OptionExtractor",
    "codexglue": f"{base_import}codexglue:CodexglueExtractor",
    "phrases": f"{base_import}phrases:PhrasesExtractor",
    "code2text": f"{base_import}code2text:Code2textExtractor",
    "ethics": f"{base_import}ethics:EthicsExtractor",
    "cabreu": f"{base_import}cabreu:CabreuExtractor",
    "sycophancy": f"{base_import}sycophancy:SycophancyExtractor",
    "evalita_sp": f"{base_import}evalita_sp:EvalitaSpExtractor",
    "glianorex": f"{base_import}glianorex:GlianorexExtractor",
    "flan": f"{base_import}flan:FlanExtractor",
    "assin": f"{base_import}assin:AssinExtractor",
    "assin_entailment": f"{base_import}assin:AssinExtractor",
    "gsm": f"{base_import}gsm:GsmExtractor",
    "mnli": f"{base_import}mnli:MnliExtractor",
    "tinytruthfulqa": f"{base_import}tinytruthfulqa:TinytruthfulqaExtractor",
    "multimedqa": f"{base_import}multimedqa:MultimedqaExtractor",
    "openllm": f"{base_import}openllm:OpenllmExtractor",
    "pythia": f"{base_import}pythia:PythiaExtractor",
    "t0": f"{base_import}t0:T0Extractor",
    "tag": f"{base_import}tag:TagExtractor",
    "basque_glue": f"{base_import}basque_glue:BasqueGlueExtractor",
    "chain": f"{base_import}chain:ChainExtractor",
    "freebase": f"{base_import}freebase:FreebaseExtractor",
    "gpt3": f"{base_import}gpt3:Gpt3Extractor",
    "iwslt2017": f"{base_import}iwslt2017:Iwslt2017Extractor",
    "iwslt2017_ar_en": f"{base_import}iwslt2017_ar_en:Iwslt2017ArEnExtractor",
    "iwslt2017_en_ar": f"{base_import}iwslt2017_en_ar:Iwslt2017EnArExtractor",
    "llama": f"{base_import}llama:LlamaExtractor",
    "math": f"{base_import}math:MathExtractor",
    "self": f"{base_import}self:SelfExtractor",
    "super_glue_lm_eval_v1": f"{base_import}super_glue_lm_eval_v1:SuperGlueLmEvalV1Extractor",
    "super_glue_lm_eval_v1_seq2seq": f"{base_import}super_glue_lm_eval_v1_seq2seq:SuperGlueLmEvalV1Seq2seqExtractor",
    "super_glue_t5_prompt": f"{base_import}super_glue_t5_prompt:SuperGlueT5PromptExtractor",
    "wmt14": f"{base_import}wmt14:Wmt14Extractor",
    "wmt14_en_fr": f"{base_import}wmt14_en_fr:Wmt14EnFrExtractor",
    "wmt14_fr_en": f"{base_import}wmt14_fr_en:Wmt14FrEnExtractor",
    "wmt16": f"{base_import}wmt16:Wmt16Extractor",
    "wmt16_de_en": f"{base_import}wmt16_de_en:Wmt16DeEnExtractor",
    "wmt16_en_de": f"{base_import}wmt16_en_de:Wmt16EnDeExtractor",
    "wmt16_en_ro": f"{base_import}wmt16_en_ro:Wmt16EnRoExtractor",
    "wmt16_ro_en": f"{base_import}wmt16_ro_en:Wmt16RoEnExtractor",
    "wmt_ro_en_t5_prompt": f"{base_import}wmt_ro_en_t5_prompt:WmtRoEnT5PromptExtractor",
    "wmt-ro-en-t5-prompt": f"{base_import}wmt_ro_en_t5_prompt:WmtRoEnT5PromptExtractor",
    "twenty_newsgroups": f"{base_import}twenty_newsgroups:TwentyNewsgroupsExtractor",
    "20_newsgroups": f"{base_import}twenty_newsgroups:TwentyNewsgroupsExtractor",
    "ag": f"{base_import}ag:AgExtractor",
    "ag_news": f"{base_import}ag:AgExtractor",
    "anagrams1": f"{base_import}anagrams1:Anagrams1Extractor",
    "anagrams2": f"{base_import}anagrams2:Anagrams2Extractor",
    "argument": f"{base_import}argument:ArgumentExtractor",
    "argument_topic": f"{base_import}argument:ArgumentExtractor",
    "atis": f"{base_import}atis:AtisExtractor",
    "banking77": f"{base_import}banking77:Banking77Extractor",
    "bec2016eu": f"{base_import}bec2016eu:Bec2016euExtractor",
    "bhtc": f"{base_import}bhtc:BhtcExtractor",
    "boolq_seq2seq": f"{base_import}boolq_seq2seq:BoolqSeq2seqExtractor",
    "catalanqa": f"{base_import}catalanqa:CatalanqaExtractor",
    "catcola": f"{base_import}catcola:CatcolaExtractor",
    "claim": f"{base_import}claim:ClaimExtractor",
    "cnn": f"{base_import}cnn:CnnExtractor",
    "cocoteros": f"{base_import}cocoteros:CocoterosExtractor",
    "coedit": f"{base_import}coedit:CoeditExtractor",
    "cola": f"{base_import}cola:ColaExtractor",
    "commonsense": f"{base_import}commonsense:CommonsenseExtractor",
    "coqcat": f"{base_import}coqcat:CoqcatExtractor",
    "cycle": f"{base_import}cycle:CycleExtractor",
    "dbpedia": f"{base_import}dbpedia:DbpediaExtractor",
    "doc": f"{base_import}doc:DocExtractor",
    "epec": f"{base_import}epec:EpecExtractor",
    "eq": f"{base_import}eq:EqExtractor",
    "escola": f"{base_import}escola:EscolaExtractor",
    "ethos": f"{base_import}ethos:EthosExtractor",
    "fda": f"{base_import}fda:FdaExtractor",
    "financial": f"{base_import}financial:FinancialExtractor",
    "galcola": f"{base_import}galcola:GalcolaExtractor",
    "law": f"{base_import}law:LawExtractor",
    "ledgar": f"{base_import}ledgar:LedgarExtractor",
    "logieval": f"{base_import}logieval:LogievalExtractor",
    "medical": f"{base_import}medical:MedicalExtractor",
    "noticia": f"{base_import}noticia:NoticiaExtractor",
    "parafraseja": f"{base_import}parafraseja:ParafrasejaExtractor",
    "parafrases": f"{base_import}parafrases:ParafrasesExtractor",
    "qnlieu": f"{base_import}qnlieu:QnlieuExtractor",
    "random": f"{base_import}random:RandomExtractor",
    "reversed": f"{base_import}reversed:ReversedExtractor",
    "sglue": f"{base_import}sglue:SglueExtractor",
    "stsb": f"{base_import}stsb:StsbExtractor",
    "summarization": f"{base_import}summarization:SummarizationExtractor",
    "teca": f"{base_import}teca:TecaExtractor",
    "tinyarc": f"{base_import}tinyarc:TinyarcExtractor",
    "tinygsm8k": f"{base_import}tinygsm8k:Tinygsm8kExtractor",
    "tinyhellaswag": f"{base_import}tinyhellaswag:TinyhellaswagExtractor",
    "tinymmlu": f"{base_import}tinymmlu:TinymmluExtractor",
    "tinywinogrande": f"{base_import}tinywinogrande:TinywinograndeExtractor",
    "unfair": f"{base_import}unfair:UnfairExtractor",
    "vaxx": f"{base_import}vaxx:VaxxExtractor",
    "wiceu": f"{base_import}wiceu:WiceuExtractor",
    "xlsum": f"{base_import}xlsum:XlsumExtractor",
    "xsum": f"{base_import}xsum:XsumExtractor",
    "yahoo": f"{base_import}yahoo:YahooExtractor",
    "instructhumaneval": f"{base_import}instructhumaneval:InstructhumanevalExtractor",
    "apps": f"{base_import}apps:AppsExtractor",
    "ds1000": f"{base_import}ds1000:Ds1000Extractor",
    "humanevalpack": f"{base_import}humanevalpack:HumanevalpackExtractor",
    "recode": f"{base_import}recode:RecodeExtractor",
    "conala": f"{base_import}conala:ConalaExtractor",
    "concode": f"{base_import}concode:ConcodeExtractor",
    "mercury": f"{base_import}mercury:MercuryExtractor",
}
