/*
 * Copyright (c) 2018, Marcelo Samsoniuk
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

`timescale 1ns / 1ps
`include "../rtl/config.vh"

module darkram
(
    input           CLK,    // clock
    input           RES,    // reset
    input           HLT,    // halt
    
    input           IDREQ,
    input  [31:0]   IADDR,
    output [31:0]   IDATA,
    output          IDACK,

    input           XDREQ,
    input           XRD,
    input           XWR,
    input  [3:0]    XBE,
    input  [31:0]   XADDR,
    input  [31:0]   XATAI,
    output [31:0]   XATAO,
    output          XDACK,
    
    output [3:0]    DEBUG
);

    // ro/rw memories

    reg [31:0] MEM [0:2**`MLEN/4-1]; // ro memory

    // memory initialization

    integer i;
    initial
    begin
    `ifdef SIMULATION
        $display("dpram: unified BRAM w/ %0dx32-bit",2**`MLEN/4);
        `ifdef __WAITSTATE__
            $display("dpram: waitstates=%0d enabled (default=1)",`__WAITSTATE__);
        `endif
        `ifdef __RMW_CYCLE__
            $display("dpram: RMW cycle enabled.",);
        `endif
            
        for(i=0;i!=2**`MLEN/4;i=i+1)
        begin
            MEM[i] = 32'd0;
        end
    `endif

     // workaround for vivado: no path in simulation and .mem extension

    // workaround for readmemh
    MEM[0] = 32'h00000513;
    MEM[1] = 32'hf1402573;
    MEM[2] = 32'h00050463;
    MEM[3] = 32'h0000006f;
    MEM[4] = 32'h400005b7;
    MEM[5] = 32'h00058503;
    MEM[6] = 32'h04050663;
    MEM[7] = 32'h07500513;
    MEM[8] = 32'h0c8000ef;
    MEM[9] = 32'h00002697;
    MEM[10] = 32'hda86a683;
    MEM[11] = 32'h00500713;
    MEM[12] = 32'h007d07b7;
    MEM[13] = 32'h00078513;
    MEM[14] = 32'h0dc000ef;
    MEM[15] = 32'h00054863;
    MEM[16] = 32'h00a68023;
    MEM[17] = 32'h00168693;
    MEM[18] = 32'hfedff06f;
    MEM[19] = 32'h02e00513;
    MEM[20] = 32'h098000ef;
    MEM[21] = 32'hfff70713;
    MEM[22] = 32'hfce04ee3;
    MEM[23] = 32'h06200513;
    MEM[24] = 32'h088000ef;
    MEM[25] = 32'h00a00513;
    MEM[26] = 32'h080000ef;
    MEM[27] = 32'h00000697;
    MEM[28] = 32'h0d068693;
    MEM[29] = 32'h00000797;
    MEM[30] = 32'h12f78793;
    MEM[31] = 32'h0006c703;
    MEM[32] = 32'h00675513;
    MEM[33] = 32'h00f50533;
    MEM[34] = 32'h00054503;
    MEM[35] = 32'h03f77713;
    MEM[36] = 32'h00168693;
    MEM[37] = 32'h054000ef;
    MEM[38] = 32'hfff70713;
    MEM[39] = 32'hfee04ce3;
    MEM[40] = 32'h0006c703;
    MEM[41] = 32'hfc071ee3;
    MEM[42] = 32'h00000697;
    MEM[43] = 32'h0ff68693;
    MEM[44] = 32'h0006c503;
    MEM[45] = 32'h00050863;
    MEM[46] = 32'h030000ef;
    MEM[47] = 32'h00168693;
    MEM[48] = 32'hff1ff06f;
    MEM[49] = 32'h00002117;
    MEM[50] = 32'hd0c12103;
    MEM[51] = 32'h00002197;
    MEM[52] = 32'hcfc1a183;
    MEM[53] = 32'h00a54533;
    MEM[54] = 32'h00b5c5b3;
    MEM[55] = 32'h00c64633;
    MEM[56] = 32'h120000ef;
    MEM[57] = 32'hf1dff06f;
    MEM[58] = 32'h400005b7;
    MEM[59] = 32'h00458603;
    MEM[60] = 32'hfff64613;
    MEM[61] = 32'h00167613;
    MEM[62] = 32'hfe060ae3;
    MEM[63] = 32'h00a582a3;
    MEM[64] = 32'h00a00593;
    MEM[65] = 32'h00b51663;
    MEM[66] = 32'h00d00513;
    MEM[67] = 32'hfddff06f;
    MEM[68] = 32'h00008067;
    MEM[69] = 32'h400005b7;
    MEM[70] = 32'h00050e63;
    MEM[71] = 32'hfff50513;
    MEM[72] = 32'h00458603;
    MEM[73] = 32'h00267613;
    MEM[74] = 32'hfe0608e3;
    MEM[75] = 32'h0055c503;
    MEM[76] = 32'h00008067;
    MEM[77] = 32'hfff00513;
    MEM[78] = 32'h00008067;
    MEM[79] = 32'h12c1a00e;
    MEM[80] = 32'h074dc19c;
    MEM[81] = 32'h0650c19a;
    MEM[82] = 32'h0452c198;
    MEM[83] = 32'h0452c198;
    MEM[84] = 32'h0452c198;
    MEM[85] = 32'h0650c198;
    MEM[86] = 32'h4dc10296;
    MEM[87] = 32'hc1049607;
    MEM[88] = 32'h06961042;
    MEM[89] = 32'h980c42c1;
    MEM[90] = 32'h44c14206;
    MEM[91] = 32'h44069a06;
    MEM[92] = 32'h960646c1;
    MEM[93] = 32'h48c14606;
    MEM[94] = 32'h48069206;
    MEM[95] = 32'h8e064ac1;
    MEM[96] = 32'h4cc14a06;
    MEM[97] = 32'h4c068a06;
    MEM[98] = 32'h86064ec1;
    MEM[99] = 32'h50c14e06;
    MEM[100] = 32'h50068206;
    MEM[101] = 32'h520a52c1;
    MEM[102] = 32'h540654c1;
    MEM[103] = 32'h560256c1;
    MEM[104] = 32'h200007c2;
    MEM[105] = 32'h490a7672;
    MEM[106] = 32'h5254534e;
    MEM[107] = 32'h49544355;
    MEM[108] = 32'h53204e4f;
    MEM[109] = 32'h20535445;
    MEM[110] = 32'h544e4157;
    MEM[111] = 32'h204f5420;
    MEM[112] = 32'h46204542;
    MEM[113] = 32'h0a454552;
    MEM[114] = 32'h0001000a;
    MEM[115] = 32'h00000000;
    MEM[116] = 32'h00000000;
    MEM[117] = 32'h00000000;
    MEM[118] = 32'h00000000;
    MEM[119] = 32'h00000000;
    MEM[120] = 32'h00000000;
    MEM[121] = 32'h00000000;
    MEM[122] = 32'h00000000;
    MEM[123] = 32'h00000000;
    MEM[124] = 32'h00000000;
    MEM[125] = 32'h00000000;
    MEM[126] = 32'h00000000;
    MEM[127] = 32'h00000000;
    MEM[128] = 32'hf9010113;
    MEM[129] = 32'h00000597;
    MEM[130] = 32'h00001517;
    MEM[131] = 32'h02010613;
    MEM[132] = 32'hffc58593;
    MEM[133] = 32'h37450513;
    MEM[134] = 32'h06812423;
    MEM[135] = 32'h06112623;
    MEM[136] = 32'h06912223;
    MEM[137] = 32'h02012023;
    MEM[138] = 32'h449000ef;
    MEM[139] = 32'h00002797;
    MEM[140] = 32'hb687a783;
    MEM[141] = 32'h00002417;
    MEM[142] = 32'hcb840413;
    MEM[143] = 32'h06078c63;
    MEM[144] = 32'h00002797;
    MEM[145] = 32'hb407aa23;
    MEM[146] = 32'h800004b7;
    MEM[147] = 32'h0004a703;
    MEM[148] = 32'hdeadc7b7;
    MEM[149] = 32'heef78793;
    MEM[150] = 32'h04f70e63;
    MEM[151] = 32'h00001517;
    MEM[152] = 32'h00040593;
    MEM[153] = 32'h33c50513;
    MEM[154] = 32'h409000ef;
    MEM[155] = 32'h00040613;
    MEM[156] = 32'h00000593;
    MEM[157] = 32'h00048513;
    MEM[158] = 32'h024010ef;
    MEM[159] = 32'h00001517;
    MEM[160] = 32'h00040593;
    MEM[161] = 32'h34850513;
    MEM[162] = 32'h3e9000ef;
    MEM[163] = 32'h00000593;
    MEM[164] = 32'h00040613;
    MEM[165] = 32'h00048513;
    MEM[166] = 32'h028010ef;
    MEM[167] = 32'h00050593;
    MEM[168] = 32'h38050c63;
    MEM[169] = 32'h00052603;
    MEM[170] = 32'h00001517;
    MEM[171] = 32'h34850513;
    MEM[172] = 32'h3c1000ef;
    MEM[173] = 32'h01000637;
    MEM[174] = 32'h000105b7;
    MEM[175] = 32'hfff58593;
    MEM[176] = 32'hf0060613;
    MEM[177] = 32'hffff0537;
    MEM[178] = 32'h294010ef;
    MEM[179] = 32'h00050593;
    MEM[180] = 32'h38050463;
    MEM[181] = 32'h00001517;
    MEM[182] = 32'h36050513;
    MEM[183] = 32'h395000ef;
    MEM[184] = 32'h00001517;
    MEM[185] = 32'hda850513;
    MEM[186] = 32'h23c010ef;
    MEM[187] = 32'h1f0010ef;
    MEM[188] = 32'h00050493;
    MEM[189] = 32'h36050a63;
    MEM[190] = 32'h00050593;
    MEM[191] = 32'h00001517;
    MEM[192] = 32'h36050513;
    MEM[193] = 32'h36d000ef;
    MEM[194] = 32'h00001517;
    MEM[195] = 32'hd0850513;
    MEM[196] = 32'h204010ef;
    MEM[197] = 32'h1b0010ef;
    MEM[198] = 32'h00a12623;
    MEM[199] = 32'h34050e63;
    MEM[200] = 32'h00050593;
    MEM[201] = 32'h00001517;
    MEM[202] = 32'h37450513;
    MEM[203] = 32'h345000ef;
    MEM[204] = 32'h1c4010ef;
    MEM[205] = 32'h000017b7;
    MEM[206] = 32'h80078793;
    MEM[207] = 32'h00f56533;
    MEM[208] = 32'h1f4010ef;
    MEM[209] = 32'h150010ef;
    MEM[210] = 32'h00856513;
    MEM[211] = 32'h1c0010ef;
    MEM[212] = 32'h00001517;
    MEM[213] = 32'h37450513;
    MEM[214] = 32'h319000ef;
    MEM[215] = 32'h00002797;
    MEM[216] = 32'ha3c7a783;
    MEM[217] = 32'hf8000713;
    MEM[218] = 32'h00e781a3;
    MEM[219] = 32'h00002717;
    MEM[220] = 32'ha2072023;
    MEM[221] = 32'h0007c503;
    MEM[222] = 32'h46d000ef;
    MEM[223] = 32'h00002797;
    MEM[224] = 32'ha1c7a783;
    MEM[225] = 32'h00050593;
    MEM[226] = 32'h00001517;
    MEM[227] = 32'h0007c603;
    MEM[228] = 32'h37450513;
    MEM[229] = 32'h2dd000ef;
    MEM[230] = 32'h00001617;
    MEM[231] = 32'h00001597;
    MEM[232] = 32'h00001517;
    MEM[233] = 32'h37860613;
    MEM[234] = 32'h38058593;
    MEM[235] = 32'h39c50513;
    MEM[236] = 32'h2c1000ef;
    MEM[237] = 32'h00002797;
    MEM[238] = 32'h9e47a783;
    MEM[239] = 32'h00001517;
    MEM[240] = 32'h39450513;
    MEM[241] = 32'h0027c583;
    MEM[242] = 32'h2a9000ef;
    MEM[243] = 32'h00002797;
    MEM[244] = 32'h9cc7a783;
    MEM[245] = 32'h00001517;
    MEM[246] = 32'h38850513;
    MEM[247] = 32'h0017c583;
    MEM[248] = 32'h00159593;
    MEM[249] = 32'h28d000ef;
    MEM[250] = 32'h09c010ef;
    MEM[251] = 32'h00001597;
    MEM[252] = 32'h18c58593;
    MEM[253] = 32'h00050663;
    MEM[254] = 32'h00001597;
    MEM[255] = 32'h17c58593;
    MEM[256] = 32'h00001517;
    MEM[257] = 32'h37050513;
    MEM[258] = 32'h269000ef;
    MEM[259] = 32'h01000613;
    MEM[260] = 32'h00060593;
    MEM[261] = 32'h3e800513;
    MEM[262] = 32'h52d000ef;
    MEM[263] = 32'h4e800793;
    MEM[264] = 32'h00f51863;
    MEM[265] = 32'h00001517;
    MEM[266] = 32'h35450513;
    MEM[267] = 32'h245000ef;
    MEM[268] = 32'h00001517;
    MEM[269] = 32'h35050513;
    MEM[270] = 32'h239000ef;
    MEM[271] = 32'h00000597;
    MEM[272] = 32'h00001697;
    MEM[273] = 32'h00001617;
    MEM[274] = 32'h13468693;
    MEM[275] = 32'hdc458593;
    MEM[276] = 32'h00002797;
    MEM[277] = 32'h13060613;
    MEM[278] = 32'h00001517;
    MEM[279] = 32'h40d40733;
    MEM[280] = 32'h40b60633;
    MEM[281] = 32'hbb078793;
    MEM[282] = 32'h32c50513;
    MEM[283] = 32'h00f12023;
    MEM[284] = 32'h201000ef;
    MEM[285] = 32'h00012783;
    MEM[286] = 32'h00001517;
    MEM[287] = 32'h33450513;
    MEM[288] = 32'h408785b3;
    MEM[289] = 32'h1ed000ef;
    MEM[290] = 32'hdeadc737;
    MEM[291] = 32'heef70713;
    MEM[292] = 32'h00002797;
    MEM[293] = 32'ha4e7ae23;
    MEM[294] = 32'h00002797;
    MEM[295] = 32'h9007a783;
    MEM[296] = 32'h00001517;
    MEM[297] = 32'h32450513;
    MEM[298] = 32'h0067d583;
    MEM[299] = 32'h1c5000ef;
    MEM[300] = 32'h00002797;
    MEM[301] = 32'h8e87a783;
    MEM[302] = 32'h001e85b7;
    MEM[303] = 32'h48058593;
    MEM[304] = 32'h0017c503;
    MEM[305] = 32'h00c7a403;
    MEM[306] = 32'h00c7a603;
    MEM[307] = 32'h00c12023;
    MEM[308] = 32'h671000ef;
    MEM[309] = 32'h00140593;
    MEM[310] = 32'h711000ef;
    MEM[311] = 32'h00012603;
    MEM[312] = 32'h00050593;
    MEM[313] = 32'h00001517;
    MEM[314] = 32'h2fc50513;
    MEM[315] = 32'h185000ef;
    MEM[316] = 32'h00048863;
    MEM[317] = 32'h00100073;
    MEM[318] = 32'h00100293;
    MEM[319] = 32'h0002a283;
    MEM[320] = 32'h00001517;
    MEM[321] = 32'h28050513;
    MEM[322] = 32'h169000ef;
    MEM[323] = 32'h00001517;
    MEM[324] = 32'h2ec50513;
    MEM[325] = 32'h15d000ef;
    MEM[326] = 32'h00012823;
    MEM[327] = 32'h02000613;
    MEM[328] = 32'h00000593;
    MEM[329] = 32'h02410513;
    MEM[330] = 32'h5c1000ef;
    MEM[331] = 32'h00002797;
    MEM[332] = 32'h86c7a783;
    MEM[333] = 32'h00001517;
    MEM[334] = 32'h2dc50513;
    MEM[335] = 32'h0107a583;
    MEM[336] = 32'h01012783;
    MEM[337] = 32'h02b12023;
    MEM[338] = 32'h40f585b3;
    MEM[339] = 32'h125000ef;
    MEM[340] = 32'h00c12783;
    MEM[341] = 32'h06079063;
    MEM[342] = 32'h000f4737;
    MEM[343] = 32'h08000613;
    MEM[344] = 32'hf8000593;
    MEM[345] = 32'h23f70713;
    MEM[346] = 32'h00002797;
    MEM[347] = 32'h8307a783;
    MEM[348] = 32'h0037c683;
    MEM[349] = 32'h02c69a63;
    MEM[350] = 32'h00002697;
    MEM[351] = 32'h8146a683;
    MEM[352] = 32'h00002517;
    MEM[353] = 32'hfff68313;
    MEM[354] = 32'h80652623;
    MEM[355] = 32'h00069c63;
    MEM[356] = 32'h0087d683;
    MEM[357] = 32'h00168693;
    MEM[358] = 32'h00d79423;
    MEM[359] = 32'h00001697;
    MEM[360] = 32'h7ee6a823;
    MEM[361] = 32'h00b781a3;
    MEM[362] = 32'h0047c783;
    MEM[363] = 32'h0027f793;
    MEM[364] = 32'hfa078ce3;
    MEM[365] = 32'h02000593;
    MEM[366] = 32'h02410513;
    MEM[367] = 32'h68c000ef;
    MEM[368] = 32'h00001797;
    MEM[369] = 32'h7d87a783;
    MEM[370] = 32'h00000493;
    MEM[371] = 32'h02410513;
    MEM[372] = 32'h0107a783;
    MEM[373] = 32'h00f12823;
    MEM[374] = 32'h00001597;
    MEM[375] = 32'h24058593;
    MEM[376] = 32'h439000ef;
    MEM[377] = 32'h04410413;
    MEM[378] = 32'h00249793;
    MEM[379] = 32'h00f407b3;
    MEM[380] = 32'h00a7a023;
    MEM[381] = 32'h00050a63;
    MEM[382] = 32'h00148493;
    MEM[383] = 32'h00800793;
    MEM[384] = 32'h00000513;
    MEM[385] = 32'hfcf49ae3;
    MEM[386] = 32'h04412783;
    MEM[387] = 32'h00f12023;
    MEM[388] = 32'hf00786e3;
    MEM[389] = 32'h00001597;
    MEM[390] = 32'h20858593;
    MEM[391] = 32'h00078513;
    MEM[392] = 32'h3d1000ef;
    MEM[393] = 32'h06051063;
    MEM[394] = 32'h00001517;
    MEM[395] = 32'h1fc50513;
    MEM[396] = 32'h041000ef;
    MEM[397] = 32'hee9ff06f;
    MEM[398] = 32'h00001517;
    MEM[399] = 32'hfd850513;
    MEM[400] = 32'h031000ef;
    MEM[401] = 32'h80000537;
    MEM[402] = 32'h800085b7;
    MEM[403] = 32'h20050513;
    MEM[404] = 32'h6f5000ef;
    MEM[405] = 32'hc61ff06f;
    MEM[406] = 32'h00001517;
    MEM[407] = 32'hff050513;
    MEM[408] = 32'h011000ef;
    MEM[409] = 32'hc7dff06f;
    MEM[410] = 32'h00001517;
    MEM[411] = 32'h01c50513;
    MEM[412] = 32'h001000ef;
    MEM[413] = 32'hc95ff06f;
    MEM[414] = 32'h00001517;
    MEM[415] = 32'h06850513;
    MEM[416] = 32'hcd9ff06f;
    MEM[417] = 32'h00012503;
    MEM[418] = 32'h00001597;
    MEM[419] = 32'h1a458593;
    MEM[420] = 32'h361000ef;
    MEM[421] = 32'h00051663;
    MEM[422] = 32'h00100073;
    MEM[423] = 32'he81ff06f;
    MEM[424] = 32'h00012503;
    MEM[425] = 32'h00001597;
    MEM[426] = 32'h19058593;
    MEM[427] = 32'h345000ef;
    MEM[428] = 32'h06051263;
    MEM[429] = 32'h681000ef;
    MEM[430] = 32'h00001517;
    MEM[431] = 32'h18450513;
    MEM[432] = 32'h7b0000ef;
    MEM[433] = 32'h00001517;
    MEM[434] = 32'h19850513;
    MEM[435] = 32'h7a4000ef;
    MEM[436] = 32'h04812403;
    MEM[437] = 32'h02040463;
    MEM[438] = 32'h00040513;
    MEM[439] = 32'h0c5000ef;
    MEM[440] = 32'h00050493;
    MEM[441] = 32'h00040513;
    MEM[442] = 32'h0b9000ef;
    MEM[443] = 32'h000025b7;
    MEM[444] = 32'h00b505b3;
    MEM[445] = 32'h00048513;
    MEM[446] = 32'h64d000ef;
    MEM[447] = 32'h06c12083;
    MEM[448] = 32'h06812403;
    MEM[449] = 32'h06412483;
    MEM[450] = 32'h00000513;
    MEM[451] = 32'h07010113;
    MEM[452] = 32'h00008067;
    MEM[453] = 32'h00012503;
    MEM[454] = 32'h00001597;
    MEM[455] = 32'h15458593;
    MEM[456] = 32'h2d1000ef;
    MEM[457] = 32'h0a051263;
    MEM[458] = 32'h04812483;
    MEM[459] = 32'h00048863;
    MEM[460] = 32'h00048513;
    MEM[461] = 32'h06d000ef;
    MEM[462] = 32'h00050493;
    MEM[463] = 32'h10048413;
    MEM[464] = 32'h00001517;
    MEM[465] = 32'h00048593;
    MEM[466] = 32'h13450513;
    MEM[467] = 32'h724000ef;
    MEM[468] = 32'h00000793;
    MEM[469] = 32'h00f48733;
    MEM[470] = 32'h00074583;
    MEM[471] = 32'h00001517;
    MEM[472] = 32'h12050513;
    MEM[473] = 32'h00f12023;
    MEM[474] = 32'h708000ef;
    MEM[475] = 32'h00012783;
    MEM[476] = 32'h01000713;
    MEM[477] = 32'h00178793;
    MEM[478] = 32'hfce79ee3;
    MEM[479] = 32'h00000793;
    MEM[480] = 32'h00f48733;
    MEM[481] = 32'h00074503;
    MEM[482] = 32'h05e00693;
    MEM[483] = 32'hfe050713;
    MEM[484] = 32'h0ff77713;
    MEM[485] = 32'h00e6f463;
    MEM[486] = 32'h02e00513;
    MEM[487] = 32'h00f12023;
    MEM[488] = 32'h46c000ef;
    MEM[489] = 32'h00012783;
    MEM[490] = 32'h01000713;
    MEM[491] = 32'h00178793;
    MEM[492] = 32'hfce798e3;
    MEM[493] = 32'h00a00513;
    MEM[494] = 32'h01048493;
    MEM[495] = 32'h450000ef;
    MEM[496] = 32'hf88490e3;
    MEM[497] = 32'hd59ff06f;
    MEM[498] = 32'h00012503;
    MEM[499] = 32'h00001597;
    MEM[500] = 32'h00200613;
    MEM[501] = 32'h0b458593;
    MEM[502] = 32'h1e1000ef;
    MEM[503] = 32'h06051263;
    MEM[504] = 32'h00012783;
    MEM[505] = 32'h0027c703;
    MEM[506] = 32'h06d00793;
    MEM[507] = 32'h0af70a63;
    MEM[508] = 32'h00100793;
    MEM[509] = 32'h00f12c23;
    MEM[510] = 32'h00200713;
    MEM[511] = 32'h00178493;
    MEM[512] = 32'h00279793;
    MEM[513] = 32'h00f40433;
    MEM[514] = 32'h00042503;
    MEM[515] = 32'h00e12a23;
    MEM[516] = 32'h00000413;
    MEM[517] = 32'h78c000ef;
    MEM[518] = 32'h00a12223;
    MEM[519] = 32'h00050593;
    MEM[520] = 32'h00001517;
    MEM[521] = 32'h05450513;
    MEM[522] = 32'h648000ef;
    MEM[523] = 32'h01812783;
    MEM[524] = 32'h08879463;
    MEM[525] = 32'h00001517;
    MEM[526] = 32'hf4c50513;
    MEM[527] = 32'hdf5ff06f;
    MEM[528] = 32'h00012503;
    MEM[529] = 32'h00001597;
    MEM[530] = 32'h00200613;
    MEM[531] = 32'h04058593;
    MEM[532] = 32'h169000ef;
    MEM[533] = 32'hf80506e3;
    MEM[534] = 32'h00012503;
    MEM[535] = 32'h00001597;
    MEM[536] = 32'h02c58593;
    MEM[537] = 32'h18d000ef;
    MEM[538] = 32'h1a051a63;
    MEM[539] = 32'h04812503;
    MEM[540] = 32'h00050a63;
    MEM[541] = 32'h72c000ef;
    MEM[542] = 32'h00001797;
    MEM[543] = 32'h5207a783;
    MEM[544] = 32'h00a79423;
    MEM[545] = 32'h00001797;
    MEM[546] = 32'h5147a783;
    MEM[547] = 32'h00001517;
    MEM[548] = 32'h00050513;
    MEM[549] = 32'h0087d583;
    MEM[550] = 32'h5d8000ef;
    MEM[551] = 32'hc81ff06f;
    MEM[552] = 32'h04812503;
    MEM[553] = 32'h6fc000ef;
    MEM[554] = 32'h00a12c23;
    MEM[555] = 32'h00200793;
    MEM[556] = 32'h00300713;
    MEM[557] = 32'hf49ff06f;
    MEM[558] = 32'h01412703;
    MEM[559] = 32'h00012783;
    MEM[560] = 32'h00e787b3;
    MEM[561] = 32'h00f12423;
    MEM[562] = 32'h00012783;
    MEM[563] = 32'h0007c703;
    MEM[564] = 32'h07200793;
    MEM[565] = 32'h08f71663;
    MEM[566] = 32'h00812783;
    MEM[567] = 32'h0007c703;
    MEM[568] = 32'h06200793;
    MEM[569] = 32'h00f71e63;
    MEM[570] = 32'h00412783;
    MEM[571] = 32'h00001517;
    MEM[572] = 32'hf9050513;
    MEM[573] = 32'h008787b3;
    MEM[574] = 32'h0007c583;
    MEM[575] = 32'h574000ef;
    MEM[576] = 32'h00812783;
    MEM[577] = 32'h0007c703;
    MEM[578] = 32'h07700793;
    MEM[579] = 32'h02f71063;
    MEM[580] = 32'h00412703;
    MEM[581] = 32'h00141793;
    MEM[582] = 32'h00001517;
    MEM[583] = 32'h00e787b3;
    MEM[584] = 32'h00079583;
    MEM[585] = 32'hf6450513;
    MEM[586] = 32'h548000ef;
    MEM[587] = 32'h00812783;
    MEM[588] = 32'h0007c703;
    MEM[589] = 32'h06c00793;
    MEM[590] = 32'h02f71063;
    MEM[591] = 32'h00412703;
    MEM[592] = 32'h00241793;
    MEM[593] = 32'h00001517;
    MEM[594] = 32'h00e787b3;
    MEM[595] = 32'h0007a583;
    MEM[596] = 32'hf3850513;
    MEM[597] = 32'h51c000ef;
    MEM[598] = 32'h00140413;
    MEM[599] = 32'hed1ff06f;
    MEM[600] = 32'h00148793;
    MEM[601] = 32'h00249493;
    MEM[602] = 32'h02010713;
    MEM[603] = 32'h00f12e23;
    MEM[604] = 32'h04448793;
    MEM[605] = 32'h00e784b3;
    MEM[606] = 32'hfe04a503;
    MEM[607] = 32'h624000ef;
    MEM[608] = 32'h00812783;
    MEM[609] = 32'h00050493;
    MEM[610] = 32'h0007c703;
    MEM[611] = 32'h06200793;
    MEM[612] = 32'h02f71063;
    MEM[613] = 32'h00412783;
    MEM[614] = 32'h0ff57593;
    MEM[615] = 32'h008787b3;
    MEM[616] = 32'h00a78023;
    MEM[617] = 32'h00001517;
    MEM[618] = 32'hed850513;
    MEM[619] = 32'h4c4000ef;
    MEM[620] = 32'h00812783;
    MEM[621] = 32'h0007c703;
    MEM[622] = 32'h07700793;
    MEM[623] = 32'h02f71463;
    MEM[624] = 32'h00412703;
    MEM[625] = 32'h01049593;
    MEM[626] = 32'h00141793;
    MEM[627] = 32'h4105d593;
    MEM[628] = 32'h00e787b3;
    MEM[629] = 32'h00001517;
    MEM[630] = 32'h00b79023;
    MEM[631] = 32'hea850513;
    MEM[632] = 32'h490000ef;
    MEM[633] = 32'h00812783;
    MEM[634] = 32'h0007c703;
    MEM[635] = 32'h06c00793;
    MEM[636] = 32'h02f71263;
    MEM[637] = 32'h00412703;
    MEM[638] = 32'h00241793;
    MEM[639] = 32'h00001517;
    MEM[640] = 32'h00e787b3;
    MEM[641] = 32'h0097a023;
    MEM[642] = 32'h00048593;
    MEM[643] = 32'he8050513;
    MEM[644] = 32'h460000ef;
    MEM[645] = 32'h01c12483;
    MEM[646] = 32'hf41ff06f;
    MEM[647] = 32'h00012503;
    MEM[648] = 32'h00001597;
    MEM[649] = 32'he7858593;
    MEM[650] = 32'h7c8000ef;
    MEM[651] = 32'h02051a63;
    MEM[652] = 32'h04812503;
    MEM[653] = 32'h00050a63;
    MEM[654] = 32'h50c000ef;
    MEM[655] = 32'h00001797;
    MEM[656] = 32'h35c7a783;
    MEM[657] = 32'h00a7a623;
    MEM[658] = 32'h00001797;
    MEM[659] = 32'h3507a783;
    MEM[660] = 32'h00001517;
    MEM[661] = 32'he5050513;
    MEM[662] = 32'h00c7a583;
    MEM[663] = 32'he3dff06f;
    MEM[664] = 32'h00012503;
    MEM[665] = 32'h00001597;
    MEM[666] = 32'he4858593;
    MEM[667] = 32'h784000ef;
    MEM[668] = 32'h02051a63;
    MEM[669] = 32'h04812503;
    MEM[670] = 32'h00050a63;
    MEM[671] = 32'h524000ef;
    MEM[672] = 32'h00001797;
    MEM[673] = 32'h3187a783;
    MEM[674] = 32'h00a79523;
    MEM[675] = 32'h00001797;
    MEM[676] = 32'h30c7a783;
    MEM[677] = 32'h00001517;
    MEM[678] = 32'he2050513;
    MEM[679] = 32'h00a7d583;
    MEM[680] = 32'hdf9ff06f;
    MEM[681] = 32'h00012503;
    MEM[682] = 32'h00001597;
    MEM[683] = 32'he1858593;
    MEM[684] = 32'h740000ef;
    MEM[685] = 32'h02051a63;
    MEM[686] = 32'h04812503;
    MEM[687] = 32'h488000ef;
    MEM[688] = 32'h00050413;
    MEM[689] = 32'h04c12503;
    MEM[690] = 32'h47c000ef;
    MEM[691] = 32'h00050593;
    MEM[692] = 32'h00040513;
    MEM[693] = 32'h06d000ef;
    MEM[694] = 32'h00050593;
    MEM[695] = 32'h00001517;
    MEM[696] = 32'hde850513;
    MEM[697] = 32'hdb5ff06f;
    MEM[698] = 32'h00012503;
    MEM[699] = 32'h00001597;
    MEM[700] = 32'hde458593;
    MEM[701] = 32'h6fc000ef;
    MEM[702] = 32'h04051863;
    MEM[703] = 32'h04812503;
    MEM[704] = 32'h444000ef;
    MEM[705] = 32'h00050413;
    MEM[706] = 32'h04c12503;
    MEM[707] = 32'h438000ef;
    MEM[708] = 32'h00050593;
    MEM[709] = 32'h00a12223;
    MEM[710] = 32'h00040513;
    MEM[711] = 32'h161000ef;
    MEM[712] = 32'h00412583;
    MEM[713] = 32'h00a12023;
    MEM[714] = 32'h00040513;
    MEM[715] = 32'h149000ef;
    MEM[716] = 32'h00012603;
    MEM[717] = 32'h00050593;
    MEM[718] = 32'h00001517;
    MEM[719] = 32'hd9c50513;
    MEM[720] = 32'h330000ef;
    MEM[721] = 32'h9d9ff06f;
    MEM[722] = 32'h00012503;
    MEM[723] = 32'h00001597;
    MEM[724] = 32'hd9c58593;
    MEM[725] = 32'h69c000ef;
    MEM[726] = 32'h04051663;
    MEM[727] = 32'h04812503;
    MEM[728] = 32'h3e4000ef;
    MEM[729] = 32'h00050413;
    MEM[730] = 32'h04c12503;
    MEM[731] = 32'h3d8000ef;
    MEM[732] = 32'h00050493;
    MEM[733] = 32'h05012503;
    MEM[734] = 32'h3cc000ef;
    MEM[735] = 32'h01051613;
    MEM[736] = 32'h01049593;
    MEM[737] = 32'h4105d593;
    MEM[738] = 32'h41065613;
    MEM[739] = 32'h00040513;
    MEM[740] = 32'h5b4000ef;
    MEM[741] = 32'h00050593;
    MEM[742] = 32'h00001517;
    MEM[743] = 32'hd5450513;
    MEM[744] = 32'hcf9ff06f;
    MEM[745] = 32'h00012503;
    MEM[746] = 32'h00001597;
    MEM[747] = 32'hd5058593;
    MEM[748] = 32'h640000ef;
    MEM[749] = 32'h02051063;
    MEM[750] = 32'h04812503;
    MEM[751] = 32'h3e4000ef;
    MEM[752] = 32'h00050593;
    MEM[753] = 32'h40155613;
    MEM[754] = 32'h00001517;
    MEM[755] = 32'hd3850513;
    MEM[756] = 32'hf71ff06f;
    MEM[757] = 32'h00012783;
    MEM[758] = 32'h0007c783;
    MEM[759] = 32'h940780e3;
    MEM[760] = 32'h00001517;
    MEM[761] = 32'h00012583;
    MEM[762] = 32'hd3450513;
    MEM[763] = 32'hcadff06f;
    MEM[764] = 32'h00001797;
    MEM[765] = 32'h1a87a703;
    MEM[766] = 32'h00474783;
    MEM[767] = 32'h0027f793;
    MEM[768] = 32'hfe078ce3;
    MEM[769] = 32'h00574503;
    MEM[770] = 32'h00008067;
    MEM[771] = 32'h00001797;
    MEM[772] = 32'h00a00713;
    MEM[773] = 32'h18c7a783;
    MEM[774] = 32'h00e51c63;
    MEM[775] = 32'h0047c703;
    MEM[776] = 32'h00177713;
    MEM[777] = 32'hfe071ce3;
    MEM[778] = 32'h00d00713;
    MEM[779] = 32'h00e782a3;
    MEM[780] = 32'h0047c703;
    MEM[781] = 32'h00177713;
    MEM[782] = 32'hfe071ce3;
    MEM[783] = 32'h00a782a3;
    MEM[784] = 32'h0ff57513;
    MEM[785] = 32'h00008067;
    MEM[786] = 32'hfe810113;
    MEM[787] = 32'h00812823;
    MEM[788] = 32'h00912623;
    MEM[789] = 32'h00112a23;
    MEM[790] = 32'h00050493;
    MEM[791] = 32'h00050413;
    MEM[792] = 32'hfff58713;
    MEM[793] = 32'h02071a63;
    MEM[794] = 32'h00a00513;
    MEM[795] = 32'hfa1ff0ef;
    MEM[796] = 32'h00040023;
    MEM[797] = 32'h40848533;
    MEM[798] = 32'h01412083;
    MEM[799] = 32'h01012403;
    MEM[800] = 32'h00a03533;
    MEM[801] = 32'h40a00533;
    MEM[802] = 32'h00a4f533;
    MEM[803] = 32'h00c12483;
    MEM[804] = 32'h01810113;
    MEM[805] = 32'h00008067;
    MEM[806] = 32'h00b12223;
    MEM[807] = 32'h00e12023;
    MEM[808] = 32'hf51ff0ef;
    MEM[809] = 32'hff350693;
    MEM[810] = 32'hfc0680e3;
    MEM[811] = 32'hff650693;
    MEM[812] = 32'hfa068ce3;
    MEM[813] = 32'h00a12423;
    MEM[814] = 32'hf55ff0ef;
    MEM[815] = 32'h00812783;
    MEM[816] = 32'h00800693;
    MEM[817] = 32'h00012703;
    MEM[818] = 32'h00412583;
    MEM[819] = 32'h00d79c63;
    MEM[820] = 32'h00848e63;
    MEM[821] = 32'hfe040fa3;
    MEM[822] = 32'hfff58713;
    MEM[823] = 32'hfff40413;
    MEM[824] = 32'hfb9ff06f;
    MEM[825] = 32'h00f40023;
    MEM[826] = 32'h00140413;
    MEM[827] = 32'h00070593;
    MEM[828] = 32'hf71ff06f;
    MEM[829] = 32'hff810113;
    MEM[830] = 32'h00812023;
    MEM[831] = 32'h00112223;
    MEM[832] = 32'h00050413;
    MEM[833] = 32'h00051663;
    MEM[834] = 32'h00001417;
    MEM[835] = 32'hd2440413;
    MEM[836] = 32'h00044503;
    MEM[837] = 32'h00051a63;
    MEM[838] = 32'h00412083;
    MEM[839] = 32'h00012403;
    MEM[840] = 32'h00810113;
    MEM[841] = 32'h00008067;
    MEM[842] = 32'h00140413;
    MEM[843] = 32'hee1ff0ef;
    MEM[844] = 32'hfe1ff06f;
    MEM[845] = 32'hffc10113;
    MEM[846] = 32'h00112023;
    MEM[847] = 32'hfb9ff0ef;
    MEM[848] = 32'h00012083;
    MEM[849] = 32'h00a00513;
    MEM[850] = 32'h00410113;
    MEM[851] = 32'hec1ff06f;
    MEM[852] = 32'hfb810113;
    MEM[853] = 32'h00b12023;
    MEM[854] = 32'h00001597;
    MEM[855] = 32'h04812023;
    MEM[856] = 32'h01100613;
    MEM[857] = 32'h00050413;
    MEM[858] = 32'hcdc58593;
    MEM[859] = 32'h00810513;
    MEM[860] = 32'h04112223;
    MEM[861] = 32'h02912e23;
    MEM[862] = 32'h524000ef;
    MEM[863] = 32'h00045e63;
    MEM[864] = 32'h00012783;
    MEM[865] = 32'hff678793;
    MEM[866] = 32'h00079863;
    MEM[867] = 32'h02d00513;
    MEM[868] = 32'he7dff0ef;
    MEM[869] = 32'h40800433;
    MEM[870] = 32'h00000493;
    MEM[871] = 32'h00012583;
    MEM[872] = 32'h00148713;
    MEM[873] = 32'h00040513;
    MEM[874] = 32'h00e12223;
    MEM[875] = 32'h644000ef;
    MEM[876] = 32'h00810713;
    MEM[877] = 32'h03450793;
    MEM[878] = 32'h00e78533;
    MEM[879] = 32'hfcc54603;
    MEM[880] = 32'h03448793;
    MEM[881] = 32'h00012583;
    MEM[882] = 32'h00e786b3;
    MEM[883] = 32'hfec68023;
    MEM[884] = 32'h00040513;
    MEM[885] = 32'h614000ef;
    MEM[886] = 32'h00012783;
    MEM[887] = 32'h00a00693;
    MEM[888] = 32'h00412703;
    MEM[889] = 32'h00050413;
    MEM[890] = 32'h06d78263;
    MEM[891] = 32'h00012583;
    MEM[892] = 32'h03470793;
    MEM[893] = 32'h00810713;
    MEM[894] = 32'h00e78733;
    MEM[895] = 32'h00e12223;
    MEM[896] = 32'h5f0000ef;
    MEM[897] = 32'h03450793;
    MEM[898] = 32'h00810713;
    MEM[899] = 32'h00e78533;
    MEM[900] = 32'hfcc54683;
    MEM[901] = 32'h00412703;
    MEM[902] = 32'h00012583;
    MEM[903] = 32'h00040513;
    MEM[904] = 32'hfed70023;
    MEM[905] = 32'h5c4000ef;
    MEM[906] = 32'h00248493;
    MEM[907] = 32'h00050413;
    MEM[908] = 32'hf60416e3;
    MEM[909] = 32'h02049063;
    MEM[910] = 32'h04412083;
    MEM[911] = 32'h04012403;
    MEM[912] = 32'h03c12483;
    MEM[913] = 32'h04810113;
    MEM[914] = 32'h00008067;
    MEM[915] = 32'h00070493;
    MEM[916] = 32'hfe1ff06f;
    MEM[917] = 32'hfff48493;
    MEM[918] = 32'h03448793;
    MEM[919] = 32'h00810713;
    MEM[920] = 32'h00e78733;
    MEM[921] = 32'hfe074503;
    MEM[922] = 32'hda5ff0ef;
    MEM[923] = 32'hfc9ff06f;
    MEM[924] = 32'hfdc10113;
    MEM[925] = 32'h02f12023;
    MEM[926] = 32'h01010793;
    MEM[927] = 32'h00812423;
    MEM[928] = 32'h00112623;
    MEM[929] = 32'h00912223;
    MEM[930] = 32'h00050413;
    MEM[931] = 32'h00b12823;
    MEM[932] = 32'h00c12a23;
    MEM[933] = 32'h00d12c23;
    MEM[934] = 32'h00e12e23;
    MEM[935] = 32'h00f12023;
    MEM[936] = 32'h00044503;
    MEM[937] = 32'h00051c63;
    MEM[938] = 32'h00c12083;
    MEM[939] = 32'h00812403;
    MEM[940] = 32'h00412483;
    MEM[941] = 32'h02410113;
    MEM[942] = 32'h00008067;
    MEM[943] = 32'h02500793;
    MEM[944] = 32'h06f51e63;
    MEM[945] = 32'h00144503;
    MEM[946] = 32'h07300793;
    MEM[947] = 32'h00140493;
    MEM[948] = 32'h02f51263;
    MEM[949] = 32'h00012783;
    MEM[950] = 32'h0007a503;
    MEM[951] = 32'h00478713;
    MEM[952] = 32'h00e12023;
    MEM[953] = 32'he11ff0ef;
    MEM[954] = 32'h00048413;
    MEM[955] = 32'h00140413;
    MEM[956] = 32'hfb1ff06f;
    MEM[957] = 32'h07800793;
    MEM[958] = 32'h02f51063;
    MEM[959] = 32'h00012783;
    MEM[960] = 32'h01000593;
    MEM[961] = 32'h00478713;
    MEM[962] = 32'h00e12023;
    MEM[963] = 32'h0007a503;
    MEM[964] = 32'he41ff0ef;
    MEM[965] = 32'hfd5ff06f;
    MEM[966] = 32'h06400793;
    MEM[967] = 32'h00f51c63;
    MEM[968] = 32'h00012783;
    MEM[969] = 32'h00a00593;
    MEM[970] = 32'h00478713;
    MEM[971] = 32'h00e12023;
    MEM[972] = 32'hfddff06f;
    MEM[973] = 32'hcd9ff0ef;
    MEM[974] = 32'hfb1ff06f;
    MEM[975] = 32'hcd1ff0ef;
    MEM[976] = 32'hfadff06f;
    MEM[977] = 32'h00050693;
    MEM[978] = 32'h04051063;
    MEM[979] = 32'h00000513;
    MEM[980] = 32'h00008067;
    MEM[981] = 32'h02b78663;
    MEM[982] = 32'hfd078793;
    MEM[983] = 32'h00351713;
    MEM[984] = 32'h00e78733;
    MEM[985] = 32'h00151793;
    MEM[986] = 32'h00f70533;
    MEM[987] = 32'h00168693;
    MEM[988] = 32'h0006c783;
    MEM[989] = 32'hfe0790e3;
    MEM[990] = 32'h02061063;
    MEM[991] = 32'h00008067;
    MEM[992] = 32'h00100613;
    MEM[993] = 32'hfe9ff06f;
    MEM[994] = 32'h00000613;
    MEM[995] = 32'h00000513;
    MEM[996] = 32'h02d00593;
    MEM[997] = 32'hfddff06f;
    MEM[998] = 32'h40a00533;
    MEM[999] = 32'h00008067;
    MEM[1000] = 32'h00050693;
    MEM[1001] = 32'h00000513;
    MEM[1002] = 32'h02069a63;
    MEM[1003] = 32'h00008067;
    MEM[1004] = 32'h00451713;
    MEM[1005] = 32'h00f66e63;
    MEM[1006] = 32'hfd078793;
    MEM[1007] = 32'h00e78533;
    MEM[1008] = 32'h00168693;
    MEM[1009] = 32'h0006c783;
    MEM[1010] = 32'hfe0794e3;
    MEM[1011] = 32'h00008067;
    MEM[1012] = 32'h05f7f793;
    MEM[1013] = 32'hfc978793;
    MEM[1014] = 32'hfe5ff06f;
    MEM[1015] = 32'h03900613;
    MEM[1016] = 32'hfe5ff06f;
    MEM[1017] = 32'h01400793;
    MEM[1018] = 32'h00a7ee63;
    MEM[1019] = 32'h00001797;
    MEM[1020] = 32'h00251513;
    MEM[1021] = 32'hd3078793;
    MEM[1022] = 32'h00a787b3;
    MEM[1023] = 32'h0007a503;
    MEM[1024] = 32'h00008067;
    MEM[1025] = 32'h00001517;
    MEM[1026] = 32'ha4450513;
    MEM[1027] = 32'h00008067;
    MEM[1028] = 32'hff010113;
    MEM[1029] = 32'h00f12023;
    MEM[1030] = 32'h00001797;
    MEM[1031] = 32'hd807a783;
    MEM[1032] = 32'h00e12223;
    MEM[1033] = 32'h00c12623;
    MEM[1034] = 32'h00d12423;
    MEM[1035] = 32'h0037c683;
    MEM[1036] = 32'h08000713;
    MEM[1037] = 32'h02e69e63;
    MEM[1038] = 32'h00001717;
    MEM[1039] = 32'hd5472703;
    MEM[1040] = 32'h00001697;
    MEM[1041] = 32'hfff70613;
    MEM[1042] = 32'hd4c6a623;
    MEM[1043] = 32'h00071e63;
    MEM[1044] = 32'h0087d703;
    MEM[1045] = 32'h06300693;
    MEM[1046] = 32'h00170713;
    MEM[1047] = 32'h00e79423;
    MEM[1048] = 32'h00001717;
    MEM[1049] = 32'hd2d72623;
    MEM[1050] = 32'hf8000713;
    MEM[1051] = 32'h00e781a3;
    MEM[1052] = 32'h00c12603;
    MEM[1053] = 32'h00812683;
    MEM[1054] = 32'h00412703;
    MEM[1055] = 32'h00012783;
    MEM[1056] = 32'h01010113;
    MEM[1057] = 32'h30200073;
    MEM[1058] = 32'hfd410113;
    MEM[1059] = 32'h00b12a23;
    MEM[1060] = 32'h00c12823;
    MEM[1061] = 32'h00d12623;
    MEM[1062] = 32'h02112423;
    MEM[1063] = 32'h02512223;
    MEM[1064] = 32'h02612023;
    MEM[1065] = 32'h00712e23;
    MEM[1066] = 32'h00e12423;
    MEM[1067] = 32'h00f12223;
    MEM[1068] = 32'h00a12c23;
    MEM[1069] = 32'h3f8000ef;
    MEM[1070] = 32'h00a12023;
    MEM[1071] = 32'h42c000ef;
    MEM[1072] = 32'h00012603;
    MEM[1073] = 32'h00001697;
    MEM[1074] = 32'h00050593;
    MEM[1075] = 32'h98c68693;
    MEM[1076] = 32'h02060663;
    MEM[1077] = 32'h00001697;
    MEM[1078] = 32'hfff60713;
    MEM[1079] = 32'h00600793;
    MEM[1080] = 32'h97468693;
    MEM[1081] = 32'h00e7ec63;
    MEM[1082] = 32'h00001797;
    MEM[1083] = 32'hc3478793;
    MEM[1084] = 32'h00271713;
    MEM[1085] = 32'h00e787b3;
    MEM[1086] = 32'h0547a683;
    MEM[1087] = 32'h00001517;
    MEM[1088] = 32'h97050513;
    MEM[1089] = 32'hd6dff0ef;
    MEM[1090] = 32'h3e0000ef;
    MEM[1091] = 32'h00450513;
    MEM[1092] = 32'h41c000ef;
    MEM[1093] = 32'h02812083;
    MEM[1094] = 32'h02412283;
    MEM[1095] = 32'h02012303;
    MEM[1096] = 32'h01c12383;
    MEM[1097] = 32'h01812503;
    MEM[1098] = 32'h01412583;
    MEM[1099] = 32'h01012603;
    MEM[1100] = 32'h00c12683;
    MEM[1101] = 32'h00812703;
    MEM[1102] = 32'h00412783;
    MEM[1103] = 32'h02c10113;
    MEM[1104] = 32'h10200073;
    MEM[1105] = 32'h00c5850b;
    MEM[1106] = 32'h00008067;
    MEM[1107] = 32'h00001797;
    MEM[1108] = 32'hc4c7a783;
    MEM[1109] = 32'hff810113;
    MEM[1110] = 32'h00812023;
    MEM[1111] = 32'h00050413;
    MEM[1112] = 32'h0107a503;
    MEM[1113] = 32'h3e800593;
    MEM[1114] = 32'h00112223;
    MEM[1115] = 32'h27c000ef;
    MEM[1116] = 32'h00040463;
    MEM[1117] = 32'h00a42023;
    MEM[1118] = 32'h00412083;
    MEM[1119] = 32'h00012403;
    MEM[1120] = 32'h00810113;
    MEM[1121] = 32'h00008067;
    MEM[1122] = 32'hfff60613;
    MEM[1123] = 32'h00000793;
    MEM[1124] = 32'h00c78e63;
    MEM[1125] = 32'h00f58733;
    MEM[1126] = 32'h00074703;
    MEM[1127] = 32'h00f506b3;
    MEM[1128] = 32'h00178793;
    MEM[1129] = 32'h00e68023;
    MEM[1130] = 32'hfe0714e3;
    MEM[1131] = 32'h00008067;
    MEM[1132] = 32'hfff00613;
    MEM[1133] = 32'hfd5ff06f;
    MEM[1134] = 32'hfff60613;
    MEM[1135] = 32'h00000793;
    MEM[1136] = 32'h00f50733;
    MEM[1137] = 32'h00074303;
    MEM[1138] = 32'h00f58733;
    MEM[1139] = 32'h00074683;
    MEM[1140] = 32'h40d30733;
    MEM[1141] = 32'h00c78a63;
    MEM[1142] = 32'h00030863;
    MEM[1143] = 32'h00178793;
    MEM[1144] = 32'h00068463;
    MEM[1145] = 32'hfc070ee3;
    MEM[1146] = 32'h00070513;
    MEM[1147] = 32'h00008067;
    MEM[1148] = 32'hfff00613;
    MEM[1149] = 32'hfc5ff06f;
    MEM[1150] = 32'h00050793;
    MEM[1151] = 32'h00078663;
    MEM[1152] = 32'h0007c703;
    MEM[1153] = 32'h00071663;
    MEM[1154] = 32'h40a78533;
    MEM[1155] = 32'h00008067;
    MEM[1156] = 32'h00178793;
    MEM[1157] = 32'hfe9ff06f;
    MEM[1158] = 32'hfec10113;
    MEM[1159] = 32'h00912423;
    MEM[1160] = 32'h00112823;
    MEM[1161] = 32'h00812623;
    MEM[1162] = 32'h00050493;
    MEM[1163] = 32'h00051863;
    MEM[1164] = 32'h00001797;
    MEM[1165] = 32'hb607a483;
    MEM[1166] = 32'h04048263;
    MEM[1167] = 32'h00058513;
    MEM[1168] = 32'h00b12023;
    MEM[1169] = 32'hfb5ff0ef;
    MEM[1170] = 32'h00a12223;
    MEM[1171] = 32'h00048413;
    MEM[1172] = 32'h00044703;
    MEM[1173] = 32'h02070063;
    MEM[1174] = 32'h00412603;
    MEM[1175] = 32'h00012583;
    MEM[1176] = 32'h00040513;
    MEM[1177] = 32'hf55ff0ef;
    MEM[1178] = 32'h00140713;
    MEM[1179] = 32'h02051463;
    MEM[1180] = 32'h00040023;
    MEM[1181] = 32'h00001797;
    MEM[1182] = 32'hb0e7ae23;
    MEM[1183] = 32'h01012083;
    MEM[1184] = 32'h00c12403;
    MEM[1185] = 32'h00048513;
    MEM[1186] = 32'h00812483;
    MEM[1187] = 32'h01410113;
    MEM[1188] = 32'h00008067;
    MEM[1189] = 32'h00070413;
    MEM[1190] = 32'hfb9ff06f;
    MEM[1191] = 32'h00000793;
    MEM[1192] = 32'h00c79463;
    MEM[1193] = 32'h00008067;
    MEM[1194] = 32'h00f58733;
    MEM[1195] = 32'h00074683;
    MEM[1196] = 32'h00f50733;
    MEM[1197] = 32'h00178793;
    MEM[1198] = 32'h00d70023;
    MEM[1199] = 32'hfe5ff06f;
    MEM[1200] = 32'h00c58633;
    MEM[1201] = 32'h00c59663;
    MEM[1202] = 32'h00000513;
    MEM[1203] = 32'h00008067;
    MEM[1204] = 32'h00054703;
    MEM[1205] = 32'h0005c783;
    MEM[1206] = 32'h00158593;
    MEM[1207] = 32'hfef718e3;
    MEM[1208] = 32'h00150513;
    MEM[1209] = 32'hfe1ff06f;
    MEM[1210] = 32'h00c50633;
    MEM[1211] = 32'h00050793;
    MEM[1212] = 32'h00c79463;
    MEM[1213] = 32'h00008067;
    MEM[1214] = 32'h00178793;
    MEM[1215] = 32'hfeb78fa3;
    MEM[1216] = 32'hff1ff06f;
    MEM[1217] = 32'h00050793;
    MEM[1218] = 32'h00b56863;
    MEM[1219] = 32'h00058713;
    MEM[1220] = 32'h00070793;
    MEM[1221] = 32'h00050593;
    MEM[1222] = 32'h00000513;
    MEM[1223] = 32'h01c0006f;
    MEM[1224] = 32'h01f79693;
    MEM[1225] = 32'h41f6d713;
    MEM[1226] = 32'h00b77733;
    MEM[1227] = 32'h00e50533;
    MEM[1228] = 32'h00159593;
    MEM[1229] = 32'h0017d793;
    MEM[1230] = 32'hfe0794e3;
    MEM[1231] = 32'h00008067;
    MEM[1232] = 32'hff410113;
    MEM[1233] = 32'h00912023;
    MEM[1234] = 32'h00112423;
    MEM[1235] = 32'h00812223;
    MEM[1236] = 32'h00000493;
    MEM[1237] = 32'h00055663;
    MEM[1238] = 32'h40a00533;
    MEM[1239] = 32'h00100493;
    MEM[1240] = 32'h00000413;
    MEM[1241] = 32'h0005d663;
    MEM[1242] = 32'h40b005b3;
    MEM[1243] = 32'h00100413;
    MEM[1244] = 32'hf95ff0ef;
    MEM[1245] = 32'h00848463;
    MEM[1246] = 32'h40a00533;
    MEM[1247] = 32'h00812083;
    MEM[1248] = 32'h00412403;
    MEM[1249] = 32'h00012483;
    MEM[1250] = 32'h00c10113;
    MEM[1251] = 32'h00008067;
    MEM[1252] = 32'h00100793;
    MEM[1253] = 32'h00059a63;
    MEM[1254] = 32'h00058513;
    MEM[1255] = 32'h00008067;
    MEM[1256] = 32'h00179793;
    MEM[1257] = 32'h00159593;
    MEM[1258] = 32'h00a5f463;
    MEM[1259] = 32'hfe05dae3;
    MEM[1260] = 32'h00058713;
    MEM[1261] = 32'h00000693;
    MEM[1262] = 32'h00050593;
    MEM[1263] = 32'h00058463;
    MEM[1264] = 32'h00079863;
    MEM[1265] = 32'hfc060ae3;
    MEM[1266] = 32'h00068593;
    MEM[1267] = 32'hfcdff06f;
    MEM[1268] = 32'h00e5e663;
    MEM[1269] = 32'h40e585b3;
    MEM[1270] = 32'h00f686b3;
    MEM[1271] = 32'h0017d793;
    MEM[1272] = 32'h00175713;
    MEM[1273] = 32'hfd9ff06f;
    MEM[1274] = 32'h00100613;
    MEM[1275] = 32'hfa5ff06f;
    MEM[1276] = 32'h00000613;
    MEM[1277] = 32'hf9dff06f;
    MEM[1278] = 32'h06058a63;
    MEM[1279] = 32'hff010113;
    MEM[1280] = 32'h00912223;
    MEM[1281] = 32'h00112623;
    MEM[1282] = 32'h00812423;
    MEM[1283] = 32'h00000493;
    MEM[1284] = 32'h00055663;
    MEM[1285] = 32'h40a00533;
    MEM[1286] = 32'h00100493;
    MEM[1287] = 32'h00000793;
    MEM[1288] = 32'h0005d663;
    MEM[1289] = 32'h40b005b3;
    MEM[1290] = 32'h00100793;
    MEM[1291] = 32'h00f12023;
    MEM[1292] = 32'h00060413;
    MEM[1293] = 32'hf5dff0ef;
    MEM[1294] = 32'h00050593;
    MEM[1295] = 32'h00040a63;
    MEM[1296] = 32'h00012783;
    MEM[1297] = 32'h00f48863;
    MEM[1298] = 32'h40b005b3;
    MEM[1299] = 32'h0080006f;
    MEM[1300] = 32'hfe049ce3;
    MEM[1301] = 32'h00c12083;
    MEM[1302] = 32'h00812403;
    MEM[1303] = 32'h00412483;
    MEM[1304] = 32'h00058513;
    MEM[1305] = 32'h01010113;
    MEM[1306] = 32'h00008067;
    MEM[1307] = 32'h00058513;
    MEM[1308] = 32'h00008067;
    MEM[1309] = 32'h00100613;
    MEM[1310] = 32'hf81ff06f;
    MEM[1311] = 32'h00000613;
    MEM[1312] = 32'hf79ff06f;
    MEM[1313] = 32'h00000793;
    MEM[1314] = 32'h00100f93;
    MEM[1315] = 32'h40ff8533;
    MEM[1316] = 32'h00008067;
    MEM[1317] = 32'h00000513;
    MEM[1318] = 32'h30002573;
    MEM[1319] = 32'h00008067;
    MEM[1320] = 32'h00000513;
    MEM[1321] = 32'h34202573;
    MEM[1322] = 32'h00008067;
    MEM[1323] = 32'h00000513;
    MEM[1324] = 32'h14202573;
    MEM[1325] = 32'h00008067;
    MEM[1326] = 32'h00000513;
    MEM[1327] = 32'hf1402573;
    MEM[1328] = 32'h00008067;
    MEM[1329] = 32'h00000513;
    MEM[1330] = 32'h30502573;
    MEM[1331] = 32'h00008067;
    MEM[1332] = 32'h00000513;
    MEM[1333] = 32'h34102573;
    MEM[1334] = 32'h00008067;
    MEM[1335] = 32'h00000513;
    MEM[1336] = 32'h10502573;
    MEM[1337] = 32'h00008067;
    MEM[1338] = 32'h00000513;
    MEM[1339] = 32'h14102573;
    MEM[1340] = 32'h00008067;
    MEM[1341] = 32'h00000513;
    MEM[1342] = 32'h30402573;
    MEM[1343] = 32'h00008067;
    MEM[1344] = 32'h00000513;
    MEM[1345] = 32'h34402573;
    MEM[1346] = 32'h00008067;
    MEM[1347] = 32'h30051073;
    MEM[1348] = 32'h00008067;
    MEM[1349] = 32'h30551073;
    MEM[1350] = 32'h00008067;
    MEM[1351] = 32'h34151073;
    MEM[1352] = 32'h00008067;
    MEM[1353] = 32'h10551073;
    MEM[1354] = 32'h00008067;
    MEM[1355] = 32'h14151073;
    MEM[1356] = 32'h00008067;
    MEM[1357] = 32'h30451073;
    MEM[1358] = 32'h00008067;
    MEM[1359] = 32'h00050113;
    MEM[1360] = 32'h00008067;
    MEM[1361] = 32'h00058113;
    MEM[1362] = 32'h00050093;
    MEM[1363] = 32'h00000513;
    MEM[1364] = 32'h00000593;
    MEM[1365] = 32'h00000613;
    MEM[1366] = 32'h00008067;
    MEM[1367] = 32'h34051073;
    MEM[1368] = 32'h3405a073;
    MEM[1369] = 32'h34063073;
    MEM[1370] = 32'h00000513;
    MEM[1371] = 32'h34002573;
    MEM[1372] = 32'h00008067;
    MEM[1373] = 32'h00000069;
    MEM[1374] = 32'h00000065;
    MEM[1375] = 32'h75626564;
    MEM[1376] = 32'h6d203a67;
    MEM[1377] = 32'h406e6961;
    MEM[1378] = 32'h73207825;
    MEM[1379] = 32'h6b636174;
    MEM[1380] = 32'h0a782540;
    MEM[1381] = 32'h00000000;
    MEM[1382] = 32'h6d726473;
    MEM[1383] = 32'h70203a30;
    MEM[1384] = 32'h61706572;
    MEM[1385] = 32'h676e6972;
    MEM[1386] = 32'h52445320;
    MEM[1387] = 32'h6d204d41;
    MEM[1388] = 32'h726f6d65;
    MEM[1389] = 32'h64252079;
    MEM[1390] = 32'h74796220;
    MEM[1391] = 32'h2e2e7365;
    MEM[1392] = 32'h00000a2e;
    MEM[1393] = 32'h6d726473;
    MEM[1394] = 32'h63203a30;
    MEM[1395] = 32'h6b636568;
    MEM[1396] = 32'h20676e69;
    MEM[1397] = 32'h41524453;
    MEM[1398] = 32'h656d204d;
    MEM[1399] = 32'h79726f6d;
    MEM[1400] = 32'h20642520;
    MEM[1401] = 32'h65747962;
    MEM[1402] = 32'h2e2e2e73;
    MEM[1403] = 32'h0000000a;
    MEM[1404] = 32'h6d726473;
    MEM[1405] = 32'h74203a30;
    MEM[1406] = 32'h20747365;
    MEM[1407] = 32'h6c696166;
    MEM[1408] = 32'h61206465;
    MEM[1409] = 32'h78252074;
    MEM[1410] = 32'h0a78253a;
    MEM[1411] = 32'h00000000;
    MEM[1412] = 32'h6d726473;
    MEM[1413] = 32'h53203a30;
    MEM[1414] = 32'h4d415244;
    MEM[1415] = 32'h6e6f6420;
    MEM[1416] = 32'h72202c65;
    MEM[1417] = 32'h6f6f6265;
    MEM[1418] = 32'h676e6974;
    MEM[1419] = 32'h0a2e2e2e;
    MEM[1420] = 32'h00000000;
    MEM[1421] = 32'h78727363;
    MEM[1422] = 32'h63203a78;
    MEM[1423] = 32'h745f7273;
    MEM[1424] = 32'h3d747365;
    MEM[1425] = 32'h000a7825;
    MEM[1426] = 32'h78727363;
    MEM[1427] = 32'h6e203a78;
    MEM[1428] = 32'h6620746f;
    MEM[1429] = 32'h646e756f;
    MEM[1430] = 32'h00000a2e;
    MEM[1431] = 32'h65767473;
    MEM[1432] = 32'h68203a63;
    MEM[1433] = 32'h6c646e61;
    MEM[1434] = 32'h25407265;
    MEM[1435] = 32'h64202c78;
    MEM[1436] = 32'h67756265;
    MEM[1437] = 32'h616e6520;
    MEM[1438] = 32'h64656c62;
    MEM[1439] = 32'h0a2e2e2e;
    MEM[1440] = 32'h00000000;
    MEM[1441] = 32'h65767473;
    MEM[1442] = 32'h6e203a63;
    MEM[1443] = 32'h6620746f;
    MEM[1444] = 32'h646e756f;
    MEM[1445] = 32'h0000000a;
    MEM[1446] = 32'h6576746d;
    MEM[1447] = 32'h68203a63;
    MEM[1448] = 32'h6c646e61;
    MEM[1449] = 32'h25407265;
    MEM[1450] = 32'h65202c78;
    MEM[1451] = 32'h6c62616e;
    MEM[1452] = 32'h20676e69;
    MEM[1453] = 32'h65746e69;
    MEM[1454] = 32'h70757272;
    MEM[1455] = 32'h2e2e7374;
    MEM[1456] = 32'h00000a2e;
    MEM[1457] = 32'h6576746d;
    MEM[1458] = 32'h69203a63;
    MEM[1459] = 32'h7265746e;
    MEM[1460] = 32'h74707572;
    MEM[1461] = 32'h6e652073;
    MEM[1462] = 32'h656c6261;
    MEM[1463] = 32'h000a2164;
    MEM[1464] = 32'h6576746d;
    MEM[1465] = 32'h6e203a63;
    MEM[1466] = 32'h6620746f;
    MEM[1467] = 32'h646e756f;
    MEM[1468] = 32'h6f702820;
    MEM[1469] = 32'h6e696c6c;
    MEM[1470] = 32'h000a2967;
    MEM[1471] = 32'h72616f62;
    MEM[1472] = 32'h25203a64;
    MEM[1473] = 32'h69282073;
    MEM[1474] = 32'h64253d64;
    MEM[1475] = 32'h00000a29;
    MEM[1476] = 32'h32337672;
    MEM[1477] = 32'h697a5f65;
    MEM[1478] = 32'h00727363;
    MEM[1479] = 32'h2c756854;
    MEM[1480] = 32'h20363020;
    MEM[1481] = 32'h2072614d;
    MEM[1482] = 32'h35323032;
    MEM[1483] = 32'h3a393120;
    MEM[1484] = 32'h333a3633;
    MEM[1485] = 32'h302b2035;
    MEM[1486] = 32'h00303031;
    MEM[1487] = 32'h6c697562;
    MEM[1488] = 32'h25203a64;
    MEM[1489] = 32'h6f662073;
    MEM[1490] = 32'h73252072;
    MEM[1491] = 32'h0000000a;
    MEM[1492] = 32'h65726f63;
    MEM[1493] = 32'h203a6425;
    MEM[1494] = 32'h00000000;
    MEM[1495] = 32'h6b726164;
    MEM[1496] = 32'h63736972;
    MEM[1497] = 32'h64254076;
    MEM[1498] = 32'h207a484d;
    MEM[1499] = 32'h00202f77;
    MEM[1500] = 32'h32337672;
    MEM[1501] = 32'h00207325;
    MEM[1502] = 32'h2043414d;
    MEM[1503] = 32'h00000000;
    MEM[1504] = 32'h0000000a;
    MEM[1505] = 32'h6d617262;
    MEM[1506] = 32'h74203a30;
    MEM[1507] = 32'h40747865;
    MEM[1508] = 32'h252b7825;
    MEM[1509] = 32'h61642064;
    MEM[1510] = 32'h25406174;
    MEM[1511] = 32'h64252b78;
    MEM[1512] = 32'h61747320;
    MEM[1513] = 32'h25406b63;
    MEM[1514] = 32'h00000a78;
    MEM[1515] = 32'h6d617262;
    MEM[1516] = 32'h25203a30;
    MEM[1517] = 32'h79622064;
    MEM[1518] = 32'h20736574;
    MEM[1519] = 32'h65657266;
    MEM[1520] = 32'h0000000a;
    MEM[1521] = 32'h74726175;
    MEM[1522] = 32'h31203a30;
    MEM[1523] = 32'h322e3531;
    MEM[1524] = 32'h7370626b;
    MEM[1525] = 32'h69642820;
    MEM[1526] = 32'h64253d76;
    MEM[1527] = 32'h00000a29;
    MEM[1528] = 32'h726d6974;
    MEM[1529] = 32'h25203a30;
    MEM[1530] = 32'h207a4864;
    MEM[1531] = 32'h76696428;
    MEM[1532] = 32'h2964253d;
    MEM[1533] = 32'h0000000a;
    MEM[1534] = 32'h636c6557;
    MEM[1535] = 32'h20656d6f;
    MEM[1536] = 32'h44206f74;
    MEM[1537] = 32'h526b7261;
    MEM[1538] = 32'h56435349;
    MEM[1539] = 32'h000a0a21;
    MEM[1540] = 32'h203e6425;
    MEM[1541] = 32'h00000000;
    MEM[1542] = 32'h00000020;
    MEM[1543] = 32'h61656c63;
    MEM[1544] = 32'h00000072;
    MEM[1545] = 32'h1b485b1b;
    MEM[1546] = 32'h004a325b;
    MEM[1547] = 32'h706f7473;
    MEM[1548] = 32'h00000000;
    MEM[1549] = 32'h6f626572;
    MEM[1550] = 32'h0000746f;
    MEM[1551] = 32'h6576746d;
    MEM[1552] = 32'h69203a63;
    MEM[1553] = 32'h7265746e;
    MEM[1554] = 32'h74707572;
    MEM[1555] = 32'h69642073;
    MEM[1556] = 32'h6c626173;
    MEM[1557] = 32'h0a216465;
    MEM[1558] = 32'h00000000;
    MEM[1559] = 32'h6f626572;
    MEM[1560] = 32'h6e69746f;
    MEM[1561] = 32'h2e2e2e67;
    MEM[1562] = 32'h0000000a;
    MEM[1563] = 32'h706d7564;
    MEM[1564] = 32'h00000000;
    MEM[1565] = 32'h203a7825;
    MEM[1566] = 32'h00000000;
    MEM[1567] = 32'h00207825;
    MEM[1568] = 32'h00006472;
    MEM[1569] = 32'h00007277;
    MEM[1570] = 32'h0064656c;
    MEM[1571] = 32'h2064656c;
    MEM[1572] = 32'h7825203d;
    MEM[1573] = 32'h0000000a;
    MEM[1574] = 32'h656d6974;
    MEM[1575] = 32'h00000072;
    MEM[1576] = 32'h656d6974;
    MEM[1577] = 32'h203d2072;
    MEM[1578] = 32'h000a6425;
    MEM[1579] = 32'h6f697067;
    MEM[1580] = 32'h00000000;
    MEM[1581] = 32'h6f697067;
    MEM[1582] = 32'h25203d20;
    MEM[1583] = 32'h00000a78;
    MEM[1584] = 32'h006c756d;
    MEM[1585] = 32'h206c756d;
    MEM[1586] = 32'h6425203d;
    MEM[1587] = 32'h0000000a;
    MEM[1588] = 32'h00766964;
    MEM[1589] = 32'h20766964;
    MEM[1590] = 32'h6425203d;
    MEM[1591] = 32'h6f6d202c;
    MEM[1592] = 32'h203d2064;
    MEM[1593] = 32'h000a6425;
    MEM[1594] = 32'h0063616d;
    MEM[1595] = 32'h2063616d;
    MEM[1596] = 32'h6425203d;
    MEM[1597] = 32'h0000000a;
    MEM[1598] = 32'h69617273;
    MEM[1599] = 32'h00000000;
    MEM[1600] = 32'h69617273;
    MEM[1601] = 32'h20782520;
    MEM[1602] = 32'h31203e3e;
    MEM[1603] = 32'h25203d20;
    MEM[1604] = 32'h00000a78;
    MEM[1605] = 32'h6d6d6f63;
    MEM[1606] = 32'h3a646e61;
    MEM[1607] = 32'h73255b20;
    MEM[1608] = 32'h6f6e205d;
    MEM[1609] = 32'h6f662074;
    MEM[1610] = 32'h2e646e75;
    MEM[1611] = 32'h6c61760a;
    MEM[1612] = 32'h63206469;
    MEM[1613] = 32'h616d6d6f;
    MEM[1614] = 32'h3a73646e;
    MEM[1615] = 32'h656c6320;
    MEM[1616] = 32'h202c7261;
    MEM[1617] = 32'h706d7564;
    MEM[1618] = 32'h65685b20;
    MEM[1619] = 32'h202c5d78;
    MEM[1620] = 32'h2064656c;
    MEM[1621] = 32'h7865685b;
    MEM[1622] = 32'h74202c5d;
    MEM[1623] = 32'h72656d69;
    MEM[1624] = 32'h65645b20;
    MEM[1625] = 32'h202c5d63;
    MEM[1626] = 32'h6f697067;
    MEM[1627] = 32'h65685b20;
    MEM[1628] = 32'h200a5d78;
    MEM[1629] = 32'h20202020;
    MEM[1630] = 32'h20202020;
    MEM[1631] = 32'h20202020;
    MEM[1632] = 32'h6d202020;
    MEM[1633] = 32'h5b206c75;
    MEM[1634] = 32'h5d636564;
    MEM[1635] = 32'h65645b20;
    MEM[1636] = 32'h202c5d63;
    MEM[1637] = 32'h20766964;
    MEM[1638] = 32'h6365645b;
    MEM[1639] = 32'h645b205d;
    MEM[1640] = 32'h2c5d6365;
    MEM[1641] = 32'h63616d20;
    MEM[1642] = 32'h65645b20;
    MEM[1643] = 32'h5b205d63;
    MEM[1644] = 32'h5d636564;
    MEM[1645] = 32'h65645b20;
    MEM[1646] = 32'h200a5d63;
    MEM[1647] = 32'h20202020;
    MEM[1648] = 32'h20202020;
    MEM[1649] = 32'h20202020;
    MEM[1650] = 32'h72202020;
    MEM[1651] = 32'h6f6f6265;
    MEM[1652] = 32'h77202c74;
    MEM[1653] = 32'h5d6d5b72;
    MEM[1654] = 32'h6c77625b;
    MEM[1655] = 32'h685b205d;
    MEM[1656] = 32'h205d7865;
    MEM[1657] = 32'h7865685b;
    MEM[1658] = 32'h5b5b205d;
    MEM[1659] = 32'h5d786568;
    MEM[1660] = 32'h65687720;
    MEM[1661] = 32'h5d6d206e;
    MEM[1662] = 32'h20200a2c;
    MEM[1663] = 32'h20202020;
    MEM[1664] = 32'h20202020;
    MEM[1665] = 32'h20202020;
    MEM[1666] = 32'h64722020;
    MEM[1667] = 32'h5b5d6d5b;
    MEM[1668] = 32'h5d6c7762;
    MEM[1669] = 32'h65685b20;
    MEM[1670] = 32'h5b205d78;
    MEM[1671] = 32'h7865685b;
    MEM[1672] = 32'h6877205d;
    MEM[1673] = 32'h6d206e65;
    MEM[1674] = 32'h00000a5d;
    MEM[1675] = 32'h4c554e28;
    MEM[1676] = 32'h0000294c;
    MEM[1677] = 32'h33323130;
    MEM[1678] = 32'h37363534;
    MEM[1679] = 32'h62613938;
    MEM[1680] = 32'h66656463;
    MEM[1681] = 32'h00000000;
    MEM[1682] = 32'h6e6b6e75;
    MEM[1683] = 32'h006e776f;
    MEM[1684] = 32'h74736e69;
    MEM[1685] = 32'h74637572;
    MEM[1686] = 32'h206e6f69;
    MEM[1687] = 32'h72646461;
    MEM[1688] = 32'h20737365;
    MEM[1689] = 32'h67696c61;
    MEM[1690] = 32'h0000006e;
    MEM[1691] = 32'h75626564;
    MEM[1692] = 32'h2a203a67;
    MEM[1693] = 32'h65202a2a;
    MEM[1694] = 32'h70656378;
    MEM[1695] = 32'h6e6f6974;
    MEM[1696] = 32'h20746120;
    MEM[1697] = 32'h77207825;
    MEM[1698] = 32'h636d202f;
    MEM[1699] = 32'h65737561;
    MEM[1700] = 32'h2f78253d;
    MEM[1701] = 32'h5d73255b;
    MEM[1702] = 32'h2a2a2a20;
    MEM[1703] = 32'h0000000a;
    MEM[1704] = 32'h74736e69;
    MEM[1705] = 32'h74637572;
    MEM[1706] = 32'h206e6f69;
    MEM[1707] = 32'h61746164;
    MEM[1708] = 32'h75616620;
    MEM[1709] = 32'h0000746c;
    MEM[1710] = 32'h656c6c69;
    MEM[1711] = 32'h206c6167;
    MEM[1712] = 32'h74736e69;
    MEM[1713] = 32'h74637572;
    MEM[1714] = 32'h006e6f69;
    MEM[1715] = 32'h61657262;
    MEM[1716] = 32'h696f706b;
    MEM[1717] = 32'h0000746e;
    MEM[1718] = 32'h64616f6c;
    MEM[1719] = 32'h64646120;
    MEM[1720] = 32'h73736572;
    MEM[1721] = 32'h696c6120;
    MEM[1722] = 32'h00006e67;
    MEM[1723] = 32'h64616f6c;
    MEM[1724] = 32'h74616420;
    MEM[1725] = 32'h61662061;
    MEM[1726] = 32'h00746c75;
    MEM[1727] = 32'h726f7473;
    MEM[1728] = 32'h64612065;
    MEM[1729] = 32'h73657264;
    MEM[1730] = 32'h6c612073;
    MEM[1731] = 32'h006e6769;
    MEM[1732] = 32'h726f7473;
    MEM[1733] = 32'h61642065;
    MEM[1734] = 32'h66206174;
    MEM[1735] = 32'h746c7561;
    MEM[1736] = 32'h00000000;
    MEM[1737] = 32'h756d6973;
    MEM[1738] = 32'h6974616c;
    MEM[1739] = 32'h6f206e6f;
    MEM[1740] = 32'h00796c6e;
    MEM[1741] = 32'h656e7661;
    MEM[1742] = 32'h696d2074;
    MEM[1743] = 32'h626f7263;
    MEM[1744] = 32'h6472616f;
    MEM[1745] = 32'h39786c20;
    MEM[1746] = 32'h00000000;
    MEM[1747] = 32'h696c6978;
    MEM[1748] = 32'h6120786e;
    MEM[1749] = 32'h31303763;
    MEM[1750] = 32'h30326120;
    MEM[1751] = 32'h00000030;
    MEM[1752] = 32'h65746d71;
    MEM[1753] = 32'h73206863;
    MEM[1754] = 32'h6d617264;
    MEM[1755] = 32'h31786c20;
    MEM[1756] = 32'h00000036;
    MEM[1757] = 32'h65746d71;
    MEM[1758] = 32'h73206863;
    MEM[1759] = 32'h74726170;
    MEM[1760] = 32'h20376e61;
    MEM[1761] = 32'h00353173;
    MEM[1762] = 32'h7474616c;
    MEM[1763] = 32'h20656369;
    MEM[1764] = 32'h76657262;
    MEM[1765] = 32'h20326169;
    MEM[1766] = 32'h3270786c;
    MEM[1767] = 32'h00000000;
    MEM[1768] = 32'h77736970;
    MEM[1769] = 32'h7364726f;
    MEM[1770] = 32'h34737220;
    MEM[1771] = 32'h6c203538;
    MEM[1772] = 32'h00003978;
    MEM[1773] = 32'h69676964;
    MEM[1774] = 32'h746e656c;
    MEM[1775] = 32'h61707320;
    MEM[1776] = 32'h6e617472;
    MEM[1777] = 32'h32732033;
    MEM[1778] = 32'h00003030;
    MEM[1779] = 32'h65696c61;
    MEM[1780] = 32'h65727078;
    MEM[1781] = 32'h68207373;
    MEM[1782] = 32'h342f6370;
    MEM[1783] = 32'h65626730;
    MEM[1784] = 32'h32346b20;
    MEM[1785] = 32'h00000030;
    MEM[1786] = 32'h65746d71;
    MEM[1787] = 32'h61206863;
    MEM[1788] = 32'h78697472;
    MEM[1789] = 32'h33612037;
    MEM[1790] = 32'h00000035;
    MEM[1791] = 32'h65696c61;
    MEM[1792] = 32'h65727078;
    MEM[1793] = 32'h68207373;
    MEM[1794] = 32'h342f6370;
    MEM[1795] = 32'h65626730;
    MEM[1796] = 32'h30756b20;
    MEM[1797] = 32'h00003034;
    MEM[1798] = 32'h69706170;
    MEM[1799] = 32'h206f696c;
    MEM[1800] = 32'h206f7564;
    MEM[1801] = 32'h69676f6c;
    MEM[1802] = 32'h61747363;
    MEM[1803] = 32'h00007472;
    MEM[1804] = 32'h65746d71;
    MEM[1805] = 32'h6b206863;
    MEM[1806] = 32'h65746e69;
    MEM[1807] = 32'h20372d78;
    MEM[1808] = 32'h3532336b;
    MEM[1809] = 32'h00000000;
    MEM[1810] = 32'h72616373;
    MEM[1811] = 32'h6d206261;
    MEM[1812] = 32'h73696e69;
    MEM[1813] = 32'h74726170;
    MEM[1814] = 32'h2d366e61;
    MEM[1815] = 32'h73756c70;
    MEM[1816] = 32'h39786c20;
    MEM[1817] = 32'h00000000;
    MEM[1818] = 32'h7474616c;
    MEM[1819] = 32'h20656369;
    MEM[1820] = 32'h35706365;
    MEM[1821] = 32'h4635342d;
    MEM[1822] = 32'h6c6f6320;
    MEM[1823] = 32'h696c726f;
    MEM[1824] = 32'h69746867;
    MEM[1825] = 32'h00000039;
    MEM[1826] = 32'h7474616c;
    MEM[1827] = 32'h20656369;
    MEM[1828] = 32'h35706365;
    MEM[1829] = 32'h4635322d;
    MEM[1830] = 32'h6c6f6320;
    MEM[1831] = 32'h696c726f;
    MEM[1832] = 32'h69746867;
    MEM[1833] = 32'h00000035;
    MEM[1834] = 32'h7474616c;
    MEM[1835] = 32'h20656369;
    MEM[1836] = 32'h35706365;
    MEM[1837] = 32'h4635382d;
    MEM[1838] = 32'h786c7520;
    MEM[1839] = 32'h00007333;
    MEM[1840] = 32'h65746d71;
    MEM[1841] = 32'h63206863;
    MEM[1842] = 32'h6f6c6379;
    MEM[1843] = 32'h3120656e;
    MEM[1844] = 32'h20706c30;
    MEM[1845] = 32'h36313063;
    MEM[1846] = 32'h00000000;
    MEM[1847] = 32'h77736970;
    MEM[1848] = 32'h7364726f;
    MEM[1849] = 32'h33686320;
    MEM[1850] = 32'h6c207834;
    MEM[1851] = 32'h00363178;
    MEM[1852] = 32'h3178616d;
    MEM[1853] = 32'h20303030;
    MEM[1854] = 32'h3178616d;
    MEM[1855] = 32'h00000030;
    MEM[1856] = 32'h30316564;
    MEM[1857] = 32'h6f6e616e;
    MEM[1858] = 32'h63796320;
    MEM[1859] = 32'h656e6f6c;
    MEM[1860] = 32'h696d2076;
    MEM[1861] = 32'h72657473;
    MEM[1862] = 32'h00000000;
    MEM[1863] = 32'h00001b24;
    MEM[1864] = 32'h00001b34;
    MEM[1865] = 32'h00001b4c;
    MEM[1866] = 32'h00001b60;
    MEM[1867] = 32'h00001b74;
    MEM[1868] = 32'h00001b88;
    MEM[1869] = 32'h00001ba0;
    MEM[1870] = 32'h00001bb4;
    MEM[1871] = 32'h00001bcc;
    MEM[1872] = 32'h00001be8;
    MEM[1873] = 32'h00001bfc;
    MEM[1874] = 32'h00001c18;
    MEM[1875] = 32'h00001c30;
    MEM[1876] = 32'h00001c48;
    MEM[1877] = 32'h00001c68;
    MEM[1878] = 32'h00001c88;
    MEM[1879] = 32'h00001ca8;
    MEM[1880] = 32'h00001cc0;
    MEM[1881] = 32'h00001cdc;
    MEM[1882] = 32'h00001cf0;
    MEM[1883] = 32'h00001d00;
    MEM[1884] = 32'h00001aa0;
    MEM[1885] = 32'h00001ab8;
    MEM[1886] = 32'h00001acc;
    MEM[1887] = 32'h00001ad8;
    MEM[1888] = 32'h00001aec;
    MEM[1889] = 32'h00001afc;
    MEM[1890] = 32'h00001b10;
    MEM[1891] = 32'h00000000;
    MEM[1892] = 32'h00000000;
    MEM[1893] = 32'h00000001;
    MEM[1894] = 32'h40000000;
    MEM[1895] = 32'h00002641;
    MEM[1896] = 32'h73697200;
    MEM[1897] = 32'h01007663;
    MEM[1898] = 32'h0000001c;
    MEM[1899] = 32'h33767205;
    MEM[1900] = 32'h70316532;
    MEM[1901] = 32'h697a5f39;
    MEM[1902] = 32'h32727363;
    MEM[1903] = 32'h08003070;
    MEM[1904] = 32'h000b0a01;
    MEM[1905] = 32'h00000000;
    MEM[1906] = 32'h0000258c;
    MEM[1907] = 32'h00000200;
    MEM[1908] = 32'h00002000;
    MEM[1909] = 32'hffffffff;
    MEM[1910] = 32'h00000000;
    MEM[1911] = 32'h3a434347;
    MEM[1912] = 32'h4e472820;
    MEM[1913] = 32'h31202955;
    MEM[1914] = 32'h2e302e35;
    MEM[1915] = 32'h30322031;
    MEM[1916] = 32'h32303532;
    MEM[1917] = 32'h28203430;
    MEM[1918] = 32'h65707865;
    MEM[1919] = 32'h656d6972;
    MEM[1920] = 32'h6c61746e;
    MEM[1921] = 32'h24410029;
    MEM[1922] = 32'h72000000;
    MEM[1923] = 32'h76637369;
    MEM[1924] = 32'h001a0100;
    MEM[1925] = 32'h04040000;
    MEM[1926] = 32'h33767205;
    MEM[1927] = 32'h70326532;
    MEM[1928] = 32'h697a5f30;
    MEM[1929] = 32'h32727363;
    MEM[1930] = 32'h41003070;
    MEM[1931] = 32'h00000024;
    MEM[1932] = 32'h63736972;
    MEM[1933] = 32'h1a010076;
    MEM[1934] = 32'h04000000;
    MEM[1935] = 32'h76720504;
    MEM[1936] = 32'h32653233;
    MEM[1937] = 32'h7a5f3070;
    MEM[1938] = 32'h72736369;
    MEM[1939] = 32'h00307032;
    MEM[1940] = 32'h00002841;
    MEM[1941] = 32'h73697200;
    MEM[1942] = 32'h01007663;
    MEM[1943] = 32'h0000001e;
    MEM[1944] = 32'h72050404;
    MEM[1945] = 32'h65323376;
    MEM[1946] = 32'h5f307032;
    MEM[1947] = 32'h7363697a;
    MEM[1948] = 32'h30703272;
    MEM[1949] = 32'h0a010800;
    MEM[1950] = 32'h0024410b;
    MEM[1951] = 32'h69720000;
    MEM[1952] = 32'h00766373;
    MEM[1953] = 32'h00001a01;
    MEM[1954] = 32'h05040400;
    MEM[1955] = 32'h32337672;
    MEM[1956] = 32'h30703265;
    MEM[1957] = 32'h63697a5f;
    MEM[1958] = 32'h70327273;
    MEM[1959] = 32'h24410030;
    MEM[1960] = 32'h72000000;
    MEM[1961] = 32'h76637369;
    MEM[1962] = 32'h001a0100;
    MEM[1963] = 32'h04040000;
    MEM[1964] = 32'h33767205;
    MEM[1965] = 32'h70326532;
    MEM[1966] = 32'h697a5f30;
    MEM[1967] = 32'h32727363;
    MEM[1968] = 32'h41003070;
    MEM[1969] = 32'h00000026;
    MEM[1970] = 32'h63736972;
    MEM[1971] = 32'h1c010076;
    MEM[1972] = 32'h05000000;
    MEM[1973] = 32'h32337672;
    MEM[1974] = 32'h39703165;
    MEM[1975] = 32'h63697a5f;
    MEM[1976] = 32'h70327273;
    MEM[1977] = 32'h01080030;
    MEM[1978] = 32'h00000b0a;

    `ifdef XILINX_SIMULATOR
        //$readmemh("darksocv.mem",MEM);
	`elsif MODEL_TECH
	    //$readmemh("../../../../src/darksocv.mem",MEM);
    `else
        //$readmemh("../src/darksocv.mem",MEM,0);
    `endif
    end

    // instruction memory
`ifdef __HARVARD__
`ifdef __ICACHE__

    reg [3:0]  ITACK  = 0;
    reg [31:0] ROMFF  = 0;

    always@(posedge CLK)
    begin
    `ifdef __WAITSTATE__        
        ITACK <= RES ? 0 : ITACK ? ITACK-1 : IDREQ ? `__WAITSTATE__ : 0;
    `else
        ITACK <= RES ? 0 : ITACK ? ITACK-1 : IDREQ ? 1 : 0;
    `endif    
    
        ROMFF <= MEM[IADDR[`MLEN-1:2]];
    end

    assign IDATA = ROMFF;
    assign IDACK = ITACK==1;

`else

    reg [3:0]  ITACK  = 0;
    reg [31:0] ROMFF  = 0;

    always@(posedge CLK)
    begin
    `ifdef __WAITSTATE__
        ITACK <= RES ? 0 : ITACK ? ITACK-1 : IDREQ ? `__WAITSTATE__ : 0; // i-bus wait-state
    `endif

        ROMFF <= MEM[IADDR[`MLEN-1:2]];
        // if(!RES && !HLT) $display("bram: addr=%x inst=%x\n",IADDR,ROMFF);
    end

    assign IDATA = ROMFF;
    
    `ifdef __WAITSTATE__
        assign IDACK = ITACK==1;
    `else
        assign IDACK = IDREQ;
    `endif

`endif
`endif

    // data memory

    reg [3:0] DTACK  = 0;

    always@(posedge CLK) // stage #1.0
    begin
    `ifdef __RMW_CYCLE__    
        `ifdef __WAITSTATE__
            DTACK <= RES ? 0 : DTACK ? DTACK-1 : XDREQ && (XRD||XWR) ? `__WAITSTATE__ : 0;
        `else
            DTACK <= RES ? 0 : DTACK ? DTACK-1 : XDREQ && (XRD||XWR) ? 1 : 0;
        `endif
    `else
        `ifdef __WAITSTATE__
            DTACK <= RES ? 0 : DTACK ? DTACK-1 : XDREQ && XRD ? `__WAITSTATE__ : 0;
        `else
            DTACK <= RES ? 0 : DTACK ? DTACK-1 : XDREQ && XRD ? 1 : 0;
        `endif
    `endif
    end

    la_spram #(.DW(32), .AW(`MLEN-2)) dataram (
        .clk(CLK),
        .ce(1'b1),
        .we(XWR && XDREQ),
        .wmask({{8{XBE[3]}}, {8{XBE[2]}}, {8{XBE[1]}}, {8{XBE[0]}}}),
        .addr(XADDR[`MLEN-1:2]),
        .din(XATAI),
        .dout(XATAO)
    );

`ifdef __RMW_CYCLE__    
    assign XDACK = DTACK==1;
`else
    assign XDACK = DTACK==1 ||(XDREQ&&XWR);
`endif
	 
    assign DEBUG = { XDREQ,XRD,XWR,XDACK };

endmodule
