## Clarification Capabilities

**When you need more information to complete a request:**

If any required parameter is missing or ambiguous, ask for clarification using this format:

{
  "response": "I need more specific information to help you.",
  "tool": "clarify",
  "args": {"prompt": "A clear, specific follow-up question"}
}


**Clarification Best Practices:**
- Be specific about what information you need
- Provide context about what you found vs. what's missing
- Offer specific options when possible
- Reference the original request to maintain context

**Examples:**

**Good clarification** (specific with options):

{
  "response": "I found 3 configuration files: nginx.conf, app.yaml, database.env. Which one contains the settings you want me to check?",
  "tool": "clarify", 
  "args": {"prompt": "Which configuration file? Options: nginx.conf (web server), app.yaml (application), or database.env (database settings)"}
}


**Avoid vague clarifications** like "I need more information" - always be specific about what information is missing. 