# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CloudforceOneRequestAssetArgs', 'CloudforceOneRequestAsset']

@pulumi.input_type
class CloudforceOneRequestAssetArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 page: pulumi.Input[_builtins.int],
                 per_page: pulumi.Input[_builtins.int],
                 request_id: pulumi.Input[_builtins.str],
                 source: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CloudforceOneRequestAsset resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.int] page: Page number of results.
        :param pulumi.Input[_builtins.int] per_page: Number of results per page.
        :param pulumi.Input[_builtins.str] request_id: UUID.
        :param pulumi.Input[_builtins.str] source: Asset file to upload.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "page", page)
        pulumi.set(__self__, "per_page", per_page)
        pulumi.set(__self__, "request_id", request_id)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def page(self) -> pulumi.Input[_builtins.int]:
        """
        Page number of results.
        """
        return pulumi.get(self, "page")

    @page.setter
    def page(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "page", value)

    @_builtins.property
    @pulumi.getter(name="perPage")
    def per_page(self) -> pulumi.Input[_builtins.int]:
        """
        Number of results per page.
        """
        return pulumi.get(self, "per_page")

    @per_page.setter
    def per_page(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "per_page", value)

    @_builtins.property
    @pulumi.getter(name="requestId")
    def request_id(self) -> pulumi.Input[_builtins.str]:
        """
        UUID.
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "request_id", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Asset file to upload.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class _CloudforceOneRequestAssetState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 page: Optional[pulumi.Input[_builtins.int]] = None,
                 per_page: Optional[pulumi.Input[_builtins.int]] = None,
                 request_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CloudforceOneRequestAsset resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] created: Defines the asset creation time.
        :param pulumi.Input[_builtins.str] description: Asset description.
        :param pulumi.Input[_builtins.str] file_type: Asset file type.
        :param pulumi.Input[_builtins.str] name: Asset name.
        :param pulumi.Input[_builtins.int] page: Page number of results.
        :param pulumi.Input[_builtins.int] per_page: Number of results per page.
        :param pulumi.Input[_builtins.str] request_id: UUID.
        :param pulumi.Input[_builtins.str] source: Asset file to upload.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_type is not None:
            pulumi.set(__self__, "file_type", file_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if page is not None:
            pulumi.set(__self__, "page", page)
        if per_page is not None:
            pulumi.set(__self__, "per_page", per_page)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the asset creation time.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Asset description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="fileType")
    def file_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Asset file type.
        """
        return pulumi.get(self, "file_type")

    @file_type.setter
    def file_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Asset name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def page(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Page number of results.
        """
        return pulumi.get(self, "page")

    @page.setter
    def page(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "page", value)

    @_builtins.property
    @pulumi.getter(name="perPage")
    def per_page(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of results per page.
        """
        return pulumi.get(self, "per_page")

    @per_page.setter
    def per_page(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "per_page", value)

    @_builtins.property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID.
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_id", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Asset file to upload.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)


@pulumi.type_token("cloudflare:index/cloudforceOneRequestAsset:CloudforceOneRequestAsset")
class CloudforceOneRequestAsset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 page: Optional[pulumi.Input[_builtins.int]] = None,
                 per_page: Optional[pulumi.Input[_builtins.int]] = None,
                 request_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_cloudforce_one_request_asset = cloudflare.CloudforceOneRequestAsset("example_cloudforce_one_request_asset",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            request_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
            page=0,
            per_page=10)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/cloudforceOneRequestAsset:CloudforceOneRequestAsset example '<account_id>/<request_id>/<asset_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.int] page: Page number of results.
        :param pulumi.Input[_builtins.int] per_page: Number of results per page.
        :param pulumi.Input[_builtins.str] request_id: UUID.
        :param pulumi.Input[_builtins.str] source: Asset file to upload.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudforceOneRequestAssetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_cloudforce_one_request_asset = cloudflare.CloudforceOneRequestAsset("example_cloudforce_one_request_asset",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            request_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
            page=0,
            per_page=10)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/cloudforceOneRequestAsset:CloudforceOneRequestAsset example '<account_id>/<request_id>/<asset_id>'
        ```

        :param str resource_name: The name of the resource.
        :param CloudforceOneRequestAssetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudforceOneRequestAssetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 page: Optional[pulumi.Input[_builtins.int]] = None,
                 per_page: Optional[pulumi.Input[_builtins.int]] = None,
                 request_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudforceOneRequestAssetArgs.__new__(CloudforceOneRequestAssetArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if page is None and not opts.urn:
                raise TypeError("Missing required property 'page'")
            __props__.__dict__["page"] = page
            if per_page is None and not opts.urn:
                raise TypeError("Missing required property 'per_page'")
            __props__.__dict__["per_page"] = per_page
            if request_id is None and not opts.urn:
                raise TypeError("Missing required property 'request_id'")
            __props__.__dict__["request_id"] = request_id
            __props__.__dict__["source"] = source
            __props__.__dict__["created"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["file_type"] = None
            __props__.__dict__["name"] = None
        super(CloudforceOneRequestAsset, __self__).__init__(
            'cloudflare:index/cloudforceOneRequestAsset:CloudforceOneRequestAsset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            file_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            page: Optional[pulumi.Input[_builtins.int]] = None,
            per_page: Optional[pulumi.Input[_builtins.int]] = None,
            request_id: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None) -> 'CloudforceOneRequestAsset':
        """
        Get an existing CloudforceOneRequestAsset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] created: Defines the asset creation time.
        :param pulumi.Input[_builtins.str] description: Asset description.
        :param pulumi.Input[_builtins.str] file_type: Asset file type.
        :param pulumi.Input[_builtins.str] name: Asset name.
        :param pulumi.Input[_builtins.int] page: Page number of results.
        :param pulumi.Input[_builtins.int] per_page: Number of results per page.
        :param pulumi.Input[_builtins.str] request_id: UUID.
        :param pulumi.Input[_builtins.str] source: Asset file to upload.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudforceOneRequestAssetState.__new__(_CloudforceOneRequestAssetState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["created"] = created
        __props__.__dict__["description"] = description
        __props__.__dict__["file_type"] = file_type
        __props__.__dict__["name"] = name
        __props__.__dict__["page"] = page
        __props__.__dict__["per_page"] = per_page
        __props__.__dict__["request_id"] = request_id
        __props__.__dict__["source"] = source
        return CloudforceOneRequestAsset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        Defines the asset creation time.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Asset description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="fileType")
    def file_type(self) -> pulumi.Output[_builtins.str]:
        """
        Asset file type.
        """
        return pulumi.get(self, "file_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Asset name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def page(self) -> pulumi.Output[_builtins.int]:
        """
        Page number of results.
        """
        return pulumi.get(self, "page")

    @_builtins.property
    @pulumi.getter(name="perPage")
    def per_page(self) -> pulumi.Output[_builtins.int]:
        """
        Number of results per page.
        """
        return pulumi.get(self, "per_page")

    @_builtins.property
    @pulumi.getter(name="requestId")
    def request_id(self) -> pulumi.Output[_builtins.str]:
        """
        UUID.
        """
        return pulumi.get(self, "request_id")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Asset file to upload.
        """
        return pulumi.get(self, "source")

