# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAccountPermissionGroupResult',
    'AwaitableGetAccountPermissionGroupResult',
    'get_account_permission_group',
    'get_account_permission_group_output',
]

@pulumi.output_type
class GetAccountPermissionGroupResult:
    """
    A collection of values returned by getAccountPermissionGroup.
    """
    def __init__(__self__, account_id=None, id=None, meta=None, name=None, permission_group_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if meta and not isinstance(meta, dict):
            raise TypeError("Expected argument 'meta' to be a dict")
        pulumi.set(__self__, "meta", meta)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if permission_group_id and not isinstance(permission_group_id, str):
            raise TypeError("Expected argument 'permission_group_id' to be a str")
        pulumi.set(__self__, "permission_group_id", permission_group_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier of the permission group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> 'outputs.GetAccountPermissionGroupMetaResult':
        """
        Attributes associated to the permission group.
        """
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the permission group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="permissionGroupId")
    def permission_group_id(self) -> _builtins.str:
        """
        Permission Group identifier tag.
        """
        return pulumi.get(self, "permission_group_id")


class AwaitableGetAccountPermissionGroupResult(GetAccountPermissionGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountPermissionGroupResult(
            account_id=self.account_id,
            id=self.id,
            meta=self.meta,
            name=self.name,
            permission_group_id=self.permission_group_id)


def get_account_permission_group(account_id: Optional[_builtins.str] = None,
                                 permission_group_id: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountPermissionGroupResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_permission_group = cloudflare.get_account_permission_group(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        permission_group_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str account_id: Account identifier tag.
    :param _builtins.str permission_group_id: Permission Group identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['permissionGroupId'] = permission_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getAccountPermissionGroup:getAccountPermissionGroup', __args__, opts=opts, typ=GetAccountPermissionGroupResult).value

    return AwaitableGetAccountPermissionGroupResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        meta=pulumi.get(__ret__, 'meta'),
        name=pulumi.get(__ret__, 'name'),
        permission_group_id=pulumi.get(__ret__, 'permission_group_id'))
def get_account_permission_group_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                        permission_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountPermissionGroupResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_permission_group = cloudflare.get_account_permission_group(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        permission_group_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str account_id: Account identifier tag.
    :param _builtins.str permission_group_id: Permission Group identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['permissionGroupId'] = permission_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getAccountPermissionGroup:getAccountPermissionGroup', __args__, opts=opts, typ=GetAccountPermissionGroupResult)
    return __ret__.apply(lambda __response__: GetAccountPermissionGroupResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        meta=pulumi.get(__response__, 'meta'),
        name=pulumi.get(__response__, 'name'),
        permission_group_id=pulumi.get(__response__, 'permission_group_id')))
