# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetApiShieldOperationResult',
    'AwaitableGetApiShieldOperationResult',
    'get_api_shield_operation',
    'get_api_shield_operation_output',
]

@pulumi.output_type
class GetApiShieldOperationResult:
    """
    A collection of values returned by getApiShieldOperation.
    """
    def __init__(__self__, endpoint=None, feature=None, features=None, filter=None, host=None, id=None, last_updated=None, method=None, operation_id=None, zone_id=None):
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if feature and not isinstance(feature, list):
            raise TypeError("Expected argument 'feature' to be a list")
        pulumi.set(__self__, "feature", feature)
        if features and not isinstance(features, dict):
            raise TypeError("Expected argument 'features' to be a dict")
        pulumi.set(__self__, "features", features)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if host and not isinstance(host, str):
            raise TypeError("Expected argument 'host' to be a str")
        pulumi.set(__self__, "host", host)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated and not isinstance(last_updated, str):
            raise TypeError("Expected argument 'last_updated' to be a str")
        pulumi.set(__self__, "last_updated", last_updated)
        if method and not isinstance(method, str):
            raise TypeError("Expected argument 'method' to be a str")
        pulumi.set(__self__, "method", method)
        if operation_id and not isinstance(operation_id, str):
            raise TypeError("Expected argument 'operation_id' to be a str")
        pulumi.set(__self__, "operation_id", operation_id)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The endpoint which can contain path parameter templates in curly braces, each will be replaced from left to right with {varN}, starting with {var1}, during insertion. This will further be Cloudflare-normalized upon insertion. See: https://developers.cloudflare.com/rules/normalization/how-it-works/.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def feature(self) -> Optional[Sequence[_builtins.str]]:
        """
        Add feature(s) to the results. The feature name that is given here corresponds to the resulting feature object. Have a look at the top-level object description for more details on the specific meaning.
        """
        return pulumi.get(self, "feature")

    @_builtins.property
    @pulumi.getter
    def features(self) -> 'outputs.GetApiShieldOperationFeaturesResult':
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetApiShieldOperationFilterResult']:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        RFC3986-compliant host.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> _builtins.str:
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        The HTTP method used to access the endpoint.
        Available values: "GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "CONNECT", "PATCH", "TRACE".
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> _builtins.str:
        """
        UUID.
        """
        return pulumi.get(self, "operation_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetApiShieldOperationResult(GetApiShieldOperationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiShieldOperationResult(
            endpoint=self.endpoint,
            feature=self.feature,
            features=self.features,
            filter=self.filter,
            host=self.host,
            id=self.id,
            last_updated=self.last_updated,
            method=self.method,
            operation_id=self.operation_id,
            zone_id=self.zone_id)


def get_api_shield_operation(feature: Optional[Sequence[_builtins.str]] = None,
                             filter: Optional[Union['GetApiShieldOperationFilterArgs', 'GetApiShieldOperationFilterArgsDict']] = None,
                             operation_id: Optional[_builtins.str] = None,
                             zone_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiShieldOperationResult:
    """
    ## Example Usage


    :param Sequence[_builtins.str] feature: Add feature(s) to the results. The feature name that is given here corresponds to the resulting feature object. Have a look at the top-level object description for more details on the specific meaning.
    :param _builtins.str operation_id: UUID.
    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['feature'] = feature
    __args__['filter'] = filter
    __args__['operationId'] = operation_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getApiShieldOperation:getApiShieldOperation', __args__, opts=opts, typ=GetApiShieldOperationResult).value

    return AwaitableGetApiShieldOperationResult(
        endpoint=pulumi.get(__ret__, 'endpoint'),
        feature=pulumi.get(__ret__, 'feature'),
        features=pulumi.get(__ret__, 'features'),
        filter=pulumi.get(__ret__, 'filter'),
        host=pulumi.get(__ret__, 'host'),
        id=pulumi.get(__ret__, 'id'),
        last_updated=pulumi.get(__ret__, 'last_updated'),
        method=pulumi.get(__ret__, 'method'),
        operation_id=pulumi.get(__ret__, 'operation_id'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_api_shield_operation_output(feature: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                    filter: Optional[pulumi.Input[Optional[Union['GetApiShieldOperationFilterArgs', 'GetApiShieldOperationFilterArgsDict']]]] = None,
                                    operation_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiShieldOperationResult]:
    """
    ## Example Usage


    :param Sequence[_builtins.str] feature: Add feature(s) to the results. The feature name that is given here corresponds to the resulting feature object. Have a look at the top-level object description for more details on the specific meaning.
    :param _builtins.str operation_id: UUID.
    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['feature'] = feature
    __args__['filter'] = filter
    __args__['operationId'] = operation_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getApiShieldOperation:getApiShieldOperation', __args__, opts=opts, typ=GetApiShieldOperationResult)
    return __ret__.apply(lambda __response__: GetApiShieldOperationResult(
        endpoint=pulumi.get(__response__, 'endpoint'),
        feature=pulumi.get(__response__, 'feature'),
        features=pulumi.get(__response__, 'features'),
        filter=pulumi.get(__response__, 'filter'),
        host=pulumi.get(__response__, 'host'),
        id=pulumi.get(__response__, 'id'),
        last_updated=pulumi.get(__response__, 'last_updated'),
        method=pulumi.get(__response__, 'method'),
        operation_id=pulumi.get(__response__, 'operation_id'),
        zone_id=pulumi.get(__response__, 'zone_id')))
