# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetApiTokenPermissionGroupsListResult',
    'AwaitableGetApiTokenPermissionGroupsListResult',
    'get_api_token_permission_groups_list',
    'get_api_token_permission_groups_list_output',
]

@pulumi.output_type
class GetApiTokenPermissionGroupsListResult:
    """
    A collection of values returned by getApiTokenPermissionGroupsList.
    """
    def __init__(__self__, id=None, max_items=None, name=None, results=None, scope=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Filter by the name of the permission group.
        The value must be URL-encoded.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetApiTokenPermissionGroupsListResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        Filter by the scope of the permission group.
        The value must be URL-encoded.
        """
        return pulumi.get(self, "scope")


class AwaitableGetApiTokenPermissionGroupsListResult(GetApiTokenPermissionGroupsListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiTokenPermissionGroupsListResult(
            id=self.id,
            max_items=self.max_items,
            name=self.name,
            results=self.results,
            scope=self.scope)


def get_api_token_permission_groups_list(max_items: Optional[_builtins.int] = None,
                                         name: Optional[_builtins.str] = None,
                                         scope: Optional[_builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiTokenPermissionGroupsListResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_api_token_permission_groups_list = cloudflare.get_api_token_permission_groups_list(name="Account%20Settings%20Write",
        scope="com.cloudflare.api.account.zone")
    ```


    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str name: Filter by the name of the permission group.
           The value must be URL-encoded.
    :param _builtins.str scope: Filter by the scope of the permission group.
           The value must be URL-encoded.
    """
    __args__ = dict()
    __args__['maxItems'] = max_items
    __args__['name'] = name
    __args__['scope'] = scope
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getApiTokenPermissionGroupsList:getApiTokenPermissionGroupsList', __args__, opts=opts, typ=GetApiTokenPermissionGroupsListResult).value

    return AwaitableGetApiTokenPermissionGroupsListResult(
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        name=pulumi.get(__ret__, 'name'),
        results=pulumi.get(__ret__, 'results'),
        scope=pulumi.get(__ret__, 'scope'))
def get_api_token_permission_groups_list_output(max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                                name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                scope: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiTokenPermissionGroupsListResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_api_token_permission_groups_list = cloudflare.get_api_token_permission_groups_list(name="Account%20Settings%20Write",
        scope="com.cloudflare.api.account.zone")
    ```


    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str name: Filter by the name of the permission group.
           The value must be URL-encoded.
    :param _builtins.str scope: Filter by the scope of the permission group.
           The value must be URL-encoded.
    """
    __args__ = dict()
    __args__['maxItems'] = max_items
    __args__['name'] = name
    __args__['scope'] = scope
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getApiTokenPermissionGroupsList:getApiTokenPermissionGroupsList', __args__, opts=opts, typ=GetApiTokenPermissionGroupsListResult)
    return __ret__.apply(lambda __response__: GetApiTokenPermissionGroupsListResult(
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        name=pulumi.get(__response__, 'name'),
        results=pulumi.get(__response__, 'results'),
        scope=pulumi.get(__response__, 'scope')))
