# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetCustomPagesResult',
    'AwaitableGetCustomPagesResult',
    'get_custom_pages',
    'get_custom_pages_output',
]

@pulumi.output_type
class GetCustomPagesResult:
    """
    A collection of values returned by getCustomPages.
    """
    def __init__(__self__, account_id=None, created_on=None, description=None, id=None, identifier=None, modified_on=None, preview_target=None, required_tokens=None, state=None, url=None, zone_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if preview_target and not isinstance(preview_target, str):
            raise TypeError("Expected argument 'preview_target' to be a str")
        pulumi.set(__self__, "preview_target", preview_target)
        if required_tokens and not isinstance(required_tokens, list):
            raise TypeError("Expected argument 'required_tokens' to be a list")
        pulumi.set(__self__, "required_tokens", required_tokens)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> _builtins.str:
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        Error Page Types
        Available values: "under*attack", "basic*challenge", "waf*challenge", "waf*block", "ip*block", "country*challenge", "500*errors", "1000*errors", "managed*challenge", "ratelimit*block".
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> _builtins.str:
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter(name="previewTarget")
    def preview_target(self) -> _builtins.str:
        return pulumi.get(self, "preview_target")

    @_builtins.property
    @pulumi.getter(name="requiredTokens")
    def required_tokens(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "required_tokens")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The custom page state.
        Available values: "default", "customized".
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL associated with the custom page.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetCustomPagesResult(GetCustomPagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomPagesResult(
            account_id=self.account_id,
            created_on=self.created_on,
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            modified_on=self.modified_on,
            preview_target=self.preview_target,
            required_tokens=self.required_tokens,
            state=self.state,
            url=self.url,
            zone_id=self.zone_id)


def get_custom_pages(account_id: Optional[_builtins.str] = None,
                     identifier: Optional[_builtins.str] = None,
                     zone_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomPagesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_custom_pages = cloudflare.get_custom_pages(identifier="ratelimit_block",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param _builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param _builtins.str identifier: Error Page Types
           Available values: "under*attack", "basic*challenge", "waf*challenge", "waf*block", "ip*block", "country*challenge", "500*errors", "1000*errors", "managed*challenge", "ratelimit*block".
    :param _builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['identifier'] = identifier
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getCustomPages:getCustomPages', __args__, opts=opts, typ=GetCustomPagesResult).value

    return AwaitableGetCustomPagesResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        created_on=pulumi.get(__ret__, 'created_on'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        preview_target=pulumi.get(__ret__, 'preview_target'),
        required_tokens=pulumi.get(__ret__, 'required_tokens'),
        state=pulumi.get(__ret__, 'state'),
        url=pulumi.get(__ret__, 'url'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_custom_pages_output(account_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            identifier: Optional[pulumi.Input[_builtins.str]] = None,
                            zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCustomPagesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_custom_pages = cloudflare.get_custom_pages(identifier="ratelimit_block",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param _builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param _builtins.str identifier: Error Page Types
           Available values: "under*attack", "basic*challenge", "waf*challenge", "waf*block", "ip*block", "country*challenge", "500*errors", "1000*errors", "managed*challenge", "ratelimit*block".
    :param _builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['identifier'] = identifier
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getCustomPages:getCustomPages', __args__, opts=opts, typ=GetCustomPagesResult)
    return __ret__.apply(lambda __response__: GetCustomPagesResult(
        account_id=pulumi.get(__response__, 'account_id'),
        created_on=pulumi.get(__response__, 'created_on'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        preview_target=pulumi.get(__response__, 'preview_target'),
        required_tokens=pulumi.get(__response__, 'required_tokens'),
        state=pulumi.get(__response__, 'state'),
        url=pulumi.get(__response__, 'url'),
        zone_id=pulumi.get(__response__, 'zone_id')))
