# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEmailSecurityTrustedDomainsResult',
    'AwaitableGetEmailSecurityTrustedDomainsResult',
    'get_email_security_trusted_domains',
    'get_email_security_trusted_domains_output',
]

@pulumi.output_type
class GetEmailSecurityTrustedDomainsResult:
    """
    A collection of values returned by getEmailSecurityTrustedDomains.
    """
    def __init__(__self__, account_id=None, comments=None, created_at=None, filter=None, id=None, is_recent=None, is_regex=None, is_similarity=None, last_modified=None, pattern=None, trusted_domain_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if comments and not isinstance(comments, str):
            raise TypeError("Expected argument 'comments' to be a str")
        pulumi.set(__self__, "comments", comments)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if is_recent and not isinstance(is_recent, bool):
            raise TypeError("Expected argument 'is_recent' to be a bool")
        pulumi.set(__self__, "is_recent", is_recent)
        if is_regex and not isinstance(is_regex, bool):
            raise TypeError("Expected argument 'is_regex' to be a bool")
        pulumi.set(__self__, "is_regex", is_regex)
        if is_similarity and not isinstance(is_similarity, bool):
            raise TypeError("Expected argument 'is_similarity' to be a bool")
        pulumi.set(__self__, "is_similarity", is_similarity)
        if last_modified and not isinstance(last_modified, str):
            raise TypeError("Expected argument 'last_modified' to be a str")
        pulumi.set(__self__, "last_modified", last_modified)
        if pattern and not isinstance(pattern, str):
            raise TypeError("Expected argument 'pattern' to be a str")
        pulumi.set(__self__, "pattern", pattern)
        if trusted_domain_id and not isinstance(trusted_domain_id, int):
            raise TypeError("Expected argument 'trusted_domain_id' to be a int")
        pulumi.set(__self__, "trusted_domain_id", trusted_domain_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Account Identifier
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def comments(self) -> _builtins.str:
        return pulumi.get(self, "comments")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetEmailSecurityTrustedDomainsFilterResult']:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The unique identifier for the trusted domain.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isRecent")
    def is_recent(self) -> _builtins.bool:
        """
        Select to prevent recently registered domains from triggering a
        Suspicious or Malicious disposition.
        """
        return pulumi.get(self, "is_recent")

    @_builtins.property
    @pulumi.getter(name="isRegex")
    def is_regex(self) -> _builtins.bool:
        return pulumi.get(self, "is_regex")

    @_builtins.property
    @pulumi.getter(name="isSimilarity")
    def is_similarity(self) -> _builtins.bool:
        """
        Select for partner or other approved domains that have similar
        spelling to your connected domains. Prevents listed domains from
        triggering a Spoof disposition.
        """
        return pulumi.get(self, "is_similarity")

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> _builtins.str:
        return pulumi.get(self, "last_modified")

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> _builtins.str:
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter(name="trustedDomainId")
    def trusted_domain_id(self) -> Optional[_builtins.int]:
        """
        The unique identifier for the trusted domain.
        """
        return pulumi.get(self, "trusted_domain_id")


class AwaitableGetEmailSecurityTrustedDomainsResult(GetEmailSecurityTrustedDomainsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEmailSecurityTrustedDomainsResult(
            account_id=self.account_id,
            comments=self.comments,
            created_at=self.created_at,
            filter=self.filter,
            id=self.id,
            is_recent=self.is_recent,
            is_regex=self.is_regex,
            is_similarity=self.is_similarity,
            last_modified=self.last_modified,
            pattern=self.pattern,
            trusted_domain_id=self.trusted_domain_id)


def get_email_security_trusted_domains(account_id: Optional[_builtins.str] = None,
                                       filter: Optional[Union['GetEmailSecurityTrustedDomainsFilterArgs', 'GetEmailSecurityTrustedDomainsFilterArgsDict']] = None,
                                       trusted_domain_id: Optional[_builtins.int] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEmailSecurityTrustedDomainsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_email_security_trusted_domains = cloudflare.get_email_security_trusted_domains(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        trusted_domain_id=2401)
    ```


    :param _builtins.str account_id: Account Identifier
    :param _builtins.int trusted_domain_id: The unique identifier for the trusted domain.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['trustedDomainId'] = trusted_domain_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getEmailSecurityTrustedDomains:getEmailSecurityTrustedDomains', __args__, opts=opts, typ=GetEmailSecurityTrustedDomainsResult).value

    return AwaitableGetEmailSecurityTrustedDomainsResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        comments=pulumi.get(__ret__, 'comments'),
        created_at=pulumi.get(__ret__, 'created_at'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        is_recent=pulumi.get(__ret__, 'is_recent'),
        is_regex=pulumi.get(__ret__, 'is_regex'),
        is_similarity=pulumi.get(__ret__, 'is_similarity'),
        last_modified=pulumi.get(__ret__, 'last_modified'),
        pattern=pulumi.get(__ret__, 'pattern'),
        trusted_domain_id=pulumi.get(__ret__, 'trusted_domain_id'))
def get_email_security_trusted_domains_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                              filter: Optional[pulumi.Input[Optional[Union['GetEmailSecurityTrustedDomainsFilterArgs', 'GetEmailSecurityTrustedDomainsFilterArgsDict']]]] = None,
                                              trusted_domain_id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEmailSecurityTrustedDomainsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_email_security_trusted_domains = cloudflare.get_email_security_trusted_domains(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        trusted_domain_id=2401)
    ```


    :param _builtins.str account_id: Account Identifier
    :param _builtins.int trusted_domain_id: The unique identifier for the trusted domain.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['trustedDomainId'] = trusted_domain_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getEmailSecurityTrustedDomains:getEmailSecurityTrustedDomains', __args__, opts=opts, typ=GetEmailSecurityTrustedDomainsResult)
    return __ret__.apply(lambda __response__: GetEmailSecurityTrustedDomainsResult(
        account_id=pulumi.get(__response__, 'account_id'),
        comments=pulumi.get(__response__, 'comments'),
        created_at=pulumi.get(__response__, 'created_at'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        is_recent=pulumi.get(__response__, 'is_recent'),
        is_regex=pulumi.get(__response__, 'is_regex'),
        is_similarity=pulumi.get(__response__, 'is_similarity'),
        last_modified=pulumi.get(__response__, 'last_modified'),
        pattern=pulumi.get(__response__, 'pattern'),
        trusted_domain_id=pulumi.get(__response__, 'trusted_domain_id')))
