# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetHostnameTlsSettingResult',
    'AwaitableGetHostnameTlsSettingResult',
    'get_hostname_tls_setting',
    'get_hostname_tls_setting_output',
]

@pulumi.output_type
class GetHostnameTlsSettingResult:
    """
    A collection of values returned by getHostnameTlsSetting.
    """
    def __init__(__self__, created_at=None, hostname=None, id=None, setting_id=None, status=None, updated_at=None, value=None, zone_id=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if setting_id and not isinstance(setting_id, str):
            raise TypeError("Expected argument 'setting_id' to be a str")
        pulumi.set(__self__, "setting_id", setting_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if value and not isinstance(value, float):
            raise TypeError("Expected argument 'value' to be a float")
        pulumi.set(__self__, "value", value)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        This is the time the tls setting was originally created for this hostname.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname for which the tls settings are set.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="settingId")
    def setting_id(self) -> _builtins.str:
        """
        The TLS Setting name.
        Available values: "ciphers", "min*tls*version", "http2".
        """
        return pulumi.get(self, "setting_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Deployment status for the given tls setting.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        This is the time the tls setting was updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        """
        The tls setting value.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetHostnameTlsSettingResult(GetHostnameTlsSettingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostnameTlsSettingResult(
            created_at=self.created_at,
            hostname=self.hostname,
            id=self.id,
            setting_id=self.setting_id,
            status=self.status,
            updated_at=self.updated_at,
            value=self.value,
            zone_id=self.zone_id)


def get_hostname_tls_setting(setting_id: Optional[_builtins.str] = None,
                             zone_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostnameTlsSettingResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_hostname_tls_setting = cloudflare.get_hostname_tls_setting(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        setting_id="ciphers")
    ```


    :param _builtins.str setting_id: The TLS Setting name.
           Available values: "ciphers", "min*tls*version", "http2".
    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['settingId'] = setting_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getHostnameTlsSetting:getHostnameTlsSetting', __args__, opts=opts, typ=GetHostnameTlsSettingResult).value

    return AwaitableGetHostnameTlsSettingResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        setting_id=pulumi.get(__ret__, 'setting_id'),
        status=pulumi.get(__ret__, 'status'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        value=pulumi.get(__ret__, 'value'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_hostname_tls_setting_output(setting_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHostnameTlsSettingResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_hostname_tls_setting = cloudflare.get_hostname_tls_setting(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        setting_id="ciphers")
    ```


    :param _builtins.str setting_id: The TLS Setting name.
           Available values: "ciphers", "min*tls*version", "http2".
    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['settingId'] = setting_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getHostnameTlsSetting:getHostnameTlsSetting', __args__, opts=opts, typ=GetHostnameTlsSettingResult)
    return __ret__.apply(lambda __response__: GetHostnameTlsSettingResult(
        created_at=pulumi.get(__response__, 'created_at'),
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        setting_id=pulumi.get(__response__, 'setting_id'),
        status=pulumi.get(__response__, 'status'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        value=pulumi.get(__response__, 'value'),
        zone_id=pulumi.get(__response__, 'zone_id')))
