# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetKeylessCertificateResult',
    'AwaitableGetKeylessCertificateResult',
    'get_keyless_certificate',
    'get_keyless_certificate_output',
]

@pulumi.output_type
class GetKeylessCertificateResult:
    """
    A collection of values returned by getKeylessCertificate.
    """
    def __init__(__self__, created_on=None, enabled=None, host=None, id=None, keyless_certificate_id=None, modified_on=None, name=None, permissions=None, port=None, status=None, tunnel=None, zone_id=None):
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if host and not isinstance(host, str):
            raise TypeError("Expected argument 'host' to be a str")
        pulumi.set(__self__, "host", host)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if keyless_certificate_id and not isinstance(keyless_certificate_id, str):
            raise TypeError("Expected argument 'keyless_certificate_id' to be a str")
        pulumi.set(__self__, "keyless_certificate_id", keyless_certificate_id)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)
        if port and not isinstance(port, float):
            raise TypeError("Expected argument 'port' to be a float")
        pulumi.set(__self__, "port", port)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tunnel and not isinstance(tunnel, dict):
            raise TypeError("Expected argument 'tunnel' to be a dict")
        pulumi.set(__self__, "tunnel", tunnel)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> _builtins.str:
        """
        When the Keyless SSL was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether or not the Keyless SSL is on or off.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The keyless SSL name.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keylessCertificateId")
    def keyless_certificate_id(self) -> Optional[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "keyless_certificate_id")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> _builtins.str:
        """
        When the Keyless SSL was last modified.
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The keyless SSL name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Sequence[_builtins.str]:
        """
        Available permissions for the Keyless SSL for the current user requesting the item.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.float:
        """
        The keyless SSL port used to communicate between Cloudflare and the client's Keyless SSL server.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the Keyless SSL.
        Available values: "active", "deleted".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tunnel(self) -> 'outputs.GetKeylessCertificateTunnelResult':
        """
        Configuration for using Keyless SSL through a Cloudflare Tunnel
        """
        return pulumi.get(self, "tunnel")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetKeylessCertificateResult(GetKeylessCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeylessCertificateResult(
            created_on=self.created_on,
            enabled=self.enabled,
            host=self.host,
            id=self.id,
            keyless_certificate_id=self.keyless_certificate_id,
            modified_on=self.modified_on,
            name=self.name,
            permissions=self.permissions,
            port=self.port,
            status=self.status,
            tunnel=self.tunnel,
            zone_id=self.zone_id)


def get_keyless_certificate(keyless_certificate_id: Optional[_builtins.str] = None,
                            zone_id: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeylessCertificateResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_keyless_certificate = cloudflare.get_keyless_certificate(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        keyless_certificate_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str keyless_certificate_id: Identifier.
    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['keylessCertificateId'] = keyless_certificate_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getKeylessCertificate:getKeylessCertificate', __args__, opts=opts, typ=GetKeylessCertificateResult).value

    return AwaitableGetKeylessCertificateResult(
        created_on=pulumi.get(__ret__, 'created_on'),
        enabled=pulumi.get(__ret__, 'enabled'),
        host=pulumi.get(__ret__, 'host'),
        id=pulumi.get(__ret__, 'id'),
        keyless_certificate_id=pulumi.get(__ret__, 'keyless_certificate_id'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        name=pulumi.get(__ret__, 'name'),
        permissions=pulumi.get(__ret__, 'permissions'),
        port=pulumi.get(__ret__, 'port'),
        status=pulumi.get(__ret__, 'status'),
        tunnel=pulumi.get(__ret__, 'tunnel'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_keyless_certificate_output(keyless_certificate_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeylessCertificateResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_keyless_certificate = cloudflare.get_keyless_certificate(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        keyless_certificate_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str keyless_certificate_id: Identifier.
    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['keylessCertificateId'] = keyless_certificate_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getKeylessCertificate:getKeylessCertificate', __args__, opts=opts, typ=GetKeylessCertificateResult)
    return __ret__.apply(lambda __response__: GetKeylessCertificateResult(
        created_on=pulumi.get(__response__, 'created_on'),
        enabled=pulumi.get(__response__, 'enabled'),
        host=pulumi.get(__response__, 'host'),
        id=pulumi.get(__response__, 'id'),
        keyless_certificate_id=pulumi.get(__response__, 'keyless_certificate_id'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        name=pulumi.get(__response__, 'name'),
        permissions=pulumi.get(__response__, 'permissions'),
        port=pulumi.get(__response__, 'port'),
        status=pulumi.get(__response__, 'status'),
        tunnel=pulumi.get(__response__, 'tunnel'),
        zone_id=pulumi.get(__response__, 'zone_id')))
