# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetListItemsResult',
    'AwaitableGetListItemsResult',
    'get_list_items',
    'get_list_items_output',
]

@pulumi.output_type
class GetListItemsResult:
    """
    A collection of values returned by getListItems.
    """
    def __init__(__self__, account_id=None, id=None, list_id=None, max_items=None, per_page=None, results=None, search=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if list_id and not isinstance(list_id, str):
            raise TypeError("Expected argument 'list_id' to be a str")
        pulumi.set(__self__, "list_id", list_id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if per_page and not isinstance(per_page, int):
            raise TypeError("Expected argument 'per_page' to be a int")
        pulumi.set(__self__, "per_page", per_page)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if search and not isinstance(search, str):
            raise TypeError("Expected argument 'search' to be a str")
        pulumi.set(__self__, "search", search)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The Account ID for this resource.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="listId")
    def list_id(self) -> _builtins.str:
        """
        The unique ID of the list.
        """
        return pulumi.get(self, "list_id")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter(name="perPage")
    def per_page(self) -> Optional[_builtins.int]:
        """
        Amount of results to include in each paginated response. A non-negative 32 bit integer.
        """
        return pulumi.get(self, "per_page")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetListItemsResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter
    def search(self) -> Optional[_builtins.str]:
        """
        A search query to filter returned items. Its meaning depends on the list type: IP addresses must start with the provided string, hostnames and bulk redirects must contain the string, and ASNs must match the string exactly.
        """
        return pulumi.get(self, "search")


class AwaitableGetListItemsResult(GetListItemsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListItemsResult(
            account_id=self.account_id,
            id=self.id,
            list_id=self.list_id,
            max_items=self.max_items,
            per_page=self.per_page,
            results=self.results,
            search=self.search)


def get_list_items(account_id: Optional[_builtins.str] = None,
                   list_id: Optional[_builtins.str] = None,
                   max_items: Optional[_builtins.int] = None,
                   per_page: Optional[_builtins.int] = None,
                   search: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListItemsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_list_items = cloudflare.get_list_items(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        list_id="2c0fc9fa937b11eaa1b71c4d701ab86e",
        per_page=1,
        search="1.1.1.")
    ```


    :param _builtins.str account_id: The Account ID for this resource.
    :param _builtins.str list_id: The unique ID of the list.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.int per_page: Amount of results to include in each paginated response. A non-negative 32 bit integer.
    :param _builtins.str search: A search query to filter returned items. Its meaning depends on the list type: IP addresses must start with the provided string, hostnames and bulk redirects must contain the string, and ASNs must match the string exactly.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['listId'] = list_id
    __args__['maxItems'] = max_items
    __args__['perPage'] = per_page
    __args__['search'] = search
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getListItems:getListItems', __args__, opts=opts, typ=GetListItemsResult).value

    return AwaitableGetListItemsResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        list_id=pulumi.get(__ret__, 'list_id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        per_page=pulumi.get(__ret__, 'per_page'),
        results=pulumi.get(__ret__, 'results'),
        search=pulumi.get(__ret__, 'search'))
def get_list_items_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                          list_id: Optional[pulumi.Input[_builtins.str]] = None,
                          max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                          per_page: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                          search: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetListItemsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_list_items = cloudflare.get_list_items(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        list_id="2c0fc9fa937b11eaa1b71c4d701ab86e",
        per_page=1,
        search="1.1.1.")
    ```


    :param _builtins.str account_id: The Account ID for this resource.
    :param _builtins.str list_id: The unique ID of the list.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.int per_page: Amount of results to include in each paginated response. A non-negative 32 bit integer.
    :param _builtins.str search: A search query to filter returned items. Its meaning depends on the list type: IP addresses must start with the provided string, hostnames and bulk redirects must contain the string, and ASNs must match the string exactly.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['listId'] = list_id
    __args__['maxItems'] = max_items
    __args__['perPage'] = per_page
    __args__['search'] = search
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getListItems:getListItems', __args__, opts=opts, typ=GetListItemsResult)
    return __ret__.apply(lambda __response__: GetListItemsResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        list_id=pulumi.get(__response__, 'list_id'),
        max_items=pulumi.get(__response__, 'max_items'),
        per_page=pulumi.get(__response__, 'per_page'),
        results=pulumi.get(__response__, 'results'),
        search=pulumi.get(__response__, 'search')))
