# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLoadBalancerPoolResult',
    'AwaitableGetLoadBalancerPoolResult',
    'get_load_balancer_pool',
    'get_load_balancer_pool_output',
]

@pulumi.output_type
class GetLoadBalancerPoolResult:
    """
    A collection of values returned by getLoadBalancerPool.
    """
    def __init__(__self__, account_id=None, check_regions=None, created_on=None, description=None, disabled_at=None, enabled=None, filter=None, id=None, latitude=None, load_shedding=None, longitude=None, minimum_origins=None, modified_on=None, monitor=None, name=None, networks=None, notification_email=None, notification_filter=None, origin_steering=None, origins=None, pool_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if check_regions and not isinstance(check_regions, list):
            raise TypeError("Expected argument 'check_regions' to be a list")
        pulumi.set(__self__, "check_regions", check_regions)
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if disabled_at and not isinstance(disabled_at, str):
            raise TypeError("Expected argument 'disabled_at' to be a str")
        pulumi.set(__self__, "disabled_at", disabled_at)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if latitude and not isinstance(latitude, float):
            raise TypeError("Expected argument 'latitude' to be a float")
        pulumi.set(__self__, "latitude", latitude)
        if load_shedding and not isinstance(load_shedding, dict):
            raise TypeError("Expected argument 'load_shedding' to be a dict")
        pulumi.set(__self__, "load_shedding", load_shedding)
        if longitude and not isinstance(longitude, float):
            raise TypeError("Expected argument 'longitude' to be a float")
        pulumi.set(__self__, "longitude", longitude)
        if minimum_origins and not isinstance(minimum_origins, int):
            raise TypeError("Expected argument 'minimum_origins' to be a int")
        pulumi.set(__self__, "minimum_origins", minimum_origins)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if monitor and not isinstance(monitor, str):
            raise TypeError("Expected argument 'monitor' to be a str")
        pulumi.set(__self__, "monitor", monitor)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if networks and not isinstance(networks, list):
            raise TypeError("Expected argument 'networks' to be a list")
        pulumi.set(__self__, "networks", networks)
        if notification_email and not isinstance(notification_email, str):
            raise TypeError("Expected argument 'notification_email' to be a str")
        pulumi.set(__self__, "notification_email", notification_email)
        if notification_filter and not isinstance(notification_filter, dict):
            raise TypeError("Expected argument 'notification_filter' to be a dict")
        pulumi.set(__self__, "notification_filter", notification_filter)
        if origin_steering and not isinstance(origin_steering, dict):
            raise TypeError("Expected argument 'origin_steering' to be a dict")
        pulumi.set(__self__, "origin_steering", origin_steering)
        if origins and not isinstance(origins, list):
            raise TypeError("Expected argument 'origins' to be a list")
        pulumi.set(__self__, "origins", origins)
        if pool_id and not isinstance(pool_id, str):
            raise TypeError("Expected argument 'pool_id' to be a str")
        pulumi.set(__self__, "pool_id", pool_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="checkRegions")
    def check_regions(self) -> Sequence[_builtins.str]:
        """
        A list of regions from which to run health checks. Null means every Cloudflare data center.
        """
        return pulumi.get(self, "check_regions")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> _builtins.str:
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A human-readable description of the pool.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disabledAt")
    def disabled_at(self) -> _builtins.str:
        """
        This field shows up only if the pool is disabled. This field is set with the time the pool was disabled at.
        """
        return pulumi.get(self, "disabled_at")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether to enable (the default) or disable this pool. Disabled pools will not receive traffic and are excluded from health checks. Disabling a pool will cause any load balancers using it to failover to the next pool (if any).
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetLoadBalancerPoolFilterResult']:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def latitude(self) -> _builtins.float:
        """
        The latitude of the data center containing the origins used in this pool in decimal degrees. If this is set, longitude must also be set.
        """
        return pulumi.get(self, "latitude")

    @_builtins.property
    @pulumi.getter(name="loadShedding")
    def load_shedding(self) -> 'outputs.GetLoadBalancerPoolLoadSheddingResult':
        """
        Configures load shedding policies and percentages for the pool.
        """
        return pulumi.get(self, "load_shedding")

    @_builtins.property
    @pulumi.getter
    def longitude(self) -> _builtins.float:
        """
        The longitude of the data center containing the origins used in this pool in decimal degrees. If this is set, latitude must also be set.
        """
        return pulumi.get(self, "longitude")

    @_builtins.property
    @pulumi.getter(name="minimumOrigins")
    def minimum_origins(self) -> _builtins.int:
        """
        The minimum number of origins that must be healthy for this pool to serve traffic. If the number of healthy origins falls below this number, the pool will be marked unhealthy and will failover to the next available pool.
        """
        return pulumi.get(self, "minimum_origins")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> _builtins.str:
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> _builtins.str:
        """
        The ID of the Monitor to use for checking the health of origins within this pool.
        """
        return pulumi.get(self, "monitor")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A short name (tag) for the pool. Only alphanumeric characters, hyphens, and underscores are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Sequence[_builtins.str]:
        """
        List of networks where Load Balancer or Pool is enabled.
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter(name="notificationEmail")
    def notification_email(self) -> _builtins.str:
        """
        This field is now deprecated. It has been moved to Cloudflare's Centralized Notification service https://developers.cloudflare.com/fundamentals/notifications/. The email address to send health status notifications to. This can be an individual mailbox or a mailing list. Multiple emails can be supplied as a comma delimited list.
        """
        return pulumi.get(self, "notification_email")

    @_builtins.property
    @pulumi.getter(name="notificationFilter")
    def notification_filter(self) -> 'outputs.GetLoadBalancerPoolNotificationFilterResult':
        """
        Filter pool and origin health notifications by resource type or health status. Use null to reset.
        """
        return pulumi.get(self, "notification_filter")

    @_builtins.property
    @pulumi.getter(name="originSteering")
    def origin_steering(self) -> 'outputs.GetLoadBalancerPoolOriginSteeringResult':
        """
        Configures origin steering for the pool. Controls how origins are selected for new sessions and traffic without session affinity.
        """
        return pulumi.get(self, "origin_steering")

    @_builtins.property
    @pulumi.getter
    def origins(self) -> Sequence['outputs.GetLoadBalancerPoolOriginResult']:
        """
        The list of origins within this pool. Traffic directed at this pool is balanced across all currently healthy origins, provided the pool itself is healthy.
        """
        return pulumi.get(self, "origins")

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "pool_id")


class AwaitableGetLoadBalancerPoolResult(GetLoadBalancerPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoadBalancerPoolResult(
            account_id=self.account_id,
            check_regions=self.check_regions,
            created_on=self.created_on,
            description=self.description,
            disabled_at=self.disabled_at,
            enabled=self.enabled,
            filter=self.filter,
            id=self.id,
            latitude=self.latitude,
            load_shedding=self.load_shedding,
            longitude=self.longitude,
            minimum_origins=self.minimum_origins,
            modified_on=self.modified_on,
            monitor=self.monitor,
            name=self.name,
            networks=self.networks,
            notification_email=self.notification_email,
            notification_filter=self.notification_filter,
            origin_steering=self.origin_steering,
            origins=self.origins,
            pool_id=self.pool_id)


def get_load_balancer_pool(account_id: Optional[_builtins.str] = None,
                           filter: Optional[Union['GetLoadBalancerPoolFilterArgs', 'GetLoadBalancerPoolFilterArgsDict']] = None,
                           pool_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoadBalancerPoolResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_load_balancer_pool = cloudflare.get_load_balancer_pool(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        pool_id="17b5962d775c646f3f9725cbc7a53df4")
    ```


    :param _builtins.str account_id: Identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['poolId'] = pool_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getLoadBalancerPool:getLoadBalancerPool', __args__, opts=opts, typ=GetLoadBalancerPoolResult).value

    return AwaitableGetLoadBalancerPoolResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        check_regions=pulumi.get(__ret__, 'check_regions'),
        created_on=pulumi.get(__ret__, 'created_on'),
        description=pulumi.get(__ret__, 'description'),
        disabled_at=pulumi.get(__ret__, 'disabled_at'),
        enabled=pulumi.get(__ret__, 'enabled'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        latitude=pulumi.get(__ret__, 'latitude'),
        load_shedding=pulumi.get(__ret__, 'load_shedding'),
        longitude=pulumi.get(__ret__, 'longitude'),
        minimum_origins=pulumi.get(__ret__, 'minimum_origins'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        monitor=pulumi.get(__ret__, 'monitor'),
        name=pulumi.get(__ret__, 'name'),
        networks=pulumi.get(__ret__, 'networks'),
        notification_email=pulumi.get(__ret__, 'notification_email'),
        notification_filter=pulumi.get(__ret__, 'notification_filter'),
        origin_steering=pulumi.get(__ret__, 'origin_steering'),
        origins=pulumi.get(__ret__, 'origins'),
        pool_id=pulumi.get(__ret__, 'pool_id'))
def get_load_balancer_pool_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  filter: Optional[pulumi.Input[Optional[Union['GetLoadBalancerPoolFilterArgs', 'GetLoadBalancerPoolFilterArgsDict']]]] = None,
                                  pool_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLoadBalancerPoolResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_load_balancer_pool = cloudflare.get_load_balancer_pool(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        pool_id="17b5962d775c646f3f9725cbc7a53df4")
    ```


    :param _builtins.str account_id: Identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['poolId'] = pool_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getLoadBalancerPool:getLoadBalancerPool', __args__, opts=opts, typ=GetLoadBalancerPoolResult)
    return __ret__.apply(lambda __response__: GetLoadBalancerPoolResult(
        account_id=pulumi.get(__response__, 'account_id'),
        check_regions=pulumi.get(__response__, 'check_regions'),
        created_on=pulumi.get(__response__, 'created_on'),
        description=pulumi.get(__response__, 'description'),
        disabled_at=pulumi.get(__response__, 'disabled_at'),
        enabled=pulumi.get(__response__, 'enabled'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        latitude=pulumi.get(__response__, 'latitude'),
        load_shedding=pulumi.get(__response__, 'load_shedding'),
        longitude=pulumi.get(__response__, 'longitude'),
        minimum_origins=pulumi.get(__response__, 'minimum_origins'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        monitor=pulumi.get(__response__, 'monitor'),
        name=pulumi.get(__response__, 'name'),
        networks=pulumi.get(__response__, 'networks'),
        notification_email=pulumi.get(__response__, 'notification_email'),
        notification_filter=pulumi.get(__response__, 'notification_filter'),
        origin_steering=pulumi.get(__response__, 'origin_steering'),
        origins=pulumi.get(__response__, 'origins'),
        pool_id=pulumi.get(__response__, 'pool_id')))
