# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetLogpushDatasetJobResult',
    'AwaitableGetLogpushDatasetJobResult',
    'get_logpush_dataset_job',
    'get_logpush_dataset_job_output',
]

@pulumi.output_type
class GetLogpushDatasetJobResult:
    """
    A collection of values returned by getLogpushDatasetJob.
    """
    def __init__(__self__, account_id=None, dataset=None, dataset_id=None, destination_conf=None, enabled=None, error_message=None, frequency=None, id=None, kind=None, last_complete=None, last_error=None, logpull_options=None, max_upload_bytes=None, max_upload_interval_seconds=None, max_upload_records=None, name=None, output_options=None, zone_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if dataset and not isinstance(dataset, str):
            raise TypeError("Expected argument 'dataset' to be a str")
        pulumi.set(__self__, "dataset", dataset)
        if dataset_id and not isinstance(dataset_id, str):
            raise TypeError("Expected argument 'dataset_id' to be a str")
        pulumi.set(__self__, "dataset_id", dataset_id)
        if destination_conf and not isinstance(destination_conf, str):
            raise TypeError("Expected argument 'destination_conf' to be a str")
        pulumi.set(__self__, "destination_conf", destination_conf)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if error_message and not isinstance(error_message, str):
            raise TypeError("Expected argument 'error_message' to be a str")
        pulumi.set(__self__, "error_message", error_message)
        if frequency and not isinstance(frequency, str):
            raise TypeError("Expected argument 'frequency' to be a str")
        pulumi.set(__self__, "frequency", frequency)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if last_complete and not isinstance(last_complete, str):
            raise TypeError("Expected argument 'last_complete' to be a str")
        pulumi.set(__self__, "last_complete", last_complete)
        if last_error and not isinstance(last_error, str):
            raise TypeError("Expected argument 'last_error' to be a str")
        pulumi.set(__self__, "last_error", last_error)
        if logpull_options and not isinstance(logpull_options, str):
            raise TypeError("Expected argument 'logpull_options' to be a str")
        pulumi.set(__self__, "logpull_options", logpull_options)
        if max_upload_bytes and not isinstance(max_upload_bytes, int):
            raise TypeError("Expected argument 'max_upload_bytes' to be a int")
        pulumi.set(__self__, "max_upload_bytes", max_upload_bytes)
        if max_upload_interval_seconds and not isinstance(max_upload_interval_seconds, int):
            raise TypeError("Expected argument 'max_upload_interval_seconds' to be a int")
        pulumi.set(__self__, "max_upload_interval_seconds", max_upload_interval_seconds)
        if max_upload_records and not isinstance(max_upload_records, int):
            raise TypeError("Expected argument 'max_upload_records' to be a int")
        pulumi.set(__self__, "max_upload_records", max_upload_records)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if output_options and not isinstance(output_options, dict):
            raise TypeError("Expected argument 'output_options' to be a dict")
        pulumi.set(__self__, "output_options", output_options)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> _builtins.str:
        """
        Name of the dataset. A list of supported datasets can be found on the [Developer Docs](https://developers.cloudflare.com/logs/reference/log-fields/).
        Available values: "access*requests", "audit*logs", "audit*logs*v2", "biso*user*actions", "casb*findings", "device*posture*results", "dlp*forensic*copies", "dns*firewall*logs", "dns*logs", "email*security*alerts", "firewall*events", "gateway*dns", "gateway*http", "gateway*network", "http*requests", "magic*ids*detections", "nel*reports", "network*analytics*logs", "page*shield*events", "sinkhole*http*logs", "spectrum*events", "ssh*logs", "workers*trace*events", "zaraz*events", "zero*trust*network*sessions".
        """
        return pulumi.get(self, "dataset")

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> _builtins.str:
        """
        Name of the dataset. A list of supported datasets can be found on the [Developer Docs](https://developers.cloudflare.com/logs/reference/log-fields/).
        Available values: "access*requests", "audit*logs", "audit*logs*v2", "biso*user*actions", "casb*findings", "device*posture*results", "dlp*forensic*copies", "dns*firewall*logs", "dns*logs", "email*security*alerts", "firewall*events", "gateway*dns", "gateway*http", "gateway*network", "http*requests", "magic*ids*detections", "nel*reports", "network*analytics*logs", "page*shield*events", "sinkhole*http*logs", "spectrum*events", "ssh*logs", "workers*trace*events", "zaraz*events", "zero*trust*network*sessions".
        """
        return pulumi.get(self, "dataset_id")

    @_builtins.property
    @pulumi.getter(name="destinationConf")
    def destination_conf(self) -> _builtins.str:
        """
        Uniquely identifies a resource (such as an s3 bucket) where data. will be pushed. Additional configuration parameters supported by the destination may be included.
        """
        return pulumi.get(self, "destination_conf")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Flag that indicates if the job is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> _builtins.str:
        """
        If not null, the job is currently failing. Failures are usually. repetitive (example: no permissions to write to destination bucket). Only the last failure is recorded. On successful execution of a job the error*message and last*error are set to null.
        """
        return pulumi.get(self, "error_message")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def frequency(self) -> _builtins.str:
        """
        This field is deprecated. Please use `max_upload_*` parameters instead. . The frequency at which Cloudflare sends batches of logs to your destination. Setting frequency to high sends your logs in larger quantities of smaller files. Setting frequency to low sends logs in smaller quantities of larger files.
        Available values: "high", "low".
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        Unique id of the job.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The kind parameter (optional) is used to differentiate between Logpush and Edge Log Delivery jobs (when supported by the dataset).
        Available values: "", "edge".
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="lastComplete")
    def last_complete(self) -> _builtins.str:
        """
        Records the last time for which logs have been successfully pushed. If the last successful push was for logs range 2018-07-23T10:00:00Z to 2018-07-23T10:01:00Z then the value of this field will be 2018-07-23T10:01:00Z. If the job has never run or has just been enabled and hasn't run yet then the field will be empty.
        """
        return pulumi.get(self, "last_complete")

    @_builtins.property
    @pulumi.getter(name="lastError")
    def last_error(self) -> _builtins.str:
        """
        Records the last time the job failed. If not null, the job is currently. failing. If null, the job has either never failed or has run successfully at least once since last failure. See also the error_message field.
        """
        return pulumi.get(self, "last_error")

    @_builtins.property
    @pulumi.getter(name="logpullOptions")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def logpull_options(self) -> _builtins.str:
        """
        This field is deprecated. Use `output_options` instead. Configuration string. It specifies things like requested fields and timestamp formats. If migrating from the logpull api, copy the url (full url or just the query string) of your call here, and logpush will keep on making this call for you, setting start and end times appropriately.
        """
        return pulumi.get(self, "logpull_options")

    @_builtins.property
    @pulumi.getter(name="maxUploadBytes")
    def max_upload_bytes(self) -> _builtins.int:
        """
        The maximum uncompressed file size of a batch of logs. This setting value must be between `5 MB` and `1 GB`, or `0` to disable it. Note that you cannot set a minimum file size; this means that log files may be much smaller than this batch size.
        """
        return pulumi.get(self, "max_upload_bytes")

    @_builtins.property
    @pulumi.getter(name="maxUploadIntervalSeconds")
    def max_upload_interval_seconds(self) -> _builtins.int:
        """
        The maximum interval in seconds for log batches. This setting must be between 30 and 300 seconds (5 minutes), or `0` to disable it. Note that you cannot specify a minimum interval for log batches; this means that log files may be sent in shorter intervals than this.
        """
        return pulumi.get(self, "max_upload_interval_seconds")

    @_builtins.property
    @pulumi.getter(name="maxUploadRecords")
    def max_upload_records(self) -> _builtins.int:
        """
        The maximum number of log lines per batch. This setting must be between 1000 and 1,000,000 lines, or `0` to disable it. Note that you cannot specify a minimum number of log lines per batch; this means that log files may contain many fewer lines than this.
        """
        return pulumi.get(self, "max_upload_records")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Optional human readable job name. Not unique. Cloudflare suggests. that you set this to a meaningful string, like the domain name, to make it easier to identify your job.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outputOptions")
    def output_options(self) -> 'outputs.GetLogpushDatasetJobOutputOptionsResult':
        """
        The structured replacement for `logpull_options`. When including this field, the `logpull_option` field will be ignored.
        """
        return pulumi.get(self, "output_options")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetLogpushDatasetJobResult(GetLogpushDatasetJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogpushDatasetJobResult(
            account_id=self.account_id,
            dataset=self.dataset,
            dataset_id=self.dataset_id,
            destination_conf=self.destination_conf,
            enabled=self.enabled,
            error_message=self.error_message,
            frequency=self.frequency,
            id=self.id,
            kind=self.kind,
            last_complete=self.last_complete,
            last_error=self.last_error,
            logpull_options=self.logpull_options,
            max_upload_bytes=self.max_upload_bytes,
            max_upload_interval_seconds=self.max_upload_interval_seconds,
            max_upload_records=self.max_upload_records,
            name=self.name,
            output_options=self.output_options,
            zone_id=self.zone_id)


def get_logpush_dataset_job(account_id: Optional[_builtins.str] = None,
                            dataset_id: Optional[_builtins.str] = None,
                            zone_id: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogpushDatasetJobResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_logpush_dataset_job = cloudflare.get_logpush_dataset_job(dataset_id="gateway_dns",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param _builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param _builtins.str dataset_id: Name of the dataset. A list of supported datasets can be found on the [Developer Docs](https://developers.cloudflare.com/logs/reference/log-fields/).
           Available values: "access*requests", "audit*logs", "audit*logs*v2", "biso*user*actions", "casb*findings", "device*posture*results", "dlp*forensic*copies", "dns*firewall*logs", "dns*logs", "email*security*alerts", "firewall*events", "gateway*dns", "gateway*http", "gateway*network", "http*requests", "magic*ids*detections", "nel*reports", "network*analytics*logs", "page*shield*events", "sinkhole*http*logs", "spectrum*events", "ssh*logs", "workers*trace*events", "zaraz*events", "zero*trust*network*sessions".
    :param _builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['datasetId'] = dataset_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getLogpushDatasetJob:getLogpushDatasetJob', __args__, opts=opts, typ=GetLogpushDatasetJobResult).value

    return AwaitableGetLogpushDatasetJobResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        dataset=pulumi.get(__ret__, 'dataset'),
        dataset_id=pulumi.get(__ret__, 'dataset_id'),
        destination_conf=pulumi.get(__ret__, 'destination_conf'),
        enabled=pulumi.get(__ret__, 'enabled'),
        error_message=pulumi.get(__ret__, 'error_message'),
        frequency=pulumi.get(__ret__, 'frequency'),
        id=pulumi.get(__ret__, 'id'),
        kind=pulumi.get(__ret__, 'kind'),
        last_complete=pulumi.get(__ret__, 'last_complete'),
        last_error=pulumi.get(__ret__, 'last_error'),
        logpull_options=pulumi.get(__ret__, 'logpull_options'),
        max_upload_bytes=pulumi.get(__ret__, 'max_upload_bytes'),
        max_upload_interval_seconds=pulumi.get(__ret__, 'max_upload_interval_seconds'),
        max_upload_records=pulumi.get(__ret__, 'max_upload_records'),
        name=pulumi.get(__ret__, 'name'),
        output_options=pulumi.get(__ret__, 'output_options'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_logpush_dataset_job_output(account_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   dataset_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogpushDatasetJobResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_logpush_dataset_job = cloudflare.get_logpush_dataset_job(dataset_id="gateway_dns",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param _builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param _builtins.str dataset_id: Name of the dataset. A list of supported datasets can be found on the [Developer Docs](https://developers.cloudflare.com/logs/reference/log-fields/).
           Available values: "access*requests", "audit*logs", "audit*logs*v2", "biso*user*actions", "casb*findings", "device*posture*results", "dlp*forensic*copies", "dns*firewall*logs", "dns*logs", "email*security*alerts", "firewall*events", "gateway*dns", "gateway*http", "gateway*network", "http*requests", "magic*ids*detections", "nel*reports", "network*analytics*logs", "page*shield*events", "sinkhole*http*logs", "spectrum*events", "ssh*logs", "workers*trace*events", "zaraz*events", "zero*trust*network*sessions".
    :param _builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['datasetId'] = dataset_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getLogpushDatasetJob:getLogpushDatasetJob', __args__, opts=opts, typ=GetLogpushDatasetJobResult)
    return __ret__.apply(lambda __response__: GetLogpushDatasetJobResult(
        account_id=pulumi.get(__response__, 'account_id'),
        dataset=pulumi.get(__response__, 'dataset'),
        dataset_id=pulumi.get(__response__, 'dataset_id'),
        destination_conf=pulumi.get(__response__, 'destination_conf'),
        enabled=pulumi.get(__response__, 'enabled'),
        error_message=pulumi.get(__response__, 'error_message'),
        frequency=pulumi.get(__response__, 'frequency'),
        id=pulumi.get(__response__, 'id'),
        kind=pulumi.get(__response__, 'kind'),
        last_complete=pulumi.get(__response__, 'last_complete'),
        last_error=pulumi.get(__response__, 'last_error'),
        logpull_options=pulumi.get(__response__, 'logpull_options'),
        max_upload_bytes=pulumi.get(__response__, 'max_upload_bytes'),
        max_upload_interval_seconds=pulumi.get(__response__, 'max_upload_interval_seconds'),
        max_upload_records=pulumi.get(__response__, 'max_upload_records'),
        name=pulumi.get(__response__, 'name'),
        output_options=pulumi.get(__response__, 'output_options'),
        zone_id=pulumi.get(__response__, 'zone_id')))
