# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetMagicTransitSiteWanResult',
    'AwaitableGetMagicTransitSiteWanResult',
    'get_magic_transit_site_wan',
    'get_magic_transit_site_wan_output',
]

@pulumi.output_type
class GetMagicTransitSiteWanResult:
    """
    A collection of values returned by getMagicTransitSiteWan.
    """
    def __init__(__self__, account_id=None, health_check_rate=None, id=None, name=None, physport=None, priority=None, site_id=None, static_addressing=None, vlan_tag=None, wan_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if health_check_rate and not isinstance(health_check_rate, str):
            raise TypeError("Expected argument 'health_check_rate' to be a str")
        pulumi.set(__self__, "health_check_rate", health_check_rate)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if physport and not isinstance(physport, int):
            raise TypeError("Expected argument 'physport' to be a int")
        pulumi.set(__self__, "physport", physport)
        if priority and not isinstance(priority, int):
            raise TypeError("Expected argument 'priority' to be a int")
        pulumi.set(__self__, "priority", priority)
        if site_id and not isinstance(site_id, str):
            raise TypeError("Expected argument 'site_id' to be a str")
        pulumi.set(__self__, "site_id", site_id)
        if static_addressing and not isinstance(static_addressing, dict):
            raise TypeError("Expected argument 'static_addressing' to be a dict")
        pulumi.set(__self__, "static_addressing", static_addressing)
        if vlan_tag and not isinstance(vlan_tag, int):
            raise TypeError("Expected argument 'vlan_tag' to be a int")
        pulumi.set(__self__, "vlan_tag", vlan_tag)
        if wan_id and not isinstance(wan_id, str):
            raise TypeError("Expected argument 'wan_id' to be a str")
        pulumi.set(__self__, "wan_id", wan_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="healthCheckRate")
    def health_check_rate(self) -> _builtins.str:
        """
        Magic WAN health check rate for tunnels created on this link. The default value is `mid`.
        Available values: "low", "mid", "high".
        """
        return pulumi.get(self, "health_check_rate")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def physport(self) -> _builtins.int:
        return pulumi.get(self, "physport")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Priority of WAN for traffic loadbalancing.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> _builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="staticAddressing")
    def static_addressing(self) -> 'outputs.GetMagicTransitSiteWanStaticAddressingResult':
        """
        (optional) if omitted, use DHCP. Submit secondary*address when site is in high availability mode.
        """
        return pulumi.get(self, "static_addressing")

    @_builtins.property
    @pulumi.getter(name="vlanTag")
    def vlan_tag(self) -> _builtins.int:
        """
        VLAN ID. Use zero for untagged.
        """
        return pulumi.get(self, "vlan_tag")

    @_builtins.property
    @pulumi.getter(name="wanId")
    def wan_id(self) -> Optional[_builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "wan_id")


class AwaitableGetMagicTransitSiteWanResult(GetMagicTransitSiteWanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMagicTransitSiteWanResult(
            account_id=self.account_id,
            health_check_rate=self.health_check_rate,
            id=self.id,
            name=self.name,
            physport=self.physport,
            priority=self.priority,
            site_id=self.site_id,
            static_addressing=self.static_addressing,
            vlan_tag=self.vlan_tag,
            wan_id=self.wan_id)


def get_magic_transit_site_wan(account_id: Optional[_builtins.str] = None,
                               site_id: Optional[_builtins.str] = None,
                               wan_id: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMagicTransitSiteWanResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_magic_transit_site_wan = cloudflare.get_magic_transit_site_wan(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        site_id="023e105f4ecef8ad9ca31a8372d0c353",
        wan_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str account_id: Identifier
    :param _builtins.str site_id: Identifier
    :param _builtins.str wan_id: Identifier
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['siteId'] = site_id
    __args__['wanId'] = wan_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getMagicTransitSiteWan:getMagicTransitSiteWan', __args__, opts=opts, typ=GetMagicTransitSiteWanResult).value

    return AwaitableGetMagicTransitSiteWanResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        health_check_rate=pulumi.get(__ret__, 'health_check_rate'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        physport=pulumi.get(__ret__, 'physport'),
        priority=pulumi.get(__ret__, 'priority'),
        site_id=pulumi.get(__ret__, 'site_id'),
        static_addressing=pulumi.get(__ret__, 'static_addressing'),
        vlan_tag=pulumi.get(__ret__, 'vlan_tag'),
        wan_id=pulumi.get(__ret__, 'wan_id'))
def get_magic_transit_site_wan_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      site_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      wan_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMagicTransitSiteWanResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_magic_transit_site_wan = cloudflare.get_magic_transit_site_wan(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        site_id="023e105f4ecef8ad9ca31a8372d0c353",
        wan_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str account_id: Identifier
    :param _builtins.str site_id: Identifier
    :param _builtins.str wan_id: Identifier
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['siteId'] = site_id
    __args__['wanId'] = wan_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getMagicTransitSiteWan:getMagicTransitSiteWan', __args__, opts=opts, typ=GetMagicTransitSiteWanResult)
    return __ret__.apply(lambda __response__: GetMagicTransitSiteWanResult(
        account_id=pulumi.get(__response__, 'account_id'),
        health_check_rate=pulumi.get(__response__, 'health_check_rate'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        physport=pulumi.get(__response__, 'physport'),
        priority=pulumi.get(__response__, 'priority'),
        site_id=pulumi.get(__response__, 'site_id'),
        static_addressing=pulumi.get(__response__, 'static_addressing'),
        vlan_tag=pulumi.get(__response__, 'vlan_tag'),
        wan_id=pulumi.get(__response__, 'wan_id')))
