# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOriginCaCertificateResult',
    'AwaitableGetOriginCaCertificateResult',
    'get_origin_ca_certificate',
    'get_origin_ca_certificate_output',
]

@pulumi.output_type
class GetOriginCaCertificateResult:
    """
    A collection of values returned by getOriginCaCertificate.
    """
    def __init__(__self__, certificate=None, certificate_id=None, csr=None, expires_on=None, filter=None, hostnames=None, id=None, request_type=None, requested_validity=None):
        if certificate and not isinstance(certificate, str):
            raise TypeError("Expected argument 'certificate' to be a str")
        pulumi.set(__self__, "certificate", certificate)
        if certificate_id and not isinstance(certificate_id, str):
            raise TypeError("Expected argument 'certificate_id' to be a str")
        pulumi.set(__self__, "certificate_id", certificate_id)
        if csr and not isinstance(csr, str):
            raise TypeError("Expected argument 'csr' to be a str")
        pulumi.set(__self__, "csr", csr)
        if expires_on and not isinstance(expires_on, str):
            raise TypeError("Expected argument 'expires_on' to be a str")
        pulumi.set(__self__, "expires_on", expires_on)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if hostnames and not isinstance(hostnames, list):
            raise TypeError("Expected argument 'hostnames' to be a list")
        pulumi.set(__self__, "hostnames", hostnames)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if request_type and not isinstance(request_type, str):
            raise TypeError("Expected argument 'request_type' to be a str")
        pulumi.set(__self__, "request_type", request_type)
        if requested_validity and not isinstance(requested_validity, float):
            raise TypeError("Expected argument 'requested_validity' to be a float")
        pulumi.set(__self__, "requested_validity", requested_validity)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> _builtins.str:
        """
        The Origin CA certificate. Will be newline-encoded.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter
    def csr(self) -> _builtins.str:
        """
        The Certificate Signing Request (CSR). Must be newline-encoded.
        """
        return pulumi.get(self, "csr")

    @_builtins.property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> _builtins.str:
        """
        When the certificate will expire.
        """
        return pulumi.get(self, "expires_on")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetOriginCaCertificateFilterResult']:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> Sequence[_builtins.str]:
        """
        Array of hostnames or wildcard names (e.g., *.example.com) bound to the certificate.
        """
        return pulumi.get(self, "hostnames")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="requestType")
    def request_type(self) -> _builtins.str:
        """
        Signature type desired on certificate ("origin-rsa" (rsa), "origin-ecc" (ecdsa), or "keyless-certificate" (for Keyless SSL servers).
        Available values: "origin-rsa", "origin-ecc", "keyless-certificate".
        """
        return pulumi.get(self, "request_type")

    @_builtins.property
    @pulumi.getter(name="requestedValidity")
    def requested_validity(self) -> _builtins.float:
        """
        The number of days for which the certificate should be valid.
        Available values: 7, 30, 90, 365, 730, 1095, 5475.
        """
        return pulumi.get(self, "requested_validity")


class AwaitableGetOriginCaCertificateResult(GetOriginCaCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOriginCaCertificateResult(
            certificate=self.certificate,
            certificate_id=self.certificate_id,
            csr=self.csr,
            expires_on=self.expires_on,
            filter=self.filter,
            hostnames=self.hostnames,
            id=self.id,
            request_type=self.request_type,
            requested_validity=self.requested_validity)


def get_origin_ca_certificate(certificate_id: Optional[_builtins.str] = None,
                              filter: Optional[Union['GetOriginCaCertificateFilterArgs', 'GetOriginCaCertificateFilterArgsDict']] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOriginCaCertificateResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_origin_ca_certificate = cloudflare.get_origin_ca_certificate(certificate_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str certificate_id: Identifier.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    __args__['filter'] = filter
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getOriginCaCertificate:getOriginCaCertificate', __args__, opts=opts, typ=GetOriginCaCertificateResult).value

    return AwaitableGetOriginCaCertificateResult(
        certificate=pulumi.get(__ret__, 'certificate'),
        certificate_id=pulumi.get(__ret__, 'certificate_id'),
        csr=pulumi.get(__ret__, 'csr'),
        expires_on=pulumi.get(__ret__, 'expires_on'),
        filter=pulumi.get(__ret__, 'filter'),
        hostnames=pulumi.get(__ret__, 'hostnames'),
        id=pulumi.get(__ret__, 'id'),
        request_type=pulumi.get(__ret__, 'request_type'),
        requested_validity=pulumi.get(__ret__, 'requested_validity'))
def get_origin_ca_certificate_output(certificate_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     filter: Optional[pulumi.Input[Optional[Union['GetOriginCaCertificateFilterArgs', 'GetOriginCaCertificateFilterArgsDict']]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOriginCaCertificateResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_origin_ca_certificate = cloudflare.get_origin_ca_certificate(certificate_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str certificate_id: Identifier.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    __args__['filter'] = filter
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getOriginCaCertificate:getOriginCaCertificate', __args__, opts=opts, typ=GetOriginCaCertificateResult)
    return __ret__.apply(lambda __response__: GetOriginCaCertificateResult(
        certificate=pulumi.get(__response__, 'certificate'),
        certificate_id=pulumi.get(__response__, 'certificate_id'),
        csr=pulumi.get(__response__, 'csr'),
        expires_on=pulumi.get(__response__, 'expires_on'),
        filter=pulumi.get(__response__, 'filter'),
        hostnames=pulumi.get(__response__, 'hostnames'),
        id=pulumi.get(__response__, 'id'),
        request_type=pulumi.get(__response__, 'request_type'),
        requested_validity=pulumi.get(__response__, 'requested_validity')))
