# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetR2BucketLockResult',
    'AwaitableGetR2BucketLockResult',
    'get_r2_bucket_lock',
    'get_r2_bucket_lock_output',
]

@pulumi.output_type
class GetR2BucketLockResult:
    """
    A collection of values returned by getR2BucketLock.
    """
    def __init__(__self__, account_id=None, bucket_name=None, id=None, rules=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if bucket_name and not isinstance(bucket_name, str):
            raise TypeError("Expected argument 'bucket_name' to be a str")
        pulumi.set(__self__, "bucket_name", bucket_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetR2BucketLockRuleResult']:
        return pulumi.get(self, "rules")


class AwaitableGetR2BucketLockResult(GetR2BucketLockResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetR2BucketLockResult(
            account_id=self.account_id,
            bucket_name=self.bucket_name,
            id=self.id,
            rules=self.rules)


def get_r2_bucket_lock(account_id: Optional[_builtins.str] = None,
                       bucket_name: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetR2BucketLockResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_r2_bucket_lock = cloudflare.get_r2_bucket_lock(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        bucket_name="example-bucket")
    ```


    :param _builtins.str account_id: Account ID.
    :param _builtins.str bucket_name: Name of the bucket.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['bucketName'] = bucket_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getR2BucketLock:getR2BucketLock', __args__, opts=opts, typ=GetR2BucketLockResult).value

    return AwaitableGetR2BucketLockResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        bucket_name=pulumi.get(__ret__, 'bucket_name'),
        id=pulumi.get(__ret__, 'id'),
        rules=pulumi.get(__ret__, 'rules'))
def get_r2_bucket_lock_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                              bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetR2BucketLockResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_r2_bucket_lock = cloudflare.get_r2_bucket_lock(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        bucket_name="example-bucket")
    ```


    :param _builtins.str account_id: Account ID.
    :param _builtins.str bucket_name: Name of the bucket.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['bucketName'] = bucket_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getR2BucketLock:getR2BucketLock', __args__, opts=opts, typ=GetR2BucketLockResult)
    return __ret__.apply(lambda __response__: GetR2BucketLockResult(
        account_id=pulumi.get(__response__, 'account_id'),
        bucket_name=pulumi.get(__response__, 'bucket_name'),
        id=pulumi.get(__response__, 'id'),
        rules=pulumi.get(__response__, 'rules')))
