# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetStreamsResult',
    'AwaitableGetStreamsResult',
    'get_streams',
    'get_streams_output',
]

@pulumi.output_type
class GetStreamsResult:
    """
    A collection of values returned by getStreams.
    """
    def __init__(__self__, account_id=None, asc=None, creator=None, end=None, id=None, include_counts=None, max_items=None, results=None, search=None, start=None, status=None, type=None, video_name=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if asc and not isinstance(asc, bool):
            raise TypeError("Expected argument 'asc' to be a bool")
        pulumi.set(__self__, "asc", asc)
        if creator and not isinstance(creator, str):
            raise TypeError("Expected argument 'creator' to be a str")
        pulumi.set(__self__, "creator", creator)
        if end and not isinstance(end, str):
            raise TypeError("Expected argument 'end' to be a str")
        pulumi.set(__self__, "end", end)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_counts and not isinstance(include_counts, bool):
            raise TypeError("Expected argument 'include_counts' to be a bool")
        pulumi.set(__self__, "include_counts", include_counts)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if search and not isinstance(search, str):
            raise TypeError("Expected argument 'search' to be a str")
        pulumi.set(__self__, "search", search)
        if start and not isinstance(start, str):
            raise TypeError("Expected argument 'start' to be a str")
        pulumi.set(__self__, "start", start)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if video_name and not isinstance(video_name, str):
            raise TypeError("Expected argument 'video_name' to be a str")
        pulumi.set(__self__, "video_name", video_name)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def asc(self) -> _builtins.bool:
        """
        Lists videos in ascending order of creation.
        """
        return pulumi.get(self, "asc")

    @_builtins.property
    @pulumi.getter
    def creator(self) -> Optional[_builtins.str]:
        """
        A user-defined identifier for the media creator.
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter
    def end(self) -> Optional[_builtins.str]:
        """
        Lists videos created before the specified date.
        """
        return pulumi.get(self, "end")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="includeCounts")
    def include_counts(self) -> _builtins.bool:
        """
        Includes the total number of videos associated with the submitted query parameters.
        """
        return pulumi.get(self, "include_counts")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetStreamsResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter
    def search(self) -> Optional[_builtins.str]:
        """
        Provides a partial word match of the `name` key in the `meta` field. Slow for medium to large video libraries. May be unavailable for very large libraries.
        """
        return pulumi.get(self, "search")

    @_builtins.property
    @pulumi.getter
    def start(self) -> Optional[_builtins.str]:
        """
        Lists videos created after the specified date.
        """
        return pulumi.get(self, "start")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Specifies the processing status for all quality levels for a video.
        Available values: "pendingupload", "downloading", "queued", "inprogress", "ready", "error", "live-inprogress".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Specifies whether the video is `vod` or `live`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="videoName")
    def video_name(self) -> Optional[_builtins.str]:
        """
        Provides a fast, exact string match on the `name` key in the `meta` field.
        """
        return pulumi.get(self, "video_name")


class AwaitableGetStreamsResult(GetStreamsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamsResult(
            account_id=self.account_id,
            asc=self.asc,
            creator=self.creator,
            end=self.end,
            id=self.id,
            include_counts=self.include_counts,
            max_items=self.max_items,
            results=self.results,
            search=self.search,
            start=self.start,
            status=self.status,
            type=self.type,
            video_name=self.video_name)


def get_streams(account_id: Optional[_builtins.str] = None,
                asc: Optional[_builtins.bool] = None,
                creator: Optional[_builtins.str] = None,
                end: Optional[_builtins.str] = None,
                include_counts: Optional[_builtins.bool] = None,
                max_items: Optional[_builtins.int] = None,
                search: Optional[_builtins.str] = None,
                start: Optional[_builtins.str] = None,
                status: Optional[_builtins.str] = None,
                type: Optional[_builtins.str] = None,
                video_name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_streams = cloudflare.get_streams(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        creator="creator-id_abcde12345",
        end="2014-01-02T02:20:00Z",
        search="puppy.mp4",
        start="2014-01-02T02:20:00Z",
        status="inprogress",
        type="live",
        video_name="puppy.mp4")
    ```


    :param _builtins.str account_id: The account identifier tag.
    :param _builtins.bool asc: Lists videos in ascending order of creation.
    :param _builtins.str creator: A user-defined identifier for the media creator.
    :param _builtins.str end: Lists videos created before the specified date.
    :param _builtins.bool include_counts: Includes the total number of videos associated with the submitted query parameters.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str search: Provides a partial word match of the `name` key in the `meta` field. Slow for medium to large video libraries. May be unavailable for very large libraries.
    :param _builtins.str start: Lists videos created after the specified date.
    :param _builtins.str status: Specifies the processing status for all quality levels for a video.
           Available values: "pendingupload", "downloading", "queued", "inprogress", "ready", "error", "live-inprogress".
    :param _builtins.str type: Specifies whether the video is `vod` or `live`.
    :param _builtins.str video_name: Provides a fast, exact string match on the `name` key in the `meta` field.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['asc'] = asc
    __args__['creator'] = creator
    __args__['end'] = end
    __args__['includeCounts'] = include_counts
    __args__['maxItems'] = max_items
    __args__['search'] = search
    __args__['start'] = start
    __args__['status'] = status
    __args__['type'] = type
    __args__['videoName'] = video_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getStreams:getStreams', __args__, opts=opts, typ=GetStreamsResult).value

    return AwaitableGetStreamsResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        asc=pulumi.get(__ret__, 'asc'),
        creator=pulumi.get(__ret__, 'creator'),
        end=pulumi.get(__ret__, 'end'),
        id=pulumi.get(__ret__, 'id'),
        include_counts=pulumi.get(__ret__, 'include_counts'),
        max_items=pulumi.get(__ret__, 'max_items'),
        results=pulumi.get(__ret__, 'results'),
        search=pulumi.get(__ret__, 'search'),
        start=pulumi.get(__ret__, 'start'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'),
        video_name=pulumi.get(__ret__, 'video_name'))
def get_streams_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                       asc: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                       creator: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       end: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       include_counts: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                       max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       search: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       start: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       video_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_streams = cloudflare.get_streams(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        creator="creator-id_abcde12345",
        end="2014-01-02T02:20:00Z",
        search="puppy.mp4",
        start="2014-01-02T02:20:00Z",
        status="inprogress",
        type="live",
        video_name="puppy.mp4")
    ```


    :param _builtins.str account_id: The account identifier tag.
    :param _builtins.bool asc: Lists videos in ascending order of creation.
    :param _builtins.str creator: A user-defined identifier for the media creator.
    :param _builtins.str end: Lists videos created before the specified date.
    :param _builtins.bool include_counts: Includes the total number of videos associated with the submitted query parameters.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str search: Provides a partial word match of the `name` key in the `meta` field. Slow for medium to large video libraries. May be unavailable for very large libraries.
    :param _builtins.str start: Lists videos created after the specified date.
    :param _builtins.str status: Specifies the processing status for all quality levels for a video.
           Available values: "pendingupload", "downloading", "queued", "inprogress", "ready", "error", "live-inprogress".
    :param _builtins.str type: Specifies whether the video is `vod` or `live`.
    :param _builtins.str video_name: Provides a fast, exact string match on the `name` key in the `meta` field.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['asc'] = asc
    __args__['creator'] = creator
    __args__['end'] = end
    __args__['includeCounts'] = include_counts
    __args__['maxItems'] = max_items
    __args__['search'] = search
    __args__['start'] = start
    __args__['status'] = status
    __args__['type'] = type
    __args__['videoName'] = video_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getStreams:getStreams', __args__, opts=opts, typ=GetStreamsResult)
    return __ret__.apply(lambda __response__: GetStreamsResult(
        account_id=pulumi.get(__response__, 'account_id'),
        asc=pulumi.get(__response__, 'asc'),
        creator=pulumi.get(__response__, 'creator'),
        end=pulumi.get(__response__, 'end'),
        id=pulumi.get(__response__, 'id'),
        include_counts=pulumi.get(__response__, 'include_counts'),
        max_items=pulumi.get(__response__, 'max_items'),
        results=pulumi.get(__response__, 'results'),
        search=pulumi.get(__response__, 'search'),
        start=pulumi.get(__response__, 'start'),
        status=pulumi.get(__response__, 'status'),
        type=pulumi.get(__response__, 'type'),
        video_name=pulumi.get(__response__, 'video_name')))
