# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetWaitingRoomSettingsResult',
    'AwaitableGetWaitingRoomSettingsResult',
    'get_waiting_room_settings',
    'get_waiting_room_settings_output',
]

@pulumi.output_type
class GetWaitingRoomSettingsResult:
    """
    A collection of values returned by getWaitingRoomSettings.
    """
    def __init__(__self__, id=None, search_engine_crawler_bypass=None, zone_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if search_engine_crawler_bypass and not isinstance(search_engine_crawler_bypass, bool):
            raise TypeError("Expected argument 'search_engine_crawler_bypass' to be a bool")
        pulumi.set(__self__, "search_engine_crawler_bypass", search_engine_crawler_bypass)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="searchEngineCrawlerBypass")
    def search_engine_crawler_bypass(self) -> _builtins.bool:
        """
        Whether to allow verified search engine crawlers to bypass all waiting rooms on this zone.
        Verified search engine crawlers will not be tracked or counted by the waiting room system,
        and will not appear in waiting room analytics.
        """
        return pulumi.get(self, "search_engine_crawler_bypass")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetWaitingRoomSettingsResult(GetWaitingRoomSettingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWaitingRoomSettingsResult(
            id=self.id,
            search_engine_crawler_bypass=self.search_engine_crawler_bypass,
            zone_id=self.zone_id)


def get_waiting_room_settings(zone_id: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWaitingRoomSettingsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_waiting_room_settings = cloudflare.get_waiting_room_settings(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getWaitingRoomSettings:getWaitingRoomSettings', __args__, opts=opts, typ=GetWaitingRoomSettingsResult).value

    return AwaitableGetWaitingRoomSettingsResult(
        id=pulumi.get(__ret__, 'id'),
        search_engine_crawler_bypass=pulumi.get(__ret__, 'search_engine_crawler_bypass'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_waiting_room_settings_output(zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWaitingRoomSettingsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_waiting_room_settings = cloudflare.get_waiting_room_settings(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getWaitingRoomSettings:getWaitingRoomSettings', __args__, opts=opts, typ=GetWaitingRoomSettingsResult)
    return __ret__.apply(lambda __response__: GetWaitingRoomSettingsResult(
        id=pulumi.get(__response__, 'id'),
        search_engine_crawler_bypass=pulumi.get(__response__, 'search_engine_crawler_bypass'),
        zone_id=pulumi.get(__response__, 'zone_id')))
