# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetZeroTrustAccessGroupResult',
    'AwaitableGetZeroTrustAccessGroupResult',
    'get_zero_trust_access_group',
    'get_zero_trust_access_group_output',
]

@pulumi.output_type
class GetZeroTrustAccessGroupResult:
    """
    A collection of values returned by getZeroTrustAccessGroup.
    """
    def __init__(__self__, account_id=None, created_at=None, excludes=None, filter=None, group_id=None, id=None, includes=None, is_defaults=None, name=None, requires=None, updated_at=None, zone_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if excludes and not isinstance(excludes, list):
            raise TypeError("Expected argument 'excludes' to be a list")
        pulumi.set(__self__, "excludes", excludes)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if includes and not isinstance(includes, list):
            raise TypeError("Expected argument 'includes' to be a list")
        pulumi.set(__self__, "includes", includes)
        if is_defaults and not isinstance(is_defaults, list):
            raise TypeError("Expected argument 'is_defaults' to be a list")
        pulumi.set(__self__, "is_defaults", is_defaults)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if requires and not isinstance(requires, list):
            raise TypeError("Expected argument 'requires' to be a list")
        pulumi.set(__self__, "requires", requires)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> Sequence['outputs.GetZeroTrustAccessGroupExcludeResult']:
        """
        Rules evaluated with a NOT logical operator. To match a policy, a user cannot meet any of the Exclude rules.
        """
        return pulumi.get(self, "excludes")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetZeroTrustAccessGroupFilterResult']:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[_builtins.str]:
        """
        UUID.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def includes(self) -> Sequence['outputs.GetZeroTrustAccessGroupIncludeResult']:
        """
        Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        """
        return pulumi.get(self, "includes")

    @_builtins.property
    @pulumi.getter(name="isDefaults")
    def is_defaults(self) -> Sequence['outputs.GetZeroTrustAccessGroupIsDefaultResult']:
        """
        Rules evaluated with an AND logical operator. To match a policy, a user must meet all of the Require rules.
        """
        return pulumi.get(self, "is_defaults")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Access group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def requires(self) -> Sequence['outputs.GetZeroTrustAccessGroupRequireResult']:
        """
        Rules evaluated with an AND logical operator. To match a policy, a user must meet all of the Require rules.
        """
        return pulumi.get(self, "requires")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetZeroTrustAccessGroupResult(GetZeroTrustAccessGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustAccessGroupResult(
            account_id=self.account_id,
            created_at=self.created_at,
            excludes=self.excludes,
            filter=self.filter,
            group_id=self.group_id,
            id=self.id,
            includes=self.includes,
            is_defaults=self.is_defaults,
            name=self.name,
            requires=self.requires,
            updated_at=self.updated_at,
            zone_id=self.zone_id)


def get_zero_trust_access_group(account_id: Optional[_builtins.str] = None,
                                filter: Optional[Union['GetZeroTrustAccessGroupFilterArgs', 'GetZeroTrustAccessGroupFilterArgsDict']] = None,
                                group_id: Optional[_builtins.str] = None,
                                zone_id: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustAccessGroupResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_group = cloudflare.get_zero_trust_access_group(group_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param _builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param _builtins.str group_id: UUID.
    :param _builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['groupId'] = group_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustAccessGroup:getZeroTrustAccessGroup', __args__, opts=opts, typ=GetZeroTrustAccessGroupResult).value

    return AwaitableGetZeroTrustAccessGroupResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        excludes=pulumi.get(__ret__, 'excludes'),
        filter=pulumi.get(__ret__, 'filter'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        includes=pulumi.get(__ret__, 'includes'),
        is_defaults=pulumi.get(__ret__, 'is_defaults'),
        name=pulumi.get(__ret__, 'name'),
        requires=pulumi.get(__ret__, 'requires'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_zero_trust_access_group_output(account_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       filter: Optional[pulumi.Input[Optional[Union['GetZeroTrustAccessGroupFilterArgs', 'GetZeroTrustAccessGroupFilterArgsDict']]]] = None,
                                       group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustAccessGroupResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_group = cloudflare.get_zero_trust_access_group(group_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param _builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param _builtins.str group_id: UUID.
    :param _builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['groupId'] = group_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustAccessGroup:getZeroTrustAccessGroup', __args__, opts=opts, typ=GetZeroTrustAccessGroupResult)
    return __ret__.apply(lambda __response__: GetZeroTrustAccessGroupResult(
        account_id=pulumi.get(__response__, 'account_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        excludes=pulumi.get(__response__, 'excludes'),
        filter=pulumi.get(__response__, 'filter'),
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id'),
        includes=pulumi.get(__response__, 'includes'),
        is_defaults=pulumi.get(__response__, 'is_defaults'),
        name=pulumi.get(__response__, 'name'),
        requires=pulumi.get(__response__, 'requires'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        zone_id=pulumi.get(__response__, 'zone_id')))
