# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZeroTrustAccessPolicyResult',
    'AwaitableGetZeroTrustAccessPolicyResult',
    'get_zero_trust_access_policy',
    'get_zero_trust_access_policy_output',
]

@pulumi.output_type
class GetZeroTrustAccessPolicyResult:
    """
    A collection of values returned by getZeroTrustAccessPolicy.
    """
    def __init__(__self__, account_id=None, app_count=None, approval_groups=None, approval_required=None, created_at=None, decision=None, excludes=None, id=None, includes=None, isolation_required=None, name=None, policy_id=None, purpose_justification_prompt=None, purpose_justification_required=None, requires=None, reusable=None, session_duration=None, updated_at=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if app_count and not isinstance(app_count, int):
            raise TypeError("Expected argument 'app_count' to be a int")
        pulumi.set(__self__, "app_count", app_count)
        if approval_groups and not isinstance(approval_groups, list):
            raise TypeError("Expected argument 'approval_groups' to be a list")
        pulumi.set(__self__, "approval_groups", approval_groups)
        if approval_required and not isinstance(approval_required, bool):
            raise TypeError("Expected argument 'approval_required' to be a bool")
        pulumi.set(__self__, "approval_required", approval_required)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if decision and not isinstance(decision, str):
            raise TypeError("Expected argument 'decision' to be a str")
        pulumi.set(__self__, "decision", decision)
        if excludes and not isinstance(excludes, list):
            raise TypeError("Expected argument 'excludes' to be a list")
        pulumi.set(__self__, "excludes", excludes)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if includes and not isinstance(includes, list):
            raise TypeError("Expected argument 'includes' to be a list")
        pulumi.set(__self__, "includes", includes)
        if isolation_required and not isinstance(isolation_required, bool):
            raise TypeError("Expected argument 'isolation_required' to be a bool")
        pulumi.set(__self__, "isolation_required", isolation_required)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)
        if purpose_justification_prompt and not isinstance(purpose_justification_prompt, str):
            raise TypeError("Expected argument 'purpose_justification_prompt' to be a str")
        pulumi.set(__self__, "purpose_justification_prompt", purpose_justification_prompt)
        if purpose_justification_required and not isinstance(purpose_justification_required, bool):
            raise TypeError("Expected argument 'purpose_justification_required' to be a bool")
        pulumi.set(__self__, "purpose_justification_required", purpose_justification_required)
        if requires and not isinstance(requires, list):
            raise TypeError("Expected argument 'requires' to be a list")
        pulumi.set(__self__, "requires", requires)
        if reusable and not isinstance(reusable, bool):
            raise TypeError("Expected argument 'reusable' to be a bool")
        pulumi.set(__self__, "reusable", reusable)
        if session_duration and not isinstance(session_duration, str):
            raise TypeError("Expected argument 'session_duration' to be a str")
        pulumi.set(__self__, "session_duration", session_duration)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="appCount")
    def app_count(self) -> _builtins.int:
        """
        Number of access applications currently using this policy.
        """
        return pulumi.get(self, "app_count")

    @_builtins.property
    @pulumi.getter(name="approvalGroups")
    def approval_groups(self) -> Sequence['outputs.GetZeroTrustAccessPolicyApprovalGroupResult']:
        """
        Administrators who can approve a temporary authentication request.
        """
        return pulumi.get(self, "approval_groups")

    @_builtins.property
    @pulumi.getter(name="approvalRequired")
    def approval_required(self) -> _builtins.bool:
        """
        Requires the user to request access from an administrator at the start of each session.
        """
        return pulumi.get(self, "approval_required")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def decision(self) -> _builtins.str:
        """
        The action Access will take if a user matches this policy. Infrastructure application policies can only use the Allow action.
        Available values: "allow", "deny", "non_identity", "bypass".
        """
        return pulumi.get(self, "decision")

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> Sequence['outputs.GetZeroTrustAccessPolicyExcludeResult']:
        """
        Rules evaluated with a NOT logical operator. To match the policy, a user cannot meet any of the Exclude rules.
        """
        return pulumi.get(self, "excludes")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID of the policy
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def includes(self) -> Sequence['outputs.GetZeroTrustAccessPolicyIncludeResult']:
        """
        Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        """
        return pulumi.get(self, "includes")

    @_builtins.property
    @pulumi.getter(name="isolationRequired")
    def isolation_required(self) -> _builtins.bool:
        """
        Require this application to be served in an isolated browser for users matching this policy. 'Client Web Isolation' must be on for the account in order to use this feature.
        """
        return pulumi.get(self, "isolation_required")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Access policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[_builtins.str]:
        """
        The UUID of the policy
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter(name="purposeJustificationPrompt")
    def purpose_justification_prompt(self) -> _builtins.str:
        """
        A custom message that will appear on the purpose justification screen.
        """
        return pulumi.get(self, "purpose_justification_prompt")

    @_builtins.property
    @pulumi.getter(name="purposeJustificationRequired")
    def purpose_justification_required(self) -> _builtins.bool:
        """
        Require users to enter a justification when they log in to the application.
        """
        return pulumi.get(self, "purpose_justification_required")

    @_builtins.property
    @pulumi.getter
    def requires(self) -> Sequence['outputs.GetZeroTrustAccessPolicyRequireResult']:
        """
        Rules evaluated with an AND logical operator. To match the policy, a user must meet all of the Require rules.
        """
        return pulumi.get(self, "requires")

    @_builtins.property
    @pulumi.getter
    def reusable(self) -> _builtins.bool:
        return pulumi.get(self, "reusable")

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> _builtins.str:
        """
        The amount of time that tokens issued for the application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h.
        """
        return pulumi.get(self, "session_duration")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        return pulumi.get(self, "updated_at")


class AwaitableGetZeroTrustAccessPolicyResult(GetZeroTrustAccessPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustAccessPolicyResult(
            account_id=self.account_id,
            app_count=self.app_count,
            approval_groups=self.approval_groups,
            approval_required=self.approval_required,
            created_at=self.created_at,
            decision=self.decision,
            excludes=self.excludes,
            id=self.id,
            includes=self.includes,
            isolation_required=self.isolation_required,
            name=self.name,
            policy_id=self.policy_id,
            purpose_justification_prompt=self.purpose_justification_prompt,
            purpose_justification_required=self.purpose_justification_required,
            requires=self.requires,
            reusable=self.reusable,
            session_duration=self.session_duration,
            updated_at=self.updated_at)


def get_zero_trust_access_policy(account_id: Optional[_builtins.str] = None,
                                 policy_id: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustAccessPolicyResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_policy = cloudflare.get_zero_trust_access_policy(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        policy_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.str policy_id: The UUID of the policy
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['policyId'] = policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustAccessPolicy:getZeroTrustAccessPolicy', __args__, opts=opts, typ=GetZeroTrustAccessPolicyResult).value

    return AwaitableGetZeroTrustAccessPolicyResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        app_count=pulumi.get(__ret__, 'app_count'),
        approval_groups=pulumi.get(__ret__, 'approval_groups'),
        approval_required=pulumi.get(__ret__, 'approval_required'),
        created_at=pulumi.get(__ret__, 'created_at'),
        decision=pulumi.get(__ret__, 'decision'),
        excludes=pulumi.get(__ret__, 'excludes'),
        id=pulumi.get(__ret__, 'id'),
        includes=pulumi.get(__ret__, 'includes'),
        isolation_required=pulumi.get(__ret__, 'isolation_required'),
        name=pulumi.get(__ret__, 'name'),
        policy_id=pulumi.get(__ret__, 'policy_id'),
        purpose_justification_prompt=pulumi.get(__ret__, 'purpose_justification_prompt'),
        purpose_justification_required=pulumi.get(__ret__, 'purpose_justification_required'),
        requires=pulumi.get(__ret__, 'requires'),
        reusable=pulumi.get(__ret__, 'reusable'),
        session_duration=pulumi.get(__ret__, 'session_duration'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_zero_trust_access_policy_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                        policy_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustAccessPolicyResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_policy = cloudflare.get_zero_trust_access_policy(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        policy_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.str policy_id: The UUID of the policy
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['policyId'] = policy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustAccessPolicy:getZeroTrustAccessPolicy', __args__, opts=opts, typ=GetZeroTrustAccessPolicyResult)
    return __ret__.apply(lambda __response__: GetZeroTrustAccessPolicyResult(
        account_id=pulumi.get(__response__, 'account_id'),
        app_count=pulumi.get(__response__, 'app_count'),
        approval_groups=pulumi.get(__response__, 'approval_groups'),
        approval_required=pulumi.get(__response__, 'approval_required'),
        created_at=pulumi.get(__response__, 'created_at'),
        decision=pulumi.get(__response__, 'decision'),
        excludes=pulumi.get(__response__, 'excludes'),
        id=pulumi.get(__response__, 'id'),
        includes=pulumi.get(__response__, 'includes'),
        isolation_required=pulumi.get(__response__, 'isolation_required'),
        name=pulumi.get(__response__, 'name'),
        policy_id=pulumi.get(__response__, 'policy_id'),
        purpose_justification_prompt=pulumi.get(__response__, 'purpose_justification_prompt'),
        purpose_justification_required=pulumi.get(__response__, 'purpose_justification_required'),
        requires=pulumi.get(__response__, 'requires'),
        reusable=pulumi.get(__response__, 'reusable'),
        session_duration=pulumi.get(__response__, 'session_duration'),
        updated_at=pulumi.get(__response__, 'updated_at')))
