# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetZeroTrustTunnelCloudflaredTokenResult',
    'AwaitableGetZeroTrustTunnelCloudflaredTokenResult',
    'get_zero_trust_tunnel_cloudflared_token',
    'get_zero_trust_tunnel_cloudflared_token_output',
]

@pulumi.output_type
class GetZeroTrustTunnelCloudflaredTokenResult:
    """
    A collection of values returned by getZeroTrustTunnelCloudflaredToken.
    """
    def __init__(__self__, account_id=None, id=None, token=None, tunnel_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if token and not isinstance(token, str):
            raise TypeError("Expected argument 'token' to be a str")
        pulumi.set(__self__, "token", token)
        if tunnel_id and not isinstance(tunnel_id, str):
            raise TypeError("Expected argument 'tunnel_id' to be a str")
        pulumi.set(__self__, "tunnel_id", tunnel_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Cloudflare account ID
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The Tunnel Token is used as a mechanism to authenticate the operation of a tunnel.
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> _builtins.str:
        """
        UUID of the tunnel.
        """
        return pulumi.get(self, "tunnel_id")


class AwaitableGetZeroTrustTunnelCloudflaredTokenResult(GetZeroTrustTunnelCloudflaredTokenResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustTunnelCloudflaredTokenResult(
            account_id=self.account_id,
            id=self.id,
            token=self.token,
            tunnel_id=self.tunnel_id)


def get_zero_trust_tunnel_cloudflared_token(account_id: Optional[_builtins.str] = None,
                                            tunnel_id: Optional[_builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustTunnelCloudflaredTokenResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_tunnel_cloudflared_token = cloudflare.get_zero_trust_tunnel_cloudflared_token(account_id="699d98642c564d2e855e9661899b7252",
        tunnel_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415")
    ```


    :param _builtins.str account_id: Cloudflare account ID
    :param _builtins.str tunnel_id: UUID of the tunnel.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['tunnelId'] = tunnel_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustTunnelCloudflaredToken:getZeroTrustTunnelCloudflaredToken', __args__, opts=opts, typ=GetZeroTrustTunnelCloudflaredTokenResult).value

    return AwaitableGetZeroTrustTunnelCloudflaredTokenResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        token=pulumi.get(__ret__, 'token'),
        tunnel_id=pulumi.get(__ret__, 'tunnel_id'))
def get_zero_trust_tunnel_cloudflared_token_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                   tunnel_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustTunnelCloudflaredTokenResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_tunnel_cloudflared_token = cloudflare.get_zero_trust_tunnel_cloudflared_token(account_id="699d98642c564d2e855e9661899b7252",
        tunnel_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415")
    ```


    :param _builtins.str account_id: Cloudflare account ID
    :param _builtins.str tunnel_id: UUID of the tunnel.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['tunnelId'] = tunnel_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustTunnelCloudflaredToken:getZeroTrustTunnelCloudflaredToken', __args__, opts=opts, typ=GetZeroTrustTunnelCloudflaredTokenResult)
    return __ret__.apply(lambda __response__: GetZeroTrustTunnelCloudflaredTokenResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        token=pulumi.get(__response__, 'token'),
        tunnel_id=pulumi.get(__response__, 'tunnel_id')))
