# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetZoneDnssecResult',
    'AwaitableGetZoneDnssecResult',
    'get_zone_dnssec',
    'get_zone_dnssec_output',
]

@pulumi.output_type
class GetZoneDnssecResult:
    """
    A collection of values returned by getZoneDnssec.
    """
    def __init__(__self__, algorithm=None, digest=None, digest_algorithm=None, digest_type=None, dnssec_multi_signer=None, dnssec_presigned=None, dnssec_use_nsec3=None, ds=None, flags=None, id=None, key_tag=None, key_type=None, modified_on=None, public_key=None, status=None, zone_id=None):
        if algorithm and not isinstance(algorithm, str):
            raise TypeError("Expected argument 'algorithm' to be a str")
        pulumi.set(__self__, "algorithm", algorithm)
        if digest and not isinstance(digest, str):
            raise TypeError("Expected argument 'digest' to be a str")
        pulumi.set(__self__, "digest", digest)
        if digest_algorithm and not isinstance(digest_algorithm, str):
            raise TypeError("Expected argument 'digest_algorithm' to be a str")
        pulumi.set(__self__, "digest_algorithm", digest_algorithm)
        if digest_type and not isinstance(digest_type, str):
            raise TypeError("Expected argument 'digest_type' to be a str")
        pulumi.set(__self__, "digest_type", digest_type)
        if dnssec_multi_signer and not isinstance(dnssec_multi_signer, bool):
            raise TypeError("Expected argument 'dnssec_multi_signer' to be a bool")
        pulumi.set(__self__, "dnssec_multi_signer", dnssec_multi_signer)
        if dnssec_presigned and not isinstance(dnssec_presigned, bool):
            raise TypeError("Expected argument 'dnssec_presigned' to be a bool")
        pulumi.set(__self__, "dnssec_presigned", dnssec_presigned)
        if dnssec_use_nsec3 and not isinstance(dnssec_use_nsec3, bool):
            raise TypeError("Expected argument 'dnssec_use_nsec3' to be a bool")
        pulumi.set(__self__, "dnssec_use_nsec3", dnssec_use_nsec3)
        if ds and not isinstance(ds, str):
            raise TypeError("Expected argument 'ds' to be a str")
        pulumi.set(__self__, "ds", ds)
        if flags and not isinstance(flags, float):
            raise TypeError("Expected argument 'flags' to be a float")
        pulumi.set(__self__, "flags", flags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_tag and not isinstance(key_tag, float):
            raise TypeError("Expected argument 'key_tag' to be a float")
        pulumi.set(__self__, "key_tag", key_tag)
        if key_type and not isinstance(key_type, str):
            raise TypeError("Expected argument 'key_type' to be a str")
        pulumi.set(__self__, "key_type", key_type)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> _builtins.str:
        """
        Algorithm key code.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def digest(self) -> _builtins.str:
        """
        Digest hash.
        """
        return pulumi.get(self, "digest")

    @_builtins.property
    @pulumi.getter(name="digestAlgorithm")
    def digest_algorithm(self) -> _builtins.str:
        """
        Type of digest algorithm.
        """
        return pulumi.get(self, "digest_algorithm")

    @_builtins.property
    @pulumi.getter(name="digestType")
    def digest_type(self) -> _builtins.str:
        """
        Coded type for digest algorithm.
        """
        return pulumi.get(self, "digest_type")

    @_builtins.property
    @pulumi.getter(name="dnssecMultiSigner")
    def dnssec_multi_signer(self) -> _builtins.bool:
        """
        If true, multi-signer DNSSEC is enabled on the zone, allowing multiple
        providers to serve a DNSSEC-signed zone at the same time.
        This is required for DNSKEY records (except those automatically
        generated by Cloudflare) to be added to the zone.
        """
        return pulumi.get(self, "dnssec_multi_signer")

    @_builtins.property
    @pulumi.getter(name="dnssecPresigned")
    def dnssec_presigned(self) -> _builtins.bool:
        return pulumi.get(self, "dnssec_presigned")

    @_builtins.property
    @pulumi.getter(name="dnssecUseNsec3")
    def dnssec_use_nsec3(self) -> _builtins.bool:
        return pulumi.get(self, "dnssec_use_nsec3")

    @_builtins.property
    @pulumi.getter
    def ds(self) -> _builtins.str:
        return pulumi.get(self, "ds")

    @_builtins.property
    @pulumi.getter
    def flags(self) -> _builtins.float:
        return pulumi.get(self, "flags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyTag")
    def key_tag(self) -> _builtins.float:
        return pulumi.get(self, "key_tag")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> _builtins.str:
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> _builtins.str:
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetZoneDnssecResult(GetZoneDnssecResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneDnssecResult(
            algorithm=self.algorithm,
            digest=self.digest,
            digest_algorithm=self.digest_algorithm,
            digest_type=self.digest_type,
            dnssec_multi_signer=self.dnssec_multi_signer,
            dnssec_presigned=self.dnssec_presigned,
            dnssec_use_nsec3=self.dnssec_use_nsec3,
            ds=self.ds,
            flags=self.flags,
            id=self.id,
            key_tag=self.key_tag,
            key_type=self.key_type,
            modified_on=self.modified_on,
            public_key=self.public_key,
            status=self.status,
            zone_id=self.zone_id)


def get_zone_dnssec(zone_id: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneDnssecResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zone_dnssec = cloudflare.get_zone_dnssec(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZoneDnssec:getZoneDnssec', __args__, opts=opts, typ=GetZoneDnssecResult).value

    return AwaitableGetZoneDnssecResult(
        algorithm=pulumi.get(__ret__, 'algorithm'),
        digest=pulumi.get(__ret__, 'digest'),
        digest_algorithm=pulumi.get(__ret__, 'digest_algorithm'),
        digest_type=pulumi.get(__ret__, 'digest_type'),
        dnssec_multi_signer=pulumi.get(__ret__, 'dnssec_multi_signer'),
        dnssec_presigned=pulumi.get(__ret__, 'dnssec_presigned'),
        dnssec_use_nsec3=pulumi.get(__ret__, 'dnssec_use_nsec3'),
        ds=pulumi.get(__ret__, 'ds'),
        flags=pulumi.get(__ret__, 'flags'),
        id=pulumi.get(__ret__, 'id'),
        key_tag=pulumi.get(__ret__, 'key_tag'),
        key_type=pulumi.get(__ret__, 'key_type'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        public_key=pulumi.get(__ret__, 'public_key'),
        status=pulumi.get(__ret__, 'status'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_zone_dnssec_output(zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZoneDnssecResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zone_dnssec = cloudflare.get_zone_dnssec(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZoneDnssec:getZoneDnssec', __args__, opts=opts, typ=GetZoneDnssecResult)
    return __ret__.apply(lambda __response__: GetZoneDnssecResult(
        algorithm=pulumi.get(__response__, 'algorithm'),
        digest=pulumi.get(__response__, 'digest'),
        digest_algorithm=pulumi.get(__response__, 'digest_algorithm'),
        digest_type=pulumi.get(__response__, 'digest_type'),
        dnssec_multi_signer=pulumi.get(__response__, 'dnssec_multi_signer'),
        dnssec_presigned=pulumi.get(__response__, 'dnssec_presigned'),
        dnssec_use_nsec3=pulumi.get(__response__, 'dnssec_use_nsec3'),
        ds=pulumi.get(__response__, 'ds'),
        flags=pulumi.get(__response__, 'flags'),
        id=pulumi.get(__response__, 'id'),
        key_tag=pulumi.get(__response__, 'key_tag'),
        key_type=pulumi.get(__response__, 'key_type'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        public_key=pulumi.get(__response__, 'public_key'),
        status=pulumi.get(__response__, 'status'),
        zone_id=pulumi.get(__response__, 'zone_id')))
