# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZoneSubscriptionResult',
    'AwaitableGetZoneSubscriptionResult',
    'get_zone_subscription',
    'get_zone_subscription_output',
]

@pulumi.output_type
class GetZoneSubscriptionResult:
    """
    A collection of values returned by getZoneSubscription.
    """
    def __init__(__self__, currency=None, current_period_end=None, current_period_start=None, frequency=None, id=None, price=None, rate_plan=None, state=None, zone_id=None):
        if currency and not isinstance(currency, str):
            raise TypeError("Expected argument 'currency' to be a str")
        pulumi.set(__self__, "currency", currency)
        if current_period_end and not isinstance(current_period_end, str):
            raise TypeError("Expected argument 'current_period_end' to be a str")
        pulumi.set(__self__, "current_period_end", current_period_end)
        if current_period_start and not isinstance(current_period_start, str):
            raise TypeError("Expected argument 'current_period_start' to be a str")
        pulumi.set(__self__, "current_period_start", current_period_start)
        if frequency and not isinstance(frequency, str):
            raise TypeError("Expected argument 'frequency' to be a str")
        pulumi.set(__self__, "frequency", frequency)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if price and not isinstance(price, float):
            raise TypeError("Expected argument 'price' to be a float")
        pulumi.set(__self__, "price", price)
        if rate_plan and not isinstance(rate_plan, dict):
            raise TypeError("Expected argument 'rate_plan' to be a dict")
        pulumi.set(__self__, "rate_plan", rate_plan)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def currency(self) -> _builtins.str:
        """
        The monetary unit in which pricing information is displayed.
        """
        return pulumi.get(self, "currency")

    @_builtins.property
    @pulumi.getter(name="currentPeriodEnd")
    def current_period_end(self) -> _builtins.str:
        """
        The end of the current period and also when the next billing is due.
        """
        return pulumi.get(self, "current_period_end")

    @_builtins.property
    @pulumi.getter(name="currentPeriodStart")
    def current_period_start(self) -> _builtins.str:
        """
        When the current billing period started. May match initial*period*start if this is the first period.
        """
        return pulumi.get(self, "current_period_start")

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> _builtins.str:
        """
        How often the subscription is renewed automatically.
        Available values: "weekly", "monthly", "quarterly", "yearly".
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Subscription identifier tag.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def price(self) -> _builtins.float:
        """
        The price of the subscription that will be billed, in US dollars.
        """
        return pulumi.get(self, "price")

    @_builtins.property
    @pulumi.getter(name="ratePlan")
    def rate_plan(self) -> 'outputs.GetZoneSubscriptionRatePlanResult':
        """
        The rate plan applied to the subscription.
        """
        return pulumi.get(self, "rate_plan")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The state that the subscription is in.
        Available values: "Trial", "Provisioned", "Paid", "AwaitingPayment", "Cancelled", "Failed", "Expired".
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Subscription identifier tag.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetZoneSubscriptionResult(GetZoneSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneSubscriptionResult(
            currency=self.currency,
            current_period_end=self.current_period_end,
            current_period_start=self.current_period_start,
            frequency=self.frequency,
            id=self.id,
            price=self.price,
            rate_plan=self.rate_plan,
            state=self.state,
            zone_id=self.zone_id)


def get_zone_subscription(zone_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneSubscriptionResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zone_subscription = cloudflare.get_zone_subscription(zone_id="506e3185e9c882d175a2d0cb0093d9f2")
    ```


    :param _builtins.str zone_id: Subscription identifier tag.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZoneSubscription:getZoneSubscription', __args__, opts=opts, typ=GetZoneSubscriptionResult).value

    return AwaitableGetZoneSubscriptionResult(
        currency=pulumi.get(__ret__, 'currency'),
        current_period_end=pulumi.get(__ret__, 'current_period_end'),
        current_period_start=pulumi.get(__ret__, 'current_period_start'),
        frequency=pulumi.get(__ret__, 'frequency'),
        id=pulumi.get(__ret__, 'id'),
        price=pulumi.get(__ret__, 'price'),
        rate_plan=pulumi.get(__ret__, 'rate_plan'),
        state=pulumi.get(__ret__, 'state'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_zone_subscription_output(zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZoneSubscriptionResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zone_subscription = cloudflare.get_zone_subscription(zone_id="506e3185e9c882d175a2d0cb0093d9f2")
    ```


    :param _builtins.str zone_id: Subscription identifier tag.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZoneSubscription:getZoneSubscription', __args__, opts=opts, typ=GetZoneSubscriptionResult)
    return __ret__.apply(lambda __response__: GetZoneSubscriptionResult(
        currency=pulumi.get(__response__, 'currency'),
        current_period_end=pulumi.get(__response__, 'current_period_end'),
        current_period_start=pulumi.get(__response__, 'current_period_start'),
        frequency=pulumi.get(__response__, 'frequency'),
        id=pulumi.get(__response__, 'id'),
        price=pulumi.get(__response__, 'price'),
        rate_plan=pulumi.get(__response__, 'rate_plan'),
        state=pulumi.get(__response__, 'state'),
        zone_id=pulumi.get(__response__, 'zone_id')))
