# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KeylessCertificateArgs', 'KeylessCertificate']

@pulumi.input_type
class KeylessCertificateArgs:
    def __init__(__self__, *,
                 certificate: pulumi.Input[_builtins.str],
                 host: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 bundle_method: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.float]] = None,
                 tunnel: Optional[pulumi.Input['KeylessCertificateTunnelArgs']] = None):
        """
        The set of arguments for constructing a KeylessCertificate resource.
        :param pulumi.Input[_builtins.str] certificate: The zone's SSL certificate or SSL certificate and intermediate(s).
        :param pulumi.Input[_builtins.str] host: The keyless SSL name.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        :param pulumi.Input[_builtins.str] bundle_method: A ubiquitous bundle has the highest probability of being verified everywhere, even by clients using outdated or unusual trust stores. An optimal bundle uses the shortest chain and newest intermediates. And the force bundle verifies the chain, but does not otherwise modify it.
               Available values: "ubiquitous", "optimal", "force".
        :param pulumi.Input[_builtins.bool] enabled: Whether or not the Keyless SSL is on or off.
        :param pulumi.Input[_builtins.str] name: The keyless SSL name.
        :param pulumi.Input[_builtins.float] port: The keyless SSL port used to communicate between Cloudflare and the client's Keyless SSL server.
        :param pulumi.Input['KeylessCertificateTunnelArgs'] tunnel: Configuration for using Keyless SSL through a Cloudflare Tunnel
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "zone_id", zone_id)
        if bundle_method is not None:
            pulumi.set(__self__, "bundle_method", bundle_method)
        if enabled is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""enabled is deprecated: This attribute is deprecated.""")
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if tunnel is not None:
            pulumi.set(__self__, "tunnel", tunnel)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Input[_builtins.str]:
        """
        The zone's SSL certificate or SSL certificate and intermediate(s).
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Input[_builtins.str]:
        """
        The keyless SSL name.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="bundleMethod")
    def bundle_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A ubiquitous bundle has the highest probability of being verified everywhere, even by clients using outdated or unusual trust stores. An optimal bundle uses the shortest chain and newest intermediates. And the force bundle verifies the chain, but does not otherwise modify it.
        Available values: "ubiquitous", "optimal", "force".
        """
        return pulumi.get(self, "bundle_method")

    @bundle_method.setter
    def bundle_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bundle_method", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not the Keyless SSL is on or off.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The keyless SSL name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The keyless SSL port used to communicate between Cloudflare and the client's Keyless SSL server.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def tunnel(self) -> Optional[pulumi.Input['KeylessCertificateTunnelArgs']]:
        """
        Configuration for using Keyless SSL through a Cloudflare Tunnel
        """
        return pulumi.get(self, "tunnel")

    @tunnel.setter
    def tunnel(self, value: Optional[pulumi.Input['KeylessCertificateTunnelArgs']]):
        pulumi.set(self, "tunnel", value)


@pulumi.input_type
class _KeylessCertificateState:
    def __init__(__self__, *,
                 bundle_method: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 port: Optional[pulumi.Input[_builtins.float]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel: Optional[pulumi.Input['KeylessCertificateTunnelArgs']] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KeylessCertificate resources.
        :param pulumi.Input[_builtins.str] bundle_method: A ubiquitous bundle has the highest probability of being verified everywhere, even by clients using outdated or unusual trust stores. An optimal bundle uses the shortest chain and newest intermediates. And the force bundle verifies the chain, but does not otherwise modify it.
               Available values: "ubiquitous", "optimal", "force".
        :param pulumi.Input[_builtins.str] certificate: The zone's SSL certificate or SSL certificate and intermediate(s).
        :param pulumi.Input[_builtins.str] created_on: When the Keyless SSL was created.
        :param pulumi.Input[_builtins.bool] enabled: Whether or not the Keyless SSL is on or off.
        :param pulumi.Input[_builtins.str] host: The keyless SSL name.
        :param pulumi.Input[_builtins.str] modified_on: When the Keyless SSL was last modified.
        :param pulumi.Input[_builtins.str] name: The keyless SSL name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions: Available permissions for the Keyless SSL for the current user requesting the item.
        :param pulumi.Input[_builtins.float] port: The keyless SSL port used to communicate between Cloudflare and the client's Keyless SSL server.
        :param pulumi.Input[_builtins.str] status: Status of the Keyless SSL.
               Available values: "active", "deleted".
        :param pulumi.Input['KeylessCertificateTunnelArgs'] tunnel: Configuration for using Keyless SSL through a Cloudflare Tunnel
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        if bundle_method is not None:
            pulumi.set(__self__, "bundle_method", bundle_method)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if enabled is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""enabled is deprecated: This attribute is deprecated.""")
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tunnel is not None:
            pulumi.set(__self__, "tunnel", tunnel)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="bundleMethod")
    def bundle_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A ubiquitous bundle has the highest probability of being verified everywhere, even by clients using outdated or unusual trust stores. An optimal bundle uses the shortest chain and newest intermediates. And the force bundle verifies the chain, but does not otherwise modify it.
        Available values: "ubiquitous", "optimal", "force".
        """
        return pulumi.get(self, "bundle_method")

    @bundle_method.setter
    def bundle_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bundle_method", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone's SSL certificate or SSL certificate and intermediate(s).
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the Keyless SSL was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not the Keyless SSL is on or off.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The keyless SSL name.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the Keyless SSL was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The keyless SSL name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Available permissions for the Keyless SSL for the current user requesting the item.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The keyless SSL port used to communicate between Cloudflare and the client's Keyless SSL server.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the Keyless SSL.
        Available values: "active", "deleted".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tunnel(self) -> Optional[pulumi.Input['KeylessCertificateTunnelArgs']]:
        """
        Configuration for using Keyless SSL through a Cloudflare Tunnel
        """
        return pulumi.get(self, "tunnel")

    @tunnel.setter
    def tunnel(self, value: Optional[pulumi.Input['KeylessCertificateTunnelArgs']]):
        pulumi.set(self, "tunnel", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/keylessCertificate:KeylessCertificate")
class KeylessCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bundle_method: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.float]] = None,
                 tunnel: Optional[pulumi.Input[Union['KeylessCertificateTunnelArgs', 'KeylessCertificateTunnelArgsDict']]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/keylessCertificate:KeylessCertificate example '<zone_id>/<keyless_certificate_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bundle_method: A ubiquitous bundle has the highest probability of being verified everywhere, even by clients using outdated or unusual trust stores. An optimal bundle uses the shortest chain and newest intermediates. And the force bundle verifies the chain, but does not otherwise modify it.
               Available values: "ubiquitous", "optimal", "force".
        :param pulumi.Input[_builtins.str] certificate: The zone's SSL certificate or SSL certificate and intermediate(s).
        :param pulumi.Input[_builtins.bool] enabled: Whether or not the Keyless SSL is on or off.
        :param pulumi.Input[_builtins.str] host: The keyless SSL name.
        :param pulumi.Input[_builtins.str] name: The keyless SSL name.
        :param pulumi.Input[_builtins.float] port: The keyless SSL port used to communicate between Cloudflare and the client's Keyless SSL server.
        :param pulumi.Input[Union['KeylessCertificateTunnelArgs', 'KeylessCertificateTunnelArgsDict']] tunnel: Configuration for using Keyless SSL through a Cloudflare Tunnel
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeylessCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/keylessCertificate:KeylessCertificate example '<zone_id>/<keyless_certificate_id>'
        ```

        :param str resource_name: The name of the resource.
        :param KeylessCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeylessCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bundle_method: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.float]] = None,
                 tunnel: Optional[pulumi.Input[Union['KeylessCertificateTunnelArgs', 'KeylessCertificateTunnelArgsDict']]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeylessCertificateArgs.__new__(KeylessCertificateArgs)

            __props__.__dict__["bundle_method"] = bundle_method
            if certificate is None and not opts.urn:
                raise TypeError("Missing required property 'certificate'")
            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["enabled"] = enabled
            if host is None and not opts.urn:
                raise TypeError("Missing required property 'host'")
            __props__.__dict__["host"] = host
            __props__.__dict__["name"] = name
            __props__.__dict__["port"] = port
            __props__.__dict__["tunnel"] = tunnel
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
            __props__.__dict__["permissions"] = None
            __props__.__dict__["status"] = None
        super(KeylessCertificate, __self__).__init__(
            'cloudflare:index/keylessCertificate:KeylessCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bundle_method: Optional[pulumi.Input[_builtins.str]] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            port: Optional[pulumi.Input[_builtins.float]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tunnel: Optional[pulumi.Input[Union['KeylessCertificateTunnelArgs', 'KeylessCertificateTunnelArgsDict']]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'KeylessCertificate':
        """
        Get an existing KeylessCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bundle_method: A ubiquitous bundle has the highest probability of being verified everywhere, even by clients using outdated or unusual trust stores. An optimal bundle uses the shortest chain and newest intermediates. And the force bundle verifies the chain, but does not otherwise modify it.
               Available values: "ubiquitous", "optimal", "force".
        :param pulumi.Input[_builtins.str] certificate: The zone's SSL certificate or SSL certificate and intermediate(s).
        :param pulumi.Input[_builtins.str] created_on: When the Keyless SSL was created.
        :param pulumi.Input[_builtins.bool] enabled: Whether or not the Keyless SSL is on or off.
        :param pulumi.Input[_builtins.str] host: The keyless SSL name.
        :param pulumi.Input[_builtins.str] modified_on: When the Keyless SSL was last modified.
        :param pulumi.Input[_builtins.str] name: The keyless SSL name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions: Available permissions for the Keyless SSL for the current user requesting the item.
        :param pulumi.Input[_builtins.float] port: The keyless SSL port used to communicate between Cloudflare and the client's Keyless SSL server.
        :param pulumi.Input[_builtins.str] status: Status of the Keyless SSL.
               Available values: "active", "deleted".
        :param pulumi.Input[Union['KeylessCertificateTunnelArgs', 'KeylessCertificateTunnelArgsDict']] tunnel: Configuration for using Keyless SSL through a Cloudflare Tunnel
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeylessCertificateState.__new__(_KeylessCertificateState)

        __props__.__dict__["bundle_method"] = bundle_method
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["host"] = host
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["name"] = name
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["port"] = port
        __props__.__dict__["status"] = status
        __props__.__dict__["tunnel"] = tunnel
        __props__.__dict__["zone_id"] = zone_id
        return KeylessCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bundleMethod")
    def bundle_method(self) -> pulumi.Output[_builtins.str]:
        """
        A ubiquitous bundle has the highest probability of being verified everywhere, even by clients using outdated or unusual trust stores. An optimal bundle uses the shortest chain and newest intermediates. And the force bundle verifies the chain, but does not otherwise modify it.
        Available values: "ubiquitous", "optimal", "force".
        """
        return pulumi.get(self, "bundle_method")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[_builtins.str]:
        """
        The zone's SSL certificate or SSL certificate and intermediate(s).
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        """
        When the Keyless SSL was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not the Keyless SSL is on or off.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[_builtins.str]:
        """
        The keyless SSL name.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        """
        When the Keyless SSL was last modified.
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The keyless SSL name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Available permissions for the Keyless SSL for the current user requesting the item.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.float]:
        """
        The keyless SSL port used to communicate between Cloudflare and the client's Keyless SSL server.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the Keyless SSL.
        Available values: "active", "deleted".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tunnel(self) -> pulumi.Output[Optional['outputs.KeylessCertificateTunnel']]:
        """
        Configuration for using Keyless SSL through a Cloudflare Tunnel
        """
        return pulumi.get(self, "tunnel")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

