# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ListArgs', 'List']

@pulumi.input_type
class ListArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 kind: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a List resource.
        :param pulumi.Input[_builtins.str] account_id: The Account ID for this resource.
        :param pulumi.Input[_builtins.str] kind: The type of the list. Each type supports specific list items (IP addresses, ASNs, hostnames or redirects).
               Available values: "ip", "redirect", "hostname", "asn".
        :param pulumi.Input[_builtins.str] name: An informative name for the list. Use this name in filter and rule expressions.
        :param pulumi.Input[_builtins.str] description: An informative summary of the list.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Account ID for this resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the list. Each type supports specific list items (IP addresses, ASNs, hostnames or redirects).
        Available values: "ip", "redirect", "hostname", "asn".
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        An informative name for the list. Use this name in filter and rule expressions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An informative summary of the list.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _ListState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 num_items: Optional[pulumi.Input[_builtins.float]] = None,
                 num_referencing_filters: Optional[pulumi.Input[_builtins.float]] = None):
        """
        Input properties used for looking up and filtering List resources.
        :param pulumi.Input[_builtins.str] account_id: The Account ID for this resource.
        :param pulumi.Input[_builtins.str] created_on: The RFC 3339 timestamp of when the list was created.
        :param pulumi.Input[_builtins.str] description: An informative summary of the list.
        :param pulumi.Input[_builtins.str] kind: The type of the list. Each type supports specific list items (IP addresses, ASNs, hostnames or redirects).
               Available values: "ip", "redirect", "hostname", "asn".
        :param pulumi.Input[_builtins.str] modified_on: The RFC 3339 timestamp of when the list was last modified.
        :param pulumi.Input[_builtins.str] name: An informative name for the list. Use this name in filter and rule expressions.
        :param pulumi.Input[_builtins.float] num_items: The number of items in the list.
        :param pulumi.Input[_builtins.float] num_referencing_filters: The number of [filters](https://www.terraform.io/api/resources/filters/) referencing the list.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_items is not None:
            pulumi.set(__self__, "num_items", num_items)
        if num_referencing_filters is not None:
            pulumi.set(__self__, "num_referencing_filters", num_referencing_filters)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Account ID for this resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RFC 3339 timestamp of when the list was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An informative summary of the list.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the list. Each type supports specific list items (IP addresses, ASNs, hostnames or redirects).
        Available values: "ip", "redirect", "hostname", "asn".
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RFC 3339 timestamp of when the list was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An informative name for the list. Use this name in filter and rule expressions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numItems")
    def num_items(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The number of items in the list.
        """
        return pulumi.get(self, "num_items")

    @num_items.setter
    def num_items(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "num_items", value)

    @_builtins.property
    @pulumi.getter(name="numReferencingFilters")
    def num_referencing_filters(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The number of [filters](https://www.terraform.io/api/resources/filters/) referencing the list.
        """
        return pulumi.get(self, "num_referencing_filters")

    @num_referencing_filters.setter
    def num_referencing_filters(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "num_referencing_filters", value)


@pulumi.type_token("cloudflare:index/list:List")
class List(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_list = cloudflare.List("example_list",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            kind="ip",
            name="list1",
            description="This is a note")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/list:List example '<account_id>/<list_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The Account ID for this resource.
        :param pulumi.Input[_builtins.str] description: An informative summary of the list.
        :param pulumi.Input[_builtins.str] kind: The type of the list. Each type supports specific list items (IP addresses, ASNs, hostnames or redirects).
               Available values: "ip", "redirect", "hostname", "asn".
        :param pulumi.Input[_builtins.str] name: An informative name for the list. Use this name in filter and rule expressions.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_list = cloudflare.List("example_list",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            kind="ip",
            name="list1",
            description="This is a note")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/list:List example '<account_id>/<list_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListArgs.__new__(ListArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["description"] = description
            if kind is None and not opts.urn:
                raise TypeError("Missing required property 'kind'")
            __props__.__dict__["kind"] = kind
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
            __props__.__dict__["num_items"] = None
            __props__.__dict__["num_referencing_filters"] = None
        super(List, __self__).__init__(
            'cloudflare:index/list:List',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            num_items: Optional[pulumi.Input[_builtins.float]] = None,
            num_referencing_filters: Optional[pulumi.Input[_builtins.float]] = None) -> 'List':
        """
        Get an existing List resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The Account ID for this resource.
        :param pulumi.Input[_builtins.str] created_on: The RFC 3339 timestamp of when the list was created.
        :param pulumi.Input[_builtins.str] description: An informative summary of the list.
        :param pulumi.Input[_builtins.str] kind: The type of the list. Each type supports specific list items (IP addresses, ASNs, hostnames or redirects).
               Available values: "ip", "redirect", "hostname", "asn".
        :param pulumi.Input[_builtins.str] modified_on: The RFC 3339 timestamp of when the list was last modified.
        :param pulumi.Input[_builtins.str] name: An informative name for the list. Use this name in filter and rule expressions.
        :param pulumi.Input[_builtins.float] num_items: The number of items in the list.
        :param pulumi.Input[_builtins.float] num_referencing_filters: The number of [filters](https://www.terraform.io/api/resources/filters/) referencing the list.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListState.__new__(_ListState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["description"] = description
        __props__.__dict__["kind"] = kind
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["name"] = name
        __props__.__dict__["num_items"] = num_items
        __props__.__dict__["num_referencing_filters"] = num_referencing_filters
        return List(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Account ID for this resource.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        """
        The RFC 3339 timestamp of when the list was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An informative summary of the list.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the list. Each type supports specific list items (IP addresses, ASNs, hostnames or redirects).
        Available values: "ip", "redirect", "hostname", "asn".
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        """
        The RFC 3339 timestamp of when the list was last modified.
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        An informative name for the list. Use this name in filter and rule expressions.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="numItems")
    def num_items(self) -> pulumi.Output[_builtins.float]:
        """
        The number of items in the list.
        """
        return pulumi.get(self, "num_items")

    @_builtins.property
    @pulumi.getter(name="numReferencingFilters")
    def num_referencing_filters(self) -> pulumi.Output[_builtins.float]:
        """
        The number of [filters](https://www.terraform.io/api/resources/filters/) referencing the list.
        """
        return pulumi.get(self, "num_referencing_filters")

