# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerPoolArgs', 'LoadBalancerPool']

@pulumi.input_type
class LoadBalancerPoolArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 origins: pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginArgs']]],
                 check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 latitude: Optional[pulumi.Input[_builtins.float]] = None,
                 load_shedding: Optional[pulumi.Input['LoadBalancerPoolLoadSheddingArgs']] = None,
                 longitude: Optional[pulumi.Input[_builtins.float]] = None,
                 minimum_origins: Optional[pulumi.Input[_builtins.int]] = None,
                 monitor: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_email: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_filter: Optional[pulumi.Input['LoadBalancerPoolNotificationFilterArgs']] = None,
                 origin_steering: Optional[pulumi.Input['LoadBalancerPoolOriginSteeringArgs']] = None):
        """
        The set of arguments for constructing a LoadBalancerPool resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] name: A short name (tag) for the pool. Only alphanumeric characters, hyphens, and underscores are allowed.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginArgs']]] origins: The list of origins within this pool. Traffic directed at this pool is balanced across all currently healthy origins, provided the pool itself is healthy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] check_regions: A list of regions from which to run health checks. Null means every Cloudflare data center.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the pool.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable (the default) or disable this pool. Disabled pools will not receive traffic and are excluded from health checks. Disabling a pool will cause any load balancers using it to failover to the next pool (if any).
        :param pulumi.Input[_builtins.float] latitude: The latitude of the data center containing the origins used in this pool in decimal degrees. If this is set, longitude must also be set.
        :param pulumi.Input['LoadBalancerPoolLoadSheddingArgs'] load_shedding: Configures load shedding policies and percentages for the pool.
        :param pulumi.Input[_builtins.float] longitude: The longitude of the data center containing the origins used in this pool in decimal degrees. If this is set, latitude must also be set.
        :param pulumi.Input[_builtins.int] minimum_origins: The minimum number of origins that must be healthy for this pool to serve traffic. If the number of healthy origins falls below this number, the pool will be marked unhealthy and will failover to the next available pool.
        :param pulumi.Input[_builtins.str] monitor: The ID of the Monitor to use for checking the health of origins within this pool.
        :param pulumi.Input[_builtins.str] notification_email: This field is now deprecated. It has been moved to Cloudflare's Centralized Notification service https://developers.cloudflare.com/fundamentals/notifications/. The email address to send health status notifications to. This can be an individual mailbox or a mailing list. Multiple emails can be supplied as a comma delimited list.
        :param pulumi.Input['LoadBalancerPoolNotificationFilterArgs'] notification_filter: Filter pool and origin health notifications by resource type or health status. Use null to reset.
        :param pulumi.Input['LoadBalancerPoolOriginSteeringArgs'] origin_steering: Configures origin steering for the pool. Controls how origins are selected for new sessions and traffic without session affinity.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "origins", origins)
        if check_regions is not None:
            pulumi.set(__self__, "check_regions", check_regions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if load_shedding is not None:
            pulumi.set(__self__, "load_shedding", load_shedding)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)
        if minimum_origins is not None:
            pulumi.set(__self__, "minimum_origins", minimum_origins)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if notification_email is not None:
            pulumi.set(__self__, "notification_email", notification_email)
        if notification_filter is not None:
            pulumi.set(__self__, "notification_filter", notification_filter)
        if origin_steering is not None:
            pulumi.set(__self__, "origin_steering", origin_steering)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        A short name (tag) for the pool. Only alphanumeric characters, hyphens, and underscores are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def origins(self) -> pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginArgs']]]:
        """
        The list of origins within this pool. Traffic directed at this pool is balanced across all currently healthy origins, provided the pool itself is healthy.
        """
        return pulumi.get(self, "origins")

    @origins.setter
    def origins(self, value: pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginArgs']]]):
        pulumi.set(self, "origins", value)

    @_builtins.property
    @pulumi.getter(name="checkRegions")
    def check_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of regions from which to run health checks. Null means every Cloudflare data center.
        """
        return pulumi.get(self, "check_regions")

    @check_regions.setter
    def check_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "check_regions", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable description of the pool.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable (the default) or disable this pool. Disabled pools will not receive traffic and are excluded from health checks. Disabling a pool will cause any load balancers using it to failover to the next pool (if any).
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def latitude(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The latitude of the data center containing the origins used in this pool in decimal degrees. If this is set, longitude must also be set.
        """
        return pulumi.get(self, "latitude")

    @latitude.setter
    def latitude(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "latitude", value)

    @_builtins.property
    @pulumi.getter(name="loadShedding")
    def load_shedding(self) -> Optional[pulumi.Input['LoadBalancerPoolLoadSheddingArgs']]:
        """
        Configures load shedding policies and percentages for the pool.
        """
        return pulumi.get(self, "load_shedding")

    @load_shedding.setter
    def load_shedding(self, value: Optional[pulumi.Input['LoadBalancerPoolLoadSheddingArgs']]):
        pulumi.set(self, "load_shedding", value)

    @_builtins.property
    @pulumi.getter
    def longitude(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The longitude of the data center containing the origins used in this pool in decimal degrees. If this is set, latitude must also be set.
        """
        return pulumi.get(self, "longitude")

    @longitude.setter
    def longitude(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "longitude", value)

    @_builtins.property
    @pulumi.getter(name="minimumOrigins")
    def minimum_origins(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum number of origins that must be healthy for this pool to serve traffic. If the number of healthy origins falls below this number, the pool will be marked unhealthy and will failover to the next available pool.
        """
        return pulumi.get(self, "minimum_origins")

    @minimum_origins.setter
    def minimum_origins(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_origins", value)

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Monitor to use for checking the health of origins within this pool.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitor", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmail")
    def notification_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field is now deprecated. It has been moved to Cloudflare's Centralized Notification service https://developers.cloudflare.com/fundamentals/notifications/. The email address to send health status notifications to. This can be an individual mailbox or a mailing list. Multiple emails can be supplied as a comma delimited list.
        """
        return pulumi.get(self, "notification_email")

    @notification_email.setter
    def notification_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_email", value)

    @_builtins.property
    @pulumi.getter(name="notificationFilter")
    def notification_filter(self) -> Optional[pulumi.Input['LoadBalancerPoolNotificationFilterArgs']]:
        """
        Filter pool and origin health notifications by resource type or health status. Use null to reset.
        """
        return pulumi.get(self, "notification_filter")

    @notification_filter.setter
    def notification_filter(self, value: Optional[pulumi.Input['LoadBalancerPoolNotificationFilterArgs']]):
        pulumi.set(self, "notification_filter", value)

    @_builtins.property
    @pulumi.getter(name="originSteering")
    def origin_steering(self) -> Optional[pulumi.Input['LoadBalancerPoolOriginSteeringArgs']]:
        """
        Configures origin steering for the pool. Controls how origins are selected for new sessions and traffic without session affinity.
        """
        return pulumi.get(self, "origin_steering")

    @origin_steering.setter
    def origin_steering(self, value: Optional[pulumi.Input['LoadBalancerPoolOriginSteeringArgs']]):
        pulumi.set(self, "origin_steering", value)


@pulumi.input_type
class _LoadBalancerPoolState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled_at: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 latitude: Optional[pulumi.Input[_builtins.float]] = None,
                 load_shedding: Optional[pulumi.Input['LoadBalancerPoolLoadSheddingArgs']] = None,
                 longitude: Optional[pulumi.Input[_builtins.float]] = None,
                 minimum_origins: Optional[pulumi.Input[_builtins.int]] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 notification_email: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_filter: Optional[pulumi.Input['LoadBalancerPoolNotificationFilterArgs']] = None,
                 origin_steering: Optional[pulumi.Input['LoadBalancerPoolOriginSteeringArgs']] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginArgs']]]] = None):
        """
        Input properties used for looking up and filtering LoadBalancerPool resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] check_regions: A list of regions from which to run health checks. Null means every Cloudflare data center.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the pool.
        :param pulumi.Input[_builtins.str] disabled_at: This field shows up only if the pool is disabled. This field is set with the time the pool was disabled at.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable (the default) or disable this pool. Disabled pools will not receive traffic and are excluded from health checks. Disabling a pool will cause any load balancers using it to failover to the next pool (if any).
        :param pulumi.Input[_builtins.float] latitude: The latitude of the data center containing the origins used in this pool in decimal degrees. If this is set, longitude must also be set.
        :param pulumi.Input['LoadBalancerPoolLoadSheddingArgs'] load_shedding: Configures load shedding policies and percentages for the pool.
        :param pulumi.Input[_builtins.float] longitude: The longitude of the data center containing the origins used in this pool in decimal degrees. If this is set, latitude must also be set.
        :param pulumi.Input[_builtins.int] minimum_origins: The minimum number of origins that must be healthy for this pool to serve traffic. If the number of healthy origins falls below this number, the pool will be marked unhealthy and will failover to the next available pool.
        :param pulumi.Input[_builtins.str] monitor: The ID of the Monitor to use for checking the health of origins within this pool.
        :param pulumi.Input[_builtins.str] name: A short name (tag) for the pool. Only alphanumeric characters, hyphens, and underscores are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] networks: List of networks where Load Balancer or Pool is enabled.
        :param pulumi.Input[_builtins.str] notification_email: This field is now deprecated. It has been moved to Cloudflare's Centralized Notification service https://developers.cloudflare.com/fundamentals/notifications/. The email address to send health status notifications to. This can be an individual mailbox or a mailing list. Multiple emails can be supplied as a comma delimited list.
        :param pulumi.Input['LoadBalancerPoolNotificationFilterArgs'] notification_filter: Filter pool and origin health notifications by resource type or health status. Use null to reset.
        :param pulumi.Input['LoadBalancerPoolOriginSteeringArgs'] origin_steering: Configures origin steering for the pool. Controls how origins are selected for new sessions and traffic without session affinity.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginArgs']]] origins: The list of origins within this pool. Traffic directed at this pool is balanced across all currently healthy origins, provided the pool itself is healthy.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if check_regions is not None:
            pulumi.set(__self__, "check_regions", check_regions)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled_at is not None:
            pulumi.set(__self__, "disabled_at", disabled_at)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if load_shedding is not None:
            pulumi.set(__self__, "load_shedding", load_shedding)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)
        if minimum_origins is not None:
            pulumi.set(__self__, "minimum_origins", minimum_origins)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if notification_email is not None:
            pulumi.set(__self__, "notification_email", notification_email)
        if notification_filter is not None:
            pulumi.set(__self__, "notification_filter", notification_filter)
        if origin_steering is not None:
            pulumi.set(__self__, "origin_steering", origin_steering)
        if origins is not None:
            pulumi.set(__self__, "origins", origins)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="checkRegions")
    def check_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of regions from which to run health checks. Null means every Cloudflare data center.
        """
        return pulumi.get(self, "check_regions")

    @check_regions.setter
    def check_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "check_regions", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable description of the pool.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disabledAt")
    def disabled_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field shows up only if the pool is disabled. This field is set with the time the pool was disabled at.
        """
        return pulumi.get(self, "disabled_at")

    @disabled_at.setter
    def disabled_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disabled_at", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable (the default) or disable this pool. Disabled pools will not receive traffic and are excluded from health checks. Disabling a pool will cause any load balancers using it to failover to the next pool (if any).
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def latitude(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The latitude of the data center containing the origins used in this pool in decimal degrees. If this is set, longitude must also be set.
        """
        return pulumi.get(self, "latitude")

    @latitude.setter
    def latitude(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "latitude", value)

    @_builtins.property
    @pulumi.getter(name="loadShedding")
    def load_shedding(self) -> Optional[pulumi.Input['LoadBalancerPoolLoadSheddingArgs']]:
        """
        Configures load shedding policies and percentages for the pool.
        """
        return pulumi.get(self, "load_shedding")

    @load_shedding.setter
    def load_shedding(self, value: Optional[pulumi.Input['LoadBalancerPoolLoadSheddingArgs']]):
        pulumi.set(self, "load_shedding", value)

    @_builtins.property
    @pulumi.getter
    def longitude(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The longitude of the data center containing the origins used in this pool in decimal degrees. If this is set, latitude must also be set.
        """
        return pulumi.get(self, "longitude")

    @longitude.setter
    def longitude(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "longitude", value)

    @_builtins.property
    @pulumi.getter(name="minimumOrigins")
    def minimum_origins(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum number of origins that must be healthy for this pool to serve traffic. If the number of healthy origins falls below this number, the pool will be marked unhealthy and will failover to the next available pool.
        """
        return pulumi.get(self, "minimum_origins")

    @minimum_origins.setter
    def minimum_origins(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_origins", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Monitor to use for checking the health of origins within this pool.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitor", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A short name (tag) for the pool. Only alphanumeric characters, hyphens, and underscores are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of networks where Load Balancer or Pool is enabled.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmail")
    def notification_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field is now deprecated. It has been moved to Cloudflare's Centralized Notification service https://developers.cloudflare.com/fundamentals/notifications/. The email address to send health status notifications to. This can be an individual mailbox or a mailing list. Multiple emails can be supplied as a comma delimited list.
        """
        return pulumi.get(self, "notification_email")

    @notification_email.setter
    def notification_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_email", value)

    @_builtins.property
    @pulumi.getter(name="notificationFilter")
    def notification_filter(self) -> Optional[pulumi.Input['LoadBalancerPoolNotificationFilterArgs']]:
        """
        Filter pool and origin health notifications by resource type or health status. Use null to reset.
        """
        return pulumi.get(self, "notification_filter")

    @notification_filter.setter
    def notification_filter(self, value: Optional[pulumi.Input['LoadBalancerPoolNotificationFilterArgs']]):
        pulumi.set(self, "notification_filter", value)

    @_builtins.property
    @pulumi.getter(name="originSteering")
    def origin_steering(self) -> Optional[pulumi.Input['LoadBalancerPoolOriginSteeringArgs']]:
        """
        Configures origin steering for the pool. Controls how origins are selected for new sessions and traffic without session affinity.
        """
        return pulumi.get(self, "origin_steering")

    @origin_steering.setter
    def origin_steering(self, value: Optional[pulumi.Input['LoadBalancerPoolOriginSteeringArgs']]):
        pulumi.set(self, "origin_steering", value)

    @_builtins.property
    @pulumi.getter
    def origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginArgs']]]]:
        """
        The list of origins within this pool. Traffic directed at this pool is balanced across all currently healthy origins, provided the pool itself is healthy.
        """
        return pulumi.get(self, "origins")

    @origins.setter
    def origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPoolOriginArgs']]]]):
        pulumi.set(self, "origins", value)


@pulumi.type_token("cloudflare:index/loadBalancerPool:LoadBalancerPool")
class LoadBalancerPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 latitude: Optional[pulumi.Input[_builtins.float]] = None,
                 load_shedding: Optional[pulumi.Input[Union['LoadBalancerPoolLoadSheddingArgs', 'LoadBalancerPoolLoadSheddingArgsDict']]] = None,
                 longitude: Optional[pulumi.Input[_builtins.float]] = None,
                 minimum_origins: Optional[pulumi.Input[_builtins.int]] = None,
                 monitor: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_email: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_filter: Optional[pulumi.Input[Union['LoadBalancerPoolNotificationFilterArgs', 'LoadBalancerPoolNotificationFilterArgsDict']]] = None,
                 origin_steering: Optional[pulumi.Input[Union['LoadBalancerPoolOriginSteeringArgs', 'LoadBalancerPoolOriginSteeringArgsDict']]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPoolOriginArgs', 'LoadBalancerPoolOriginArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/loadBalancerPool:LoadBalancerPool example '<account_id>/<pool_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] check_regions: A list of regions from which to run health checks. Null means every Cloudflare data center.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the pool.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable (the default) or disable this pool. Disabled pools will not receive traffic and are excluded from health checks. Disabling a pool will cause any load balancers using it to failover to the next pool (if any).
        :param pulumi.Input[_builtins.float] latitude: The latitude of the data center containing the origins used in this pool in decimal degrees. If this is set, longitude must also be set.
        :param pulumi.Input[Union['LoadBalancerPoolLoadSheddingArgs', 'LoadBalancerPoolLoadSheddingArgsDict']] load_shedding: Configures load shedding policies and percentages for the pool.
        :param pulumi.Input[_builtins.float] longitude: The longitude of the data center containing the origins used in this pool in decimal degrees. If this is set, latitude must also be set.
        :param pulumi.Input[_builtins.int] minimum_origins: The minimum number of origins that must be healthy for this pool to serve traffic. If the number of healthy origins falls below this number, the pool will be marked unhealthy and will failover to the next available pool.
        :param pulumi.Input[_builtins.str] monitor: The ID of the Monitor to use for checking the health of origins within this pool.
        :param pulumi.Input[_builtins.str] name: A short name (tag) for the pool. Only alphanumeric characters, hyphens, and underscores are allowed.
        :param pulumi.Input[_builtins.str] notification_email: This field is now deprecated. It has been moved to Cloudflare's Centralized Notification service https://developers.cloudflare.com/fundamentals/notifications/. The email address to send health status notifications to. This can be an individual mailbox or a mailing list. Multiple emails can be supplied as a comma delimited list.
        :param pulumi.Input[Union['LoadBalancerPoolNotificationFilterArgs', 'LoadBalancerPoolNotificationFilterArgsDict']] notification_filter: Filter pool and origin health notifications by resource type or health status. Use null to reset.
        :param pulumi.Input[Union['LoadBalancerPoolOriginSteeringArgs', 'LoadBalancerPoolOriginSteeringArgsDict']] origin_steering: Configures origin steering for the pool. Controls how origins are selected for new sessions and traffic without session affinity.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPoolOriginArgs', 'LoadBalancerPoolOriginArgsDict']]]] origins: The list of origins within this pool. Traffic directed at this pool is balanced across all currently healthy origins, provided the pool itself is healthy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/loadBalancerPool:LoadBalancerPool example '<account_id>/<pool_id>'
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 latitude: Optional[pulumi.Input[_builtins.float]] = None,
                 load_shedding: Optional[pulumi.Input[Union['LoadBalancerPoolLoadSheddingArgs', 'LoadBalancerPoolLoadSheddingArgsDict']]] = None,
                 longitude: Optional[pulumi.Input[_builtins.float]] = None,
                 minimum_origins: Optional[pulumi.Input[_builtins.int]] = None,
                 monitor: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_email: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_filter: Optional[pulumi.Input[Union['LoadBalancerPoolNotificationFilterArgs', 'LoadBalancerPoolNotificationFilterArgsDict']]] = None,
                 origin_steering: Optional[pulumi.Input[Union['LoadBalancerPoolOriginSteeringArgs', 'LoadBalancerPoolOriginSteeringArgsDict']]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPoolOriginArgs', 'LoadBalancerPoolOriginArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerPoolArgs.__new__(LoadBalancerPoolArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["check_regions"] = check_regions
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["latitude"] = latitude
            __props__.__dict__["load_shedding"] = load_shedding
            __props__.__dict__["longitude"] = longitude
            __props__.__dict__["minimum_origins"] = minimum_origins
            __props__.__dict__["monitor"] = monitor
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_email"] = notification_email
            __props__.__dict__["notification_filter"] = notification_filter
            __props__.__dict__["origin_steering"] = origin_steering
            if origins is None and not opts.urn:
                raise TypeError("Missing required property 'origins'")
            __props__.__dict__["origins"] = origins
            __props__.__dict__["created_on"] = None
            __props__.__dict__["disabled_at"] = None
            __props__.__dict__["modified_on"] = None
            __props__.__dict__["networks"] = None
        super(LoadBalancerPool, __self__).__init__(
            'cloudflare:index/loadBalancerPool:LoadBalancerPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disabled_at: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            latitude: Optional[pulumi.Input[_builtins.float]] = None,
            load_shedding: Optional[pulumi.Input[Union['LoadBalancerPoolLoadSheddingArgs', 'LoadBalancerPoolLoadSheddingArgsDict']]] = None,
            longitude: Optional[pulumi.Input[_builtins.float]] = None,
            minimum_origins: Optional[pulumi.Input[_builtins.int]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            monitor: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            notification_email: Optional[pulumi.Input[_builtins.str]] = None,
            notification_filter: Optional[pulumi.Input[Union['LoadBalancerPoolNotificationFilterArgs', 'LoadBalancerPoolNotificationFilterArgsDict']]] = None,
            origin_steering: Optional[pulumi.Input[Union['LoadBalancerPoolOriginSteeringArgs', 'LoadBalancerPoolOriginSteeringArgsDict']]] = None,
            origins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPoolOriginArgs', 'LoadBalancerPoolOriginArgsDict']]]]] = None) -> 'LoadBalancerPool':
        """
        Get an existing LoadBalancerPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] check_regions: A list of regions from which to run health checks. Null means every Cloudflare data center.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the pool.
        :param pulumi.Input[_builtins.str] disabled_at: This field shows up only if the pool is disabled. This field is set with the time the pool was disabled at.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable (the default) or disable this pool. Disabled pools will not receive traffic and are excluded from health checks. Disabling a pool will cause any load balancers using it to failover to the next pool (if any).
        :param pulumi.Input[_builtins.float] latitude: The latitude of the data center containing the origins used in this pool in decimal degrees. If this is set, longitude must also be set.
        :param pulumi.Input[Union['LoadBalancerPoolLoadSheddingArgs', 'LoadBalancerPoolLoadSheddingArgsDict']] load_shedding: Configures load shedding policies and percentages for the pool.
        :param pulumi.Input[_builtins.float] longitude: The longitude of the data center containing the origins used in this pool in decimal degrees. If this is set, latitude must also be set.
        :param pulumi.Input[_builtins.int] minimum_origins: The minimum number of origins that must be healthy for this pool to serve traffic. If the number of healthy origins falls below this number, the pool will be marked unhealthy and will failover to the next available pool.
        :param pulumi.Input[_builtins.str] monitor: The ID of the Monitor to use for checking the health of origins within this pool.
        :param pulumi.Input[_builtins.str] name: A short name (tag) for the pool. Only alphanumeric characters, hyphens, and underscores are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] networks: List of networks where Load Balancer or Pool is enabled.
        :param pulumi.Input[_builtins.str] notification_email: This field is now deprecated. It has been moved to Cloudflare's Centralized Notification service https://developers.cloudflare.com/fundamentals/notifications/. The email address to send health status notifications to. This can be an individual mailbox or a mailing list. Multiple emails can be supplied as a comma delimited list.
        :param pulumi.Input[Union['LoadBalancerPoolNotificationFilterArgs', 'LoadBalancerPoolNotificationFilterArgsDict']] notification_filter: Filter pool and origin health notifications by resource type or health status. Use null to reset.
        :param pulumi.Input[Union['LoadBalancerPoolOriginSteeringArgs', 'LoadBalancerPoolOriginSteeringArgsDict']] origin_steering: Configures origin steering for the pool. Controls how origins are selected for new sessions and traffic without session affinity.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPoolOriginArgs', 'LoadBalancerPoolOriginArgsDict']]]] origins: The list of origins within this pool. Traffic directed at this pool is balanced across all currently healthy origins, provided the pool itself is healthy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerPoolState.__new__(_LoadBalancerPoolState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["check_regions"] = check_regions
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["description"] = description
        __props__.__dict__["disabled_at"] = disabled_at
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["latitude"] = latitude
        __props__.__dict__["load_shedding"] = load_shedding
        __props__.__dict__["longitude"] = longitude
        __props__.__dict__["minimum_origins"] = minimum_origins
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["monitor"] = monitor
        __props__.__dict__["name"] = name
        __props__.__dict__["networks"] = networks
        __props__.__dict__["notification_email"] = notification_email
        __props__.__dict__["notification_filter"] = notification_filter
        __props__.__dict__["origin_steering"] = origin_steering
        __props__.__dict__["origins"] = origins
        return LoadBalancerPool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="checkRegions")
    def check_regions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of regions from which to run health checks. Null means every Cloudflare data center.
        """
        return pulumi.get(self, "check_regions")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        A human-readable description of the pool.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disabledAt")
    def disabled_at(self) -> pulumi.Output[_builtins.str]:
        """
        This field shows up only if the pool is disabled. This field is set with the time the pool was disabled at.
        """
        return pulumi.get(self, "disabled_at")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable (the default) or disable this pool. Disabled pools will not receive traffic and are excluded from health checks. Disabling a pool will cause any load balancers using it to failover to the next pool (if any).
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def latitude(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The latitude of the data center containing the origins used in this pool in decimal degrees. If this is set, longitude must also be set.
        """
        return pulumi.get(self, "latitude")

    @_builtins.property
    @pulumi.getter(name="loadShedding")
    def load_shedding(self) -> pulumi.Output['outputs.LoadBalancerPoolLoadShedding']:
        """
        Configures load shedding policies and percentages for the pool.
        """
        return pulumi.get(self, "load_shedding")

    @_builtins.property
    @pulumi.getter
    def longitude(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The longitude of the data center containing the origins used in this pool in decimal degrees. If this is set, latitude must also be set.
        """
        return pulumi.get(self, "longitude")

    @_builtins.property
    @pulumi.getter(name="minimumOrigins")
    def minimum_origins(self) -> pulumi.Output[_builtins.int]:
        """
        The minimum number of origins that must be healthy for this pool to serve traffic. If the number of healthy origins falls below this number, the pool will be marked unhealthy and will failover to the next available pool.
        """
        return pulumi.get(self, "minimum_origins")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Monitor to use for checking the health of origins within this pool.
        """
        return pulumi.get(self, "monitor")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A short name (tag) for the pool. Only alphanumeric characters, hyphens, and underscores are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of networks where Load Balancer or Pool is enabled.
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter(name="notificationEmail")
    def notification_email(self) -> pulumi.Output[_builtins.str]:
        """
        This field is now deprecated. It has been moved to Cloudflare's Centralized Notification service https://developers.cloudflare.com/fundamentals/notifications/. The email address to send health status notifications to. This can be an individual mailbox or a mailing list. Multiple emails can be supplied as a comma delimited list.
        """
        return pulumi.get(self, "notification_email")

    @_builtins.property
    @pulumi.getter(name="notificationFilter")
    def notification_filter(self) -> pulumi.Output['outputs.LoadBalancerPoolNotificationFilter']:
        """
        Filter pool and origin health notifications by resource type or health status. Use null to reset.
        """
        return pulumi.get(self, "notification_filter")

    @_builtins.property
    @pulumi.getter(name="originSteering")
    def origin_steering(self) -> pulumi.Output['outputs.LoadBalancerPoolOriginSteering']:
        """
        Configures origin steering for the pool. Controls how origins are selected for new sessions and traffic without session affinity.
        """
        return pulumi.get(self, "origin_steering")

    @_builtins.property
    @pulumi.getter
    def origins(self) -> pulumi.Output[Sequence['outputs.LoadBalancerPoolOrigin']]:
        """
        The list of origins within this pool. Traffic directed at this pool is balanced across all currently healthy origins, provided the pool itself is healthy.
        """
        return pulumi.get(self, "origins")

