# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MagicNetworkMonitoringRuleArgs', 'MagicNetworkMonitoringRule']

@pulumi.input_type
class MagicNetworkMonitoringRuleArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 automatic_advertisement: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.float]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 packet_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a MagicNetworkMonitoringRule resource.
        :param pulumi.Input[_builtins.str] name: The name of the rule. Must be unique. Supports characters A-Z, a-z, 0-9, underscore (_), dash (-), period (.), and tilde (~). You can’t have a space in the rule name. Max 256 characters.
        :param pulumi.Input[_builtins.bool] automatic_advertisement: Toggle on if you would like Cloudflare to automatically advertise the IP Prefixes within the rule via Magic Transit when the rule is triggered. Only available for users of Magic Transit.
        :param pulumi.Input[_builtins.float] bandwidth: The number of bits per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        :param pulumi.Input[_builtins.str] duration: The amount of time that the rule threshold must be exceeded to send an alert notification. The final value must be equivalent to one of the following 8 values ["1m","5m","10m","15m","20m","30m","45m","60m"].
               Available values: "1m", "5m", "10m", "15m", "20m", "30m", "45m", "60m".
        :param pulumi.Input[_builtins.float] packet_threshold: The number of packets per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "name", name)
        if automatic_advertisement is not None:
            pulumi.set(__self__, "automatic_advertisement", automatic_advertisement)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if packet_threshold is not None:
            pulumi.set(__self__, "packet_threshold", packet_threshold)
        if prefixes is not None:
            pulumi.set(__self__, "prefixes", prefixes)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the rule. Must be unique. Supports characters A-Z, a-z, 0-9, underscore (_), dash (-), period (.), and tilde (~). You can’t have a space in the rule name. Max 256 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="automaticAdvertisement")
    def automatic_advertisement(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Toggle on if you would like Cloudflare to automatically advertise the IP Prefixes within the rule via Magic Transit when the rule is triggered. Only available for users of Magic Transit.
        """
        return pulumi.get(self, "automatic_advertisement")

    @automatic_advertisement.setter
    def automatic_advertisement(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automatic_advertisement", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The number of bits per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of time that the rule threshold must be exceeded to send an alert notification. The final value must be equivalent to one of the following 8 values ["1m","5m","10m","15m","20m","30m","45m","60m"].
        Available values: "1m", "5m", "10m", "15m", "20m", "30m", "45m", "60m".
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="packetThreshold")
    def packet_threshold(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The number of packets per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        """
        return pulumi.get(self, "packet_threshold")

    @packet_threshold.setter
    def packet_threshold(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "packet_threshold", value)

    @_builtins.property
    @pulumi.getter
    def prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "prefixes")

    @prefixes.setter
    def prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "prefixes", value)


@pulumi.input_type
class _MagicNetworkMonitoringRuleState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 automatic_advertisement: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.float]] = None,
                 bandwidth_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 packet_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 prefix_match: Optional[pulumi.Input[_builtins.str]] = None,
                 prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zscore_sensitivity: Optional[pulumi.Input[_builtins.str]] = None,
                 zscore_target: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MagicNetworkMonitoringRule resources.
        :param pulumi.Input[_builtins.bool] automatic_advertisement: Toggle on if you would like Cloudflare to automatically advertise the IP Prefixes within the rule via Magic Transit when the rule is triggered. Only available for users of Magic Transit.
        :param pulumi.Input[_builtins.float] bandwidth: The number of bits per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        :param pulumi.Input[_builtins.float] bandwidth_threshold: The number of bits per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        :param pulumi.Input[_builtins.str] duration: The amount of time that the rule threshold must be exceeded to send an alert notification. The final value must be equivalent to one of the following 8 values ["1m","5m","10m","15m","20m","30m","45m","60m"].
               Available values: "1m", "5m", "10m", "15m", "20m", "30m", "45m", "60m".
        :param pulumi.Input[_builtins.str] name: The name of the rule. Must be unique. Supports characters A-Z, a-z, 0-9, underscore (_), dash (-), period (.), and tilde (~). You can’t have a space in the rule name. Max 256 characters.
        :param pulumi.Input[_builtins.float] packet_threshold: The number of packets per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        :param pulumi.Input[_builtins.str] prefix_match: Prefix match type to be applied for a prefix auto advertisement when using an advanced_ddos rule.
               Available values: "exact", "subnet", "supernet".
        :param pulumi.Input[_builtins.str] type: MNM rule type.
               Available values: "threshold", "zscore", "advanced_ddos".
        :param pulumi.Input[_builtins.str] zscore_sensitivity: Level of sensitivity set for zscore rules.
               Available values: "low", "medium", "high".
        :param pulumi.Input[_builtins.str] zscore_target: Target of the zscore rule analysis.
               Available values: "bits", "packets".
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if automatic_advertisement is not None:
            pulumi.set(__self__, "automatic_advertisement", automatic_advertisement)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if bandwidth_threshold is not None:
            pulumi.set(__self__, "bandwidth_threshold", bandwidth_threshold)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if packet_threshold is not None:
            pulumi.set(__self__, "packet_threshold", packet_threshold)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)
        if prefixes is not None:
            pulumi.set(__self__, "prefixes", prefixes)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zscore_sensitivity is not None:
            pulumi.set(__self__, "zscore_sensitivity", zscore_sensitivity)
        if zscore_target is not None:
            pulumi.set(__self__, "zscore_target", zscore_target)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="automaticAdvertisement")
    def automatic_advertisement(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Toggle on if you would like Cloudflare to automatically advertise the IP Prefixes within the rule via Magic Transit when the rule is triggered. Only available for users of Magic Transit.
        """
        return pulumi.get(self, "automatic_advertisement")

    @automatic_advertisement.setter
    def automatic_advertisement(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automatic_advertisement", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The number of bits per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthThreshold")
    def bandwidth_threshold(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The number of bits per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        """
        return pulumi.get(self, "bandwidth_threshold")

    @bandwidth_threshold.setter
    def bandwidth_threshold(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "bandwidth_threshold", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of time that the rule threshold must be exceeded to send an alert notification. The final value must be equivalent to one of the following 8 values ["1m","5m","10m","15m","20m","30m","45m","60m"].
        Available values: "1m", "5m", "10m", "15m", "20m", "30m", "45m", "60m".
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the rule. Must be unique. Supports characters A-Z, a-z, 0-9, underscore (_), dash (-), period (.), and tilde (~). You can’t have a space in the rule name. Max 256 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="packetThreshold")
    def packet_threshold(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The number of packets per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        """
        return pulumi.get(self, "packet_threshold")

    @packet_threshold.setter
    def packet_threshold(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "packet_threshold", value)

    @_builtins.property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prefix match type to be applied for a prefix auto advertisement when using an advanced_ddos rule.
        Available values: "exact", "subnet", "supernet".
        """
        return pulumi.get(self, "prefix_match")

    @prefix_match.setter
    def prefix_match(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "prefix_match", value)

    @_builtins.property
    @pulumi.getter
    def prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "prefixes")

    @prefixes.setter
    def prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "prefixes", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MNM rule type.
        Available values: "threshold", "zscore", "advanced_ddos".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="zscoreSensitivity")
    def zscore_sensitivity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Level of sensitivity set for zscore rules.
        Available values: "low", "medium", "high".
        """
        return pulumi.get(self, "zscore_sensitivity")

    @zscore_sensitivity.setter
    def zscore_sensitivity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zscore_sensitivity", value)

    @_builtins.property
    @pulumi.getter(name="zscoreTarget")
    def zscore_target(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target of the zscore rule analysis.
        Available values: "bits", "packets".
        """
        return pulumi.get(self, "zscore_target")

    @zscore_target.setter
    def zscore_target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zscore_target", value)


@pulumi.type_token("cloudflare:index/magicNetworkMonitoringRule:MagicNetworkMonitoringRule")
class MagicNetworkMonitoringRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 automatic_advertisement: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.float]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 packet_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_magic_network_monitoring_rule = cloudflare.MagicNetworkMonitoringRule("example_magic_network_monitoring_rule",
            account_id="6f91088a406011ed95aed352566e8d4c",
            duration="1m",
            name="my_rule_1",
            automatic_advertisement=True,
            bandwidth=1000,
            packet_threshold=10000,
            prefixes=["203.0.113.1/32"])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/magicNetworkMonitoringRule:MagicNetworkMonitoringRule example '<account_id>/<rule_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] automatic_advertisement: Toggle on if you would like Cloudflare to automatically advertise the IP Prefixes within the rule via Magic Transit when the rule is triggered. Only available for users of Magic Transit.
        :param pulumi.Input[_builtins.float] bandwidth: The number of bits per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        :param pulumi.Input[_builtins.str] duration: The amount of time that the rule threshold must be exceeded to send an alert notification. The final value must be equivalent to one of the following 8 values ["1m","5m","10m","15m","20m","30m","45m","60m"].
               Available values: "1m", "5m", "10m", "15m", "20m", "30m", "45m", "60m".
        :param pulumi.Input[_builtins.str] name: The name of the rule. Must be unique. Supports characters A-Z, a-z, 0-9, underscore (_), dash (-), period (.), and tilde (~). You can’t have a space in the rule name. Max 256 characters.
        :param pulumi.Input[_builtins.float] packet_threshold: The number of packets per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MagicNetworkMonitoringRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_magic_network_monitoring_rule = cloudflare.MagicNetworkMonitoringRule("example_magic_network_monitoring_rule",
            account_id="6f91088a406011ed95aed352566e8d4c",
            duration="1m",
            name="my_rule_1",
            automatic_advertisement=True,
            bandwidth=1000,
            packet_threshold=10000,
            prefixes=["203.0.113.1/32"])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/magicNetworkMonitoringRule:MagicNetworkMonitoringRule example '<account_id>/<rule_id>'
        ```

        :param str resource_name: The name of the resource.
        :param MagicNetworkMonitoringRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MagicNetworkMonitoringRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 automatic_advertisement: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.float]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 packet_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MagicNetworkMonitoringRuleArgs.__new__(MagicNetworkMonitoringRuleArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["automatic_advertisement"] = automatic_advertisement
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["duration"] = duration
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["packet_threshold"] = packet_threshold
            __props__.__dict__["prefixes"] = prefixes
            __props__.__dict__["bandwidth_threshold"] = None
            __props__.__dict__["prefix_match"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["zscore_sensitivity"] = None
            __props__.__dict__["zscore_target"] = None
        super(MagicNetworkMonitoringRule, __self__).__init__(
            'cloudflare:index/magicNetworkMonitoringRule:MagicNetworkMonitoringRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            automatic_advertisement: Optional[pulumi.Input[_builtins.bool]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.float]] = None,
            bandwidth_threshold: Optional[pulumi.Input[_builtins.float]] = None,
            duration: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            packet_threshold: Optional[pulumi.Input[_builtins.float]] = None,
            prefix_match: Optional[pulumi.Input[_builtins.str]] = None,
            prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            zscore_sensitivity: Optional[pulumi.Input[_builtins.str]] = None,
            zscore_target: Optional[pulumi.Input[_builtins.str]] = None) -> 'MagicNetworkMonitoringRule':
        """
        Get an existing MagicNetworkMonitoringRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] automatic_advertisement: Toggle on if you would like Cloudflare to automatically advertise the IP Prefixes within the rule via Magic Transit when the rule is triggered. Only available for users of Magic Transit.
        :param pulumi.Input[_builtins.float] bandwidth: The number of bits per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        :param pulumi.Input[_builtins.float] bandwidth_threshold: The number of bits per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        :param pulumi.Input[_builtins.str] duration: The amount of time that the rule threshold must be exceeded to send an alert notification. The final value must be equivalent to one of the following 8 values ["1m","5m","10m","15m","20m","30m","45m","60m"].
               Available values: "1m", "5m", "10m", "15m", "20m", "30m", "45m", "60m".
        :param pulumi.Input[_builtins.str] name: The name of the rule. Must be unique. Supports characters A-Z, a-z, 0-9, underscore (_), dash (-), period (.), and tilde (~). You can’t have a space in the rule name. Max 256 characters.
        :param pulumi.Input[_builtins.float] packet_threshold: The number of packets per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        :param pulumi.Input[_builtins.str] prefix_match: Prefix match type to be applied for a prefix auto advertisement when using an advanced_ddos rule.
               Available values: "exact", "subnet", "supernet".
        :param pulumi.Input[_builtins.str] type: MNM rule type.
               Available values: "threshold", "zscore", "advanced_ddos".
        :param pulumi.Input[_builtins.str] zscore_sensitivity: Level of sensitivity set for zscore rules.
               Available values: "low", "medium", "high".
        :param pulumi.Input[_builtins.str] zscore_target: Target of the zscore rule analysis.
               Available values: "bits", "packets".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MagicNetworkMonitoringRuleState.__new__(_MagicNetworkMonitoringRuleState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["automatic_advertisement"] = automatic_advertisement
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["bandwidth_threshold"] = bandwidth_threshold
        __props__.__dict__["duration"] = duration
        __props__.__dict__["name"] = name
        __props__.__dict__["packet_threshold"] = packet_threshold
        __props__.__dict__["prefix_match"] = prefix_match
        __props__.__dict__["prefixes"] = prefixes
        __props__.__dict__["type"] = type
        __props__.__dict__["zscore_sensitivity"] = zscore_sensitivity
        __props__.__dict__["zscore_target"] = zscore_target
        return MagicNetworkMonitoringRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="automaticAdvertisement")
    def automatic_advertisement(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Toggle on if you would like Cloudflare to automatically advertise the IP Prefixes within the rule via Magic Transit when the rule is triggered. Only available for users of Magic Transit.
        """
        return pulumi.get(self, "automatic_advertisement")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The number of bits per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="bandwidthThreshold")
    def bandwidth_threshold(self) -> pulumi.Output[_builtins.float]:
        """
        The number of bits per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        """
        return pulumi.get(self, "bandwidth_threshold")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[_builtins.str]:
        """
        The amount of time that the rule threshold must be exceeded to send an alert notification. The final value must be equivalent to one of the following 8 values ["1m","5m","10m","15m","20m","30m","45m","60m"].
        Available values: "1m", "5m", "10m", "15m", "20m", "30m", "45m", "60m".
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the rule. Must be unique. Supports characters A-Z, a-z, 0-9, underscore (_), dash (-), period (.), and tilde (~). You can’t have a space in the rule name. Max 256 characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="packetThreshold")
    def packet_threshold(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The number of packets per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        """
        return pulumi.get(self, "packet_threshold")

    @_builtins.property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> pulumi.Output[_builtins.str]:
        """
        Prefix match type to be applied for a prefix auto advertisement when using an advanced_ddos rule.
        Available values: "exact", "subnet", "supernet".
        """
        return pulumi.get(self, "prefix_match")

    @_builtins.property
    @pulumi.getter
    def prefixes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "prefixes")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        MNM rule type.
        Available values: "threshold", "zscore", "advanced_ddos".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="zscoreSensitivity")
    def zscore_sensitivity(self) -> pulumi.Output[_builtins.str]:
        """
        Level of sensitivity set for zscore rules.
        Available values: "low", "medium", "high".
        """
        return pulumi.get(self, "zscore_sensitivity")

    @_builtins.property
    @pulumi.getter(name="zscoreTarget")
    def zscore_target(self) -> pulumi.Output[_builtins.str]:
        """
        Target of the zscore rule analysis.
        Available values: "bits", "packets".
        """
        return pulumi.get(self, "zscore_target")

