# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MagicTransitSiteAclArgs', 'MagicTransitSiteAcl']

@pulumi.input_type
class MagicTransitSiteAclArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 lan1: pulumi.Input['MagicTransitSiteAclLan1Args'],
                 lan2: pulumi.Input['MagicTransitSiteAclLan2Args'],
                 name: pulumi.Input[_builtins.str],
                 site_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_locally: Optional[pulumi.Input[_builtins.bool]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 unidirectional: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a MagicTransitSiteAcl resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier
        :param pulumi.Input[_builtins.str] name: The name of the ACL.
        :param pulumi.Input[_builtins.str] site_id: Identifier
        :param pulumi.Input[_builtins.str] description: Description for the ACL.
        :param pulumi.Input[_builtins.bool] forward_locally: The desired forwarding action for this ACL policy. If set to "false", the policy will forward traffic to Cloudflare. If set to "true", the policy will forward traffic locally on the Magic Connector. If not included in request, will default to false.
        :param pulumi.Input[_builtins.bool] unidirectional: The desired traffic direction for this ACL policy. If set to "false", the policy will allow bidirectional traffic. If set to "true", the policy will only allow traffic in one direction. If not included in request, will default to false.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "lan1", lan1)
        pulumi.set(__self__, "lan2", lan2)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "site_id", site_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if forward_locally is not None:
            pulumi.set(__self__, "forward_locally", forward_locally)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if unidirectional is not None:
            pulumi.set(__self__, "unidirectional", unidirectional)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def lan1(self) -> pulumi.Input['MagicTransitSiteAclLan1Args']:
        return pulumi.get(self, "lan1")

    @lan1.setter
    def lan1(self, value: pulumi.Input['MagicTransitSiteAclLan1Args']):
        pulumi.set(self, "lan1", value)

    @_builtins.property
    @pulumi.getter
    def lan2(self) -> pulumi.Input['MagicTransitSiteAclLan2Args']:
        return pulumi.get(self, "lan2")

    @lan2.setter
    def lan2(self, value: pulumi.Input['MagicTransitSiteAclLan2Args']):
        pulumi.set(self, "lan2", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the ACL.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the ACL.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="forwardLocally")
    def forward_locally(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The desired forwarding action for this ACL policy. If set to "false", the policy will forward traffic to Cloudflare. If set to "true", the policy will forward traffic locally on the Magic Connector. If not included in request, will default to false.
        """
        return pulumi.get(self, "forward_locally")

    @forward_locally.setter
    def forward_locally(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_locally", value)

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "protocols", value)

    @_builtins.property
    @pulumi.getter
    def unidirectional(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The desired traffic direction for this ACL policy. If set to "false", the policy will allow bidirectional traffic. If set to "true", the policy will only allow traffic in one direction. If not included in request, will default to false.
        """
        return pulumi.get(self, "unidirectional")

    @unidirectional.setter
    def unidirectional(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unidirectional", value)


@pulumi.input_type
class _MagicTransitSiteAclState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_locally: Optional[pulumi.Input[_builtins.bool]] = None,
                 lan1: Optional[pulumi.Input['MagicTransitSiteAclLan1Args']] = None,
                 lan2: Optional[pulumi.Input['MagicTransitSiteAclLan2Args']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 unidirectional: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering MagicTransitSiteAcl resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier
        :param pulumi.Input[_builtins.str] description: Description for the ACL.
        :param pulumi.Input[_builtins.bool] forward_locally: The desired forwarding action for this ACL policy. If set to "false", the policy will forward traffic to Cloudflare. If set to "true", the policy will forward traffic locally on the Magic Connector. If not included in request, will default to false.
        :param pulumi.Input[_builtins.str] name: The name of the ACL.
        :param pulumi.Input[_builtins.str] site_id: Identifier
        :param pulumi.Input[_builtins.bool] unidirectional: The desired traffic direction for this ACL policy. If set to "false", the policy will allow bidirectional traffic. If set to "true", the policy will only allow traffic in one direction. If not included in request, will default to false.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if forward_locally is not None:
            pulumi.set(__self__, "forward_locally", forward_locally)
        if lan1 is not None:
            pulumi.set(__self__, "lan1", lan1)
        if lan2 is not None:
            pulumi.set(__self__, "lan2", lan2)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if unidirectional is not None:
            pulumi.set(__self__, "unidirectional", unidirectional)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the ACL.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="forwardLocally")
    def forward_locally(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The desired forwarding action for this ACL policy. If set to "false", the policy will forward traffic to Cloudflare. If set to "true", the policy will forward traffic locally on the Magic Connector. If not included in request, will default to false.
        """
        return pulumi.get(self, "forward_locally")

    @forward_locally.setter
    def forward_locally(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_locally", value)

    @_builtins.property
    @pulumi.getter
    def lan1(self) -> Optional[pulumi.Input['MagicTransitSiteAclLan1Args']]:
        return pulumi.get(self, "lan1")

    @lan1.setter
    def lan1(self, value: Optional[pulumi.Input['MagicTransitSiteAclLan1Args']]):
        pulumi.set(self, "lan1", value)

    @_builtins.property
    @pulumi.getter
    def lan2(self) -> Optional[pulumi.Input['MagicTransitSiteAclLan2Args']]:
        return pulumi.get(self, "lan2")

    @lan2.setter
    def lan2(self, value: Optional[pulumi.Input['MagicTransitSiteAclLan2Args']]):
        pulumi.set(self, "lan2", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the ACL.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "protocols", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def unidirectional(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The desired traffic direction for this ACL policy. If set to "false", the policy will allow bidirectional traffic. If set to "true", the policy will only allow traffic in one direction. If not included in request, will default to false.
        """
        return pulumi.get(self, "unidirectional")

    @unidirectional.setter
    def unidirectional(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unidirectional", value)


@pulumi.type_token("cloudflare:index/magicTransitSiteAcl:MagicTransitSiteAcl")
class MagicTransitSiteAcl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_locally: Optional[pulumi.Input[_builtins.bool]] = None,
                 lan1: Optional[pulumi.Input[Union['MagicTransitSiteAclLan1Args', 'MagicTransitSiteAclLan1ArgsDict']]] = None,
                 lan2: Optional[pulumi.Input[Union['MagicTransitSiteAclLan2Args', 'MagicTransitSiteAclLan2ArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 unidirectional: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/magicTransitSiteAcl:MagicTransitSiteAcl example '<account_id>/<site_id>/<acl_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier
        :param pulumi.Input[_builtins.str] description: Description for the ACL.
        :param pulumi.Input[_builtins.bool] forward_locally: The desired forwarding action for this ACL policy. If set to "false", the policy will forward traffic to Cloudflare. If set to "true", the policy will forward traffic locally on the Magic Connector. If not included in request, will default to false.
        :param pulumi.Input[_builtins.str] name: The name of the ACL.
        :param pulumi.Input[_builtins.str] site_id: Identifier
        :param pulumi.Input[_builtins.bool] unidirectional: The desired traffic direction for this ACL policy. If set to "false", the policy will allow bidirectional traffic. If set to "true", the policy will only allow traffic in one direction. If not included in request, will default to false.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MagicTransitSiteAclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/magicTransitSiteAcl:MagicTransitSiteAcl example '<account_id>/<site_id>/<acl_id>'
        ```

        :param str resource_name: The name of the resource.
        :param MagicTransitSiteAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MagicTransitSiteAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_locally: Optional[pulumi.Input[_builtins.bool]] = None,
                 lan1: Optional[pulumi.Input[Union['MagicTransitSiteAclLan1Args', 'MagicTransitSiteAclLan1ArgsDict']]] = None,
                 lan2: Optional[pulumi.Input[Union['MagicTransitSiteAclLan2Args', 'MagicTransitSiteAclLan2ArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 unidirectional: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MagicTransitSiteAclArgs.__new__(MagicTransitSiteAclArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["description"] = description
            __props__.__dict__["forward_locally"] = forward_locally
            if lan1 is None and not opts.urn:
                raise TypeError("Missing required property 'lan1'")
            __props__.__dict__["lan1"] = lan1
            if lan2 is None and not opts.urn:
                raise TypeError("Missing required property 'lan2'")
            __props__.__dict__["lan2"] = lan2
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["protocols"] = protocols
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["unidirectional"] = unidirectional
        super(MagicTransitSiteAcl, __self__).__init__(
            'cloudflare:index/magicTransitSiteAcl:MagicTransitSiteAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            forward_locally: Optional[pulumi.Input[_builtins.bool]] = None,
            lan1: Optional[pulumi.Input[Union['MagicTransitSiteAclLan1Args', 'MagicTransitSiteAclLan1ArgsDict']]] = None,
            lan2: Optional[pulumi.Input[Union['MagicTransitSiteAclLan2Args', 'MagicTransitSiteAclLan2ArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            site_id: Optional[pulumi.Input[_builtins.str]] = None,
            unidirectional: Optional[pulumi.Input[_builtins.bool]] = None) -> 'MagicTransitSiteAcl':
        """
        Get an existing MagicTransitSiteAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier
        :param pulumi.Input[_builtins.str] description: Description for the ACL.
        :param pulumi.Input[_builtins.bool] forward_locally: The desired forwarding action for this ACL policy. If set to "false", the policy will forward traffic to Cloudflare. If set to "true", the policy will forward traffic locally on the Magic Connector. If not included in request, will default to false.
        :param pulumi.Input[_builtins.str] name: The name of the ACL.
        :param pulumi.Input[_builtins.str] site_id: Identifier
        :param pulumi.Input[_builtins.bool] unidirectional: The desired traffic direction for this ACL policy. If set to "false", the policy will allow bidirectional traffic. If set to "true", the policy will only allow traffic in one direction. If not included in request, will default to false.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MagicTransitSiteAclState.__new__(_MagicTransitSiteAclState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["description"] = description
        __props__.__dict__["forward_locally"] = forward_locally
        __props__.__dict__["lan1"] = lan1
        __props__.__dict__["lan2"] = lan2
        __props__.__dict__["name"] = name
        __props__.__dict__["protocols"] = protocols
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["unidirectional"] = unidirectional
        return MagicTransitSiteAcl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description for the ACL.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="forwardLocally")
    def forward_locally(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The desired forwarding action for this ACL policy. If set to "false", the policy will forward traffic to Cloudflare. If set to "true", the policy will forward traffic locally on the Magic Connector. If not included in request, will default to false.
        """
        return pulumi.get(self, "forward_locally")

    @_builtins.property
    @pulumi.getter
    def lan1(self) -> pulumi.Output['outputs.MagicTransitSiteAclLan1']:
        return pulumi.get(self, "lan1")

    @_builtins.property
    @pulumi.getter
    def lan2(self) -> pulumi.Output['outputs.MagicTransitSiteAclLan2']:
        return pulumi.get(self, "lan2")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the ACL.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "protocols")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter
    def unidirectional(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The desired traffic direction for this ACL policy. If set to "false", the policy will allow bidirectional traffic. If set to "true", the policy will only allow traffic in one direction. If not included in request, will default to false.
        """
        return pulumi.get(self, "unidirectional")

