# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SchemaValidationOperationSettingsArgs', 'SchemaValidationOperationSettings']

@pulumi.input_type
class SchemaValidationOperationSettingsArgs:
    def __init__(__self__, *,
                 mitigation_action: pulumi.Input[_builtins.str],
                 operation_id: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a SchemaValidationOperationSettings resource.
        :param pulumi.Input[_builtins.str] mitigation_action: When set, this applies a mitigation action to this operation
               
                 - `"log"` - log request when request does not conform to schema for this operation
                 - `"block"` - deny access to the site when request does not conform to schema for this operation
                 - `"none"` - will skip mitigation for this operation
                 - `null` - clears any mitigation action
               Available values: "log", "block", "none".
        :param pulumi.Input[_builtins.str] operation_id: UUID.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        pulumi.set(__self__, "mitigation_action", mitigation_action)
        pulumi.set(__self__, "operation_id", operation_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="mitigationAction")
    def mitigation_action(self) -> pulumi.Input[_builtins.str]:
        """
        When set, this applies a mitigation action to this operation

          - `"log"` - log request when request does not conform to schema for this operation
          - `"block"` - deny access to the site when request does not conform to schema for this operation
          - `"none"` - will skip mitigation for this operation
          - `null` - clears any mitigation action
        Available values: "log", "block", "none".
        """
        return pulumi.get(self, "mitigation_action")

    @mitigation_action.setter
    def mitigation_action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mitigation_action", value)

    @_builtins.property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> pulumi.Input[_builtins.str]:
        """
        UUID.
        """
        return pulumi.get(self, "operation_id")

    @operation_id.setter
    def operation_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "operation_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _SchemaValidationOperationSettingsState:
    def __init__(__self__, *,
                 mitigation_action: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SchemaValidationOperationSettings resources.
        :param pulumi.Input[_builtins.str] mitigation_action: When set, this applies a mitigation action to this operation
               
                 - `"log"` - log request when request does not conform to schema for this operation
                 - `"block"` - deny access to the site when request does not conform to schema for this operation
                 - `"none"` - will skip mitigation for this operation
                 - `null` - clears any mitigation action
               Available values: "log", "block", "none".
        :param pulumi.Input[_builtins.str] operation_id: UUID.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        if mitigation_action is not None:
            pulumi.set(__self__, "mitigation_action", mitigation_action)
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="mitigationAction")
    def mitigation_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When set, this applies a mitigation action to this operation

          - `"log"` - log request when request does not conform to schema for this operation
          - `"block"` - deny access to the site when request does not conform to schema for this operation
          - `"none"` - will skip mitigation for this operation
          - `null` - clears any mitigation action
        Available values: "log", "block", "none".
        """
        return pulumi.get(self, "mitigation_action")

    @mitigation_action.setter
    def mitigation_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mitigation_action", value)

    @_builtins.property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID.
        """
        return pulumi.get(self, "operation_id")

    @operation_id.setter
    def operation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/schemaValidationOperationSettings:SchemaValidationOperationSettings")
class SchemaValidationOperationSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 mitigation_action: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_schema_validation_operation_settings = cloudflare.SchemaValidationOperationSettings("example_schema_validation_operation_settings",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            operation_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
            mitigation_action="block")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] mitigation_action: When set, this applies a mitigation action to this operation
               
                 - `"log"` - log request when request does not conform to schema for this operation
                 - `"block"` - deny access to the site when request does not conform to schema for this operation
                 - `"none"` - will skip mitigation for this operation
                 - `null` - clears any mitigation action
               Available values: "log", "block", "none".
        :param pulumi.Input[_builtins.str] operation_id: UUID.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SchemaValidationOperationSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_schema_validation_operation_settings = cloudflare.SchemaValidationOperationSettings("example_schema_validation_operation_settings",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            operation_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
            mitigation_action="block")
        ```

        :param str resource_name: The name of the resource.
        :param SchemaValidationOperationSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SchemaValidationOperationSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 mitigation_action: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SchemaValidationOperationSettingsArgs.__new__(SchemaValidationOperationSettingsArgs)

            if mitigation_action is None and not opts.urn:
                raise TypeError("Missing required property 'mitigation_action'")
            __props__.__dict__["mitigation_action"] = mitigation_action
            if operation_id is None and not opts.urn:
                raise TypeError("Missing required property 'operation_id'")
            __props__.__dict__["operation_id"] = operation_id
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(SchemaValidationOperationSettings, __self__).__init__(
            'cloudflare:index/schemaValidationOperationSettings:SchemaValidationOperationSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            mitigation_action: Optional[pulumi.Input[_builtins.str]] = None,
            operation_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SchemaValidationOperationSettings':
        """
        Get an existing SchemaValidationOperationSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] mitigation_action: When set, this applies a mitigation action to this operation
               
                 - `"log"` - log request when request does not conform to schema for this operation
                 - `"block"` - deny access to the site when request does not conform to schema for this operation
                 - `"none"` - will skip mitigation for this operation
                 - `null` - clears any mitigation action
               Available values: "log", "block", "none".
        :param pulumi.Input[_builtins.str] operation_id: UUID.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SchemaValidationOperationSettingsState.__new__(_SchemaValidationOperationSettingsState)

        __props__.__dict__["mitigation_action"] = mitigation_action
        __props__.__dict__["operation_id"] = operation_id
        __props__.__dict__["zone_id"] = zone_id
        return SchemaValidationOperationSettings(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="mitigationAction")
    def mitigation_action(self) -> pulumi.Output[_builtins.str]:
        """
        When set, this applies a mitigation action to this operation

          - `"log"` - log request when request does not conform to schema for this operation
          - `"block"` - deny access to the site when request does not conform to schema for this operation
          - `"none"` - will skip mitigation for this operation
          - `null` - clears any mitigation action
        Available values: "log", "block", "none".
        """
        return pulumi.get(self, "mitigation_action")

    @_builtins.property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> pulumi.Output[_builtins.str]:
        """
        UUID.
        """
        return pulumi.get(self, "operation_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

