# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SnippetsArgs', 'Snippets']

@pulumi.input_type
class SnippetsArgs:
    def __init__(__self__, *,
                 files: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 metadata: pulumi.Input['SnippetsMetadataArgs'],
                 snippet_name: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a Snippets resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] files: The list of files belonging to the snippet.
        :param pulumi.Input['SnippetsMetadataArgs'] metadata: Metadata about the snippet.
        :param pulumi.Input[_builtins.str] snippet_name: The identifying name of the snippet.
        :param pulumi.Input[_builtins.str] zone_id: The unique ID of the zone.
        """
        pulumi.set(__self__, "files", files)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "snippet_name", snippet_name)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def files(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of files belonging to the snippet.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "files", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Input['SnippetsMetadataArgs']:
        """
        Metadata about the snippet.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: pulumi.Input['SnippetsMetadataArgs']):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="snippetName")
    def snippet_name(self) -> pulumi.Input[_builtins.str]:
        """
        The identifying name of the snippet.
        """
        return pulumi.get(self, "snippet_name")

    @snippet_name.setter
    def snippet_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "snippet_name", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique ID of the zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _SnippetsState:
    def __init__(__self__, *,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input['SnippetsMetadataArgs']] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet_name: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Snippets resources.
        :param pulumi.Input[_builtins.str] created_on: The timestamp of when the snippet was created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] files: The list of files belonging to the snippet.
        :param pulumi.Input['SnippetsMetadataArgs'] metadata: Metadata about the snippet.
        :param pulumi.Input[_builtins.str] modified_on: The timestamp of when the snippet was last modified.
        :param pulumi.Input[_builtins.str] snippet_name: The identifying name of the snippet.
        :param pulumi.Input[_builtins.str] zone_id: The unique ID of the zone.
        """
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if snippet_name is not None:
            pulumi.set(__self__, "snippet_name", snippet_name)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of when the snippet was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of files belonging to the snippet.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "files", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['SnippetsMetadataArgs']]:
        """
        Metadata about the snippet.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['SnippetsMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of when the snippet was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter(name="snippetName")
    def snippet_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifying name of the snippet.
        """
        return pulumi.get(self, "snippet_name")

    @snippet_name.setter
    def snippet_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet_name", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique ID of the zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/snippets:Snippets")
class Snippets(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Union['SnippetsMetadataArgs', 'SnippetsMetadataArgsDict']]] = None,
                 snippet_name: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a Snippets resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] files: The list of files belonging to the snippet.
        :param pulumi.Input[Union['SnippetsMetadataArgs', 'SnippetsMetadataArgsDict']] metadata: Metadata about the snippet.
        :param pulumi.Input[_builtins.str] snippet_name: The identifying name of the snippet.
        :param pulumi.Input[_builtins.str] zone_id: The unique ID of the zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnippetsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Snippets resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SnippetsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnippetsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Union['SnippetsMetadataArgs', 'SnippetsMetadataArgsDict']]] = None,
                 snippet_name: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnippetsArgs.__new__(SnippetsArgs)

            if files is None and not opts.urn:
                raise TypeError("Missing required property 'files'")
            __props__.__dict__["files"] = files
            if metadata is None and not opts.urn:
                raise TypeError("Missing required property 'metadata'")
            __props__.__dict__["metadata"] = metadata
            if snippet_name is None and not opts.urn:
                raise TypeError("Missing required property 'snippet_name'")
            __props__.__dict__["snippet_name"] = snippet_name
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
        super(Snippets, __self__).__init__(
            'cloudflare:index/snippets:Snippets',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            metadata: Optional[pulumi.Input[Union['SnippetsMetadataArgs', 'SnippetsMetadataArgsDict']]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            snippet_name: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Snippets':
        """
        Get an existing Snippets resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_on: The timestamp of when the snippet was created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] files: The list of files belonging to the snippet.
        :param pulumi.Input[Union['SnippetsMetadataArgs', 'SnippetsMetadataArgsDict']] metadata: Metadata about the snippet.
        :param pulumi.Input[_builtins.str] modified_on: The timestamp of when the snippet was last modified.
        :param pulumi.Input[_builtins.str] snippet_name: The identifying name of the snippet.
        :param pulumi.Input[_builtins.str] zone_id: The unique ID of the zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnippetsState.__new__(_SnippetsState)

        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["files"] = files
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["snippet_name"] = snippet_name
        __props__.__dict__["zone_id"] = zone_id
        return Snippets(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of when the snippet was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def files(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of files belonging to the snippet.
        """
        return pulumi.get(self, "files")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['outputs.SnippetsMetadata']:
        """
        Metadata about the snippet.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of when the snippet was last modified.
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter(name="snippetName")
    def snippet_name(self) -> pulumi.Output[_builtins.str]:
        """
        The identifying name of the snippet.
        """
        return pulumi.get(self, "snippet_name")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique ID of the zone.
        """
        return pulumi.get(self, "zone_id")

