# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['StreamAudioTrackArgs', 'StreamAudioTrack']

@pulumi.input_type
class StreamAudioTrackArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 identifier: pulumi.Input[_builtins.str],
                 audio_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StreamAudioTrack resource.
        :param pulumi.Input[_builtins.str] account_id: The account identifier tag.
        :param pulumi.Input[_builtins.str] identifier: A Cloudflare-generated unique identifier for a media item.
        :param pulumi.Input[_builtins.str] audio_identifier: The unique identifier for an additional audio track.
        :param pulumi.Input[_builtins.bool] default: Denotes whether the audio track will be played by default in a player.
        :param pulumi.Input[_builtins.str] label: A string to uniquely identify the track amongst other audio track labels for the specified video.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "identifier", identifier)
        if audio_identifier is not None:
            pulumi.set(__self__, "audio_identifier", audio_identifier)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if label is not None:
            pulumi.set(__self__, "label", label)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        A Cloudflare-generated unique identifier for a media item.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="audioIdentifier")
    def audio_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for an additional audio track.
        """
        return pulumi.get(self, "audio_identifier")

    @audio_identifier.setter
    def audio_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audio_identifier", value)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Denotes whether the audio track will be played by default in a player.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string to uniquely identify the track amongst other audio track labels for the specified video.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)


@pulumi.input_type
class _StreamAudioTrackState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 audio_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StreamAudioTrack resources.
        :param pulumi.Input[_builtins.str] account_id: The account identifier tag.
        :param pulumi.Input[_builtins.str] audio_identifier: The unique identifier for an additional audio track.
        :param pulumi.Input[_builtins.bool] default: Denotes whether the audio track will be played by default in a player.
        :param pulumi.Input[_builtins.str] identifier: A Cloudflare-generated unique identifier for a media item.
        :param pulumi.Input[_builtins.str] label: A string to uniquely identify the track amongst other audio track labels for the specified video.
        :param pulumi.Input[_builtins.str] status: Specifies the processing status of the video.
               Available values: "queued", "ready", "error".
        :param pulumi.Input[_builtins.str] uid: A Cloudflare-generated unique identifier for a media item.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if audio_identifier is not None:
            pulumi.set(__self__, "audio_identifier", audio_identifier)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="audioIdentifier")
    def audio_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for an additional audio track.
        """
        return pulumi.get(self, "audio_identifier")

    @audio_identifier.setter
    def audio_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audio_identifier", value)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Denotes whether the audio track will be played by default in a player.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Cloudflare-generated unique identifier for a media item.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string to uniquely identify the track amongst other audio track labels for the specified video.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the processing status of the video.
        Available values: "queued", "ready", "error".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Cloudflare-generated unique identifier for a media item.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)


@pulumi.type_token("cloudflare:index/streamAudioTrack:StreamAudioTrack")
class StreamAudioTrack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 audio_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_stream_audio_track = cloudflare.StreamAudioTrack("example_stream_audio_track",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            identifier="ea95132c15732412d22c1476fa83f27a",
            audio_identifier="ea95132c15732412d22c1476fa83f27a",
            default=True,
            label="director commentary")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The account identifier tag.
        :param pulumi.Input[_builtins.str] audio_identifier: The unique identifier for an additional audio track.
        :param pulumi.Input[_builtins.bool] default: Denotes whether the audio track will be played by default in a player.
        :param pulumi.Input[_builtins.str] identifier: A Cloudflare-generated unique identifier for a media item.
        :param pulumi.Input[_builtins.str] label: A string to uniquely identify the track amongst other audio track labels for the specified video.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamAudioTrackArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_stream_audio_track = cloudflare.StreamAudioTrack("example_stream_audio_track",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            identifier="ea95132c15732412d22c1476fa83f27a",
            audio_identifier="ea95132c15732412d22c1476fa83f27a",
            default=True,
            label="director commentary")
        ```

        :param str resource_name: The name of the resource.
        :param StreamAudioTrackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamAudioTrackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 audio_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamAudioTrackArgs.__new__(StreamAudioTrackArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["audio_identifier"] = audio_identifier
            __props__.__dict__["default"] = default
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["label"] = label
            __props__.__dict__["status"] = None
            __props__.__dict__["uid"] = None
        super(StreamAudioTrack, __self__).__init__(
            'cloudflare:index/streamAudioTrack:StreamAudioTrack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            audio_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            default: Optional[pulumi.Input[_builtins.bool]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None) -> 'StreamAudioTrack':
        """
        Get an existing StreamAudioTrack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The account identifier tag.
        :param pulumi.Input[_builtins.str] audio_identifier: The unique identifier for an additional audio track.
        :param pulumi.Input[_builtins.bool] default: Denotes whether the audio track will be played by default in a player.
        :param pulumi.Input[_builtins.str] identifier: A Cloudflare-generated unique identifier for a media item.
        :param pulumi.Input[_builtins.str] label: A string to uniquely identify the track amongst other audio track labels for the specified video.
        :param pulumi.Input[_builtins.str] status: Specifies the processing status of the video.
               Available values: "queued", "ready", "error".
        :param pulumi.Input[_builtins.str] uid: A Cloudflare-generated unique identifier for a media item.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamAudioTrackState.__new__(_StreamAudioTrackState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["audio_identifier"] = audio_identifier
        __props__.__dict__["default"] = default
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["label"] = label
        __props__.__dict__["status"] = status
        __props__.__dict__["uid"] = uid
        return StreamAudioTrack(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="audioIdentifier")
    def audio_identifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique identifier for an additional audio track.
        """
        return pulumi.get(self, "audio_identifier")

    @_builtins.property
    @pulumi.getter
    def default(self) -> pulumi.Output[_builtins.bool]:
        """
        Denotes whether the audio track will be played by default in a player.
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        A Cloudflare-generated unique identifier for a media item.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A string to uniquely identify the track amongst other audio track labels for the specified video.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the processing status of the video.
        Available values: "queued", "ready", "error".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        A Cloudflare-generated unique identifier for a media item.
        """
        return pulumi.get(self, "uid")

